/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcTableMeta;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcMetaTablesResult
extends JdbcResult {
    private List<JdbcTableMeta> meta;

    JdbcMetaTablesResult() {
        super((byte)7);
    }

    JdbcMetaTablesResult(List<JdbcTableMeta> meta) {
        super((byte)7);
        this.meta = meta;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.writeBinary(writer, ver);
        if (F.isEmpty(this.meta)) {
            writer.writeInt(0);
        } else {
            writer.writeInt(this.meta.size());
            for (JdbcTableMeta m : this.meta) {
                m.writeBinary(writer, ver);
            }
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.readBinary(reader, ver);
        int size2 = reader.readInt();
        if (size2 == 0) {
            this.meta = Collections.emptyList();
        } else {
            this.meta = new ArrayList<JdbcTableMeta>(size2);
            for (int i = 0; i < size2; ++i) {
                JdbcTableMeta m = new JdbcTableMeta();
                m.readBinary(reader, ver);
                this.meta.add(m);
            }
        }
    }

    public List<JdbcTableMeta> meta() {
        return this.meta;
    }

    public String toString() {
        return S.toString(JdbcMetaTablesResult.class, this);
    }
}

