/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequest;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResponse;

public class JdbcMessageParser
implements ClientListenerMessageParser {
    private final GridKernalContext ctx;
    private final ClientListenerProtocolVersion ver;
    protected static final int INIT_CAP = 1024;

    public JdbcMessageParser(GridKernalContext ctx, ClientListenerProtocolVersion ver) {
        this.ctx = ctx;
        this.ver = ver;
    }

    protected BinaryReaderExImpl createReader(byte[] msg) {
        BinaryHeapInputStream stream = new BinaryHeapInputStream(msg);
        return new BinaryReaderExImpl(null, stream, this.ctx.config().getClassLoader(), true);
    }

    protected BinaryWriterExImpl createWriter(int cap) {
        return new BinaryWriterExImpl(null, new BinaryHeapOutputStream(cap), null, null);
    }

    @Override
    public ClientListenerRequest decode(byte[] msg) {
        assert (msg != null);
        BinaryReaderExImpl reader = this.createReader(msg);
        return JdbcRequest.readRequest(reader, this.ver);
    }

    @Override
    public byte[] encode(ClientListenerResponse msg) {
        assert (msg != null);
        assert (msg instanceof JdbcResponse);
        JdbcResponse res = (JdbcResponse)msg;
        BinaryWriterExImpl writer = this.createWriter(1024);
        res.writeBinary(writer, this.ver);
        return writer.array();
    }
}

