/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.jobmetrics;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.jobmetrics.GridJobMetrics;
import org.apache.ignite.internal.processors.jobmetrics.GridJobMetricsSnapshot;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteReducer;

public class GridJobMetricsProcessor
extends GridProcessorAdapter {
    private static final int CONCURRENCY_LEVEL = Integer.getInteger("IGNITE_JOBS_METRICS_CONCURRENCY_LEVEL", 64);
    private final long expireTime;
    private final int histSize;
    private final int queSize;
    private volatile long idleTimer = U.currentTimeMillis();
    private final AtomicBoolean isIdle = new AtomicBoolean(true);
    private volatile InternalMetrics metrics;

    public GridJobMetricsProcessor(GridKernalContext ctx) {
        super(ctx);
        int size2;
        this.expireTime = ctx.config().getMetricsExpireTime();
        this.histSize = ctx.config().getMetricsHistorySize();
        assert (this.histSize > 0) : this.histSize;
        int minSize = this.histSize / CONCURRENCY_LEVEL + 1;
        for (size2 = 1; size2 < minSize; size2 <<= 1) {
        }
        this.queSize = size2;
        this.reset();
    }

    public void reset() {
        InternalMetrics prevMetrics = this.metrics;
        this.metrics = new InternalMetrics();
        if (prevMetrics != null) {
            this.metrics.totalIdleTime = prevMetrics.totalIdleTime;
        }
    }

    int getHistorySize() {
        return this.histSize;
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.assertParameter(this.histSize > 0, "metricsHistorySize > 0");
        this.assertParameter(this.expireTime > 0L, "metricsExpireTime > 0");
        if (this.metrics.snapshotsQueues == null) {
            throw new IgniteCheckedException("Invalid concurrency level configured (is 'IGNITE_JOBS_METRICS_CONCURRENCY_LEVEL' system property properly set?).");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Job metrics processor started [histSize=" + this.histSize + ", concurLvl=" + CONCURRENCY_LEVEL + ", expireTime=" + this.expireTime + ']');
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Job metrics processor stopped.");
        }
    }

    public GridJobMetrics getJobMetrics() {
        long now = U.currentTimeMillis();
        SnapshotReducer rdc = new SnapshotReducer();
        InternalMetrics im = this.metrics;
        for (SnapshotsQueue q : im.snapshotsQueues) {
            q.reduce(rdc, now);
        }
        GridJobMetrics m = rdc.reduce();
        m.setCurrentIdleTime(im.curIdleTime);
        m.setTotalIdleTime(im.totalIdleTime);
        return m;
    }

    public void addSnapshot(GridJobMetricsSnapshot metrics) {
        assert (metrics != null);
        InternalMetrics m = this.metrics;
        m.snapshotsQueues[ThreadLocalRandom.current().nextInt(m.snapshotsQueues.length)].add(metrics);
        long idleTimer0 = this.idleTimer;
        if (metrics.getActiveJobs() > 0) {
            if (this.isIdle.get() && this.isIdle.compareAndSet(true, false)) {
                long now = U.currentTimeMillis();
                InternalMetrics internalMetrics = m;
                internalMetrics.totalIdleTime = internalMetrics.totalIdleTime + (now - idleTimer0);
                m.curIdleTime = 0L;
            }
        } else {
            long now = U.currentTimeMillis();
            if (!this.isIdle.compareAndSet(false, true)) {
                InternalMetrics internalMetrics = m;
                internalMetrics.curIdleTime = internalMetrics.curIdleTime + (now - idleTimer0);
                internalMetrics = m;
                internalMetrics.totalIdleTime = internalMetrics.totalIdleTime + (now - idleTimer0);
            }
            this.idleTimer = now;
        }
    }

    @Override
    public void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> Job metrics processor processor memory stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + ']', new Object[0]);
    }

    private static class SnapshotReducer
    implements IgniteReducer<GridJobMetricsSnapshot, GridJobMetrics> {
        private static final long serialVersionUID = 0L;
        private final GridJobMetrics m = new GridJobMetrics();
        private int cnt;
        private int totalActiveJobs;
        private int totalWaitingJobs;
        private int totalStartedJobs;
        private int totalCancelledJobs;
        private int totalRejectedJobs;
        private int totalFinishedJobs;
        private long totalExecTime;
        private long totalWaitTime;
        private double totalCpuLoad;
        private GridJobMetricsSnapshot lastSnapshot;

        private SnapshotReducer() {
        }

        @Override
        public boolean collect(GridJobMetricsSnapshot s2) {
            assert (s2 != null);
            ++this.cnt;
            if (this.lastSnapshot == null || this.lastSnapshot.getTimestamp() < s2.getTimestamp()) {
                this.lastSnapshot = s2;
            }
            if (this.m.getMaximumActiveJobs() < s2.getActiveJobs()) {
                this.m.setMaximumActiveJobs(s2.getActiveJobs());
            }
            if (this.m.getMaximumWaitingJobs() < s2.getPassiveJobs()) {
                this.m.setMaximumWaitingJobs(s2.getPassiveJobs());
            }
            if (this.m.getMaximumCancelledJobs() < s2.getCancelJobs()) {
                this.m.setMaximumCancelledJobs(s2.getCancelJobs());
            }
            if (this.m.getMaximumRejectedJobs() < s2.getRejectJobs()) {
                this.m.setMaximumRejectedJobs(s2.getRejectJobs());
            }
            if (this.m.getMaximumJobWaitTime() < s2.getMaximumWaitTime()) {
                this.m.setMaximumJobWaitTime(s2.getMaximumWaitTime());
            }
            if (this.m.getMaximumJobExecuteTime() < s2.getMaximumExecutionTime()) {
                this.m.setMaxJobExecutionTime(s2.getMaximumExecutionTime());
            }
            this.totalActiveJobs += s2.getActiveJobs();
            this.totalCancelledJobs += s2.getCancelJobs();
            this.totalWaitingJobs += s2.getPassiveJobs();
            this.totalRejectedJobs += s2.getRejectJobs();
            this.totalWaitTime += s2.getWaitTime();
            this.totalExecTime += s2.getExecutionTime();
            this.totalStartedJobs += s2.getStartedJobs();
            this.totalFinishedJobs += s2.getFinishedJobs();
            this.totalCpuLoad += s2.getCpuLoad();
            return true;
        }

        void collectTotals(int totalFinishedJobs, int totalCancelledJobs, int totalRejectedJobs, long totalExecTime) {
            this.m.setTotalExecutedJobs(this.m.getTotalExecutedJobs() + totalFinishedJobs);
            this.m.setTotalCancelledJobs(this.m.getTotalCancelledJobs() + totalCancelledJobs);
            this.m.setTotalRejectedJobs(this.m.getTotalRejectedJobs() + totalRejectedJobs);
            this.m.setTotalJobsExecutionTime(this.m.getTotalJobsExecutionTime() + totalExecTime);
        }

        @Override
        public GridJobMetrics reduce() {
            if (this.lastSnapshot != null) {
                this.m.setCurrentActiveJobs(this.lastSnapshot.getActiveJobs());
                this.m.setCurrentWaitingJobs(this.lastSnapshot.getPassiveJobs());
                this.m.setCurrentCancelledJobs(this.lastSnapshot.getCancelJobs());
                this.m.setCurrentRejectedJobs(this.lastSnapshot.getRejectJobs());
                this.m.setCurrentJobExecutionTime(this.lastSnapshot.getMaximumExecutionTime());
                this.m.setCurrentJobWaitTime(this.lastSnapshot.getMaximumWaitTime());
            }
            if (this.cnt > 0) {
                this.m.setAverageActiveJobs((float)this.totalActiveJobs / (float)this.cnt);
                this.m.setAverageWaitingJobs((float)this.totalWaitingJobs / (float)this.cnt);
                this.m.setAverageCancelledJobs((float)this.totalCancelledJobs / (float)this.cnt);
                this.m.setAverageRejectedJobs((float)this.totalRejectedJobs / (float)this.cnt);
                this.m.setAverageCpuLoad(this.totalCpuLoad / (double)this.cnt);
            }
            this.m.setAverageJobExecutionTime(this.totalFinishedJobs > 0 ? (double)this.totalExecTime / (double)this.totalFinishedJobs : 0.0);
            this.m.setAverageJobWaitTime(this.totalStartedJobs > 0 ? (double)this.totalWaitTime / (double)this.totalStartedJobs : 0.0);
            return this.m;
        }
    }

    private class SnapshotsQueue {
        private int idx;
        private final GridJobMetricsSnapshot[] snapshots;
        private final int mask;
        private int totalFinishedJobs;
        private int totalCancelledJobs;
        private int totalRejectedJobs;
        private long totalExecTime;

        private SnapshotsQueue(int size2) {
            assert (size2 > 0) : size2;
            this.snapshots = new GridJobMetricsSnapshot[size2];
            this.mask = size2 - 1;
        }

        synchronized void add(GridJobMetricsSnapshot s2) {
            this.snapshots[this.idx++ & this.mask] = s2;
            this.totalFinishedJobs += s2.getFinishedJobs();
            this.totalCancelledJobs += s2.getCancelJobs();
            this.totalRejectedJobs += s2.getRejectJobs();
            this.totalExecTime += s2.getExecutionTime();
        }

        synchronized void reduce(SnapshotReducer rdc, long now) {
            assert (rdc != null);
            for (GridJobMetricsSnapshot s2 : this.snapshots) {
                if (s2 == null) break;
                if (now - s2.getTimestamp() > GridJobMetricsProcessor.this.expireTime) continue;
                rdc.collect(s2);
            }
            rdc.collectTotals(this.totalFinishedJobs, this.totalCancelledJobs, this.totalRejectedJobs, this.totalExecTime);
        }
    }

    private class InternalMetrics {
        private volatile long totalIdleTime;
        private volatile long curIdleTime;
        private final SnapshotsQueue[] snapshotsQueues;

        InternalMetrics() {
            if (CONCURRENCY_LEVEL < 0) {
                this.snapshotsQueues = null;
            } else {
                this.snapshotsQueues = new SnapshotsQueue[CONCURRENCY_LEVEL];
                for (int i = 0; i < this.snapshotsQueues.length; ++i) {
                    this.snapshotsQueues[i] = new SnapshotsQueue(GridJobMetricsProcessor.this.queSize);
                }
            }
        }
    }
}

