/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.secondary.local;

import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsBaseBlockKey;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;

public final class LocalFileSystemBlockKey
implements IgfsBaseBlockKey,
Comparable<LocalFileSystemBlockKey> {
    private IgfsPath path;
    private long blockId;

    public LocalFileSystemBlockKey(IgfsPath path2, long blockId) {
        assert (path2 != null);
        assert (blockId >= 0L);
        this.path = path2;
        this.blockId = blockId;
    }

    @Override
    public long blockId() {
        return this.blockId;
    }

    @Override
    public int fileHash() {
        return this.path.hashCode();
    }

    @Override
    public IgniteUuid affinityKey() {
        return null;
    }

    @Override
    public int compareTo(@NotNull LocalFileSystemBlockKey o) {
        int res = this.path.compareTo(o.path);
        if (res != 0) {
            return res;
        }
        long v1 = this.blockId;
        long v2 = o.blockId;
        if (v1 != v2) {
            return v1 > v2 ? 1 : -1;
        }
        return 0;
    }

    public int hashCode() {
        return this.path.hashCode() + (int)(this.blockId ^ this.blockId >>> 32);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof LocalFileSystemBlockKey)) {
            return false;
        }
        LocalFileSystemBlockKey that = (LocalFileSystemBlockKey)o;
        return this.blockId == that.blockId && this.path.equals(that.path);
    }

    public String toString() {
        return S.toString(LocalFileSystemBlockKey.class, this);
    }
}

