/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.meta;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public class IgfsMetaFileLockProcessor
implements EntryProcessor<IgniteUuid, IgfsEntryInfo, IgfsEntryInfo>,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private IgniteUuid lockId;

    public IgfsMetaFileLockProcessor() {
    }

    public IgfsMetaFileLockProcessor(IgniteUuid lockId) {
        this.lockId = lockId;
    }

    @Override
    public IgfsEntryInfo process(MutableEntry<IgniteUuid, IgfsEntryInfo> entry2, Object ... args2) throws EntryProcessorException {
        IgfsEntryInfo oldInfo = (IgfsEntryInfo)entry2.getValue();
        IgfsEntryInfo newInfo = oldInfo.lock(this.lockId);
        entry2.setValue(newInfo);
        return newInfo;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeGridUuid(out, this.lockId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.lockId = U.readGridUuid(in);
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        BinaryUtils.writeIgniteUuid(out, this.lockId);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.lockId = BinaryUtils.readIgniteUuid(in);
    }

    public String toString() {
        return S.toString(IgfsMetaFileLockProcessor.class, this);
    }
}

