/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.meta;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsFileInfo;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class IgfsMetaFileCreateProcessor
implements EntryProcessor<IgniteUuid, IgfsEntryInfo, IgfsEntryInfo>,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private long accessTime;
    private long modificationTime;
    private Map<String, String> props;
    private int blockSize;
    private IgniteUuid affKey;
    private IgniteUuid lockId;
    private boolean evictExclude;
    private long len;

    public IgfsMetaFileCreateProcessor() {
    }

    public IgfsMetaFileCreateProcessor(long accessTime, long modificationTime, Map<String, String> props, int blockSize, @Nullable IgniteUuid affKey, IgniteUuid lockId, boolean evictExclude, long len) {
        this.accessTime = accessTime;
        this.modificationTime = modificationTime;
        this.props = props;
        this.blockSize = blockSize;
        this.affKey = affKey;
        this.lockId = lockId;
        this.evictExclude = evictExclude;
        this.len = len;
    }

    @Override
    public IgfsEntryInfo process(MutableEntry<IgniteUuid, IgfsEntryInfo> entry2, Object ... args2) throws EntryProcessorException {
        IgfsFileInfo info2 = IgfsUtils.createFile((IgniteUuid)entry2.getKey(), this.blockSize, this.len, this.affKey, this.lockId, this.evictExclude, this.props, this.accessTime, this.modificationTime);
        entry2.setValue(info2);
        return info2;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.accessTime);
        out.writeLong(this.modificationTime);
        IgfsUtils.writeProperties(out, this.props);
        out.writeInt(this.blockSize);
        U.writeGridUuid(out, this.affKey);
        U.writeGridUuid(out, this.lockId);
        out.writeBoolean(this.evictExclude);
        out.writeLong(this.len);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.accessTime = in.readLong();
        this.modificationTime = in.readLong();
        this.props = IgfsUtils.readProperties(in);
        this.blockSize = in.readInt();
        this.affKey = U.readGridUuid(in);
        this.lockId = U.readGridUuid(in);
        this.evictExclude = in.readBoolean();
        this.len = in.readLong();
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        out.writeLong(this.accessTime);
        out.writeLong(this.modificationTime);
        IgfsUtils.writeProperties(out, this.props);
        out.writeInt(this.blockSize);
        BinaryUtils.writeIgniteUuid(out, this.affKey);
        BinaryUtils.writeIgniteUuid(out, this.lockId);
        out.writeBoolean(this.evictExclude);
        out.writeLong(this.len);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.accessTime = in.readLong();
        this.modificationTime = in.readLong();
        this.props = IgfsUtils.readProperties(in);
        this.blockSize = in.readInt();
        this.affKey = BinaryUtils.readIgniteUuid(in);
        this.lockId = BinaryUtils.readIgniteUuid(in);
        this.evictExclude = in.readBoolean();
        this.len = in.readLong();
    }

    public String toString() {
        return S.toString(IgfsMetaFileCreateProcessor.class, this);
    }
}

