/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.meta;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsListingEntry;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public class IgfsMetaDirectoryListingRenameProcessor
implements EntryProcessor<IgniteUuid, IgfsEntryInfo, Void>,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private String oldName;
    private String newName;

    public IgfsMetaDirectoryListingRenameProcessor() {
    }

    public IgfsMetaDirectoryListingRenameProcessor(String oldName, String newName) {
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public Void process(MutableEntry<IgniteUuid, IgfsEntryInfo> e, Object ... args2) throws EntryProcessorException {
        IgfsEntryInfo fileInfo = (IgfsEntryInfo)e.getValue();
        assert (fileInfo.isDirectory());
        HashMap<String, IgfsListingEntry> listing = new HashMap<String, IgfsListingEntry>(fileInfo.listing());
        IgfsListingEntry entry2 = (IgfsListingEntry)listing.remove(this.oldName);
        if (entry2 == null) {
            throw new IgniteException("Directory listing doesn't contain expected entry: " + this.oldName);
        }
        IgfsListingEntry replacedEntry = listing.put(this.newName, entry2);
        if (replacedEntry != null) {
            throw new IgniteException("Entry with new name already exists [name=" + this.newName + ", entry=" + replacedEntry + ']');
        }
        e.setValue(fileInfo.listing(listing));
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.oldName);
        U.writeString(out, this.newName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.oldName = U.readString(in);
        this.newName = U.readString(in);
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        out.writeString(this.oldName);
        out.writeString(this.newName);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.oldName = in.readString();
        this.newName = in.readString();
    }

    public String toString() {
        return S.toString(IgfsMetaDirectoryListingRenameProcessor.class, this);
    }
}

