/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.data;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.processors.igfs.IgfsBlockKey;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IgfsDataPutProcessor
implements EntryProcessor<IgfsBlockKey, byte[], Void>,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private byte[] newVal;

    public IgfsDataPutProcessor() {
    }

    public IgfsDataPutProcessor(byte[] newVal) {
        assert (newVal != null);
        this.newVal = newVal;
    }

    @Override
    public Void process(MutableEntry<IgfsBlockKey, byte[]> entry2, Object ... args2) throws EntryProcessorException {
        byte[] curVal = (byte[])entry2.getValue();
        if (curVal == null || this.newVal.length > curVal.length) {
            entry2.setValue(this.newVal);
        }
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.newVal = U.readByteArray(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeByteArray(out, this.newVal);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        this.newVal = reader.rawReader().readByteArray();
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        writer.rawWriter().writeByteArray(this.newVal);
    }

    public String toString() {
        return S.toString(IgfsDataPutProcessor.class, this);
    }
}

