/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.client;

import java.util.Map;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.igfs.IgfsFile;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.processors.igfs.client.IgfsClientAbstractCallable;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgfsClientUpdateCallable
extends IgfsClientAbstractCallable<IgfsFile> {
    private static final long serialVersionUID = 0L;
    private Map<String, String> props;

    public IgfsClientUpdateCallable() {
    }

    public IgfsClientUpdateCallable(@Nullable String igfsName, @Nullable String user, IgfsPath path2, @Nullable Map<String, String> props) {
        super(igfsName, user, path2);
        this.props = props;
    }

    @Override
    protected IgfsFile call0(IgfsContext ctx) throws Exception {
        return ctx.igfs().update(this.path, this.props);
    }

    @Override
    public void writeBinary0(BinaryRawWriter writer) throws BinaryObjectException {
        IgfsUtils.writeProperties(writer, this.props);
    }

    @Override
    public void readBinary0(BinaryRawReader reader) throws BinaryObjectException {
        this.props = IgfsUtils.readProperties(reader);
    }

    public String toString() {
        return S.toString(IgfsClientUpdateCallable.class, this);
    }
}

