/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.IgfsEvent;
import org.apache.ignite.igfs.IgfsException;
import org.apache.ignite.igfs.IgfsGroupDataBlocksKeyMapper;
import org.apache.ignite.igfs.IgfsIpcEndpointConfiguration;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.igfs.IgfsAttributes;
import org.apache.ignite.internal.processors.igfs.IgfsColocatedMetadataAffinityKeyMapper;
import org.apache.ignite.internal.processors.igfs.IgfsDirectoryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsFileAffinityRange;
import org.apache.ignite.internal.processors.igfs.IgfsFileInfo;
import org.apache.ignite.internal.processors.igfs.IgfsListingEntry;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.lang.IgniteOutClosureX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class IgfsUtils {
    public static final IgniteUuid ROOT_ID = new IgniteUuid(new UUID(0L, 0L), 0L);
    public static final IgniteUuid DELETE_LOCK_ID = new IgniteUuid(new UUID(0L, 0L), 0L);
    public static final int TRASH_CONCURRENCY = 64;
    public static final String PROP_USER_NAME = "usrName";
    public static final String PROP_GROUP_NAME = "grpName";
    public static final String PROP_PERMISSION = "permission";
    public static final String PROP_PREFER_LOCAL_WRITES = "locWrite";
    private static final byte PROP_IDX = 0;
    private static final byte PROP_USER_NAME_IDX = 1;
    private static final byte PROP_GROUP_NAME_IDX = 2;
    private static final byte PROP_PERMISSION_IDX = 3;
    private static final byte PROP_PREFER_LOCAL_WRITES_IDX = 4;
    private static final IgniteUuid[] TRASH_IDS;
    private static final int MAX_CACHE_TX_RETRIES;
    private static final char TRASH_NAME_SEPARATOR = '|';
    private static final byte FLAG_DIR = 1;
    private static final byte FLAG_FILE = 2;
    public static final String IGFS_CACHE_PREFIX = "igfs-internal-";
    public static final String DATA_CACHE_SUFFIX = "-data";
    public static final String META_CACHE_SUFFIX = "-meta";
    private static final int MAX_STR_LEN = 16383;
    private static final int MIN_TCP_PORT = 1;
    private static final int MAX_TCP_PORT = 65535;

    public static IgniteUuid randomTrashId() {
        return TRASH_IDS[ThreadLocalRandom.current().nextInt(64)];
    }

    public static IgniteUuid trashId(int idx) {
        assert (idx >= 0 && idx < 64);
        return TRASH_IDS[idx];
    }

    public static boolean isRootOrTrashId(@Nullable IgniteUuid id) {
        return IgfsUtils.isRootId(id) || IgfsUtils.isTrashId(id);
    }

    public static boolean isRootId(@Nullable IgniteUuid id) {
        return id != null && ROOT_ID.equals(id);
    }

    private static boolean isTrashId(IgniteUuid id) {
        if (id == null) {
            return false;
        }
        UUID gid = id.globalId();
        return id.localId() == 0L && gid.getMostSignificantBits() == 0L && gid.getLeastSignificantBits() > 0L && gid.getLeastSignificantBits() <= 64L;
    }

    public static IgfsException toIgfsException(Throwable err2) {
        IgfsException err0 = err2 instanceof IgfsException ? (IgfsException)err2 : null;
        IgfsException igfsErr = X.cause(err2, IgfsException.class);
        while (igfsErr != null && igfsErr != err0) {
            err0 = igfsErr;
            igfsErr = X.cause(err2, IgfsException.class);
        }
        if (err0 != err2) {
            err0 = err0 != null ? IgfsUtils.newIgfsException(err0.getClass(), err0.getMessage(), err0) : (err2 instanceof ClusterTopologyServerNotFoundException ? new IgfsException("Cache server nodes not found.", err2) : new IgfsException("Generic IGFS error occurred.", err2));
        }
        return err0;
    }

    public static IgfsException newIgfsException(Class<? extends IgfsException> cls, String msg, Throwable cause) {
        try {
            Constructor<? extends IgfsException> ctor = cls.getConstructor(String.class, Throwable.class);
            return ctor.newInstance(msg, cause);
        }
        catch (ReflectiveOperationException e) {
            throw new IgniteException("Failed to create IGFS exception: " + cls.getName(), e);
        }
    }

    private IgfsUtils() {
    }

    public static String fixUserName(@Nullable String user) {
        if (F.isEmpty(user)) {
            user = FileSystemConfiguration.DFLT_USER_NAME;
        }
        return user;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T doInTransactionWithRetries(IgniteInternalCache cache, IgniteOutClosureX<T> clo) throws IgniteCheckedException {
        assert (cache != null);
        int attempts = 0;
        while (attempts < MAX_CACHE_TX_RETRIES) {
            try (Transaction tx = cache.txStart(TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                T res = clo.applyx();
                tx.commit();
                T t = res;
                return t;
            }
            catch (IgniteCheckedException | IgniteException e) {
                ClusterTopologyException cte = X.cause(e, ClusterTopologyException.class);
                if (cte == null) throw U.cast(e);
                ((IgniteFutureImpl)cte.retryReadyFuture()).internalFuture().getUninterruptibly();
                ++attempts;
            }
        }
        throw new IgniteCheckedException("Failed to perform operation since max number of attempts exceeded. [maxAttempts=" + MAX_CACHE_TX_RETRIES + ']');
    }

    public static void sendEvents(GridKernalContext kernalCtx, IgfsPath path2, int type) {
        IgfsUtils.sendEvents(kernalCtx, path2, null, type);
    }

    public static void sendEvents(GridKernalContext kernalCtx, IgfsPath path2, IgfsPath newPath, int type) {
        assert (kernalCtx != null);
        assert (path2 != null);
        GridEventStorageManager evts = kernalCtx.event();
        ClusterNode locNode = kernalCtx.discovery().localNode();
        if (evts.isRecordable(type)) {
            if (newPath == null) {
                evts.record(new IgfsEvent(path2, locNode, type));
            } else {
                evts.record(new IgfsEvent(path2, newPath, locNode, type));
            }
        }
    }

    public static boolean matchIgfsCacheName(@Nullable String cacheName) {
        return cacheName != null && cacheName.startsWith(IGFS_CACHE_PREFIX);
    }

    public static boolean isIgfsCache(IgniteConfiguration cfg, @Nullable String cacheName) {
        return IgfsUtils.matchIgfsCacheName(cacheName);
    }

    public static void prepareCacheConfigurations(IgniteConfiguration cfg) throws IgniteCheckedException {
        FileSystemConfiguration[] igfsCfgs = cfg.getFileSystemConfiguration();
        ArrayList<CacheConfiguration> ccfgs = new ArrayList<CacheConfiguration>(Arrays.asList(cfg.getCacheConfiguration()));
        if (igfsCfgs != null) {
            for (FileSystemConfiguration igfsCfg : igfsCfgs) {
                if (igfsCfg == null) continue;
                CacheConfiguration ccfgMeta = igfsCfg.getMetaCacheConfiguration();
                if (ccfgMeta == null) {
                    ccfgMeta = IgfsUtils.defaultMetaCacheConfig();
                    igfsCfg.setMetaCacheConfiguration(ccfgMeta);
                }
                ccfgMeta.setName(IGFS_CACHE_PREFIX + igfsCfg.getName() + META_CACHE_SUFFIX);
                ccfgs.add(ccfgMeta);
                CacheConfiguration ccfgData = igfsCfg.getDataCacheConfiguration();
                if (ccfgData == null) {
                    ccfgData = IgfsUtils.defaultDataCacheConfig();
                    igfsCfg.setDataCacheConfiguration(ccfgData);
                }
                ccfgData.setName(IGFS_CACHE_PREFIX + igfsCfg.getName() + DATA_CACHE_SUFFIX);
                ccfgs.add(ccfgData);
                ccfgMeta.setCopyOnRead(false);
                ccfgData.setCopyOnRead(false);
                ccfgMeta.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
                ccfgData.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
                if (igfsCfg.isColocateMetadata() && ccfgMeta.getAffinityMapper() == null) {
                    ccfgMeta.setAffinityMapper(new IgfsColocatedMetadataAffinityKeyMapper());
                }
                if (ccfgData.getAffinityMapper() != null) continue;
                ccfgData.setAffinityMapper(new IgfsGroupDataBlocksKeyMapper());
            }
            cfg.setCacheConfiguration(ccfgs.toArray(new CacheConfiguration[ccfgs.size()]));
        }
        IgfsUtils.validateLocalIgfsConfigurations(cfg);
    }

    private static void validateLocalIgfsConfigurations(IgniteConfiguration igniteCfg) throws IgniteCheckedException {
        if (igniteCfg.getFileSystemConfiguration() == null || igniteCfg.getFileSystemConfiguration().length == 0) {
            return;
        }
        HashSet<String> cfgNames = new HashSet<String>();
        for (FileSystemConfiguration cfg : igniteCfg.getFileSystemConfiguration()) {
            boolean secondary;
            String name = cfg.getName();
            if (name == null) {
                throw new IgniteCheckedException("IGFS name cannot be null");
            }
            if (cfgNames.contains(name)) {
                throw new IgniteCheckedException("Duplicate IGFS name found (check configuration and assign unique name to each): " + name);
            }
            CacheConfiguration ccfgData = cfg.getDataCacheConfiguration();
            CacheConfiguration ccfgMeta = cfg.getMetaCacheConfiguration();
            if (QueryUtils.isEnabled(ccfgData)) {
                throw new IgniteCheckedException("IGFS data cache cannot start with enabled query indexing.");
            }
            if (QueryUtils.isEnabled(ccfgMeta)) {
                throw new IgniteCheckedException("IGFS metadata cache cannot start with enabled query indexing.");
            }
            if (ccfgMeta.getAtomicityMode() != CacheAtomicityMode.TRANSACTIONAL) {
                throw new IgniteCheckedException("IGFS metadata cache should be transactional: " + cfg.getName());
            }
            if (!(ccfgData.getAffinityMapper() instanceof IgfsGroupDataBlocksKeyMapper)) {
                throw new IgniteCheckedException("Invalid IGFS data cache configuration (key affinity mapper class should be " + IgfsGroupDataBlocksKeyMapper.class.getSimpleName() + "): " + cfg);
            }
            IgfsIpcEndpointConfiguration ipcCfg = cfg.getIpcEndpointConfiguration();
            if (ipcCfg != null) {
                int tcpPort = ipcCfg.getPort();
                if (tcpPort < 1 || tcpPort > 65535) {
                    throw new IgniteCheckedException("IGFS endpoint TCP port is out of range [1..65535]: " + tcpPort);
                }
                if (ipcCfg.getThreadCount() <= 0) {
                    throw new IgniteCheckedException("IGFS endpoint thread count must be positive: " + ipcCfg.getThreadCount());
                }
            }
            boolean bl = secondary = cfg.getDefaultMode() == IgfsMode.PROXY;
            if (cfg.getPathModes() != null) {
                for (Map.Entry<String, IgfsMode> mode : cfg.getPathModes().entrySet()) {
                    if (mode.getValue() != IgfsMode.PROXY) continue;
                    secondary = true;
                }
            }
            if (secondary && cfg.getSecondaryFileSystem() == null) {
                throw new IgniteCheckedException("Grid configuration parameter invalid: secondaryFileSystem cannot be null when mode is not " + (Object)((Object)IgfsMode.PRIMARY));
            }
            cfgNames.add(name);
        }
    }

    private static CacheConfiguration defaultCacheConfig() {
        CacheConfiguration cfg = new CacheConfiguration();
        cfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cfg.setCacheMode(CacheMode.PARTITIONED);
        return cfg;
    }

    private static CacheConfiguration defaultMetaCacheConfig() {
        CacheConfiguration cfg = IgfsUtils.defaultCacheConfig();
        cfg.setBackups(1);
        return cfg;
    }

    private static CacheConfiguration defaultDataCacheConfig() {
        return IgfsUtils.defaultCacheConfig();
    }

    public static IgfsDirectoryInfo createDirectory(IgniteUuid id) {
        return IgfsUtils.createDirectory(id, null, null);
    }

    public static IgfsDirectoryInfo createDirectory(IgniteUuid id, @Nullable Map<String, IgfsListingEntry> listing, @Nullable Map<String, String> props) {
        long time = System.currentTimeMillis();
        return IgfsUtils.createDirectory(id, listing, props, time, time);
    }

    public static IgfsDirectoryInfo createDirectory(IgniteUuid id, @Nullable Map<String, IgfsListingEntry> listing, @Nullable Map<String, String> props, long createTime, long modificationTime) {
        return new IgfsDirectoryInfo(id, listing, props, createTime, modificationTime);
    }

    public static IgfsFileInfo createFile(IgniteUuid id, int blockSize, long len, @Nullable IgniteUuid affKey, @Nullable IgniteUuid lockId, boolean evictExclude, @Nullable Map<String, String> props, long accessTime, long modificationTime) {
        return new IgfsFileInfo(id, blockSize, len, affKey, props, null, lockId, accessTime, modificationTime, evictExclude);
    }

    public static void writeListingEntry(BinaryRawWriter out, @Nullable IgfsListingEntry entry2) {
        if (entry2 != null) {
            out.writeBoolean(true);
            BinaryUtils.writeIgniteUuid(out, entry2.fileId());
            out.writeBoolean(entry2.isDirectory());
        } else {
            out.writeBoolean(false);
        }
    }

    @Nullable
    public static IgfsListingEntry readListingEntry(BinaryRawReader in) {
        if (in.readBoolean()) {
            IgniteUuid id = BinaryUtils.readIgniteUuid(in);
            boolean dir = in.readBoolean();
            return new IgfsListingEntry(id, dir);
        }
        return null;
    }

    public static void writeListingEntry(DataOutput out, @Nullable IgfsListingEntry entry2) throws IOException {
        if (entry2 != null) {
            out.writeBoolean(true);
            IgniteUtils.writeGridUuid(out, entry2.fileId());
            out.writeBoolean(entry2.isDirectory());
        } else {
            out.writeBoolean(false);
        }
    }

    @Nullable
    public static IgfsListingEntry readListingEntry(DataInput in) throws IOException {
        if (in.readBoolean()) {
            IgniteUuid id = IgniteUtils.readGridUuid(in);
            boolean dir = in.readBoolean();
            return new IgfsListingEntry(id, dir);
        }
        return null;
    }

    public static void writeProperties(BinaryRawWriter out, @Nullable Map<String, String> props) {
        if (props != null) {
            out.writeInt(props.size());
            for (Map.Entry<String, String> entry2 : props.entrySet()) {
                String key = entry2.getKey();
                if (key == PROP_PERMISSION) {
                    out.writeByte((byte)3);
                } else if (key == PROP_PREFER_LOCAL_WRITES) {
                    out.writeByte((byte)4);
                } else if (key == PROP_USER_NAME) {
                    out.writeByte((byte)1);
                } else if (key == PROP_GROUP_NAME) {
                    out.writeByte((byte)2);
                } else {
                    out.writeByte((byte)0);
                    out.writeString(key);
                }
                out.writeString(entry2.getValue());
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Nullable
    public static Map<String, String> readProperties(BinaryRawReader in) {
        int size2 = in.readInt();
        if (size2 >= 0) {
            HashMap<String, String> props = new HashMap<String, String>(size2);
            for (int i = 0; i < size2; ++i) {
                String key;
                byte idx = in.readByte();
                switch (idx) {
                    case 3: {
                        key = PROP_PERMISSION;
                        break;
                    }
                    case 4: {
                        key = PROP_PREFER_LOCAL_WRITES;
                        break;
                    }
                    case 1: {
                        key = PROP_USER_NAME;
                        break;
                    }
                    case 2: {
                        key = PROP_GROUP_NAME;
                        break;
                    }
                    default: {
                        key = in.readString();
                    }
                }
                props.put(key, in.readString());
            }
            return props;
        }
        return null;
    }

    public static void writeProperties(DataOutput out, @Nullable Map<String, String> props) throws IOException {
        if (props != null) {
            out.writeInt(props.size());
            for (Map.Entry<String, String> entry2 : props.entrySet()) {
                String key = entry2.getKey();
                if (key == PROP_PERMISSION) {
                    out.writeByte(3);
                } else if (key == PROP_PREFER_LOCAL_WRITES) {
                    out.writeByte(4);
                } else if (key == PROP_USER_NAME) {
                    out.writeByte(1);
                } else if (key == PROP_GROUP_NAME) {
                    out.writeByte(2);
                } else {
                    out.writeByte(0);
                    U.writeString(out, key);
                }
                U.writeString(out, entry2.getValue());
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Nullable
    public static Map<String, String> readProperties(DataInput in) throws IOException {
        int size2 = in.readInt();
        if (size2 >= 0) {
            HashMap<String, String> props = new HashMap<String, String>(size2);
            for (int i = 0; i < size2; ++i) {
                String key;
                byte idx = in.readByte();
                switch (idx) {
                    case 3: {
                        key = PROP_PERMISSION;
                        break;
                    }
                    case 4: {
                        key = PROP_PREFER_LOCAL_WRITES;
                        break;
                    }
                    case 1: {
                        key = PROP_USER_NAME;
                        break;
                    }
                    case 2: {
                        key = PROP_GROUP_NAME;
                        break;
                    }
                    default: {
                        key = U.readString(in);
                    }
                }
                props.put(key, U.readString(in));
            }
            return props;
        }
        return null;
    }

    public static void writePath(BinaryRawWriter writer, @Nullable IgfsPath path2) {
        if (path2 != null) {
            writer.writeBoolean(true);
            path2.writeRawBinary(writer);
        } else {
            writer.writeBoolean(false);
        }
    }

    @Nullable
    public static IgfsPath readPath(BinaryRawReader reader) {
        if (reader.readBoolean()) {
            IgfsPath path2 = new IgfsPath();
            path2.readRawBinary(reader);
            return path2;
        }
        return null;
    }

    public static IgfsPath readPath(ObjectInput in) throws IOException {
        IgfsPath res = new IgfsPath();
        res.readExternal(in);
        return res;
    }

    public static void writeFileAffinityRange(BinaryRawWriter writer, @Nullable IgfsFileAffinityRange affRange) {
        if (affRange != null) {
            writer.writeBoolean(true);
            affRange.writeRawBinary(writer);
        } else {
            writer.writeBoolean(false);
        }
    }

    public static IgfsFileAffinityRange readFileAffinityRange(BinaryRawReader reader) {
        if (reader.readBoolean()) {
            IgfsFileAffinityRange affRange = new IgfsFileAffinityRange();
            affRange.readRawBinary(reader);
            return affRange;
        }
        return null;
    }

    public static IgfsPath extractOriginalPathFromTrash(String name) {
        int idx = name.indexOf(124);
        assert (idx >= 0);
        String path2 = name.substring(idx + 1, name.length());
        return new IgfsPath(path2);
    }

    static String composeNameForTrash(IgfsPath path2, IgniteUuid id) {
        return id.toString() + '|' + path2.toString();
    }

    public static boolean isIgfsNode(ClusterNode node, String igfsName) {
        assert (node != null);
        IgfsAttributes[] igfs = (IgfsAttributes[])node.attribute("org.apache.ignite.igfs");
        if (igfs != null) {
            for (IgfsAttributes attrs : igfs) {
                if (!F.eq(igfsName, attrs.igfsName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDualMode(IgfsMode mode) {
        return mode == IgfsMode.DUAL_SYNC || mode == IgfsMode.DUAL_ASYNC;
    }

    public static boolean canContain(IgfsMode parent, IgfsMode child) {
        return IgfsUtils.isDualMode(parent) || parent == child;
    }

    public static ArrayList<T2<IgfsPath, IgfsMode>> preparePathModes(IgfsMode dfltMode, @Nullable List<T2<IgfsPath, IgfsMode>> modes, Set<IgfsPath> dualParentsContainingPrimaryChildren) throws IgniteCheckedException {
        if (modes == null) {
            return null;
        }
        Collections.sort(modes, new Comparator<Map.Entry<IgfsPath, IgfsMode>>(){

            @Override
            public int compare(Map.Entry<IgfsPath, IgfsMode> o1, Map.Entry<IgfsPath, IgfsMode> o2) {
                return o1.getKey().depth() - o2.getKey().depth();
            }
        });
        ArrayList<T2<IgfsPath, IgfsMode>> resModes = new ArrayList<T2<IgfsPath, IgfsMode>>(modes.size() + 1);
        resModes.add(new T2<IgfsPath, IgfsMode>(IgfsPath.ROOT, dfltMode));
        block0: for (T2<IgfsPath, IgfsMode> mode : modes) {
            assert (mode.getKey() != null);
            for (T2 t2 : resModes) {
                if (!((IgfsPath)mode.getKey()).isSubDirectoryOf((IgfsPath)t2.getKey())) continue;
                assert (t2.getValue() != null);
                if (t2.getValue() == mode.getValue()) continue block0;
                if (!IgfsUtils.canContain((IgfsMode)((Object)t2.getValue()), (IgfsMode)((Object)mode.getValue()))) {
                    throw new IgniteCheckedException("Subdirectory " + mode.getKey() + " mode " + mode.getValue() + " is not compatible with upper level " + t2.getKey() + " directory mode " + t2.getValue() + ".");
                }
                resModes.add(0, mode);
                if (mode.getValue() != IgfsMode.PRIMARY) continue block0;
                dualParentsContainingPrimaryChildren.add(((IgfsPath)mode.getKey()).parent());
                continue block0;
            }
        }
        resModes.remove(resModes.size() - 1);
        return resModes;
    }

    public static byte flags(boolean isDir, boolean isFile) {
        byte res;
        byte by2 = res = isDir ? (byte)1 : 0;
        if (isFile) {
            res = (byte)(res | 2);
        }
        return res;
    }

    public static boolean isDirectory(byte flags) {
        return IgfsUtils.hasFlag(flags, (byte)1);
    }

    public static boolean isFile(byte flags) {
        return IgfsUtils.hasFlag(flags, (byte)2);
    }

    private static boolean hasFlag(byte flags, byte flag) {
        return (flags & flag) == flag;
    }

    public static Map<String, String> readStringMap(DataInput in) throws IOException {
        int size2 = in.readInt();
        if (size2 == -1) {
            return null;
        }
        HashMap<String, String> map2 = U.newHashMap(size2);
        for (int i = 0; i < size2; ++i) {
            map2.put(IgfsUtils.readUTF(in), IgfsUtils.readUTF(in));
        }
        return map2;
    }

    public static void writeStringMap(DataOutput out, @Nullable Map<String, String> map2) throws IOException {
        if (map2 != null) {
            out.writeInt(map2.size());
            for (Map.Entry<String, String> e : map2.entrySet()) {
                IgfsUtils.writeUTF(out, e.getKey());
                IgfsUtils.writeUTF(out, e.getValue());
            }
        } else {
            out.writeInt(-1);
        }
    }

    public static void writeUTF(DataOutput out, @Nullable String val) throws IOException {
        if (val == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(val.length());
            if (val.length() <= 16383) {
                out.writeUTF(val);
            } else {
                int partLen;
                for (int written = 0; written < val.length(); written += partLen) {
                    partLen = Math.min(val.length() - written, 16383);
                    String part = val.substring(written, written + partLen);
                    out.writeUTF(part);
                }
            }
        }
    }

    public static String readUTF(DataInput in) throws IOException {
        int len = in.readInt();
        if (len < 0) {
            return null;
        }
        if (len <= 16383) {
            return in.readUTF();
        }
        StringBuilder sb = new StringBuilder(len);
        do {
            sb.append(in.readUTF());
        } while (sb.length() < len);
        assert (sb.length() == len);
        return sb.toString();
    }

    static {
        MAX_CACHE_TX_RETRIES = IgniteSystemProperties.getInteger("IGNITE_CACHE_RETRIES_COUNT", 100);
        TRASH_IDS = new IgniteUuid[64];
        for (int i = 0; i < 64; ++i) {
            IgfsUtils.TRASH_IDS[i] = new IgniteUuid(new UUID(0L, i + 1), 0L);
        }
    }
}

