/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.igfs.IgfsIpcEndpointConfiguration;
import org.apache.ignite.igfs.IgfsIpcEndpointType;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.igfs.common.IgfsControlResponse;
import org.apache.ignite.internal.igfs.common.IgfsDataInputStream;
import org.apache.ignite.internal.igfs.common.IgfsDataOutputStream;
import org.apache.ignite.internal.igfs.common.IgfsIpcCommand;
import org.apache.ignite.internal.igfs.common.IgfsMarshaller;
import org.apache.ignite.internal.igfs.common.IgfsMessage;
import org.apache.ignite.internal.processors.igfs.IgfsClientSession;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.IgfsIpcHandler;
import org.apache.ignite.internal.processors.igfs.IgfsServerHandler;
import org.apache.ignite.internal.util.ipc.IpcEndpoint;
import org.apache.ignite.internal.util.ipc.IpcServerEndpoint;
import org.apache.ignite.internal.util.ipc.loopback.IpcServerTcpEndpoint;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryServerEndpoint;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.spi.IgnitePortProtocol;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentLinkedDeque8;

public class IgfsServer {
    private final IgfsContext igfsCtx;
    private final IgniteLogger log;
    private final IgfsMarshaller marsh;
    private final IgfsIpcEndpointConfiguration endpointCfg;
    private IpcServerEndpoint srvEndpoint;
    private IgfsServerHandler hnd;
    private AcceptWorker acceptWorker;
    private ConcurrentLinkedDeque8<ClientWorker> clientWorkers = new ConcurrentLinkedDeque8();
    private final boolean mgmt;

    public IgfsServer(IgfsContext igfsCtx, IgfsIpcEndpointConfiguration endpointCfg, boolean mgmt) {
        assert (igfsCtx != null);
        assert (endpointCfg != null);
        this.endpointCfg = endpointCfg;
        this.igfsCtx = igfsCtx;
        this.mgmt = mgmt;
        this.log = igfsCtx.kernalContext().log(IgfsServer.class);
        this.marsh = new IgfsMarshaller();
    }

    public void start() throws IgniteCheckedException {
        this.srvEndpoint = this.createEndpoint(this.endpointCfg, this.mgmt);
        if (U.isWindows() && this.srvEndpoint instanceof IpcSharedMemoryServerEndpoint) {
            throw new IgniteCheckedException(IpcSharedMemoryServerEndpoint.class.getSimpleName() + " should not be configured on Windows (configure " + IpcServerTcpEndpoint.class.getSimpleName() + ")");
        }
        if (this.srvEndpoint instanceof IpcServerTcpEndpoint) {
            IpcServerTcpEndpoint srvEndpoint0 = (IpcServerTcpEndpoint)this.srvEndpoint;
            srvEndpoint0.setManagement(this.mgmt);
            if (srvEndpoint0.getHost() == null) {
                if (this.mgmt) {
                    String locHostName = this.igfsCtx.kernalContext().config().getLocalHost();
                    try {
                        srvEndpoint0.setHost(U.resolveLocalHost(locHostName).getHostAddress());
                    }
                    catch (IOException e) {
                        throw new IgniteCheckedException("Failed to resolve local host: " + locHostName, e);
                    }
                } else {
                    srvEndpoint0.setHost("127.0.0.1");
                }
            }
        }
        this.igfsCtx.kernalContext().resource().injectGeneric(this.srvEndpoint);
        this.srvEndpoint.start();
        if (this.srvEndpoint.getPort() >= 0) {
            this.igfsCtx.kernalContext().ports().registerPort(this.srvEndpoint.getPort(), IgnitePortProtocol.TCP, this.srvEndpoint.getClass());
        }
        this.hnd = new IgfsIpcHandler(this.igfsCtx, this.endpointCfg, this.mgmt);
        this.acceptWorker = new AcceptWorker();
    }

    private IpcServerEndpoint createEndpoint(IgfsIpcEndpointConfiguration endpointCfg, boolean mgmt) throws IgniteCheckedException {
        A.notNull(endpointCfg, "endpointCfg");
        IgfsIpcEndpointType typ2 = endpointCfg.getType();
        if (typ2 == null) {
            throw new IgniteCheckedException("Failed to create server endpoint (type is not specified)");
        }
        switch (typ2) {
            case SHMEM: {
                IpcSharedMemoryServerEndpoint endpoint = new IpcSharedMemoryServerEndpoint(this.igfsCtx.kernalContext().config().getWorkDirectory());
                endpoint.setPort(endpointCfg.getPort());
                endpoint.setSize(endpointCfg.getMemorySize());
                endpoint.setTokenDirectoryPath(endpointCfg.getTokenDirectoryPath());
                return endpoint;
            }
            case TCP: {
                IpcServerTcpEndpoint endpoint = new IpcServerTcpEndpoint();
                endpoint.setHost(endpointCfg.getHost());
                endpoint.setPort(endpointCfg.getPort());
                endpoint.setManagement(mgmt);
                return endpoint;
            }
        }
        throw new IgniteCheckedException("Failed to create server endpoint (type is unknown): " + (Object)((Object)typ2));
    }

    public void onKernalStart() {
        if (this.srvEndpoint != null) {
            new IgniteThread(this.acceptWorker).start();
        }
    }

    public void stop(boolean cancel) {
        if (this.srvEndpoint == null) {
            return;
        }
        U.cancel(this.acceptWorker);
        U.join(this.acceptWorker, this.log);
        try {
            this.hnd.stop();
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to stop IGFS server handler (will close client connections anyway).", e);
        }
        for (ClientWorker worker : this.clientWorkers) {
            U.cancel(worker);
        }
        U.join(this.clientWorkers, this.log);
        if (this.srvEndpoint.getPort() >= 0) {
            this.igfsCtx.kernalContext().ports().deregisterPort(this.srvEndpoint.getPort(), IgnitePortProtocol.TCP, this.srvEndpoint.getClass());
        }
        try {
            this.igfsCtx.kernalContext().resource().cleanupGeneric(this.srvEndpoint);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to cleanup server endpoint.", e);
        }
    }

    public IpcServerEndpoint getIpcServerEndpoint() {
        return this.srvEndpoint;
    }

    private class AcceptWorker
    extends GridWorker {
        private int acceptCnt;

        protected AcceptWorker() {
            super(IgfsServer.this.igfsCtx.kernalContext().igniteInstanceName(), "igfs-accept-worker", IgfsServer.this.log);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    IpcEndpoint client = IgfsServer.this.srvEndpoint.accept();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("IGFS client connected [igfsName=" + IgfsServer.this.igfsCtx.kernalContext().igniteInstanceName() + ", client=" + client + ']');
                    }
                    ClientWorker worker = new ClientWorker(client, this.acceptCnt++);
                    IgniteThread workerThread = new IgniteThread(worker);
                    ConcurrentLinkedDeque8.Node<ClientWorker> node = IgfsServer.this.clientWorkers.addx(worker);
                    worker.node(node);
                    workerThread.start();
                }
            }
            catch (IgniteCheckedException e) {
                if (!this.isCancelled()) {
                    U.error(this.log, "Failed to accept client IPC connection (will shutdown accept thread).", e);
                }
            }
            finally {
                IgfsServer.this.srvEndpoint.close();
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            IgfsServer.this.srvEndpoint.close();
        }
    }

    private class ClientWorker
    extends GridWorker {
        private final IpcEndpoint endpoint;
        private final IgfsDataOutputStream out;
        private final IgfsClientSession ses;
        private ConcurrentLinkedDeque8.Node<ClientWorker> node;

        protected ClientWorker(IpcEndpoint endpoint, int idx) throws IgniteCheckedException {
            super(IgfsServer.this.igfsCtx.kernalContext().igniteInstanceName(), "igfs-client-worker-" + idx, IgfsServer.this.log);
            this.endpoint = endpoint;
            this.ses = new IgfsClientSession();
            this.out = new IgfsDataOutputStream(new BufferedOutputStream(endpoint.outputStream()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            try {
                IgfsDataInputStream dis = new IgfsDataInputStream(this.endpoint.inputStream());
                byte[] hdr = new byte[24];
                boolean first = true;
                while (!Thread.currentThread().isInterrupted()) {
                    dis.readFully(hdr);
                    final long reqId = U.bytesToLong(hdr, 0);
                    int ordinal = U.bytesToInt(hdr, 8);
                    if (first) {
                        if (reqId != 0L || ordinal != IgfsIpcCommand.HANDSHAKE.ordinal()) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("IGFS IPC handshake failed [reqId=" + reqId + ", ordinal=" + ordinal + ']');
                            }
                            return;
                        }
                        first = false;
                    }
                    IgfsIpcCommand cmd = IgfsIpcCommand.valueOf(ordinal);
                    IgfsMessage msg = IgfsServer.this.marsh.unmarshall(cmd, hdr, dis);
                    IgniteInternalFuture<IgfsMessage> fut = IgfsServer.this.hnd.handleAsync(this.ses, msg, dis);
                    if (fut == null) continue;
                    if (fut.isDone()) {
                        IgfsMessage res;
                        try {
                            res = fut.get();
                        }
                        catch (IgniteCheckedException e) {
                            res = new IgfsControlResponse();
                            ((IgfsControlResponse)res).error(e);
                        }
                        try {
                            IgfsDataOutputStream e = this.out;
                            synchronized (e) {
                                IgfsMarshaller.fillHeader(hdr, reqId, res.command());
                                IgfsServer.this.marsh.marshall(res, hdr, this.out);
                                this.out.flush();
                                continue;
                            }
                        }
                        catch (IOException | IgniteCheckedException e) {
                            this.shutdown0(e);
                            continue;
                        }
                    }
                    fut.listen((IgniteInClosure<IgniteInternalFuture<IgfsMessage>>)new CIX1<IgniteInternalFuture<IgfsMessage>>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void applyx(IgniteInternalFuture<IgfsMessage> fut) {
                            IgfsMessage res;
                            try {
                                res = fut.get();
                            }
                            catch (IgniteCheckedException e) {
                                res = new IgfsControlResponse();
                                ((IgfsControlResponse)res).error(e);
                            }
                            try {
                                IgfsDataOutputStream e = ClientWorker.this.out;
                                synchronized (e) {
                                    byte[] hdr = IgfsMarshaller.createHeader(reqId, res.command());
                                    IgfsServer.this.marsh.marshall(res, hdr, ClientWorker.this.out);
                                    ClientWorker.this.out.flush();
                                }
                            }
                            catch (IOException | IgniteCheckedException e) {
                                ClientWorker.this.shutdown0(e);
                            }
                        }
                    });
                }
            }
            catch (EOFException dis) {
            }
            catch (IOException | IgniteCheckedException e) {
                if (!this.isCancelled()) {
                    U.error(this.log, "Failed to read data from client (will close connection)", e);
                }
            }
            finally {
                this.onFinished();
            }
        }

        public void node(ConcurrentLinkedDeque8.Node<ClientWorker> node) {
            this.node = node;
        }

        @Override
        public void cancel() {
            super.cancel();
            this.shutdown0(null);
        }

        private void shutdown0(@Nullable Throwable e) {
            if (!this.isCancelled() && e != null) {
                U.error(this.log, "Stopping client reader due to exception: " + this.endpoint, e);
            }
            U.closeQuiet(this.out);
            this.endpoint.close();
        }

        private void onFinished() {
            U.closeQuiet(this.out);
            this.endpoint.close();
            if (IgfsServer.this.clientWorkers.unlinkx(this.node)) {
                IgfsServer.this.hnd.onClosed(this.ses);
            }
        }
    }
}

