/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.util.Collection;
import java.util.Map;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class IgfsPathIds {
    private final IgfsPath path;
    private final String[] parts;
    private final IgniteUuid[] ids;
    private IgniteUuid[] surrogateIds;
    private final int lastExistingIdx;

    public IgfsPathIds(IgfsPath path2, String[] parts, IgniteUuid[] ids) {
        assert (path2 != null);
        assert (parts.length == ids.length);
        this.path = path2;
        this.parts = parts;
        this.ids = ids;
        int lastExistingIdx0 = -1;
        for (int i = parts.length - 1; i >= 0; --i) {
            if (ids[i] == null) continue;
            lastExistingIdx0 = i;
            break;
        }
        assert (lastExistingIdx0 >= 0);
        this.lastExistingIdx = lastExistingIdx0;
    }

    public IgfsPathIds parent() {
        assert (this.ids.length > 1);
        String[] parentParts = new String[this.parts.length - 1];
        IgniteUuid[] parentIds = new IgniteUuid[this.ids.length - 1];
        System.arraycopy(this.parts, 0, parentParts, 0, parentParts.length);
        System.arraycopy(this.ids, 0, parentIds, 0, parentIds.length);
        return new IgfsPathIds(this.path.parent(), parentParts, parentIds);
    }

    public int count() {
        return this.ids.length;
    }

    public IgfsPath path() {
        return this.path;
    }

    public String part(int idx) {
        assert (idx < this.parts.length);
        return this.parts[idx];
    }

    public String lastPart() {
        return this.parts[this.parts.length - 1];
    }

    public IgniteUuid lastId() {
        return this.ids[this.ids.length - 1];
    }

    @Nullable
    public IgniteUuid lastParentId() {
        return this.ids[this.ids.length - 2];
    }

    public boolean isLastIndex(int idx) {
        return idx == this.parts.length - 1;
    }

    public IgfsPath lastExistingPath() {
        IgfsPath path2 = IgfsPath.ROOT;
        for (int i = 1; i <= this.lastExistingIdx; ++i) {
            path2 = new IgfsPath(path2, this.parts[i]);
        }
        return path2;
    }

    public boolean allExists() {
        return this.parts.length == this.lastExistingIdx + 1;
    }

    public boolean lastExists() {
        return this.lastExistingIdx == this.ids.length - 1;
    }

    public boolean lastParentExists() {
        return this.ids.length > 1 && this.lastExistingIdx == this.ids.length - 2;
    }

    public IgniteUuid lastExistingId() {
        return this.ids[this.lastExistingIdx];
    }

    public int lastExistingIndex() {
        return this.lastExistingIdx;
    }

    public void addExistingIds(Collection<IgniteUuid> col, boolean relaxed) {
        if (relaxed) {
            col.add(this.ids[this.lastExistingIdx]);
            if (this.lastExistingIdx == this.ids.length - 1 && this.lastExistingIdx > 0) {
                col.add(this.ids[this.lastExistingIdx - 1]);
            }
        } else {
            for (int i = 0; i <= this.lastExistingIdx; ++i) {
                col.add(this.ids[i]);
            }
        }
    }

    public void addSurrogateIds(Collection<IgniteUuid> col) {
        int i;
        if (this.surrogateIds == null) {
            this.surrogateIds = new IgniteUuid[this.ids.length];
            for (i = this.lastExistingIdx + 1; i < this.surrogateIds.length; ++i) {
                this.surrogateIds[i] = IgniteUuid.randomUuid();
            }
        }
        for (i = this.lastExistingIdx + 1; i < this.surrogateIds.length; ++i) {
            col.add(this.surrogateIds[i]);
        }
    }

    public IgniteUuid id(int idx) {
        return idx <= this.lastExistingIdx ? this.ids[idx] : this.surrogateId(idx);
    }

    public IgniteUuid surrogateId(int idx) {
        assert (this.surrogateIds != null);
        assert (idx > this.lastExistingIdx);
        assert (idx < this.surrogateIds.length);
        return this.surrogateIds[idx];
    }

    public boolean verifyIntegrity(Map<IgniteUuid, IgfsEntryInfo> infos, boolean relaxed) {
        if (relaxed) {
            IgfsEntryInfo parentInfo;
            IgfsEntryInfo info2 = infos.get(this.ids[this.lastExistingIdx]);
            if (info2 == null) {
                return false;
            }
            if (!(this.lastExistingIdx != this.ids.length - 1 || this.lastExistingIdx <= 0 || (parentInfo = infos.get(this.ids[this.lastExistingIdx - 1])) != null && parentInfo.hasChild(this.parts[this.lastExistingIdx], this.ids[this.lastExistingIdx]))) {
                return false;
            }
        } else {
            for (int i = 0; i <= this.lastExistingIdx; ++i) {
                IgfsEntryInfo info3 = infos.get(this.ids[i]);
                if (info3 == null) {
                    return false;
                }
                if (i >= this.lastExistingIdx || info3.hasChild(this.parts[i + 1], this.ids[i + 1])) continue;
                return false;
            }
        }
        return true;
    }
}

