/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.igfs.IgfsFile;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsAbstractOutputStream;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.IgfsFileWorkerBatch;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

class IgfsOutputStreamProxyImpl
extends IgfsAbstractOutputStream {
    private IgfsFile info;

    IgfsOutputStreamProxyImpl(IgfsContext igfsCtx, IgfsPath path2, IgfsFile info2, int bufSize, @Nullable IgfsFileWorkerBatch batch) {
        super(igfsCtx, path2, bufSize, batch);
        assert (batch != null);
        this.info = info2;
    }

    @Override
    protected int optimizeBufferSize(int bufSize) {
        assert (bufSize > 0);
        return bufSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.mux;
        synchronized (object) {
            this.checkClosed(null, 0);
            this.sendBufferIfNotEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        Object object = this.mux;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Throwable err2 = null;
            try {
                this.sendBufferIfNotEmpty();
            }
            catch (Exception e) {
                err2 = new IOException("Failed to flush data during stream close [path=" + this.path + ", fileInfo=" + this.info + ']', e);
            }
            this.batch.finish();
            try {
                this.batch.await();
            }
            catch (IgniteCheckedException e) {
                if (err2 == null) {
                    err2 = new IOException("Failed to close secondary file system stream [path=" + this.path + ", fileInfo=" + this.info + ']', e);
                }
                err2.addSuppressed(e);
            }
            if (err2 != null) {
                throw err2;
            }
            this.updateMetricsOnClose();
        }
    }

    @Override
    protected void send(Object data, int writeLen) throws IOException {
        assert (Thread.holdsLock(this.mux));
        assert (data instanceof ByteBuffer || data instanceof DataInput);
        try {
            this.bytes += (long)writeLen;
            byte[] dataBuf = new byte[writeLen];
            if (data instanceof ByteBuffer) {
                ByteBuffer byteBuf = (ByteBuffer)data;
                byteBuf.get(dataBuf);
            } else {
                DataInput dataIn = (DataInput)data;
                try {
                    dataIn.readFully(dataBuf);
                }
                catch (IOException e) {
                    throw new IgniteCheckedException(e);
                }
            }
            if (!this.batch.write(dataBuf)) {
                throw new IgniteCheckedException("Cannot write more data to the secondary file system output stream because it was marked as closed: " + this.batch.path());
            }
            this.igfsCtx.metrics().addWriteBlocks(1, 1);
        }
        catch (IgniteCheckedException e) {
            throw new IOException("Failed to store data into file: " + this.path, e);
        }
    }

    @Override
    public String toString() {
        return S.toString(IgfsOutputStreamProxyImpl.class, this);
    }
}

