/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.util.concurrent.atomic.LongAdder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiTuple;

public class IgfsLocalMetrics {
    private volatile IgniteBiTuple<LongAdder, LongAdder> blocksRead;
    private volatile IgniteBiTuple<LongAdder, LongAdder> blocksWritten;
    private volatile IgniteBiTuple<LongAdder, LongAdder> bytesRead;
    private volatile IgniteBiTuple<LongAdder, LongAdder> bytesWritten;
    private final LongAdder filesOpenedForRead = new LongAdder();
    private final LongAdder filesOpenedForWrite = new LongAdder();

    IgfsLocalMetrics() {
        this.reset();
    }

    long readBytes() {
        return this.bytesRead.get1().longValue();
    }

    long readBytesTime() {
        return this.bytesRead.get2().longValue();
    }

    void addReadBytesTime(long readBytes, long readTime) {
        IgniteBiTuple<LongAdder, LongAdder> bytesRead0 = this.bytesRead;
        bytesRead0.get1().add(readBytes);
        bytesRead0.get2().add(readTime);
    }

    long writeBytes() {
        return this.bytesWritten.get1().longValue();
    }

    long writeBytesTime() {
        return this.bytesWritten.get2().longValue();
    }

    void addWrittenBytesTime(long writtenBytes, long writeTime) {
        IgniteBiTuple<LongAdder, LongAdder> bytesWritten0 = this.bytesWritten;
        bytesWritten0.get1().add(writtenBytes);
        bytesWritten0.get2().add(writeTime);
    }

    long readBlocks() {
        return this.blocksRead.get1().longValue();
    }

    long readBlocksSecondary() {
        return this.blocksRead.get2().longValue();
    }

    void addReadBlocks(int total2, int secondary) {
        IgniteBiTuple<LongAdder, LongAdder> blocksRead0 = this.blocksRead;
        blocksRead0.get1().add(total2);
        blocksRead0.get2().add(secondary);
    }

    long writeBlocks() {
        return this.blocksWritten.get1().longValue();
    }

    long writeBlocksSecondary() {
        return this.blocksWritten.get2().longValue();
    }

    void addWriteBlocks(int total2, int secondary) {
        IgniteBiTuple<LongAdder, LongAdder> blocksWritten0 = this.blocksWritten;
        blocksWritten0.get1().add(total2);
        blocksWritten0.get2().add(secondary);
    }

    void incrementFilesOpenedForRead() {
        this.filesOpenedForRead.increment();
    }

    void decrementFilesOpenedForRead() {
        this.filesOpenedForRead.decrement();
    }

    int filesOpenedForRead() {
        return this.filesOpenedForRead.intValue();
    }

    void incrementFilesOpenedForWrite() {
        this.filesOpenedForWrite.increment();
    }

    void decrementFilesOpenedForWrite() {
        this.filesOpenedForWrite.decrement();
    }

    int filesOpenedForWrite() {
        return this.filesOpenedForWrite.intValue();
    }

    void reset() {
        this.blocksRead = F.t(new LongAdder(), new LongAdder());
        this.blocksWritten = F.t(new LongAdder(), new LongAdder());
        this.bytesRead = F.t(new LongAdder(), new LongAdder());
        this.bytesWritten = F.t(new LongAdder(), new LongAdder());
    }
}

