/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.IOException;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystem;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystemPositionedReadable;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IgfsLazySecondaryFileSystemPositionedReadable
implements IgfsSecondaryFileSystemPositionedReadable {
    private final IgfsSecondaryFileSystem fs;
    private final IgfsPath path;
    private final int bufSize;
    private final Object mux = new Object();
    private IgfsSecondaryFileSystemPositionedReadable target;

    public IgfsLazySecondaryFileSystemPositionedReadable(IgfsSecondaryFileSystem fs, IgfsPath path2, int bufSize) {
        assert (fs != null);
        assert (path2 != null);
        this.fs = fs;
        this.path = path2;
        this.bufSize = bufSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(long pos, byte[] buf, int off, int len) throws IOException {
        Object object = this.mux;
        synchronized (object) {
            if (this.target == null) {
                this.target = this.fs.open(this.path, this.bufSize);
            }
        }
        return this.target.read(pos, buf, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.mux;
        synchronized (object) {
            if (this.target != null) {
                this.target.close();
            }
        }
    }

    public String toString() {
        return S.toString(IgfsLazySecondaryFileSystemPositionedReadable.class, this);
    }
}

