/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.IOException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.igfs.IgfsInputStream;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.mapreduce.IgfsFileRange;
import org.apache.ignite.igfs.mapreduce.IgfsJob;
import org.apache.ignite.igfs.mapreduce.IgfsRecordResolver;
import org.apache.ignite.internal.GridInternalWrapper;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;

public class IgfsJobImpl
implements ComputeJob,
GridInternalWrapper<IgfsJob> {
    private static final long serialVersionUID = 0L;
    private IgfsJob job;
    private String igfsName;
    private IgfsPath path;
    private long start;
    private long len;
    private IgfsRecordResolver rslvr;
    @IgniteInstanceResource
    private Ignite ignite;
    @LoggerResource
    private IgniteLogger log;

    public IgfsJobImpl(IgfsJob job, String igfsName, IgfsPath path2, long start, long len, IgfsRecordResolver rslvr) {
        this.job = job;
        this.igfsName = igfsName;
        this.path = path2;
        this.start = start;
        this.len = len;
        this.rslvr = rslvr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute() {
        IgniteFileSystem fs = this.ignite.fileSystem(this.igfsName);
        try (IgfsInputStream in = fs.open(this.path);){
            IgfsFileRange split2 = new IgfsFileRange(this.path, this.start, this.len);
            if (this.rslvr != null && (split2 = this.rslvr.resolveRecords(fs, in, split2)) == null) {
                this.log.warning("No data found for split on local node after resolver is applied [igfsName=" + this.igfsName + ", path=" + this.path + ", start=" + this.start + ", len=" + this.len + ']');
                Object var5_7 = null;
                return var5_7;
            }
            in.seek(split2.start());
            Object object = this.job.execute(fs, new IgfsFileRange(this.path, split2.start(), split2.length()), in);
            return object;
        }
        catch (IOException e) {
            throw new IgniteException("Failed to execute IGFS job for file split [igfsName=" + this.igfsName + ", path=" + this.path + ", start=" + this.start + ", len=" + this.len + ']', e);
        }
    }

    @Override
    public void cancel() {
        this.job.cancel();
    }

    @Override
    public IgfsJob userObject() {
        return this.job;
    }
}

