/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.events.IgfsEvent;
import org.apache.ignite.igfs.IgfsCorruptedFileException;
import org.apache.ignite.igfs.IgfsInputStream;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.IgfsPathNotFoundException;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystemPositionedReadable;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsLocalMetrics;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgfsInputStreamImpl
extends IgfsInputStream
implements IgfsSecondaryFileSystemPositionedReadable {
    private static final byte[][] EMPTY_CHUNKS = new byte[0][];
    private final IgfsContext igfsCtx;
    private final IgfsSecondaryFileSystemPositionedReadable secReader;
    private IgniteLogger log;
    protected final IgfsPath path;
    private volatile IgfsEntryInfo fileInfo;
    private long pos;
    private final Map<Long, IgniteInternalFuture<byte[]>> locCache;
    private final int maxLocCacheSize;
    private final Set<IgniteInternalFuture<byte[]>> pendingFuts;
    private final Lock pendingFutsLock = new ReentrantLock();
    private final Condition pendingFutsCond = this.pendingFutsLock.newCondition();
    private boolean closed;
    private int prefetchBlocks;
    private int seqReadsBeforePrefetch;
    private long bytes;
    private long prevBlockIdx = -1L;
    private int seqReads;
    private long time;
    private long len;
    private int blockSize;
    private long blocksCnt;
    private boolean proxy;

    IgfsInputStreamImpl(IgfsContext igfsCtx, IgfsPath path2, @Nullable IgfsEntryInfo fileInfo, int prefetchBlocks, int seqReadsBeforePrefetch, @Nullable IgfsSecondaryFileSystemPositionedReadable secReader, long len, int blockSize, long blocksCnt, boolean proxy) {
        assert (igfsCtx != null);
        assert (path2 != null);
        this.igfsCtx = igfsCtx;
        this.path = path2;
        this.fileInfo = fileInfo;
        this.prefetchBlocks = prefetchBlocks;
        this.seqReadsBeforePrefetch = seqReadsBeforePrefetch;
        this.secReader = secReader;
        this.len = len;
        this.blockSize = blockSize;
        this.blocksCnt = blocksCnt;
        this.proxy = proxy;
        this.log = igfsCtx.kernalContext().log(IgfsInputStream.class);
        this.maxLocCacheSize = (prefetchBlocks > 0 ? prefetchBlocks : 1) * 3 / 2;
        this.locCache = new LinkedHashMap<Long, IgniteInternalFuture<byte[]>>(this.maxLocCacheSize, 1.0f);
        this.pendingFuts = new GridConcurrentHashSet<IgniteInternalFuture<byte[]>>(prefetchBlocks > 0 ? prefetchBlocks : 1);
        igfsCtx.metrics().incrementFilesOpenedForRead();
    }

    public synchronized long bytes() {
        return this.bytes;
    }

    @Override
    public long length() {
        return this.len;
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] buf = new byte[1];
        int read = this.read(buf, 0, 1);
        if (read == -1) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    @Override
    public synchronized int read(@NotNull byte[] b, int off, int len) throws IOException {
        int read = this.readFromStore(this.pos, b, off, len);
        if (read != -1) {
            this.pos += (long)read;
        }
        return read;
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Seek position cannot be negative: " + pos);
        }
        this.pos = pos;
    }

    @Override
    public synchronized long position() throws IOException {
        return this.pos;
    }

    @Override
    public synchronized int available() throws IOException {
        long l = this.len - this.pos;
        if (l < 0L) {
            return 0;
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public synchronized void readFully(long pos, byte[] buf) throws IOException {
        this.readFully(pos, buf, 0, buf.length);
    }

    @Override
    public synchronized void readFully(long pos, byte[] buf, int off, int len) throws IOException {
        int read;
        for (int readBytes = 0; readBytes < len; readBytes += read) {
            read = this.readFromStore(pos + (long)readBytes, buf, off + readBytes, len - readBytes);
            if (read != -1) continue;
            throw new EOFException("Failed to read stream fully (stream ends unexpectedly)[pos=" + pos + ", buf.length=" + buf.length + ", off=" + off + ", len=" + len + ']');
        }
    }

    @Override
    public synchronized int read(long pos, byte[] buf, int off, int len) throws IOException {
        return this.readFromStore(pos, buf, off, len);
    }

    public synchronized byte[][] readChunks(long pos, int len) throws IOException {
        long readable = this.len - pos;
        if (readable <= 0L) {
            return EMPTY_CHUNKS;
        }
        long startTime = System.nanoTime();
        if (readable < (long)len) {
            len = (int)readable;
        }
        assert (len > 0);
        this.bytes += (long)len;
        int start = (int)(pos / (long)this.blockSize);
        int end = (int)((pos + (long)len - 1L) / (long)this.blockSize);
        int chunkCnt = end - start + 1;
        byte[][] chunks = new byte[chunkCnt][];
        for (int i = 0; i < chunkCnt; ++i) {
            int blockOff;
            byte[] block = this.blockFragmentizerSafe(start + i);
            int blockLen = Math.min(len, block.length - (blockOff = (int)(pos % (long)this.blockSize)));
            if (blockLen == block.length) {
                chunks[i] = block;
            } else {
                assert (i == 0 || i == chunkCnt - 1);
                chunks[i] = Arrays.copyOfRange(block, blockOff, blockOff + blockLen);
            }
            len -= blockLen;
            pos += (long)blockLen;
        }
        assert (len == 0);
        this.time += System.nanoTime() - startTime;
        return chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            try {
                if (this.secReader != null) {
                    this.secReader.close();
                    for (IgniteInternalFuture<byte[]> fut : this.locCache.values()) {
                        try {
                            fut.get();
                        }
                        catch (IgniteCheckedException igniteCheckedException) {}
                    }
                    while (!this.pendingFuts.isEmpty()) {
                        this.pendingFutsLock.lock();
                        try {
                            this.pendingFutsCond.await(100L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                        finally {
                            this.pendingFutsLock.unlock();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new IOException("File to close the file: " + this.path, e);
            }
            finally {
                this.closed = true;
                IgfsLocalMetrics metrics = this.igfsCtx.metrics();
                metrics.addReadBytesTime(this.bytes, this.time);
                metrics.decrementFilesOpenedForRead();
                this.locCache.clear();
                GridEventStorageManager evts = this.igfsCtx.kernalContext().event();
                if (evts.isRecordable(123)) {
                    evts.record(new IgfsEvent(this.path, this.igfsCtx.localNode(), 123, this.bytes()));
                }
            }
        }
    }

    private int readFromStore(long pos, byte[] buf, int off, int len) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Read position cannot be negative: " + pos);
        }
        if (buf == null) {
            throw new NullPointerException("Destination buffer cannot be null.");
        }
        if (off < 0 || len < 0 || buf.length < len + off) {
            throw new IndexOutOfBoundsException("Invalid buffer boundaries [buf.length=" + buf.length + ", off=" + off + ", len=" + len + ']');
        }
        if (len == 0) {
            return 0;
        }
        long readable = this.len - pos;
        if (readable <= 0L) {
            return -1;
        }
        long startTime = System.nanoTime();
        if (readable < (long)len) {
            len = (int)readable;
        }
        assert (len > 0);
        byte[] block = this.blockFragmentizerSafe(pos / (long)this.blockSize);
        int blockOff = (int)(pos % (long)this.blockSize);
        len = Math.min(len, block.length - blockOff);
        U.arrayCopy(block, blockOff, buf, off, len);
        this.bytes += (long)len;
        this.time += System.nanoTime() - startTime;
        return len;
    }

    private byte[] blockFragmentizerSafe(long blockIdx) throws IOException {
        try {
            try {
                return this.block(blockIdx);
            }
            catch (IgfsCorruptedFileException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to fetch file block [path=" + this.path + ", fileInfo=" + this.fileInfo + ", blockIdx=" + blockIdx + ", errMsg=" + e.getMessage() + ']');
                }
                if (this.fileInfo != null && this.fileInfo.fileMap() != null && !this.fileInfo.fileMap().ranges().isEmpty()) {
                    IgfsEntryInfo newInfo = this.igfsCtx.meta().info(this.fileInfo.id());
                    if (newInfo == null) {
                        throw new IgfsPathNotFoundException("Failed to read file block (file was concurrently deleted) [path=" + this.path + ", blockIdx=" + blockIdx + ']');
                    }
                    this.fileInfo = newInfo;
                    this.locCache.clear();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Updated input stream file info after block fetch failure [path=" + this.path + ", fileInfo=" + this.fileInfo + ']');
                    }
                    return this.block(blockIdx);
                }
                throw new IOException(e.getMessage(), e);
            }
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private byte[] block(long blockIdx) throws IOException, IgniteCheckedException {
        byte[] bytes2;
        assert (blockIdx >= 0L);
        IgniteInternalFuture<byte[]> bytesFut = this.locCache.get(blockIdx);
        if (bytesFut == null) {
            if (this.closed) {
                throw new IOException("Stream is already closed: " + this);
            }
            this.seqReads = this.prevBlockIdx != -1L && this.prevBlockIdx + 1L == blockIdx ? (this.seqReads = this.seqReads + 1) : 0;
            this.prevBlockIdx = blockIdx;
            bytesFut = this.dataBlock(blockIdx);
            assert (bytesFut != null);
            this.addLocalCacheFuture(blockIdx, bytesFut);
        }
        if (this.prefetchBlocks > 0 && this.seqReads >= this.seqReadsBeforePrefetch - 1) {
            for (int i = 1; i <= this.prefetchBlocks && (long)this.blockSize * ((long)i + blockIdx) < this.len; ++i) {
                if (this.locCache.get(blockIdx + (long)i) != null) continue;
                this.addLocalCacheFuture(blockIdx + (long)i, this.dataBlock(blockIdx + (long)i));
            }
        }
        if ((bytes2 = bytesFut.get()) == null) {
            throw new IgfsCorruptedFileException("Failed to retrieve file's data block (corrupted file?) [path=" + this.path + ", blockIdx=" + blockIdx + ']');
        }
        int blockSize0 = this.blockSize;
        if (blockIdx == this.blocksCnt - 1L) {
            blockSize0 = (int)(this.len % (long)blockSize0);
        }
        if (bytes2.length < blockSize0) {
            throw new IOException("Inconsistent file's data block (incorrectly written?) [path=" + this.path + ", blockIdx=" + blockIdx + ", blockSize=" + bytes2.length + ", expectedBlockSize=" + blockSize0 + ", fileBlockSize=" + this.blockSize + ", fileLen=" + this.len + ']');
        }
        return bytes2;
    }

    private void addLocalCacheFuture(long idx, IgniteInternalFuture<byte[]> fut) {
        assert (Thread.holdsLock(this));
        if (!this.locCache.containsKey(idx)) {
            IgniteInternalFuture<byte[]> evictFut;
            if (this.locCache.size() == this.maxLocCacheSize && !(evictFut = this.locCache.remove(this.locCache.keySet().iterator().next())).isDone()) {
                this.pendingFuts.add(evictFut);
                evictFut.listen(new IgniteInClosure<IgniteInternalFuture<byte[]>>(){

                    @Override
                    public void apply(IgniteInternalFuture<byte[]> t) {
                        IgfsInputStreamImpl.this.pendingFuts.remove(evictFut);
                        IgfsInputStreamImpl.this.pendingFutsLock.lock();
                        try {
                            IgfsInputStreamImpl.this.pendingFutsCond.signalAll();
                        }
                        finally {
                            IgfsInputStreamImpl.this.pendingFutsLock.unlock();
                        }
                    }
                });
            }
            this.locCache.put(idx, fut);
        }
    }

    @Nullable
    protected IgniteInternalFuture<byte[]> dataBlock(final long blockIdx) throws IgniteCheckedException {
        if (this.proxy) {
            assert (this.secReader != null);
            final GridFutureAdapter<byte[]> fut = new GridFutureAdapter<byte[]>();
            this.igfsCtx.runInIgfsThreadPool(new Runnable(){

                @Override
                public void run() {
                    try {
                        fut.onDone(IgfsInputStreamImpl.this.igfsCtx.data().secondaryDataBlock(IgfsInputStreamImpl.this.path, blockIdx, IgfsInputStreamImpl.this.secReader, IgfsInputStreamImpl.this.blockSize));
                    }
                    catch (Throwable e) {
                        fut.onDone(null, e);
                    }
                }
            });
            return fut;
        }
        assert (this.fileInfo != null);
        return this.igfsCtx.data().dataBlock(this.fileInfo, this.path, blockIdx, this.secReader);
    }

    public String toString() {
        return S.toString(IgfsInputStreamImpl.class, this);
    }
}

