/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.eviction.EvictionFilter;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.igfs.IgfsEvictionFilter;
import org.apache.ignite.cache.eviction.igfs.IgfsPerBlockLruEvictionPolicy;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.igfs.IgfsBlockKey;
import org.apache.ignite.internal.processors.igfs.IgfsHelper;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IgfsHelperImpl
implements IgfsHelper {
    @Override
    public void preProcessCacheConfiguration(CacheConfiguration cfg) {
        EvictionPolicy evictPlc;
        EvictionPolicy evictionPolicy = evictPlc = cfg.getEvictionPolicyFactory() != null ? cfg.getEvictionPolicyFactory().create() : cfg.getEvictionPolicy();
        if (evictPlc instanceof IgfsPerBlockLruEvictionPolicy && cfg.getEvictionFilter() == null) {
            cfg.setEvictionFilter(new IgfsEvictionFilter());
        }
    }

    @Override
    public void validateCacheConfiguration(CacheConfiguration cfg) throws IgniteCheckedException {
        EvictionFilter evictFilter;
        EvictionPolicy evictPlc;
        EvictionPolicy evictionPolicy = evictPlc = cfg.getEvictionPolicyFactory() != null ? cfg.getEvictionPolicyFactory().create() : cfg.getEvictionPolicy();
        if (evictPlc != null && evictPlc instanceof IgfsPerBlockLruEvictionPolicy && (evictFilter = cfg.getEvictionFilter()) != null && !(evictFilter instanceof IgfsEvictionFilter)) {
            throw new IgniteCheckedException("Eviction filter cannot be set explicitly when using IgfsPerBlockLruEvictionPolicy: " + U.maskName(cfg.getName()));
        }
    }

    @Override
    public boolean isIgfsBlockKey(Object key) {
        return key instanceof IgfsBlockKey;
    }
}

