/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsFileWorkerBatchCancelledException;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;

public abstract class IgfsFileWorkerBatch
implements Runnable {
    private static final byte[] FINISH_MARKER = new byte[0];
    private static final byte[] CANCEL_MARKER = new byte[0];
    private final BlockingDeque<byte[]> queue = new LinkedBlockingDeque<byte[]>();
    private final GridFutureAdapter fut = new GridFutureAdapter();
    private final IgfsPath path;
    private final OutputStream out;
    private volatile boolean finishing;

    IgfsFileWorkerBatch(IgfsPath path2, OutputStream out) {
        assert (path2 != null);
        assert (out != null);
        this.path = path2;
        this.out = out;
    }

    synchronized boolean write(byte[] data) {
        return this.offer(data, false, false);
    }

    synchronized boolean finish() {
        return this.offer(FINISH_MARKER, false, true);
    }

    synchronized boolean cancel() {
        return this.offer(CANCEL_MARKER, true, true);
    }

    private synchronized boolean offer(byte[] data, boolean head2, boolean finish2) {
        if (this.finishing) {
            return false;
        }
        if (head2) {
            this.queue.addFirst(data);
        } else {
            this.queue.addLast(data);
        }
        if (finish2) {
            this.finishing = true;
        }
        return true;
    }

    boolean finishing() {
        return this.finishing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Throwable err2 = null;
        while (true) {
            try {
                byte[] data;
                do {
                    if ((data = this.queue.poll(1000L, TimeUnit.MILLISECONDS)) == FINISH_MARKER) {
                        assert (this.queue.isEmpty());
                        return;
                    }
                    if (data != CANCEL_MARKER) continue;
                    throw new IgfsFileWorkerBatchCancelledException(this.path);
                } while (data == null);
                try {
                    this.out.write(data);
                }
                catch (IOException e) {
                    throw new IgniteCheckedException("Failed to write data to the file due to secondary file system exception: " + this.path, e);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                err2 = e;
                return;
            }
            catch (Exception e) {
                err2 = e;
                return;
            }
            continue;
            break;
        }
        catch (Throwable e) {
            err2 = e;
            if (!(e instanceof Error)) return;
            throw e;
        }
        finally {
            U.closeQuiet(this.out);
            this.onDone();
            assert (!this.fut.isDone());
            this.fut.onDone(null, err2);
        }
    }

    void await() throws IgniteCheckedException {
        this.fut.get();
    }

    IgfsPath path() {
        return this.path;
    }

    protected abstract void onDone();
}

