/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.processors.igfs.IgfsFileAffinityRange;
import org.apache.ignite.internal.processors.igfs.IgfsInvalidRangeException;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class IgfsFileMap
implements Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private List<IgfsFileAffinityRange> ranges;

    public IgfsFileMap() {
    }

    public IgfsFileMap(@Nullable IgfsFileMap old) {
        if (old != null && old.ranges != null) {
            this.ranges = new ArrayList<IgfsFileAffinityRange>(old.ranges.size());
            this.ranges.addAll(old.ranges);
        }
    }

    public IgniteUuid affinityKey(long blockOff, boolean includeMoved) {
        if (this.ranges == null) {
            return null;
        }
        assert (!this.ranges.isEmpty());
        int leftIdx = 0;
        int rightIdx = this.ranges.size() - 1;
        IgfsFileAffinityRange leftRange = this.ranges.get(leftIdx);
        IgfsFileAffinityRange rightRange = this.ranges.get(rightIdx);
        if (leftRange.less(blockOff)) {
            return null;
        }
        if (leftRange.belongs(blockOff)) {
            return leftRange.status() != 2 ? leftRange.affinityKey() : (includeMoved ? leftRange.affinityKey() : null);
        }
        if (rightRange.greater(blockOff)) {
            return null;
        }
        if (rightRange.belongs(blockOff)) {
            return rightRange.status() != 2 ? rightRange.affinityKey() : (includeMoved ? leftRange.affinityKey() : null);
        }
        while (rightIdx - leftIdx > 1) {
            int midIdx = (leftIdx + rightIdx) / 2;
            IgfsFileAffinityRange midRange = this.ranges.get(midIdx);
            if (midRange.belongs(blockOff)) {
                return midRange.status() != 2 ? midRange.affinityKey() : (includeMoved ? leftRange.affinityKey() : null);
            }
            if (midRange.less(blockOff)) {
                rightIdx = midIdx;
                continue;
            }
            assert (midRange.greater(blockOff));
            leftIdx = midIdx;
        }
        return null;
    }

    public void updateRangeStatus(IgfsFileAffinityRange range2, int status) {
        if (this.ranges == null) {
            throw new IgfsInvalidRangeException("Failed to update range status (file map is empty) [range=" + range2 + ", ranges=null]");
        }
        assert (!this.ranges.isEmpty());
        int lastIdx = this.ranges.size() - 1;
        IgfsFileAffinityRange last2 = this.ranges.get(lastIdx);
        if (last2.startOffset() == range2.startOffset()) {
            this.updateRangeStatus0(lastIdx, last2, range2, status);
            return;
        }
        int firstIdx = 0;
        IgfsFileAffinityRange first = this.ranges.get(firstIdx);
        if (first.startOffset() == range2.startOffset()) {
            this.updateRangeStatus0(firstIdx, first, range2, status);
            return;
        }
        while (lastIdx - firstIdx > 1) {
            int midIdx = (firstIdx + lastIdx) / 2;
            IgfsFileAffinityRange midRange = this.ranges.get(midIdx);
            if (midRange.startOffset() == range2.startOffset()) {
                this.updateRangeStatus0(midIdx, midRange, range2, status);
                return;
            }
            if (midRange.less(range2.startOffset())) {
                lastIdx = midIdx;
                continue;
            }
            assert (midRange.greater(range2.startOffset()));
            firstIdx = midIdx;
        }
        throw new IgfsInvalidRangeException("Failed to update map for range (corresponding map range was not found) [range=" + range2 + ", status=" + status + ", ranges=" + this.ranges + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRange(IgfsFileAffinityRange range2) {
        if (this.ranges == null) {
            throw new IgfsInvalidRangeException("Failed to remove range (file map is empty) [range=" + range2 + ", ranges=null]");
        }
        assert (!this.ranges.isEmpty());
        try {
            int lastIdx = this.ranges.size() - 1;
            IgfsFileAffinityRange last2 = this.ranges.get(lastIdx);
            if (last2.regionEqual(range2)) {
                assert (last2.status() == 2);
                this.ranges.remove(last2);
                return;
            }
            int firstIdx = 0;
            IgfsFileAffinityRange first = this.ranges.get(firstIdx);
            if (first.regionEqual(range2)) {
                assert (first.status() == 2);
                this.ranges.remove(first);
                return;
            }
            while (lastIdx - firstIdx > 1) {
                int midIdx = (firstIdx + lastIdx) / 2;
                IgfsFileAffinityRange midRange = this.ranges.get(midIdx);
                if (midRange.regionEqual(range2)) {
                    assert (midRange.status() == 2);
                    this.ranges.remove(midIdx);
                    return;
                }
                if (midRange.less(range2.startOffset())) {
                    lastIdx = midIdx;
                    continue;
                }
                assert (midRange.greater(range2.startOffset()));
                firstIdx = midIdx;
            }
        }
        finally {
            if (this.ranges.isEmpty()) {
                this.ranges = null;
            }
        }
        throw new IgfsInvalidRangeException("Failed to remove range from file map (corresponding map range was not found) [range=" + range2 + ", ranges=" + this.ranges + ']');
    }

    private void updateRangeStatus0(int origIdx, IgfsFileAffinityRange orig, IgfsFileAffinityRange update2, int status) {
        assert (F.eq(orig.affinityKey(), update2.affinityKey()));
        assert (this.ranges.get(origIdx) == orig);
        if (orig.regionEqual(update2)) {
            this.ranges.set(origIdx, new IgfsFileAffinityRange(update2, status));
        } else {
            assert (orig.endOffset() > update2.endOffset());
            this.ranges.set(origIdx, new IgfsFileAffinityRange(update2, status));
            this.ranges.add(origIdx + 1, new IgfsFileAffinityRange(update2.endOffset() + 1L, orig.endOffset(), orig.affinityKey()));
        }
    }

    public List<IgfsFileAffinityRange> ranges() {
        if (this.ranges == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.ranges);
    }

    public void addRange(IgfsFileAffinityRange range2) {
        if (range2 == null || range2.empty()) {
            return;
        }
        if (this.ranges == null) {
            this.ranges = new ArrayList<IgfsFileAffinityRange>();
            this.ranges.add(range2);
            return;
        }
        assert (!this.ranges.isEmpty());
        IgfsFileAffinityRange last2 = this.ranges.get(this.ranges.size() - 1);
        assert (last2.greater(range2.startOffset())) : "Cannot add range to middle of map [last=" + last2 + ", range=" + range2 + ']';
        IgfsFileAffinityRange concat2 = last2.concat(range2);
        if (concat2 == null) {
            this.ranges.add(range2);
        } else {
            this.ranges.set(this.ranges.size() - 1, concat2);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.ranges == null) {
            out.writeInt(-1);
        } else {
            assert (!this.ranges.isEmpty());
            out.writeInt(this.ranges.size());
            for (IgfsFileAffinityRange range2 : this.ranges) {
                out.writeObject(range2);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        if (size2 > 0) {
            this.ranges = new ArrayList<IgfsFileAffinityRange>(size2);
            for (int i = 0; i < size2; ++i) {
                this.ranges.add((IgfsFileAffinityRange)in.readObject());
            }
        }
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        if (this.ranges == null) {
            out.writeInt(-1);
        } else {
            assert (!this.ranges.isEmpty());
            out.writeInt(this.ranges.size());
            for (IgfsFileAffinityRange range2 : this.ranges) {
                out.writeObject(range2);
            }
        }
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        int size2 = in.readInt();
        if (size2 > 0) {
            this.ranges = new ArrayList<IgfsFileAffinityRange>(size2);
            for (int i = 0; i < size2; ++i) {
                this.ranges.add((IgfsFileAffinityRange)in.readObject());
            }
        }
    }

    public String toString() {
        return S.toString(IgfsFileMap.class, this);
    }
}

