/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class IgfsFileAffinityRange
implements Message,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    public static final int RANGE_STATUS_INITIAL = 0;
    public static final int RANGE_STATUS_MOVING = 1;
    public static final int RANGE_STATUS_MOVED = 2;
    private IgniteUuid affKey;
    private int status = 0;
    private long startOff;
    private long endOff;
    private boolean done;

    public IgfsFileAffinityRange() {
    }

    IgfsFileAffinityRange(long startOff, long endOff, IgniteUuid affKey) {
        this.startOff = startOff;
        this.endOff = endOff;
        this.affKey = affKey;
    }

    IgfsFileAffinityRange(IgfsFileAffinityRange other, int status) {
        this.startOff = other.startOff;
        this.endOff = other.endOff;
        this.affKey = other.affKey;
        this.status = status;
    }

    public IgniteUuid affinityKey() {
        return this.affKey;
    }

    public long startOffset() {
        return this.startOff;
    }

    public long endOffset() {
        return this.endOff;
    }

    public boolean belongs(long blockStartOff) {
        return blockStartOff >= this.startOff && blockStartOff < this.endOff;
    }

    public boolean less(long blockStartOff) {
        return blockStartOff < this.startOff;
    }

    public boolean greater(long blockStartOff) {
        return blockStartOff > this.endOff;
    }

    public boolean empty() {
        return this.startOff == this.endOff;
    }

    public int status() {
        return this.status;
    }

    public void expand(long blockStartOff, int expansionSize) {
        if (this.endOff == this.startOff) {
            assert (this.endOff == blockStartOff) : "Failed to expand range [endOff=" + this.endOff + ", blockStartOff=" + blockStartOff + ", expansionSize=" + expansionSize + ']';
            this.endOff += (long)(expansionSize - 1);
        } else {
            assert (this.endOff == blockStartOff - 1L);
            this.endOff += (long)expansionSize;
        }
    }

    public Collection<IgfsFileAffinityRange> split(long maxSize) {
        long len = this.endOff - this.startOff + 1L;
        if (len > maxSize) {
            int size2 = (int)(len / maxSize + 1L);
            ArrayList<IgfsFileAffinityRange> res = new ArrayList<IgfsFileAffinityRange>(size2);
            long pos = this.startOff;
            while (pos < this.endOff + 1L) {
                long end = Math.min(pos + maxSize - 1L, this.endOff);
                IgfsFileAffinityRange part = new IgfsFileAffinityRange(pos, end, this.affKey);
                part.status = this.status;
                res.add(part);
                pos = end + 1L;
            }
            return res;
        }
        return Collections.singletonList(this);
    }

    @Nullable
    public IgfsFileAffinityRange concat(IgfsFileAffinityRange range2) {
        if (this.endOff + 1L != range2.startOff || !F.eq(this.affKey, range2.affKey) || this.status != 0) {
            return null;
        }
        return new IgfsFileAffinityRange(this.startOff, range2.endOff, this.affKey);
    }

    public boolean regionEqual(IgfsFileAffinityRange other) {
        return this.startOff == other.startOff && this.endOff == other.endOff;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeGridUuid(out, this.affKey);
        out.writeInt(this.status);
        out.writeLong(this.startOff);
        out.writeLong(this.endOff);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.affKey = U.readGridUuid(in);
        this.status = in.readInt();
        this.startOff = in.readLong();
        this.endOff = in.readLong();
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        this.writeRawBinary(writer.rawWriter());
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        this.readRawBinary(reader.rawReader());
    }

    public void writeRawBinary(BinaryRawWriter writer) throws BinaryObjectException {
        BinaryUtils.writeIgniteUuid(writer, this.affKey);
        writer.writeInt(this.status);
        writer.writeLong(this.startOff);
        writer.writeLong(this.endOff);
    }

    public void readRawBinary(BinaryRawReader reader) throws BinaryObjectException {
        this.affKey = BinaryUtils.readIgniteUuid(reader);
        this.status = reader.readInt();
        this.startOff = reader.readLong();
        this.endOff = reader.readLong();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeIgniteUuid("affKey", this.affKey)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeBoolean("done", this.done)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLong("endOff", this.endOff)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeLong("startOff", this.startOff)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeInt("status", this.status)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.affKey = reader.readIgniteUuid("affKey");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.done = reader.readBoolean("done");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.endOff = reader.readLong("endOff");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.startOff = reader.readLong("startOff");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.status = reader.readInt("status");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(IgfsFileAffinityRange.class);
    }

    @Override
    public short directType() {
        return 68;
    }

    @Override
    public byte fieldsCount() {
        return 5;
    }

    public String toString() {
        return S.toString(IgfsFileAffinityRange.class, this);
    }
}

