/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.IgfsDataManager;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsListingEntry;
import org.apache.ignite.internal.processors.igfs.IgfsMetaManager;
import org.apache.ignite.internal.processors.igfs.IgfsThread;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public class IgfsDeleteWorker
extends IgfsThread {
    private static final long FREQUENCY = 1000L;
    private static final int MAX_DELETE_BATCH = 100;
    private final IgfsContext igfsCtx;
    private final IgfsMetaManager meta;
    private final IgfsDataManager data;
    private final IgniteLogger log;
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();
    private boolean force;
    private volatile boolean cancelled;

    IgfsDeleteWorker(IgfsContext igfsCtx) {
        super("igfs-delete-worker%" + igfsCtx.igfs().name() + "%" + igfsCtx.kernalContext().localNodeId() + "%");
        this.igfsCtx = igfsCtx;
        this.meta = igfsCtx.meta();
        this.data = igfsCtx.data();
        assert (this.meta != null);
        assert (this.data != null);
        this.log = igfsCtx.kernalContext().log(IgfsDeleteWorker.class);
    }

    @Override
    protected void body() throws InterruptedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Delete worker started.");
        }
        while (!this.cancelled) {
            this.lock.lock();
            try {
                if (!this.cancelled && !this.force) {
                    this.cond.await(1000L, TimeUnit.MILLISECONDS);
                }
                this.force = false;
            }
            finally {
                this.lock.unlock();
            }
            if (this.cancelled) continue;
            this.delete();
        }
    }

    void signal() {
        this.lock.lock();
        try {
            this.force = true;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    void cancel() {
        this.cancelled = true;
        this.interrupt();
    }

    private void delete() {
        for (int i = 0; i < 64; ++i) {
            this.delete(IgfsUtils.trashId(i));
        }
    }

    private void delete(IgniteUuid trashId) {
        IgfsEntryInfo info2;
        block9: {
            info2 = null;
            try {
                info2 = this.meta.info(trashId);
            }
            catch (ClusterTopologyServerNotFoundException clusterTopologyServerNotFoundException) {
            }
            catch (IgniteCheckedException e) {
                U.warn(this.log, "Cannot obtain trash directory info (is node stopping?)");
                if (!this.log.isDebugEnabled()) break block9;
                U.error(this.log, "Cannot obtain trash directory info.", e);
            }
        }
        if (info2 != null) {
            for (Map.Entry<String, IgfsListingEntry> entry2 : info2.listing().entrySet()) {
                IgniteUuid fileId = entry2.getValue().fileId();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Deleting IGFS trash entry [name=" + entry2.getKey() + ", fileId=" + fileId + ']');
                }
                try {
                    if (this.cancelled) break;
                    if (!this.delete(trashId, entry2.getKey(), fileId) || !this.log.isDebugEnabled()) continue;
                    this.log.debug("Sending delete confirmation message [name=" + entry2.getKey() + ", fileId=" + fileId + ']');
                }
                catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to delete entry from the trash directory: " + entry2.getKey(), e);
                }
            }
        }
    }

    private boolean delete(IgniteUuid trashId, String name, IgniteUuid id) throws IgniteCheckedException {
        IgfsEntryInfo info2;
        assert (name != null);
        assert (id != null);
        while ((info2 = this.meta.info(id)) != null) {
            if (info2.isDirectory()) {
                if (!this.deleteDirectoryContents(trashId, id)) {
                    return false;
                }
                if (!this.meta.delete(trashId, name, id)) continue;
                return true;
            }
            assert (info2.isFile());
            IgfsEntryInfo lockedInfo = this.meta.lock(id, true);
            if (lockedInfo == null) {
                return false;
            }
            assert (id.equals(lockedInfo.id()));
            this.data.delete(lockedInfo).get();
            boolean ret = this.meta.delete(trashId, name, id);
            if (ret) {
                IgfsPath path2 = IgfsUtils.extractOriginalPathFromTrash(name);
                assert (path2 != null);
                IgfsUtils.sendEvents(this.igfsCtx.kernalContext(), path2, 127);
            }
            return ret;
        }
        return false;
    }

    private boolean deleteDirectoryContents(IgniteUuid parentId, IgniteUuid id) throws IgniteCheckedException {
        IgfsEntryInfo info2;
        assert (parentId != null);
        assert (id != null);
        while ((info2 = this.meta.info(id)) != null) {
            assert (info2.isDirectory());
            Map<String, IgfsListingEntry> listing = info2.listing();
            if (listing.isEmpty()) {
                return true;
            }
            HashMap<String, IgfsListingEntry> delListing = new HashMap<String, IgfsListingEntry>(100, 1.0f);
            GridCompoundFuture fut = new GridCompoundFuture();
            int failedFiles = 0;
            for (Map.Entry<String, IgfsListingEntry> entry2 : listing.entrySet()) {
                if (this.cancelled) {
                    return false;
                }
                if (entry2.getValue().isDirectory()) {
                    if (this.deleteDirectoryContents(id, entry2.getValue().fileId())) {
                        delListing.put(entry2.getKey(), entry2.getValue());
                    } else {
                        ++failedFiles;
                    }
                } else {
                    IgfsEntryInfo fileInfo = this.meta.info(entry2.getValue().fileId());
                    if (fileInfo != null) {
                        assert (fileInfo.isFile());
                        IgfsEntryInfo lockedInfo = this.meta.lock(fileInfo.id(), true);
                        if (lockedInfo == null) {
                            ++failedFiles;
                        } else {
                            assert (IgfsUtils.DELETE_LOCK_ID.equals(lockedInfo.lockId()));
                            fut.add(this.data.delete(lockedInfo));
                            delListing.put(entry2.getKey(), entry2.getValue());
                        }
                    }
                }
                if (delListing.size() != 100) continue;
                break;
            }
            fut.markInitialized();
            try {
                fut.get();
            }
            catch (IgniteFutureCancelledCheckedException ignore) {
                this.cancelled = true;
                return false;
            }
            Collection<IgniteUuid> delIds = this.meta.delete(id, delListing);
            if (listing.size() == delIds.size()) {
                return true;
            }
            if (listing.size() != delListing.size() + failedFiles) continue;
            return false;
        }
        return true;
    }
}

