/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.events.IgfsEvent;
import org.apache.ignite.igfs.IgfsOutputStream;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.IgfsFileWorkerBatch;
import org.apache.ignite.internal.processors.igfs.IgfsLocalMetrics;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

abstract class IgfsAbstractOutputStream
extends IgfsOutputStream {
    protected final IgfsContext igfsCtx;
    protected final IgfsPath path;
    protected final int bufSize;
    protected final IgfsFileWorkerBatch batch;
    protected final Object mux;
    protected boolean closed;
    protected ByteBuffer buf;
    protected long bytes;
    protected long time;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IgfsAbstractOutputStream(IgfsContext igfsCtx, IgfsPath path2, int bufSize, @Nullable IgfsFileWorkerBatch batch) {
        Object object = this.mux = new Object();
        synchronized (object) {
            this.path = path2;
            this.bufSize = this.optimizeBufferSize(bufSize);
            this.igfsCtx = igfsCtx;
            this.batch = batch;
        }
        igfsCtx.metrics().incrementFilesOpenedForWrite();
    }

    protected abstract int optimizeBufferSize(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        Object object = this.mux;
        synchronized (object) {
            this.checkClosed(null, 0);
            b &= 0xFF;
            long startTime = System.nanoTime();
            if (this.buf == null) {
                this.buf = this.allocateNewBuffer();
            }
            this.buf.put((byte)b);
            this.sendBufferIfFull();
            this.time += System.nanoTime() - startTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        A.notNull(b, "b");
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException("Invalid bounds [data.length=" + b.length + ", offset=" + off + ", length=" + len + ']');
        }
        Object object = this.mux;
        synchronized (object) {
            this.checkClosed(null, 0);
            if (len == 0) {
                return;
            }
            long startTime = System.nanoTime();
            if (this.buf == null) {
                if (len >= this.bufSize) {
                    ByteBuffer tmpBuf = ByteBuffer.wrap(b, off, len);
                    this.send(tmpBuf, tmpBuf.remaining());
                } else {
                    this.buf = this.allocateNewBuffer();
                    this.buf.put(b, off, len);
                }
            } else {
                if (this.buf.remaining() < len) {
                    this.buf = ByteBuffer.allocate(this.buf.position() + len).put((ByteBuffer)this.buf.flip());
                }
                this.buf.put(b, off, len);
                this.sendBufferIfFull();
            }
            this.time += System.nanoTime() - startTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferFrom(DataInput in, int len) throws IOException {
        Object object = this.mux;
        synchronized (object) {
            this.checkClosed(in, len);
            long startTime = System.nanoTime();
            this.sendBufferIfNotEmpty();
            this.send(in, len);
            this.time += System.nanoTime() - startTime;
        }
    }

    protected void checkClosed(@Nullable DataInput in, int len) throws IOException {
        assert (Thread.holdsLock(this.mux));
        if (this.closed) {
            if (in != null) {
                in.skipBytes(len);
            }
            throw new IOException("Stream has been closed: " + this);
        }
    }

    private void sendBufferIfFull() throws IOException {
        if (this.buf.position() >= this.bufSize) {
            this.sendBuffer();
        }
    }

    void sendBufferIfNotEmpty() throws IOException {
        if (this.buf != null && this.buf.position() > 0) {
            this.sendBuffer();
        }
    }

    private void sendBuffer() throws IOException {
        this.buf.flip();
        this.send(this.buf, this.buf.remaining());
        this.buf = null;
    }

    protected abstract void send(Object var1, int var2) throws IOException;

    private ByteBuffer allocateNewBuffer() {
        return ByteBuffer.allocate(this.bufSize);
    }

    protected void updateMetricsOnClose() {
        IgfsLocalMetrics metrics = this.igfsCtx.metrics();
        metrics.addWrittenBytesTime(this.bytes, this.time);
        metrics.decrementFilesOpenedForWrite();
        GridEventStorageManager evts = this.igfsCtx.kernalContext().event();
        if (evts.isRecordable(122)) {
            evts.record(new IgfsEvent(this.path, this.igfsCtx.localNode(), 122, this.bytes));
        }
    }

    public String toString() {
        return S.toString(IgfsAbstractOutputStream.class, this);
    }
}

