/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.hadoop.shuffle;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.hadoop.HadoopJobId;
import org.apache.ignite.internal.processors.hadoop.message.HadoopMessage;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class HadoopShuffleMessage
implements Message,
HadoopMessage {
    private static final long serialVersionUID = 0L;
    private static final AtomicLong ids = new AtomicLong();
    private static final byte MARKER_KEY = 17;
    private static final byte MARKER_VALUE = 31;
    @GridToStringInclude
    private long msgId;
    @GridToStringInclude
    private HadoopJobId jobId;
    @GridToStringInclude
    private int reducer;
    private byte[] buf;
    @GridToStringInclude
    private int off;

    public HadoopShuffleMessage() {
    }

    public HadoopShuffleMessage(HadoopJobId jobId, int reducer, int size2) {
        assert (jobId != null);
        this.buf = new byte[size2];
        this.jobId = jobId;
        this.reducer = reducer;
        this.msgId = ids.incrementAndGet();
    }

    public long id() {
        return this.msgId;
    }

    public HadoopJobId jobId() {
        return this.jobId;
    }

    public int reducer() {
        return this.reducer;
    }

    public byte[] buffer() {
        return this.buf;
    }

    public int offset() {
        return this.off;
    }

    public boolean available(int size2, boolean valOnly) {
        if (this.off + (size2 += valOnly ? 5 : 10) > this.buf.length) {
            if (this.off == 0) {
                this.buf = new byte[size2];
                return true;
            }
            return false;
        }
        return true;
    }

    public void addKey(long keyPtr, int keySize) {
        this.add((byte)17, keyPtr, keySize);
    }

    public void addValue(long valPtr, int valSize) {
        this.add((byte)31, valPtr, valSize);
    }

    private void add(byte marker, long ptr, int size2) {
        this.buf[this.off++] = marker;
        GridUnsafe.putInt(this.buf, GridUnsafe.BYTE_ARR_OFF + (long)this.off, size2);
        this.off += 4;
        GridUnsafe.copyOffheapHeap(ptr, this.buf, GridUnsafe.BYTE_ARR_OFF + (long)this.off, size2);
        this.off += size2;
    }

    public void visit(Visitor v) throws IgniteCheckedException {
        int size2;
        for (int i = 0; i < this.off; i += size2) {
            byte marker = this.buf[i++];
            size2 = GridUnsafe.getInt(this.buf, GridUnsafe.BYTE_ARR_OFF + (long)i);
            i += 4;
            if (marker == 31) {
                v.onValue(this.buf, i, size2);
                continue;
            }
            if (marker == 17) {
                v.onKey(this.buf, i, size2);
                continue;
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeByteArray("buf", this.buf)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeMessage("jobId", this.jobId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLong("msgId", this.msgId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeInt("off", this.off)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeInt("reducer", this.reducer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.buf = reader.readByteArray("buf");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.jobId = (HadoopJobId)reader.readMessage("jobId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msgId = reader.readLong("msgId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.off = reader.readInt("off");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.reducer = reader.readInt("reducer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HadoopShuffleMessage.class);
    }

    @Override
    public short directType() {
        return -37;
    }

    @Override
    public byte fieldsCount() {
        return 5;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.jobId.writeExternal(out);
        out.writeLong(this.msgId);
        out.writeInt(this.reducer);
        out.writeInt(this.off);
        U.writeByteArray(out, this.buf);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jobId = new HadoopJobId();
        this.jobId.readExternal(in);
        this.msgId = in.readLong();
        this.reducer = in.readInt();
        this.off = in.readInt();
        this.buf = U.readByteArray(in);
    }

    public String toString() {
        return S.toString(HadoopShuffleMessage.class, this);
    }

    public static interface Visitor {
        public void onKey(byte[] var1, int var2, int var3) throws IgniteCheckedException;

        public void onValue(byte[] var1, int var2, int var3) throws IgniteCheckedException;
    }
}

