/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.hadoop;

import java.util.Comparator;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.hadoop.HadoopJobEx;
import org.apache.ignite.internal.processors.hadoop.HadoopMapperAwareTaskOutput;
import org.apache.ignite.internal.processors.hadoop.HadoopPartitioner;
import org.apache.ignite.internal.processors.hadoop.HadoopSerialization;
import org.apache.ignite.internal.processors.hadoop.HadoopTaskInfo;
import org.apache.ignite.internal.processors.hadoop.HadoopTaskInput;
import org.apache.ignite.internal.processors.hadoop.HadoopTaskOutput;
import org.apache.ignite.internal.processors.hadoop.counter.HadoopCounter;
import org.apache.ignite.internal.processors.hadoop.counter.HadoopCounters;
import org.apache.ignite.internal.processors.hadoop.io.PartiallyOffheapRawComparatorEx;

public abstract class HadoopTaskContext {
    protected final HadoopJobEx job;
    private HadoopTaskInput input;
    private HadoopTaskOutput output;
    private HadoopTaskInfo taskInfo;

    protected HadoopTaskContext(HadoopTaskInfo taskInfo, HadoopJobEx job) {
        this.taskInfo = taskInfo;
        this.job = job;
    }

    public HadoopTaskInfo taskInfo() {
        return this.taskInfo;
    }

    public void taskInfo(HadoopTaskInfo info2) {
        this.taskInfo = info2;
    }

    public HadoopTaskOutput output() {
        return this.output;
    }

    public HadoopTaskInput input() {
        return this.input;
    }

    public HadoopJobEx job() {
        return this.job;
    }

    public abstract <T extends HadoopCounter> T counter(String var1, String var2, Class<T> var3);

    public abstract HadoopCounters counters();

    public void input(HadoopTaskInput in) {
        this.input = in;
    }

    public void output(HadoopTaskOutput out) {
        this.output = out;
    }

    public abstract HadoopPartitioner partitioner() throws IgniteCheckedException;

    public abstract HadoopSerialization keySerialization() throws IgniteCheckedException;

    public abstract HadoopSerialization valueSerialization() throws IgniteCheckedException;

    public abstract Comparator<Object> sortComparator();

    public abstract PartiallyOffheapRawComparatorEx<Object> partialRawSortComparator();

    public abstract Comparator<Object> groupComparator();

    public abstract void run() throws IgniteCheckedException;

    public abstract void cancel();

    public abstract void prepareTaskEnvironment() throws IgniteCheckedException;

    public abstract void cleanupTaskEnvironment() throws IgniteCheckedException;

    public abstract <T> T runAsJobOwner(Callable<T> var1) throws IgniteCheckedException;

    public void onMapperFinished() throws IgniteCheckedException {
        if (this.output instanceof HadoopMapperAwareTaskOutput) {
            ((HadoopMapperAwareTaskOutput)this.output).onMapperFinished();
        }
    }
}

