/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.hadoop;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.hadoop.HadoopClasspathUtils;
import org.apache.ignite.internal.processors.hadoop.HadoopHelper;
import org.apache.ignite.internal.processors.hadoop.HadoopJobId;
import org.apache.ignite.internal.processors.hadoop.HadoopTaskInfo;
import org.apache.ignite.internal.util.ClassCache;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class HadoopClassLoader
extends URLClassLoader
implements ClassCache {
    public static final String CLS_DAEMON = "org.apache.hadoop.util.Daemon";
    public static final String CLS_SHUTDOWN_HOOK_MANAGER = "org.apache.hadoop.util.ShutdownHookManager";
    public static final String CLS_DAEMON_REPLACE = "org.apache.ignite.internal.processors.hadoop.impl.v2.HadoopDaemon";
    public static final String CLS_SHUTDOWN_HOOK_MANAGER_REPLACE = "org.apache.ignite.internal.processors.hadoop.impl.v2.HadoopShutdownHookManager";
    private static final ClassLoader APP_CLS_LDR = HadoopClassLoader.class.getClassLoader();
    private static final Collection<URL> appJars = F.asList(IgniteUtils.classLoaderUrls(APP_CLS_LDR));
    private static final Object LIBS_MUX = new Object();
    private static final Collection<String> PREDEFINED_NATIVE_LIBS;
    private static Collection<Object> NATIVE_LIBS;
    private static volatile Collection<URL> hadoopJars;
    private static final Map<String, byte[]> bytesCache;
    private final ConcurrentMap<String, Class> cacheMap = new ConcurrentHashMap<String, Class>();
    private final String name;
    private final HadoopHelper helper;

    public static String nameForJob(HadoopJobId jobId) {
        return "hadoop-job-" + jobId;
    }

    public static String nameForTask(HadoopTaskInfo info2, boolean prefix) {
        if (prefix) {
            return "hadoop-task-" + info2.jobId() + "-";
        }
        return "hadoop-task-" + info2.jobId() + "-" + (Object)((Object)info2.type()) + "-" + info2.taskNumber();
    }

    public HadoopClassLoader(URL[] urls, String name, @Nullable String[] libNames, HadoopHelper helper) {
        super(HadoopClassLoader.addHadoopUrls(urls), APP_CLS_LDR);
        assert (!(this.getParent() instanceof HadoopClassLoader));
        this.name = name;
        this.helper = helper;
        this.initializeNativeLibraries(libNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNativeLibraries(@Nullable String[] usrLibs) {
        Serializable ldrLibs;
        Collection<Object> res;
        Object object2 = LIBS_MUX;
        synchronized (object2) {
            if (NATIVE_LIBS == null) {
                LinkedList<NativeLibrary> libs = new LinkedList<NativeLibrary>();
                for (String lib : PREDEFINED_NATIVE_LIBS) {
                    libs.add(new NativeLibrary(lib, true));
                }
                if (!F.isEmpty(usrLibs)) {
                    for (String usrLib : usrLibs) {
                        libs.add(new NativeLibrary(usrLib, false));
                    }
                }
                NATIVE_LIBS = HadoopClassLoader.initializeNativeLibraries0(libs);
            }
            res = NATIVE_LIBS;
        }
        Object ldrLibsObj = HadoopClassLoader.nativeLibraries(this);
        if (ldrLibsObj instanceof Vector) {
            ldrLibs = (Vector)ldrLibsObj;
            Vector vector = ldrLibs;
            synchronized (vector) {
                ((Vector)ldrLibs).addAll(res);
            }
        }
        if (ldrLibsObj instanceof ConcurrentHashMap) {
            Serializable serializable = ldrLibs = (ConcurrentHashMap)ldrLibsObj;
            synchronized (serializable) {
                for (Object nl : res) {
                    ((ConcurrentHashMap)ldrLibs).put(HadoopClassLoader.nativeLibraryName(nl), nl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Object> initializeNativeLibraries0(Collection<NativeLibrary> libs) {
        assert (Thread.holdsLock(LIBS_MUX));
        HashSet<Object> res = new HashSet<Object>();
        for (NativeLibrary lib : libs) {
            String libName = lib.name;
            File libFile = new File(libName);
            try {
                if (libFile.isAbsolute()) {
                    System.load(libName);
                } else {
                    System.loadLibrary(libName);
                }
                Object libObj = null;
                for (ClassLoader ldr = APP_CLS_LDR; ldr != null; ldr = ldr.getParent()) {
                    Object ldrLibObject = HadoopClassLoader.nativeLibraries(ldr);
                    Collection<Object> ldrLibObjs = null;
                    ldrLibObjs = ldrLibObject instanceof Vector ? (Vector)ldrLibObject : (ldrLibObject instanceof ConcurrentHashMap ? ((ConcurrentHashMap)ldrLibObject).values() : Collections.emptySet());
                    Object object = ldrLibObject;
                    synchronized (object) {
                        for (Object ldrLibObj : ldrLibObjs) {
                            String name = HadoopClassLoader.nativeLibraryName(ldrLibObj);
                            if (libFile.isAbsolute()) {
                                if (!F.eq(name, libFile.getCanonicalPath())) continue;
                                libObj = ldrLibObj;
                                break;
                            }
                            if (!name.contains(libName)) continue;
                            libObj = ldrLibObj;
                            break;
                        }
                    }
                    if (libObj != null) break;
                }
                if (libObj == null) {
                    throw new IgniteException("Failed to find loaded library: " + libName);
                }
                res.add(libObj);
            }
            catch (UnsatisfiedLinkError e) {
                if (lib.optional) continue;
                throw e;
            }
            catch (IOException e) {
                throw new IgniteException("Failed to initialize native libraries due to unexpected exception.", e);
            }
        }
        return res;
    }

    private static Object nativeLibraries(ClassLoader ldr) {
        assert (ldr != null);
        return U.field(ldr, "nativeLibraries");
    }

    private static String nativeLibraryName(Object lib) {
        assert (lib != null);
        return (String)U.field(lib, "name");
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            if (name.equals(CLS_SHUTDOWN_HOOK_MANAGER)) {
                return this.loadReplace(name, CLS_SHUTDOWN_HOOK_MANAGER_REPLACE);
            }
            if (name.equals(CLS_DAEMON)) {
                return this.loadReplace(name, CLS_DAEMON_REPLACE);
            }
            if (HadoopClassLoader.loadByCurrentClassloader(name)) {
                return this.loadClassExplicitly(name, resolve);
            }
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new ClassNotFoundException("Failed to load class: " + name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadReplace(String originalName, String replaceName) {
        Object object = this.getClassLoadingLock(originalName);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(originalName);
            if (c != null) {
                return c;
            }
            byte[] bytes2 = bytesCache.get(originalName);
            if (bytes2 == null) {
                InputStream in = this.helper.loadClassBytes(this, replaceName);
                if (in == null) {
                    throw new IgniteException("Failed to replace class [originalName=" + originalName + ", replaceName=" + replaceName + ']');
                }
                bytes2 = this.helper.loadReplace(in, originalName, replaceName);
                bytesCache.put(originalName, bytes2);
            }
            return this.defineClass(originalName, bytes2, 0, bytes2.length);
        }
    }

    @Override
    public Class<?> getFromCache(String clsName) throws ClassNotFoundException {
        Class<?> old;
        Class<?> cls = (Class<?>)this.cacheMap.get(clsName);
        if (cls == null && (old = this.cacheMap.putIfAbsent(clsName, cls = Class.forName(clsName, true, this))) != null) {
            cls = old;
        }
        return cls;
    }

    public static boolean loadByCurrentClassloader(String clsName) {
        if (clsName.startsWith("org.apache.ignite.internal.processors.hadoop.impl")) {
            return true;
        }
        return clsName.startsWith("org.apache.ignite.hadoop") && (clsName.contains("org.apache.ignite.hadoop.fs.v1.IgniteHadoopFileSystem") || clsName.contains("org.apache.ignite.hadoop.fs.v2.IgniteHadoopFileSystem") || clsName.contains("org.apache.ignite.hadoop.io.TextPartiallyRawComparator") || clsName.contains("org.apache.ignite.hadoop.mapreduce.IgniteHadoopClientProtocolProvider"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClassExplicitly(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    private static URL[] addHadoopUrls(URL[] urls) {
        Collection<URL> hadoopJars;
        try {
            hadoopJars = HadoopClassLoader.hadoopUrls();
        }
        catch (IgniteCheckedException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Object> list2 = new ArrayList<Object>(hadoopJars.size() + appJars.size() + (urls == null ? 0 : urls.length));
        list2.addAll(appJars);
        list2.addAll(hadoopJars);
        if (!F.isEmpty(urls)) {
            list2.addAll(F.asList(urls));
        }
        return list2.toArray(new URL[list2.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<URL> hadoopUrls() throws IgniteCheckedException {
        Collection<URL> hadoopUrls = hadoopJars;
        if (hadoopUrls != null) {
            return hadoopUrls;
        }
        Class<HadoopClassLoader> clazz2 = HadoopClassLoader.class;
        synchronized (HadoopClassLoader.class) {
            hadoopUrls = hadoopJars;
            if (hadoopUrls != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return hadoopUrls;
            }
            try {
                hadoopUrls = HadoopClasspathUtils.classpathForClassLoader();
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Failed to resolve Hadoop JAR locations: " + e.getMessage(), e);
            }
            hadoopJars = hadoopUrls;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return hadoopUrls;
        }
    }

    public String toString() {
        return S.toString(HadoopClassLoader.class, this);
    }

    public String name() {
        return this.name;
    }

    static {
        bytesCache = new ConcurrentHashMap<String, byte[]>();
        HadoopClassLoader.registerAsParallelCapable();
        PREDEFINED_NATIVE_LIBS = new HashSet<String>();
        PREDEFINED_NATIVE_LIBS.add("hadoop");
        PREDEFINED_NATIVE_LIBS.add("MapRClient");
    }

    private static class NativeLibrary {
        private final String name;
        private final boolean optional;

        public NativeLibrary(String name, boolean optional) {
            this.name = name;
            this.optional = optional;
        }
    }
}

