/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSet;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheGateway;
import org.apache.ignite.internal.processors.datastructures.GridCacheSetImpl;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.jetbrains.annotations.NotNull;

public class GridCacheSetProxy<T>
implements IgniteSet<T>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<T3<GridKernalContext, String, String>> stash = new ThreadLocal<T3<GridKernalContext, String, String>>(){

        @Override
        protected T3<GridKernalContext, String, String> initialValue() {
            return new T3<GridKernalContext, String, String>();
        }
    };
    private GridCacheSetImpl<T> delegate;
    private GridCacheContext cctx;
    private GridCacheGateway gate;
    private GridSpinBusyLock busyLock;
    private boolean rmvCheck;

    public GridCacheSetProxy() {
    }

    public GridCacheSetProxy(GridCacheContext cctx, GridCacheSetImpl<T> delegate) {
        this.cctx = cctx;
        this.delegate = delegate;
        this.gate = cctx.gate();
        this.busyLock = new GridSpinBusyLock();
    }

    public GridCacheSetImpl delegate() {
        return this.delegate;
    }

    public void blockOnRemove() {
        this.delegate.removed(true);
        this.busyLock.block();
    }

    @Override
    public int size() {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                int n = this.delegate.size();
                this.gate.leave();
                return n;
            }
            catch (Throwable throwable2) {
                this.gate.leave();
                throw throwable2;
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public boolean isEmpty() {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                boolean bl = this.delegate.isEmpty();
                this.gate.leave();
                return bl;
            }
            catch (Throwable throwable2) {
                this.gate.leave();
                throw throwable2;
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public boolean contains(Object o) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                boolean bl = this.delegate.contains(o);
                this.gate.leave();
                return bl;
            }
            catch (Throwable throwable2) {
                this.gate.leave();
                throw throwable2;
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    @NotNull
    public Object[] toArray() {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                Object[] objectArray = this.delegate.toArray();
                this.gate.leave();
                return objectArray;
            }
            catch (Throwable throwable2) {
                this.gate.leave();
                throw throwable2;
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(T1[] a) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                T1[] T1Array = this.delegate.toArray((T[])a);
                this.gate.leave();
                return T1Array;
            }
            catch (Throwable throwable2) {
                this.gate.leave();
                throw throwable2;
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public boolean add(T t) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                boolean bl = this.delegate.add(t);
                this.gate.leave();
                return bl;
            }
            catch (Throwable throwable2) {
                this.gate.leave();
                throw throwable2;
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                boolean bl = this.delegate.remove(o);
                this.gate.leave();
                return bl;
            }
            catch (Throwable throwable2) {
                this.gate.leave();
                throw throwable2;
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                boolean bl = this.delegate.containsAll(c);
                this.gate.leave();
                return bl;
            }
            catch (Throwable throwable2) {
                this.gate.leave();
                throw throwable2;
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                boolean bl = this.delegate.addAll(c);
                this.gate.leave();
                return bl;
            }
            catch (Throwable throwable2) {
                this.gate.leave();
                throw throwable2;
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                boolean bl = this.delegate.retainAll(c);
                this.gate.leave();
                return bl;
            }
            catch (Throwable throwable2) {
                this.gate.leave();
                throw throwable2;
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                boolean bl = this.delegate.removeAll(c);
                this.gate.leave();
                return bl;
            }
            catch (Throwable throwable2) {
                this.gate.leave();
                throw throwable2;
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public void clear() {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                this.delegate.clear();
            }
            finally {
                this.gate.leave();
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public Iterator<T> iterator() {
        this.enterBusy();
        try {
            this.gate.enter();
            try {
                Iterator<T> iterator2 = this.delegate.iterator();
                this.gate.leave();
                return iterator2;
            }
            catch (Throwable throwable2) {
                this.gate.leave();
                throw throwable2;
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    @Override
    public void close() {
        IgniteFutureImpl<Boolean> destroyFut = null;
        this.gate.enter();
        try {
            this.delegate.close();
            if (this.delegate.separated()) {
                IgniteInternalFuture<Boolean> fut = this.cctx.kernalContext().cache().dynamicDestroyCache(this.cctx.cache().name(), false, true, false);
                ((GridFutureAdapter)fut).ignoreInterrupts();
                destroyFut = new IgniteFutureImpl<Boolean>(fut);
            }
        }
        finally {
            this.gate.leave();
        }
        if (destroyFut != null) {
            destroyFut.get();
        }
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public boolean collocated() {
        return this.delegate.collocated();
    }

    @Override
    public boolean removed() {
        return this.delegate.removed();
    }

    @Override
    public void affinityRun(IgniteRunnable job) {
        this.delegate.affinityRun(job);
    }

    @Override
    public <R> R affinityCall(IgniteCallable<R> job) {
        return this.delegate.affinityCall(job);
    }

    private void enterBusy() {
        if (this.rmvCheck) {
            boolean rmvd;
            try {
                rmvd = !this.delegate().checkHeader();
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            this.rmvCheck = false;
            if (rmvd) {
                this.delegate.removed(true);
                this.cctx.dataStructures().onRemoved(this);
                throw this.removedError();
            }
        }
        if (!this.busyLock.enterBusy()) {
            throw this.removedError();
        }
    }

    public void needCheckNotRemoved() {
        this.rmvCheck = true;
    }

    private IllegalStateException removedError() {
        return new IllegalStateException("Set has been removed from cache: " + this.delegate);
    }

    private void leaveBusy() {
        this.busyLock.leaveBusy();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cctx.kernalContext());
        U.writeString(out, this.name());
        U.writeString(out, this.cctx.group().name());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        T3<GridKernalContext, String, String> t = stash.get();
        t.set1((GridKernalContext)in.readObject());
        t.set2(U.readString(in));
        t.set3(U.readString(in));
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            T3<GridKernalContext, String, String> t = stash.get();
            IgniteSet igniteSet = ((GridKernalContext)t.get1()).dataStructures().set((String)t.get2(), (String)t.get3(), null);
            return igniteSet;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

