/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.datastructures.AtomicDataStructureProxy;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.processors.datastructures.GridCacheSemaphoreEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheSemaphoreState;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public final class GridCacheSemaphoreImpl
extends AtomicDataStructureProxy<GridCacheSemaphoreState>
implements GridCacheSemaphoreEx,
IgniteChangeGlobalStateSupport,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<IgniteBiTuple<GridKernalContext, String>> stash = new ThreadLocal<IgniteBiTuple<GridKernalContext, String>>(){

        @Override
        protected IgniteBiTuple<GridKernalContext, String> initialValue() {
            return new IgniteBiTuple<GridKernalContext, String>();
        }
    };
    private final AtomicBoolean initGuard = new AtomicBoolean();
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private Sync sync;

    public GridCacheSemaphoreImpl() {
    }

    public GridCacheSemaphoreImpl(String name, GridCacheInternalKey key, IgniteInternalCache<GridCacheInternalKey, GridCacheSemaphoreState> semView) {
        super(name, key, semView);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeSemaphore() throws IgniteCheckedException {
        if (!this.initGuard.get() && this.initGuard.compareAndSet(false, true)) {
            try {
                this.sync = GridCacheUtils.retryTopologySafe(new Callable<Sync>(){

                    @Override
                    public Sync call() throws Exception {
                        try (GridNearTxLocal tx = CU.txStartInternal(GridCacheSemaphoreImpl.this.ctx, GridCacheSemaphoreImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                            GridCacheSemaphoreState val = (GridCacheSemaphoreState)GridCacheSemaphoreImpl.this.cacheView.get(GridCacheSemaphoreImpl.this.key);
                            if (val == null) {
                                if (GridCacheSemaphoreImpl.this.log.isDebugEnabled()) {
                                    GridCacheSemaphoreImpl.this.log.debug("Failed to find semaphore with given name: " + GridCacheSemaphoreImpl.this.name);
                                }
                                Sync sync = null;
                                return sync;
                            }
                            int cnt = val.getCount();
                            Map<UUID, Integer> waiters = val.getWaiters();
                            boolean failoverSafe = val.isFailoverSafe();
                            tx.commit();
                            Sync sync = new Sync(cnt, waiters, failoverSafe);
                            sync.setBroken(val.isBroken());
                            Sync sync2 = sync;
                            return sync2;
                        }
                    }
                });
                if (!this.log.isDebugEnabled()) return;
                this.log.debug("Initialized internal sync structure: " + this.sync);
                return;
            }
            finally {
                this.initLatch.countDown();
            }
        } else {
            U.await(this.initLatch);
            if (this.sync != null) return;
            throw new IgniteCheckedException("Internal semaphore has not been properly initialized.");
        }
    }

    @Override
    public void onUpdate(GridCacheSemaphoreState val) {
        if (this.sync == null) {
            return;
        }
        this.sync.setBroken(val.isBroken());
        this.sync.setPermits(val.getCount());
        this.sync.setWaiters(val.getWaiters());
        this.sync.releaseShared(0);
    }

    @Override
    public void onNodeRemoved(UUID nodeId) {
        try {
            this.initializeSemaphore();
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to recover from failover because distributed semaphore cannot be initialized (Ignore if this node is failing also).");
            return;
        }
        int numPermits = this.sync.getPermitsForNode(nodeId);
        if (numPermits > 0) {
            boolean broken = !this.sync.failoverSafe;
            this.sync.releaseFailedNode(nodeId, broken);
            if (broken) {
                this.sync.setBroken(true);
                for (Thread t : this.sync.getSharedQueuedThreads()) {
                    t.interrupt();
                }
                this.sync.releaseShared(0);
            }
        }
    }

    @Override
    public void stop() {
        block9: {
            if (this.initGuard.get()) {
                try {
                    U.await(this.initLatch);
                }
                catch (IgniteInterruptedCheckedException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.error("Failed waiting while initialization is completed.", e);
                    }
                    break block9;
                }
            }
            if (this.initGuard.compareAndSet(false, true)) {
                this.initLatch.countDown();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Semaphore wasn't initialized. Prevented further initialization.");
                }
                return;
            }
            try {
                U.await(this.initLatch);
            }
            catch (IgniteInterruptedCheckedException e) {
                if (!this.log.isDebugEnabled()) break block9;
                this.log.error("Failed waiting while initialization is completed.", e);
            }
        }
        assert (this.sync != null);
        this.sync.setBroken(true);
        this.sync.releaseShared(0);
    }

    @Override
    public void needCheckNotRemoved() {
    }

    @Override
    public void acquire() throws IgniteInterruptedException {
        this.acquire(1);
    }

    @Override
    public void acquire(int permits) throws IgniteInterruptedException {
        this.ctx.kernalContext().gateway().readLock();
        A.ensure(permits >= 0, "Number of permits must be non-negative.");
        try {
            this.initializeSemaphore();
            this.sync.acquireSharedInterruptibly(permits);
            if (this.isBroken()) {
                Thread.interrupted();
                throw new InterruptedException();
            }
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public void acquireUninterruptibly() {
        this.ctx.kernalContext().gateway().readLock();
        try {
            this.initializeSemaphore();
            this.sync.acquireShared(1);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public void acquireUninterruptibly(int permits) {
        this.ctx.kernalContext().gateway().readLock();
        A.ensure(permits >= 0, "Number of permits must be non-negative.");
        try {
            this.initializeSemaphore();
            this.sync.acquireShared(permits);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public int availablePermits() {
        int ret;
        this.ctx.kernalContext().gateway().readLock();
        try {
            this.initializeSemaphore();
            ret = GridCacheUtils.retryTopologySafe(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    try (GridNearTxLocal tx = CU.txStartInternal(GridCacheSemaphoreImpl.this.ctx, GridCacheSemaphoreImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                        GridCacheSemaphoreState val = (GridCacheSemaphoreState)GridCacheSemaphoreImpl.this.cacheView.get(GridCacheSemaphoreImpl.this.key);
                        if (val == null) {
                            throw new IgniteException("Failed to find semaphore with given name: " + GridCacheSemaphoreImpl.this.name);
                        }
                        int cnt = val.getCount();
                        tx.rollback();
                        Integer n = cnt;
                        return n;
                    }
                }
            });
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
        return ret;
    }

    @Override
    public int drainPermits() {
        this.ctx.kernalContext().gateway().readLock();
        try {
            this.initializeSemaphore();
            int n = this.sync.drainPermits();
            return n;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public boolean tryAcquire() {
        this.ctx.kernalContext().gateway().readLock();
        try {
            boolean res;
            this.initializeSemaphore();
            boolean bl = res = this.sync.nonfairTryAcquireShared(1) >= 0;
            if (this.isBroken()) {
                Thread.interrupted();
                throw new InterruptedException();
            }
            boolean bl2 = res;
            return bl2;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) throws IgniteException {
        this.ctx.kernalContext().gateway().readLock();
        try {
            this.initializeSemaphore();
            boolean res = this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
            if (this.isBroken()) {
                Thread.interrupted();
                throw new InterruptedException();
            }
            boolean bl = res;
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int permits) {
        this.ctx.kernalContext().gateway().readLock();
        A.ensure(permits >= 0, "Number of permits must be non-negative.");
        try {
            this.initializeSemaphore();
            this.sync.releaseShared(permits);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public boolean tryAcquire(int permits) {
        this.ctx.kernalContext().gateway().readLock();
        A.ensure(permits >= 0, "Number of permits must be non-negative.");
        try {
            this.initializeSemaphore();
            boolean bl = this.sync.nonfairTryAcquireShared(permits) >= 0;
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws IgniteInterruptedException {
        this.ctx.kernalContext().gateway().readLock();
        A.ensure(permits >= 0, "Number of permits must be non-negative.");
        try {
            this.initializeSemaphore();
            boolean res = this.sync.tryAcquireSharedNanos(permits, unit.toNanos(timeout));
            if (this.isBroken()) {
                Thread.interrupted();
                throw new InterruptedException();
            }
            boolean bl = res;
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public boolean isFailoverSafe() {
        this.ctx.kernalContext().gateway().readLock();
        try {
            this.initializeSemaphore();
            boolean bl = this.sync.failoverSafe;
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public boolean hasQueuedThreads() {
        this.ctx.kernalContext().gateway().readLock();
        try {
            this.initializeSemaphore();
            boolean bl = this.sync.getWaiters() != 0;
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public int getQueueLength() {
        this.ctx.kernalContext().gateway().readLock();
        try {
            this.initializeSemaphore();
            int n = this.sync.getWaiters();
            return n;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public boolean isBroken() {
        this.ctx.kernalContext().gateway().readLock();
        try {
            this.initializeSemaphore();
            boolean bl = this.sync.isBroken();
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        finally {
            this.ctx.kernalContext().gateway().readUnlock();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx.kernalContext());
        out.writeUTF(this.name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<GridKernalContext, String> t = stash.get();
        t.set1((GridKernalContext)in.readObject());
        t.set2(in.readUTF());
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<GridKernalContext, String> t = stash.get();
            IgniteSemaphore sem = IgnitionEx.localIgnite().context().dataStructures().semaphore(t.get2(), null, 0, false, false);
            if (sem == null) {
                throw new IllegalStateException("Semaphore was not found on deserialization: " + t.get2());
            }
            IgniteSemaphore igniteSemaphore = sem;
            return igniteSemaphore;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    @Override
    public void close() {
        if (!this.rmvd) {
            try {
                this.ctx.kernalContext().dataStructures().removeSemaphore(this.name, this.ctx.group().name());
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    public String toString() {
        return S.toString(GridCacheSemaphoreImpl.class, this);
    }

    final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1192457210091910933L;
        private Map<UUID, Integer> nodeMap;
        final boolean failoverSafe;
        protected boolean broken = false;

        protected Sync(int permits, Map<UUID, Integer> waiters, boolean failoverSafe) {
            this.setState(permits);
            this.nodeMap = waiters;
            this.failoverSafe = failoverSafe;
        }

        synchronized void setWaiters(Map<UUID, Integer> nodeMap) {
            this.nodeMap = nodeMap;
        }

        int getWaiters() {
            int totalWaiters = 0;
            for (Integer i : this.nodeMap.values()) {
                if (i <= 0) continue;
                ++totalWaiters;
            }
            return totalWaiters;
        }

        int getPermitsForNode(UUID nodeID) {
            return this.nodeMap.containsKey(nodeID) ? this.nodeMap.get(nodeID) : 0;
        }

        final synchronized void setPermits(int permits) {
            this.setState(permits);
        }

        final int getPermits() {
            return this.getState();
        }

        protected boolean isBroken() {
            return this.broken;
        }

        protected void setBroken(boolean broken) {
            this.broken = broken;
        }

        final int nonfairTryAcquireShared(int acquires) {
            int available;
            int remaining;
            do {
                if (!this.broken) continue;
                return 1;
            } while ((remaining = (available = this.getState()) - acquires) >= 0 && !this.compareAndSetGlobalState(available, remaining, false));
            return remaining;
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            return this.nonfairTryAcquireShared(acquires);
        }

        @Override
        protected final boolean tryReleaseShared(int releases) {
            int next2;
            int cur;
            if (this.broken) {
                return true;
            }
            if (releases == 0) {
                return true;
            }
            do {
                if (this.broken) {
                    return true;
                }
                cur = this.getState();
                next2 = cur + releases;
                if (next2 >= cur) continue;
                throw new Error("Maximum permit count exceeded");
            } while (!this.compareAndSetGlobalState(cur, next2, false));
            return true;
        }

        final int drainPermits() {
            int curr;
            do {
                if (!this.broken) continue;
                return 1;
            } while ((curr = this.getState()) != 0 && !this.compareAndSetGlobalState(curr, 0, true));
            return curr;
        }

        boolean compareAndSetGlobalState(final int expVal, final int newVal, final boolean draining) {
            try {
                return GridCacheUtils.retryTopologySafe(new Callable<Boolean>(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public Boolean call() throws Exception {
                        try (GridNearTxLocal tx = CU.txStartInternal(GridCacheSemaphoreImpl.this.ctx, GridCacheSemaphoreImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                            boolean retVal;
                            GridCacheSemaphoreState val = (GridCacheSemaphoreState)GridCacheSemaphoreImpl.this.cacheView.get(GridCacheSemaphoreImpl.this.key);
                            if (val == null) {
                                throw new IgniteCheckedException("Failed to find semaphore with given name: " + GridCacheSemaphoreImpl.this.name);
                            }
                            if (val.isBroken()) {
                                tx.rollback();
                                Boolean bl = true;
                                return bl;
                            }
                            boolean bl = retVal = val.getCount() == expVal;
                            if (retVal) {
                                if (!draining) {
                                    UUID nodeID = GridCacheSemaphoreImpl.this.ctx.localNodeId();
                                    Map<UUID, Integer> map2 = val.getWaiters();
                                    int waitingCnt = expVal - newVal;
                                    if (map2.containsKey(nodeID)) {
                                        waitingCnt += map2.get(nodeID).intValue();
                                    }
                                    map2.put(nodeID, waitingCnt);
                                    val.setWaiters(map2);
                                }
                                val.setCount(newVal);
                                GridCacheSemaphoreImpl.this.cacheView.put(GridCacheSemaphoreImpl.this.key, val);
                                tx.commit();
                            }
                            Boolean bl2 = retVal;
                            return bl2;
                        }
                        catch (Error | Exception e) {
                            if (GridCacheSemaphoreImpl.this.ctx.kernalContext().isStopping()) throw e;
                            U.error(GridCacheSemaphoreImpl.this.log, "Failed to compare and set: " + this, e);
                            throw e;
                        }
                    }
                });
            }
            catch (IgniteCheckedException e) {
                if (GridCacheSemaphoreImpl.this.ctx.kernalContext().isStopping()) {
                    if (GridCacheSemaphoreImpl.this.log.isDebugEnabled()) {
                        GridCacheSemaphoreImpl.this.log.debug("Ignoring failure in semaphore on node left handler (node is stopping): " + e);
                    }
                    return true;
                }
                throw U.convertException(e);
            }
        }

        boolean releaseFailedNode(final UUID nodeId, final boolean broken) {
            try {
                return GridCacheUtils.retryTopologySafe(new Callable<Boolean>(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public Boolean call() throws Exception {
                        try (GridNearTxLocal tx = CU.txStartInternal(GridCacheSemaphoreImpl.this.ctx, GridCacheSemaphoreImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                            GridCacheSemaphoreState val = (GridCacheSemaphoreState)GridCacheSemaphoreImpl.this.cacheView.get(GridCacheSemaphoreImpl.this.key);
                            if (val == null) {
                                throw new IgniteCheckedException("Failed to find semaphore with given name: " + GridCacheSemaphoreImpl.this.name);
                            }
                            if (val.isBroken()) {
                                tx.rollback();
                                Boolean bl = false;
                                return bl;
                            }
                            if (broken) {
                                val.setBroken(true);
                                GridCacheSemaphoreImpl.this.cacheView.put(GridCacheSemaphoreImpl.this.key, val);
                                tx.commit();
                                Boolean bl = true;
                                return bl;
                            }
                            Map<UUID, Integer> map2 = val.getWaiters();
                            if (!map2.containsKey(nodeId)) {
                                tx.rollback();
                                Boolean bl = false;
                                return bl;
                            }
                            int numPermits = map2.get(nodeId);
                            if (numPermits > 0) {
                                val.setCount(val.getCount() + numPermits);
                            }
                            map2.remove(nodeId);
                            val.setWaiters(map2);
                            GridCacheSemaphoreImpl.this.cacheView.put(GridCacheSemaphoreImpl.this.key, val);
                            GridCacheSemaphoreImpl.this.sync.nodeMap = map2;
                            tx.commit();
                            Boolean bl = true;
                            return bl;
                        }
                        catch (Error | Exception e) {
                            if (GridCacheSemaphoreImpl.this.ctx.kernalContext().isStopping()) throw e;
                            U.error(GridCacheSemaphoreImpl.this.log, "Failed to compare and set: " + this, e);
                            throw e;
                        }
                    }
                });
            }
            catch (IgniteCheckedException e) {
                if (GridCacheSemaphoreImpl.this.ctx.kernalContext().isStopping()) {
                    if (GridCacheSemaphoreImpl.this.log.isDebugEnabled()) {
                        GridCacheSemaphoreImpl.this.log.debug("Ignoring failure in semaphore on node left handler (node is stopping): " + e);
                    }
                    return true;
                }
                throw U.convertException(e);
            }
        }
    }
}

