/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteQueue;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheGateway;
import org.apache.ignite.internal.processors.datastructures.GridCacheQueueAdapter;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.jetbrains.annotations.Nullable;

public class GridCacheQueueProxy<T>
implements IgniteQueue<T>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<T3<GridKernalContext, String, String>> stash = new ThreadLocal<T3<GridKernalContext, String, String>>(){

        @Override
        protected T3<GridKernalContext, String, String> initialValue() {
            return new T3<GridKernalContext, String, String>();
        }
    };
    private GridCacheQueueAdapter<T> delegate;
    private GridCacheContext cctx;
    private GridCacheGateway gate;

    public GridCacheQueueProxy() {
    }

    public GridCacheQueueProxy(GridCacheContext cctx, GridCacheQueueAdapter<T> delegate) {
        this.cctx = cctx;
        this.delegate = delegate;
        this.gate = cctx.gate();
    }

    public GridCacheQueueAdapter<T> delegate() {
        return this.delegate;
    }

    @Override
    public boolean add(T item) {
        this.gate.enter();
        try {
            boolean bl = this.delegate.add(item);
            return bl;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean offer(T item) {
        this.gate.enter();
        try {
            boolean bl = this.delegate.offer(item);
            return bl;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> items) {
        this.gate.enter();
        try {
            boolean bl = this.delegate.addAll(items);
            return bl;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean contains(Object item) {
        this.gate.enter();
        try {
            boolean bl = this.delegate.contains(item);
            return bl;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean containsAll(Collection<?> items) {
        this.gate.enter();
        try {
            boolean bl = this.delegate.containsAll(items);
            return bl;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public void clear() {
        this.gate.enter();
        try {
            this.delegate.clear();
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean remove(Object item) {
        this.gate.enter();
        try {
            boolean bl = this.delegate.remove(item);
            return bl;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean removeAll(Collection<?> items) {
        this.gate.enter();
        try {
            boolean bl = this.delegate.removeAll(items);
            return bl;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean isEmpty() {
        this.gate.enter();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public Iterator<T> iterator() {
        this.gate.enter();
        try {
            Iterator<T> iterator2 = this.delegate.iterator();
            return iterator2;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public Object[] toArray() {
        this.gate.enter();
        try {
            Object[] objectArray = this.delegate.toArray();
            return objectArray;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        this.gate.enter();
        try {
            T1[] T1Array = this.delegate.toArray(a);
            return T1Array;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public boolean retainAll(Collection<?> items) {
        this.gate.enter();
        try {
            boolean bl = this.delegate.retainAll(items);
            return bl;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public int size() {
        this.gate.enter();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    @Nullable
    public T poll() {
        this.gate.enter();
        try {
            Object t = this.delegate.poll();
            return t;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    @Nullable
    public T peek() {
        this.gate.enter();
        try {
            T t = this.delegate.peek();
            return t;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public void clear(int batchSize) {
        this.gate.enter();
        try {
            this.delegate.clear(batchSize);
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public int remainingCapacity() {
        this.gate.enter();
        try {
            int n = this.delegate.remainingCapacity();
            return n;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        this.gate.enter();
        try {
            int n = this.delegate.drainTo(c);
            return n;
        }
        finally {
            this.gate.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        this.gate.enter();
        try {
            int n = this.delegate.drainTo(c, maxElements);
            return n;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public T remove() {
        this.gate.enter();
        try {
            T t = this.delegate.remove();
            return t;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public T element() {
        this.gate.enter();
        try {
            T t = this.delegate.element();
            return t;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public void put(T item) {
        this.gate.enter();
        try {
            this.delegate.put(item);
        }
        finally {
            this.gate.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T item, long timeout, TimeUnit unit) {
        this.gate.enter();
        try {
            boolean bl = this.delegate.offer(item, timeout, unit);
            return bl;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    @Nullable
    public T take() {
        this.gate.enter();
        try {
            T t = this.delegate.take();
            return t;
        }
        finally {
            this.gate.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T poll(long timeout, TimeUnit unit) {
        this.gate.enter();
        try {
            T t = this.delegate.poll(timeout, unit);
            return t;
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public void close() {
        this.gate.enter();
        try {
            this.delegate.close();
        }
        finally {
            this.gate.leave();
        }
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public int capacity() {
        return this.delegate.capacity();
    }

    @Override
    public boolean bounded() {
        return this.delegate.bounded();
    }

    @Override
    public boolean collocated() {
        return this.delegate.collocated();
    }

    @Override
    public boolean removed() {
        return this.delegate.removed();
    }

    @Override
    public void affinityRun(IgniteRunnable job) {
        this.delegate.affinityRun(job);
    }

    @Override
    public <R> R affinityCall(IgniteCallable<R> job) {
        return this.delegate.affinityCall(job);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridCacheQueueProxy that = (GridCacheQueueProxy)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cctx.kernalContext());
        U.writeString(out, this.name());
        U.writeString(out, this.cctx.group().name());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        T3<GridKernalContext, String, String> t = stash.get();
        t.set1((GridKernalContext)in.readObject());
        t.set2(U.readString(in));
        t.set3(U.readString(in));
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            T3<GridKernalContext, String, String> t = stash.get();
            IgniteQueue igniteQueue = ((GridKernalContext)t.get1()).dataStructures().queue((String)t.get2(), (String)t.get3(), 0, null);
            return igniteQueue;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

