/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.processors.datastructures.DataStructureType;
import org.apache.ignite.internal.processors.datastructures.VolatileAtomicDataStructureValue;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public final class GridCacheLockState
extends VolatileAtomicDataStructureValue
implements Cloneable {
    private static final long serialVersionUID = 0L;
    private int cnt;
    private long threadId;
    private UUID id;
    private long gridStartTime;
    private boolean failoverSafe;
    @GridToStringInclude
    private Map<String, LinkedList<UUID>> conditionMap;
    @GridToStringInclude
    private Map<UUID, LinkedList<String>> signals;
    private boolean fair;
    @GridToStringInclude
    private LinkedList<UUID> nodes;
    private boolean changed;

    public GridCacheLockState(int cnt, UUID id, long threadID, boolean failoverSafe, boolean fair, long gridStartTime) {
        assert (cnt >= 0);
        this.id = id;
        this.threadId = threadID;
        this.conditionMap = new HashMap<String, LinkedList<UUID>>();
        this.signals = null;
        this.nodes = new LinkedList();
        this.fair = fair;
        this.failoverSafe = failoverSafe;
        this.gridStartTime = gridStartTime;
    }

    public GridCacheLockState() {
    }

    @Override
    public DataStructureType type() {
        return DataStructureType.REENTRANT_LOCK;
    }

    @Override
    public long gridStartTime() {
        return this.gridStartTime;
    }

    public void set(int cnt) {
        this.cnt = cnt;
    }

    public int get() {
        return this.cnt;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public boolean isFailoverSafe() {
        return this.failoverSafe;
    }

    public int condtionCount() {
        return this.conditionMap.size();
    }

    public Map<String, LinkedList<UUID>> getConditionMap() {
        return this.conditionMap;
    }

    public void setConditionMap(Map<String, LinkedList<UUID>> conditionMap) {
        this.conditionMap = conditionMap;
    }

    public Map<UUID, LinkedList<String>> getSignals() {
        return this.signals;
    }

    public void setSignals(Map<UUID, LinkedList<String>> signals) {
        this.signals = signals;
    }

    public LinkedList<UUID> getNodes() {
        return this.nodes;
    }

    public void setNodes(LinkedList<UUID> nodes2) {
        this.nodes = nodes2;
    }

    public boolean isFair() {
        return this.fair;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.cnt);
        out.writeLong(this.threadId);
        U.writeUuid(out, this.id);
        out.writeLong(this.gridStartTime);
        out.writeBoolean(this.failoverSafe);
        out.writeBoolean(this.fair);
        out.writeBoolean(this.changed);
        out.writeBoolean(this.conditionMap != null);
        if (this.conditionMap != null) {
            out.writeInt(this.conditionMap.size());
            for (Map.Entry<String, LinkedList<UUID>> entry2 : this.conditionMap.entrySet()) {
                U.writeString(out, entry2.getKey());
                out.writeInt(entry2.getValue().size());
                for (UUID uUID : entry2.getValue()) {
                    U.writeUuid(out, uUID);
                }
            }
        }
        out.writeBoolean(this.signals != null);
        if (this.signals != null) {
            out.writeInt(this.signals.size());
            for (Map.Entry<Object, LinkedList<Object>> entry3 : this.signals.entrySet()) {
                U.writeUuid(out, (UUID)entry3.getKey());
                out.writeInt(entry3.getValue().size());
                for (String string2 : entry3.getValue()) {
                    U.writeString(out, string2);
                }
            }
        }
        out.writeBoolean(this.nodes != null);
        if (this.nodes != null) {
            out.writeInt(this.nodes.size());
            for (UUID uUID : this.nodes) {
                U.writeUuid(out, uUID);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int j;
        LinkedList<Object> list2;
        int size1;
        int i;
        int size2;
        this.cnt = in.readInt();
        this.threadId = in.readLong();
        this.id = U.readUuid(in);
        this.gridStartTime = in.readLong();
        this.failoverSafe = in.readBoolean();
        this.fair = in.readBoolean();
        this.changed = in.readBoolean();
        if (in.readBoolean()) {
            size2 = in.readInt();
            this.conditionMap = U.newLinkedHashMap(size2);
            for (i = 0; i < size2; ++i) {
                String key = U.readString(in);
                size1 = in.readInt();
                list2 = new LinkedList<Object>();
                for (j = 0; j < size1; ++j) {
                    list2.add(U.readUuid(in));
                }
                this.conditionMap.put(key, list2);
            }
        }
        if (in.readBoolean()) {
            assert (this.conditionMap != null);
            size2 = in.readInt();
            this.signals = U.newLinkedHashMap(size2);
            for (i = 0; i < size2; ++i) {
                UUID node = U.readUuid(in);
                size1 = in.readInt();
                list2 = new LinkedList();
                for (j = 0; j < size1; ++j) {
                    list2.add(U.readString(in));
                }
                this.signals.put(node, list2);
            }
        } else {
            this.signals = null;
        }
        if (in.readBoolean()) {
            size2 = in.readInt();
            this.nodes = new LinkedList();
            for (i = 0; i < size2; ++i) {
                this.nodes.add(U.readUuid(in));
            }
        } else {
            this.nodes = null;
        }
    }

    public String toString() {
        return S.toString(GridCacheLockState.class, this);
    }
}

