/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridCacheInternalKeyImpl
implements GridCacheInternalKey,
Externalizable,
Cloneable {
    private static final long serialVersionUID = 0L;
    @AffinityKeyMapped
    private String name;
    private String grpName;

    public GridCacheInternalKeyImpl(String name, String grpName) {
        assert (!F.isEmpty(name)) : name;
        this.name = name;
        this.grpName = grpName;
    }

    public GridCacheInternalKeyImpl() {
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String groupName() {
        return this.grpName;
    }

    public int hashCode() {
        int result2 = this.name != null ? this.name.hashCode() : 0;
        result2 = 31 * result2 + (this.grpName != null ? this.grpName.hashCode() : 0);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GridCacheInternalKeyImpl) {
            GridCacheInternalKeyImpl other = (GridCacheInternalKeyImpl)obj;
            return F.eq(this.name, other.name) && F.eq(this.grpName, other.grpName);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        U.writeString(out, this.grpName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.name = U.readString(in);
        this.grpName = U.readString(in);
    }

    public String toString() {
        return S.toString(GridCacheInternalKeyImpl.class, this);
    }
}

