/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastreamer;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.stream.StreamReceiver;
import org.jetbrains.annotations.Nullable;

public class DataStreamerCacheUpdaters {
    private static final StreamReceiver INDIVIDUAL = new Individual();
    private static final StreamReceiver BATCHED = new Batched();
    private static final StreamReceiver BATCHED_SORTED = new BatchedSorted();

    public static <K, V> StreamReceiver<K, V> individual() {
        return INDIVIDUAL;
    }

    public static <K, V> StreamReceiver<K, V> batched() {
        return BATCHED;
    }

    public static <K extends Comparable<?>, V> StreamReceiver<K, V> batchedSorted() {
        return BATCHED_SORTED;
    }

    protected static <K, V> void updateAll(IgniteCache<K, V> cache, @Nullable Set<K> rmvCol, Map<K, V> putMap) {
        assert (rmvCol != null || putMap != null);
        if (rmvCol != null) {
            cache.removeAll(rmvCol);
        }
        if (putMap != null) {
            cache.putAll(putMap);
        }
    }

    public static interface InternalUpdater {
    }

    private static class BatchedSorted<K, V>
    implements StreamReceiver<K, V> {
        private static final long serialVersionUID = 0L;

        private BatchedSorted() {
        }

        @Override
        public void receive(IgniteCache<K, V> cache, Collection<Map.Entry<K, V>> entries) {
            assert (cache != null);
            assert (!F.isEmpty(entries));
            TreeMap<K, V> putAll = null;
            TreeSet<K> rmvAll = null;
            for (Map.Entry<K, V> entry2 : entries) {
                K key = entry2.getKey();
                assert (key instanceof Comparable);
                V val = entry2.getValue();
                if (val == null) {
                    if (rmvAll == null) {
                        rmvAll = new TreeSet<K>();
                    }
                    rmvAll.add(key);
                    continue;
                }
                if (putAll == null) {
                    putAll = new TreeMap<K, V>();
                }
                putAll.put(key, val);
            }
            DataStreamerCacheUpdaters.updateAll(cache, rmvAll, putAll);
        }
    }

    private static class Batched<K, V>
    implements StreamReceiver<K, V>,
    InternalUpdater {
        private static final long serialVersionUID = 0L;

        private Batched() {
        }

        @Override
        public void receive(IgniteCache<K, V> cache, Collection<Map.Entry<K, V>> entries) {
            assert (cache != null);
            assert (!F.isEmpty(entries));
            HashMap<K, V> putAll = null;
            HashSet<K> rmvAll = null;
            for (Map.Entry<K, V> entry2 : entries) {
                K key = entry2.getKey();
                assert (key != null);
                V val = entry2.getValue();
                if (val == null) {
                    if (rmvAll == null) {
                        rmvAll = new HashSet<K>();
                    }
                    rmvAll.add(key);
                    continue;
                }
                if (putAll == null) {
                    putAll = new HashMap<K, V>();
                }
                putAll.put(key, val);
            }
            DataStreamerCacheUpdaters.updateAll(cache, rmvAll, putAll);
        }
    }

    private static class Individual<K, V>
    implements StreamReceiver<K, V>,
    InternalUpdater {
        private static final long serialVersionUID = 0L;

        private Individual() {
        }

        @Override
        public void receive(IgniteCache<K, V> cache, Collection<Map.Entry<K, V>> entries) {
            assert (cache != null);
            assert (!F.isEmpty(entries));
            for (Map.Entry<K, V> entry2 : entries) {
                K key = entry2.getKey();
                assert (key != null);
                V val = entry2.getValue();
                if (val == null) {
                    cache.remove(key);
                    continue;
                }
                cache.put(key, val);
            }
        }
    }
}

