/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.continuous;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.cache.event.CacheEntryUpdatedListener;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheEntryEventSerializableFilter;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridMessageListenHandler;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteDeploymentCheckedException;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfoBean;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryMessageResultsCollector;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.managers.eventstorage.HighPriorityListener;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryHandler;
import org.apache.ignite.internal.processors.continuous.AbstractContinuousMessage;
import org.apache.ignite.internal.processors.continuous.ContinuousRoutineInfo;
import org.apache.ignite.internal.processors.continuous.ContinuousRoutineStartResultMessage;
import org.apache.ignite.internal.processors.continuous.ContinuousRoutinesCommonDiscoveryData;
import org.apache.ignite.internal.processors.continuous.ContinuousRoutinesInfo;
import org.apache.ignite.internal.processors.continuous.ContinuousRoutinesJoiningNodeDiscoveryData;
import org.apache.ignite.internal.processors.continuous.GridContinuousBatch;
import org.apache.ignite.internal.processors.continuous.GridContinuousHandler;
import org.apache.ignite.internal.processors.continuous.GridContinuousMessage;
import org.apache.ignite.internal.processors.continuous.GridContinuousMessageType;
import org.apache.ignite.internal.processors.continuous.StartRequestData;
import org.apache.ignite.internal.processors.continuous.StartRequestDataV2;
import org.apache.ignite.internal.processors.continuous.StartRoutineAckDiscoveryMessage;
import org.apache.ignite.internal.processors.continuous.StartRoutineDiscoveryMessage;
import org.apache.ignite.internal.processors.continuous.StartRoutineDiscoveryMessageV2;
import org.apache.ignite.internal.processors.continuous.StopRoutineAckDiscoveryMessage;
import org.apache.ignite.internal.processors.continuous.StopRoutineDiscoveryMessage;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.thread.OomExceptionHandler;
import org.jetbrains.annotations.Nullable;

public class GridContinuousProcessor
extends GridProcessorAdapter {
    private final ConcurrentMap<UUID, LocalRoutineInfo> locInfos = new ConcurrentHashMap<UUID, LocalRoutineInfo>();
    private final ConcurrentMap<UUID, Map<UUID, LocalRoutineInfo>> clientInfos = new ConcurrentHashMap<UUID, Map<UUID, LocalRoutineInfo>>();
    private final ConcurrentMap<UUID, RemoteRoutineInfo> rmtInfos = new ConcurrentHashMap<UUID, RemoteRoutineInfo>();
    private final ConcurrentMap<UUID, StartFuture> startFuts = new ConcurrentHashMap<UUID, StartFuture>();
    private final ConcurrentMap<UUID, StopFuture> stopFuts = new ConcurrentHashMap<UUID, StopFuture>();
    private final Map<UUID, IgniteThread> bufCheckThreads = new ConcurrentHashMap<UUID, IgniteThread>();
    private final ConcurrentMap<IgniteUuid, SyncMessageAckFuture> syncMsgFuts = new ConcurrentHashMap<IgniteUuid, SyncMessageAckFuture>();
    private final Collection<UUID> stopped = new HashSet<UUID>();
    private final Lock stopLock = new ReentrantLock();
    private Marshaller marsh;
    private long retryDelay = 1000L;
    private int retryCnt = 3;
    private final ReentrantReadWriteLock processorStopLock = new ReentrantReadWriteLock();
    private boolean processorStopped;
    private final AtomicLong seq = new AtomicLong();
    private ContinuousRoutinesInfo routinesInfo;
    private int discoProtoVer;

    public GridContinuousProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public void start() throws IgniteCheckedException {
        int n = this.discoProtoVer = this.ctx.discovery().mutableCustomMessages() ? 1 : 2;
        if (this.discoProtoVer == 2) {
            this.routinesInfo = new ContinuousRoutinesInfo();
        }
        if (this.ctx.config().isDaemon()) {
            return;
        }
        this.retryDelay = this.ctx.config().getNetworkSendRetryDelay();
        this.retryCnt = this.ctx.config().getNetworkSendRetryCount();
        this.marsh = this.ctx.config().getMarshaller();
        this.ctx.event().addLocalEventListener(new DiscoveryListener(), 11, 12);
        this.ctx.event().addLocalEventListener(new GridLocalEventListener(){

            @Override
            public void onEvent(Event evt) {
                GridContinuousProcessor.this.cancelFutures(new IgniteCheckedException("Topology segmented"));
            }
        }, 14, new int[0]);
        this.ctx.discovery().setCustomEventListener(StartRoutineDiscoveryMessage.class, new CustomEventListener<StartRoutineDiscoveryMessage>(){

            @Override
            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, StartRoutineDiscoveryMessage msg) {
                assert (GridContinuousProcessor.this.discoProtoVer == 1) : GridContinuousProcessor.access$200(GridContinuousProcessor.this);
                if (GridContinuousProcessor.this.ctx.isStopping()) {
                    return;
                }
                GridContinuousProcessor.this.processStartRequest(snd, msg);
            }
        });
        this.ctx.discovery().setCustomEventListener(StartRoutineDiscoveryMessageV2.class, new CustomEventListener<StartRoutineDiscoveryMessageV2>(){

            @Override
            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, StartRoutineDiscoveryMessageV2 msg) {
                assert (GridContinuousProcessor.this.discoProtoVer == 2) : GridContinuousProcessor.access$200(GridContinuousProcessor.this);
                if (GridContinuousProcessor.this.ctx.isStopping()) {
                    return;
                }
                GridContinuousProcessor.this.processStartRequestV2(topVer, snd, msg);
            }
        });
        this.ctx.discovery().setCustomEventListener(StartRoutineAckDiscoveryMessage.class, new CustomEventListener<StartRoutineAckDiscoveryMessage>(){

            @Override
            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, StartRoutineAckDiscoveryMessage msg) {
                if (GridContinuousProcessor.this.ctx.isStopping()) {
                    return;
                }
                GridContinuousProcessor.this.processStartAckRequest(topVer, msg);
            }
        });
        this.ctx.discovery().setCustomEventListener(StopRoutineDiscoveryMessage.class, new CustomEventListener<StopRoutineDiscoveryMessage>(){

            @Override
            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, StopRoutineDiscoveryMessage msg) {
                if (GridContinuousProcessor.this.discoProtoVer == 2) {
                    GridContinuousProcessor.this.routinesInfo.removeRoutine(msg.routineId);
                }
                if (GridContinuousProcessor.this.ctx.isStopping()) {
                    return;
                }
                GridContinuousProcessor.this.processStopRequest(snd, msg);
            }
        });
        this.ctx.discovery().setCustomEventListener(StopRoutineAckDiscoveryMessage.class, new CustomEventListener<StopRoutineAckDiscoveryMessage>(){

            @Override
            public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, StopRoutineAckDiscoveryMessage msg) {
                if (GridContinuousProcessor.this.ctx.isStopping()) {
                    return;
                }
                GridContinuousProcessor.this.processStopAckRequest(msg);
            }
        });
        this.ctx.io().addMessageListener(GridTopic.TOPIC_CONTINUOUS, new GridMessageListener(){

            @Override
            public void onMessage(UUID nodeId, Object obj, byte plc) {
                if (obj instanceof ContinuousRoutineStartResultMessage) {
                    GridContinuousProcessor.this.processRoutineStartResultMessage(nodeId, (ContinuousRoutineStartResultMessage)obj);
                } else {
                    GridContinuousMessage msg = (GridContinuousMessage)obj;
                    if (msg.data() == null && msg.dataBytes() != null) {
                        try {
                            msg.data(U.unmarshal(GridContinuousProcessor.this.marsh, msg.dataBytes(), U.resolveClassLoader(GridContinuousProcessor.this.ctx.config())));
                        }
                        catch (IgniteCheckedException e) {
                            U.error(GridContinuousProcessor.this.log, "Failed to process message (ignoring): " + msg, e);
                            return;
                        }
                    }
                    switch (msg.type()) {
                        case MSG_EVT_NOTIFICATION: {
                            GridContinuousProcessor.this.processNotification(nodeId, msg);
                            break;
                        }
                        case MSG_EVT_ACK: {
                            GridContinuousProcessor.this.processMessageAck(msg);
                            break;
                        }
                        default: {
                            assert (false) : "Unexpected message received: " + (Object)((Object)msg.type());
                            break;
                        }
                    }
                }
            }
        });
        this.ctx.cacheObjects().onContinuousProcessorStarted(this.ctx);
        this.ctx.service().onContinuousProcessorStarted(this.ctx);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Continuous processor started.");
        }
    }

    private void cancelFutures(IgniteCheckedException e) {
        GridFutureAdapter fut;
        Iterator itr = this.startFuts.values().iterator();
        while (itr.hasNext()) {
            fut = (StartFuture)itr.next();
            itr.remove();
            fut.onDone(e);
        }
        itr = this.stopFuts.values().iterator();
        while (itr.hasNext()) {
            fut = (StopFuture)itr.next();
            itr.remove();
            fut.onDone(e);
        }
    }

    public boolean lockStopping() {
        this.processorStopLock.readLock().lock();
        if (this.processorStopped) {
            this.processorStopLock.readLock().unlock();
            return false;
        }
        return true;
    }

    public void unlockStopping() {
        this.processorStopLock.readLock().unlock();
    }

    @Override
    public void onKernalStop(boolean cancel) {
        this.processorStopLock.writeLock().lock();
        try {
            this.processorStopped = true;
        }
        finally {
            this.processorStopLock.writeLock().unlock();
        }
        this.cancelFutures(new NodeStoppingException("Failed to start continuous query (node is stopping)"));
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        if (this.ctx.config().isDaemon()) {
            return;
        }
        this.ctx.io().removeMessageListener(GridTopic.TOPIC_CONTINUOUS);
        for (IgniteThread thread : this.bufCheckThreads.values()) {
            U.interrupt(thread);
            U.join(thread);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Continuous processor stopped.");
        }
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.CONTINUOUS_PROC;
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        if (this.ctx.isDaemon()) {
            return;
        }
        if (this.discoProtoVer == 2) {
            this.routinesInfo.collectJoiningNodeData(dataBag);
            return;
        }
        Serializable data = this.getDiscoveryData(dataBag.joiningNodeId());
        if (data != null) {
            dataBag.addJoiningNodeData(GridComponent.DiscoveryDataExchangeType.CONTINUOUS_PROC.ordinal(), data);
        }
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        if (this.ctx.isDaemon()) {
            return;
        }
        if (this.discoProtoVer == 2) {
            this.routinesInfo.collectGridNodeData(dataBag);
            return;
        }
        Serializable data = this.getDiscoveryData(dataBag.joiningNodeId());
        if (data != null) {
            dataBag.addNodeSpecificData(GridComponent.DiscoveryDataExchangeType.CONTINUOUS_PROC.ordinal(), data);
        }
    }

    private Serializable getDiscoveryData(UUID joiningNodeId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("collectDiscoveryData [node=" + joiningNodeId + ", loc=" + this.ctx.localNodeId() + ", locInfos=" + this.locInfos + ", clientInfos=" + this.clientInfos + ']');
        }
        if (!joiningNodeId.equals(this.ctx.localNodeId()) || !this.locInfos.isEmpty()) {
            Map<UUID, Map<UUID, LocalRoutineInfo>> clientInfos0 = this.copyClientInfos(this.clientInfos);
            if (joiningNodeId.equals(this.ctx.localNodeId()) && this.ctx.discovery().localNode().isClient()) {
                Map<UUID, LocalRoutineInfo> infos = this.copyLocalInfos(this.locInfos);
                clientInfos0.put(this.ctx.localNodeId(), infos);
            }
            DiscoveryData data = new DiscoveryData(this.ctx.localNodeId(), clientInfos0);
            for (Map.Entry e : this.locInfos.entrySet()) {
                UUID routineId = (UUID)e.getKey();
                LocalRoutineInfo info2 = (LocalRoutineInfo)e.getValue();
                data.addItem(new DiscoveryDataItem(routineId, info2.prjPred, info2.hnd, info2.bufSize, info2.interval, info2.autoUnsubscribe));
            }
            return data;
        }
        return null;
    }

    private Map<UUID, Map<UUID, LocalRoutineInfo>> copyClientInfos(Map<UUID, Map<UUID, LocalRoutineInfo>> clientInfos) {
        HashMap<UUID, Map<UUID, LocalRoutineInfo>> res = U.newHashMap(clientInfos.size());
        for (Map.Entry<UUID, Map<UUID, LocalRoutineInfo>> e : clientInfos.entrySet()) {
            HashMap<UUID, LocalRoutineInfo> cp = U.newHashMap(e.getValue().size());
            for (Map.Entry<UUID, LocalRoutineInfo> e0 : e.getValue().entrySet()) {
                cp.put(e0.getKey(), e0.getValue());
            }
            res.put(e.getKey(), cp);
        }
        return res;
    }

    private Map<UUID, LocalRoutineInfo> copyLocalInfos(Map<UUID, LocalRoutineInfo> locInfos) {
        HashMap<UUID, LocalRoutineInfo> res = U.newHashMap(locInfos.size());
        for (Map.Entry<UUID, LocalRoutineInfo> e : locInfos.entrySet()) {
            res.put(e.getKey(), e.getValue());
        }
        return res;
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("onJoiningNodeDataReceived [joining=" + data.joiningNodeId() + ", loc=" + this.ctx.localNodeId() + ", data=" + data.joiningNodeData() + ']');
        }
        if (this.discoProtoVer == 2) {
            if (data.hasJoiningNodeData()) {
                ContinuousRoutinesJoiningNodeDiscoveryData nodeData = (ContinuousRoutinesJoiningNodeDiscoveryData)data.joiningNodeData();
                for (ContinuousRoutineInfo routineInfo : nodeData.startedRoutines) {
                    this.routinesInfo.addRoutineInfo(routineInfo);
                    this.startDiscoveryDataRoutine(routineInfo);
                }
            }
        } else if (data.hasJoiningNodeData()) {
            this.onDiscoDataReceived((DiscoveryData)data.joiningNodeData());
        }
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        block5: {
            block4: {
                if (this.discoProtoVer != 2) break block4;
                if (this.ctx.isDaemon()) {
                    return;
                }
                if (data.commonData() == null) break block5;
                ContinuousRoutinesCommonDiscoveryData commonData = (ContinuousRoutinesCommonDiscoveryData)data.commonData();
                for (ContinuousRoutineInfo routineInfo : commonData.startedRoutines) {
                    if (this.routinesInfo.routineExists(routineInfo.routineId)) continue;
                    this.routinesInfo.addRoutineInfo(routineInfo);
                    this.startDiscoveryDataRoutine(routineInfo);
                }
                break block5;
            }
            Map<UUID, Serializable> nodeSpecData = data.nodeSpecificData();
            if (nodeSpecData != null) {
                for (Map.Entry<UUID, Serializable> e : nodeSpecData.entrySet()) {
                    this.onDiscoDataReceived((DiscoveryData)e.getValue());
                }
            }
        }
    }

    private void startDiscoveryDataRoutine(ContinuousRoutineInfo routineInfo) {
        IgnitePredicate nodeFilter;
        try {
            if (routineInfo.nodeFilter != null) {
                nodeFilter = (IgnitePredicate)U.unmarshal(this.marsh, routineInfo.nodeFilter, U.resolveClassLoader(this.ctx.config()));
                this.ctx.resource().injectGeneric(nodeFilter);
            } else {
                nodeFilter = null;
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to unmarshal continuous routine filter, ignore routine [routineId=" + routineInfo.routineId + ", srcNodeId=" + routineInfo.srcNodeId + ']', e);
            return;
        }
        this.ctx.discovery().localJoinFuture().listen(f2 -> this.ctx.closure().runLocalSafe(() -> {
            if (nodeFilter == null || nodeFilter.apply(this.ctx.discovery().localNode())) {
                GridContinuousHandler hnd;
                try {
                    hnd = (GridContinuousHandler)U.unmarshal(this.marsh, routineInfo.hnd, U.resolveClassLoader(this.ctx.config()));
                    if (this.ctx.config().isPeerClassLoadingEnabled()) {
                        hnd.p2pUnmarshal(routineInfo.srcNodeId, this.ctx);
                    }
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to unmarshal continuous routine handler, ignore routine [routineId=" + routineInfo.routineId + ", srcNodeId=" + routineInfo.srcNodeId + ']', e);
                    return;
                }
                try {
                    this.registerHandler(routineInfo.srcNodeId, routineInfo.routineId, hnd, routineInfo.bufSize, routineInfo.interval, routineInfo.autoUnsubscribe, false);
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to register continuous routine handler, ignore routine [routineId=" + routineInfo.routineId + ", srcNodeId=" + routineInfo.srcNodeId + ']', e);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Do not register continuous routine, rejected by node filter [routineId=" + routineInfo.routineId + ", srcNodeId=" + routineInfo.srcNodeId + ']');
            }
        }));
    }

    private void onDiscoDataReceived(DiscoveryData data) {
        if (!this.ctx.isDaemon() && data != null) {
            for (DiscoveryDataItem discoveryDataItem : data.items) {
                try {
                    if (discoveryDataItem.prjPred != null) {
                        this.ctx.resource().injectGeneric(discoveryDataItem.prjPred);
                    }
                    if ((discoveryDataItem.prjPred == null || discoveryDataItem.prjPred.apply(this.ctx.discovery().localNode())) && !this.locInfos.containsKey(discoveryDataItem.routineId)) {
                        this.registerHandler(data.nodeId, discoveryDataItem.routineId, discoveryDataItem.hnd, discoveryDataItem.bufSize, discoveryDataItem.interval, discoveryDataItem.autoUnsubscribe, false);
                    }
                    if (discoveryDataItem.autoUnsubscribe) continue;
                    this.locInfos.putIfAbsent(discoveryDataItem.routineId, new LocalRoutineInfo(discoveryDataItem.prjPred, discoveryDataItem.hnd, discoveryDataItem.bufSize, discoveryDataItem.interval, discoveryDataItem.autoUnsubscribe));
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to register continuous handler.", e);
                }
            }
            for (Map.Entry entry2 : data.clientInfos.entrySet()) {
                HashMap map2;
                UUID clientNodeId = (UUID)entry2.getKey();
                if (!this.ctx.clientNode()) {
                    Map clientRoutineMap = (Map)entry2.getValue();
                    for (Map.Entry e : clientRoutineMap.entrySet()) {
                        UUID routineId = (UUID)e.getKey();
                        LocalRoutineInfo info2 = (LocalRoutineInfo)e.getValue();
                        try {
                            if (info2.prjPred != null) {
                                this.ctx.resource().injectGeneric(info2.prjPred);
                            }
                            if (info2.prjPred != null && !info2.prjPred.apply(this.ctx.discovery().localNode())) continue;
                            this.registerHandler(clientNodeId, routineId, info2.hnd, info2.bufSize, info2.interval, info2.autoUnsubscribe, false);
                        }
                        catch (IgniteCheckedException err2) {
                            U.error(this.log, "Failed to register continuous handler.", err2);
                        }
                    }
                }
                if ((map2 = (HashMap)this.clientInfos.get(entry2.getKey())) == null) {
                    map2 = new HashMap();
                    this.clientInfos.put((UUID)entry2.getKey(), map2);
                }
                map2.putAll((Map)entry2.getValue());
            }
        }
    }

    public void onCacheStart(GridCacheContext ctx) throws IgniteCheckedException {
        for (Map.Entry entry2 : this.rmtInfos.entrySet()) {
            UUID routineId = (UUID)entry2.getKey();
            RemoteRoutineInfo rmtInfo = (RemoteRoutineInfo)entry2.getValue();
            GridContinuousHandler hnd = rmtInfo.hnd;
            if (!hnd.isQuery() || !F.eq(ctx.name(), hnd.cacheName()) || !rmtInfo.clearDelayedRegister()) continue;
            GridContinuousHandler.RegisterStatus status = hnd.register(rmtInfo.nodeId, routineId, this.ctx);
            assert (status != GridContinuousHandler.RegisterStatus.DELAYED);
        }
    }

    public void onCacheStop(GridCacheContext ctx) {
        Iterator it = this.rmtInfos.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry2 = it.next();
            GridContinuousHandler hnd = ((RemoteRoutineInfo)entry2.getValue()).hnd;
            if (!hnd.isQuery() || !F.eq(ctx.name(), hnd.cacheName())) continue;
            it.remove();
        }
    }

    public UUID registerStaticRoutine(String cacheName, CacheEntryUpdatedListener<?, ?> locLsnr, CacheEntryEventSerializableFilter rmtFilter, @Nullable IgnitePredicate<ClusterNode> prjPred) throws IgniteCheckedException {
        String topicPrefix = "CONTINUOUS_QUERY_STATIC_" + cacheName;
        CacheContinuousQueryHandler hnd = new CacheContinuousQueryHandler(cacheName, GridTopic.TOPIC_CACHE.topic(topicPrefix, this.ctx.localNodeId(), this.seq.incrementAndGet()), locLsnr, rmtFilter, true, false, true, false);
        hnd.internal(true);
        UUID routineId = UUID.randomUUID();
        LocalRoutineInfo routineInfo = new LocalRoutineInfo(prjPred, hnd, 1, 0L, true);
        if (this.discoProtoVer == 2) {
            this.routinesInfo.addRoutineInfo(this.createRoutineInfo(this.ctx.localNodeId(), routineId, hnd, prjPred, routineInfo.bufSize, routineInfo.interval, routineInfo.autoUnsubscribe));
        }
        this.locInfos.put(routineId, routineInfo);
        this.registerMessageListener(hnd);
        return routineId;
    }

    private ContinuousRoutineInfo createRoutineInfo(UUID srcNodeId, UUID routineId, GridContinuousHandler hnd, @Nullable IgnitePredicate<ClusterNode> nodeFilter, int bufSize, long interval, boolean autoUnsubscribe) throws IgniteCheckedException {
        byte[] hndBytes = this.marsh.marshal(hnd);
        byte[] filterBytes = nodeFilter != null ? this.marsh.marshal(nodeFilter) : null;
        return new ContinuousRoutineInfo(srcNodeId, routineId, hndBytes, filterBytes, bufSize, interval, autoUnsubscribe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<UUID> startRoutine(GridContinuousHandler hnd, boolean locOnly, int bufSize, long interval, boolean autoUnsubscribe, @Nullable IgnitePredicate<ClusterNode> prjPred) {
        AbstractContinuousMessage msg;
        assert (hnd != null);
        assert (bufSize > 0);
        assert (interval >= 0L);
        UUID routineId = UUID.randomUUID();
        this.locInfos.put(routineId, new LocalRoutineInfo(prjPred, hnd, bufSize, interval, autoUnsubscribe));
        if (locOnly) {
            try {
                this.registerHandler(this.ctx.localNodeId(), routineId, hnd, bufSize, interval, autoUnsubscribe, true);
                return new GridFinishedFuture<UUID>(routineId);
            }
            catch (IgniteCheckedException e) {
                this.unregisterHandler(routineId, hnd, true);
                return new GridFinishedFuture<UUID>(e);
            }
        }
        boolean locIncluded = prjPred == null || prjPred.apply(this.ctx.discovery().localNode());
        try {
            msg = this.createStartMessage(routineId, hnd, bufSize, interval, autoUnsubscribe, prjPred);
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<UUID>(e);
        }
        this.registerMessageListener(hnd);
        if (!this.lockStopping()) {
            return new GridFinishedFuture<UUID>(new NodeStoppingException("Failed to start continuous query (node is stopping)"));
        }
        try {
            StartFuture fut = new StartFuture(routineId);
            this.startFuts.put(routineId, fut);
            try {
                if (locIncluded || hnd.isQuery()) {
                    this.registerHandler(this.ctx.localNodeId(), routineId, hnd, bufSize, interval, autoUnsubscribe, true);
                }
                this.ctx.discovery().sendCustomEvent(msg);
            }
            catch (IgniteCheckedException e) {
                this.startFuts.remove(routineId);
                this.locInfos.remove(routineId);
                this.unregisterHandler(routineId, hnd, true);
                fut.onDone(e);
                StartFuture startFuture = fut;
                this.unlockStopping();
                return startFuture;
            }
            fut.onLocalRegistered();
            StartFuture startFuture = fut;
            return startFuture;
        }
        finally {
            this.unlockStopping();
        }
    }

    private AbstractContinuousMessage createStartMessage(UUID routineId, GridContinuousHandler hnd, int bufSize, long interval, boolean autoUnsubscribe, @Nullable IgnitePredicate<ClusterNode> nodeFilter) throws IgniteCheckedException {
        hnd = hnd.clone();
        String clsName = null;
        GridDeploymentInfoBean dep = null;
        if (this.ctx.config().isPeerClassLoadingEnabled()) {
            if (nodeFilter != null && !U.isGrid(nodeFilter.getClass())) {
                Class<?> cls = U.detectClass(nodeFilter);
                clsName = cls.getName();
                GridDeployment dep0 = this.ctx.deploy().deploy(cls, U.detectClassLoader(cls));
                if (dep0 == null) {
                    throw new IgniteDeploymentCheckedException("Failed to deploy projection predicate: " + nodeFilter);
                }
                dep = new GridDeploymentInfoBean(dep0);
            }
            hnd.p2pMarshal(this.ctx);
        }
        if (this.discoProtoVer == 1) {
            StartRequestData reqData = new StartRequestData(nodeFilter, hnd, bufSize, interval, autoUnsubscribe);
            if (clsName != null) {
                reqData.className(clsName);
                reqData.deploymentInfo(dep);
                reqData.p2pMarshal(this.marsh);
            }
            return new StartRoutineDiscoveryMessage(routineId, reqData, reqData.handler().keepBinary());
        }
        assert (this.discoProtoVer == 2) : this.discoProtoVer;
        byte[] nodeFilterBytes = nodeFilter != null ? U.marshal(this.marsh, nodeFilter) : null;
        byte[] hndBytes = U.marshal(this.marsh, (Object)hnd);
        StartRequestDataV2 reqData = new StartRequestDataV2(nodeFilterBytes, hndBytes, bufSize, interval, autoUnsubscribe);
        if (clsName != null) {
            reqData.className(clsName);
            reqData.deploymentInfo(dep);
        }
        return new StartRoutineDiscoveryMessageV2(routineId, reqData, hnd.keepBinary());
    }

    private void registerMessageListener(GridContinuousHandler hnd) {
        if (hnd.orderedTopic() != null) {
            this.ctx.io().addMessageListener(hnd.orderedTopic(), new GridMessageListener(){

                @Override
                public void onMessage(UUID nodeId, Object obj, byte plc) {
                    GridContinuousMessage msg = (GridContinuousMessage)obj;
                    assert (msg.type() == GridContinuousMessageType.MSG_EVT_NOTIFICATION);
                    if (msg.data() == null && msg.dataBytes() != null) {
                        try {
                            msg.data(U.unmarshal(GridContinuousProcessor.this.marsh, msg.dataBytes(), U.resolveClassLoader(GridContinuousProcessor.this.ctx.config())));
                        }
                        catch (IgniteCheckedException e) {
                            U.error(GridContinuousProcessor.this.log, "Failed to process message (ignoring): " + msg, e);
                            return;
                        }
                    }
                    GridContinuousProcessor.this.processNotification(nodeId, msg);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<?> stopRoutine(UUID routineId) {
        assert (routineId != null);
        boolean doStop = false;
        if (!this.lockStopping()) {
            return new GridFinishedFuture(new NodeStoppingException("Failed to stop continuous query (node is stopping)"));
        }
        try {
            StopFuture fut = (StopFuture)this.stopFuts.get(routineId);
            if (fut == null) {
                fut = new StopFuture(this.ctx);
                StopFuture old = this.stopFuts.putIfAbsent(routineId, fut);
                if (old != null) {
                    fut = old;
                } else {
                    doStop = true;
                }
            }
            if (doStop) {
                boolean stop = false;
                LocalRoutineInfo routine = (LocalRoutineInfo)this.locInfos.remove(routineId);
                if (routine != null) {
                    stop = true;
                    this.unregisterHandler(routineId, routine.hnd, true);
                }
                if (!stop && this.discoProtoVer == 2) {
                    stop = this.routinesInfo.routineExists(routineId);
                }
                if (!stop) {
                    this.stopFuts.remove(routineId);
                    fut.onDone();
                    StopFuture stopFuture = fut;
                    return stopFuture;
                }
                try {
                    this.ctx.discovery().sendCustomEvent(new StopRoutineDiscoveryMessage(routineId));
                }
                catch (IgniteCheckedException e) {
                    fut.onDone(e);
                }
                if (this.ctx.isStopping()) {
                    fut.onDone();
                }
            }
            StopFuture stopFuture = fut;
            return stopFuture;
        }
        finally {
            this.unlockStopping();
        }
    }

    public void addBackupNotification(UUID nodeId, UUID routineId, Collection<?> objs, @Nullable Object orderedTopic) throws IgniteCheckedException {
        if (this.processorStopped) {
            return;
        }
        RemoteRoutineInfo info2 = (RemoteRoutineInfo)this.rmtInfos.get(routineId);
        if (info2 != null) {
            GridContinuousBatch batch = info2.addAll(objs);
            Collection<Object> toSnd = batch.collect();
            if (!toSnd.isEmpty()) {
                this.sendNotification(nodeId, routineId, null, toSnd, orderedTopic, true, null);
            }
        } else {
            LocalRoutineInfo locRoutineInfo = (LocalRoutineInfo)this.locInfos.get(routineId);
            if (locRoutineInfo != null) {
                locRoutineInfo.handler().notifyCallback(nodeId, routineId, objs, this.ctx);
            }
        }
    }

    public void addNotification(UUID nodeId, final UUID routineId, @Nullable Object obj, @Nullable Object orderedTopic, boolean sync, boolean msg) throws IgniteCheckedException {
        assert (nodeId != null);
        assert (routineId != null);
        assert (!msg || obj instanceof Message || obj instanceof Collection) : obj;
        assert (!nodeId.equals(this.ctx.localNodeId()));
        if (this.processorStopped) {
            return;
        }
        final RemoteRoutineInfo info2 = (RemoteRoutineInfo)this.rmtInfos.get(routineId);
        if (info2 != null) {
            assert (info2.interval == 0L || !sync);
            if (sync) {
                SyncMessageAckFuture fut = new SyncMessageAckFuture(nodeId);
                IgniteUuid futId = IgniteUuid.randomUuid();
                this.syncMsgFuts.put(futId, fut);
                try {
                    this.sendNotification(nodeId, routineId, futId, obj instanceof Collection ? (List<Object>)obj : F.asList(obj), null, msg, null);
                    info2.hnd.onBatchAcknowledged(routineId, info2.add(obj), this.ctx);
                }
                catch (IgniteCheckedException e) {
                    this.syncMsgFuts.remove(futId);
                    throw e;
                }
                while (true) {
                    try {
                        fut.get(100L, TimeUnit.MILLISECONDS);
                    }
                    catch (IgniteFutureTimeoutCheckedException ignored) {
                        if (!this.ctx.discovery().alive(nodeId)) {
                            SyncMessageAckFuture fut0 = (SyncMessageAckFuture)this.syncMsgFuts.remove(futId);
                            if (fut0 == null) break;
                            ClusterTopologyCheckedException err2 = new ClusterTopologyCheckedException("Node left grid after receiving, but before processing the message [node=" + nodeId + "]");
                            fut0.onDone(err2);
                            break;
                        }
                        LT.warn(this.log, "Failed to wait for ack message. [node=" + nodeId + ", routine=" + routineId + "]");
                        continue;
                    }
                    break;
                }
                assert (fut.isDone()) : "Future in not finished [fut= " + fut + "]";
            } else {
                final GridContinuousBatch batch = info2.add(obj);
                if (batch != null) {
                    CI1<IgniteException> ackC = new CI1<IgniteException>(){

                        @Override
                        public void apply(IgniteException e) {
                            if (e == null) {
                                info2.hnd.onBatchAcknowledged(routineId, batch, GridContinuousProcessor.this.ctx);
                            }
                        }
                    };
                    this.sendNotification(nodeId, routineId, null, batch.collect(), orderedTopic, msg, (IgniteInClosure<IgniteException>)ackC);
                }
            }
        }
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        this.cancelFutures(new IgniteClientDisconnectedCheckedException(reconnectFut, "Client node disconnected."));
        if (this.log.isDebugEnabled()) {
            this.log.debug("onDisconnected [rmtInfos=" + this.rmtInfos + ", locInfos=" + this.locInfos + ", clientInfos=" + this.clientInfos + ']');
        }
        for (Map.Entry e : this.rmtInfos.entrySet()) {
            RemoteRoutineInfo info2 = (RemoteRoutineInfo)e.getValue();
            if (this.ctx.localNodeId().equals(info2.nodeId) && !info2.autoUnsubscribe) continue;
            this.unregisterRemote((UUID)e.getKey());
        }
        for (LocalRoutineInfo routine : this.locInfos.values()) {
            routine.hnd.onClientDisconnected();
        }
        this.rmtInfos.clear();
        this.clientInfos.clear();
        if (this.discoProtoVer == 2) {
            this.routinesInfo.onClientDisconnected(this.locInfos.keySet());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("after onDisconnected [rmtInfos=" + this.rmtInfos + ", locInfos=" + this.locInfos + ", clientInfos=" + this.clientInfos + ']');
        }
    }

    private void sendNotification(UUID nodeId, UUID routineId, @Nullable IgniteUuid futId, Collection<Object> toSnd, @Nullable Object orderedTopic, boolean msg, IgniteInClosure<IgniteException> ackC) throws IgniteCheckedException {
        assert (nodeId != null);
        assert (routineId != null);
        assert (toSnd != null);
        assert (!toSnd.isEmpty());
        this.sendWithRetries(nodeId, new GridContinuousMessage(GridContinuousMessageType.MSG_EVT_NOTIFICATION, routineId, futId, toSnd, msg), orderedTopic, ackC);
    }

    private void processStopAckRequest(StopRoutineAckDiscoveryMessage msg) {
        StopFuture fut = (StopFuture)this.stopFuts.remove(msg.routineId());
        if (fut != null) {
            fut.onDone();
        }
    }

    private void processStopRequest(ClusterNode snd, StopRoutineDiscoveryMessage msg) {
        Map clientInfo;
        if (!snd.id().equals(this.ctx.localNodeId())) {
            UUID routineId = msg.routineId();
            this.unregisterRemote(routineId);
        }
        Iterator iterator2 = this.clientInfos.values().iterator();
        while (iterator2.hasNext() && (clientInfo = (Map)iterator2.next()).remove(msg.routineId()) == null) {
        }
    }

    private void processStartAckRequest(AffinityTopologyVersion topVer, StartRoutineAckDiscoveryMessage msg) {
        StartFuture fut = (StartFuture)this.startFuts.remove(msg.routineId());
        if (fut != null) {
            fut.onAllRemoteRegistered(topVer, msg.errs(), msg.updateCountersPerNode(), msg.updateCounters());
        }
    }

    private void processStartRequest(ClusterNode node, StartRoutineDiscoveryMessage req) {
        GridCacheAdapter cache;
        GridCacheProcessor proc;
        GridContinuousHandler hnd0;
        UUID routineId = req.routineId();
        if (node.id().equals(this.ctx.localNodeId())) {
            return;
        }
        StartRequestData data = req.startRequestData();
        GridContinuousHandler hnd = data.handler();
        if (req.keepBinary()) {
            assert (hnd instanceof CacheContinuousQueryHandler);
            ((CacheContinuousQueryHandler)hnd).keepBinary(true);
        }
        IgniteCheckedException err2 = null;
        try {
            if (this.ctx.config().isPeerClassLoadingEnabled()) {
                String clsName = data.className();
                if (clsName != null) {
                    GridDeploymentInfo depInfo = data.deploymentInfo();
                    GridDeployment dep = this.ctx.deploy().getGlobalDeployment(depInfo.deployMode(), clsName, clsName, depInfo.userVersion(), node.id(), depInfo.classLoaderId(), depInfo.participants(), null);
                    if (dep == null) {
                        throw new IgniteDeploymentCheckedException("Failed to obtain deployment for class: " + clsName);
                    }
                    data.p2pUnmarshal(this.marsh, U.resolveClassLoader(dep.classLoader(), this.ctx.config()));
                }
                hnd.p2pUnmarshal(node.id(), this.ctx);
            }
        }
        catch (IgniteCheckedException e) {
            err2 = e;
            U.error(this.log, "Failed to register handler [nodeId=" + node.id() + ", routineId=" + routineId + ']', e);
        }
        GridContinuousHandler gridContinuousHandler = hnd0 = hnd instanceof GridMessageListenHandler ? new GridMessageListenHandler((GridMessageListenHandler)hnd) : hnd;
        if (node.isClient()) {
            HashMap<UUID, LocalRoutineInfo> clientRoutineMap = (HashMap<UUID, LocalRoutineInfo>)this.clientInfos.get(node.id());
            if (clientRoutineMap == null) {
                clientRoutineMap = new HashMap<UUID, LocalRoutineInfo>();
                Map old = this.clientInfos.put(node.id(), clientRoutineMap);
                assert (old == null);
            }
            clientRoutineMap.put(routineId, new LocalRoutineInfo(data.projectionPredicate(), hnd0, data.bufferSize(), data.interval(), data.autoUnsubscribe()));
        }
        if (err2 == null) {
            try {
                IgnitePredicate<ClusterNode> prjPred = data.projectionPredicate();
                if (prjPred != null) {
                    this.ctx.resource().injectGeneric(prjPred);
                }
                if ((prjPred == null || prjPred.apply(this.ctx.discovery().node(this.ctx.localNodeId()))) && !this.locInfos.containsKey(routineId)) {
                    this.registerHandler(node.id(), routineId, hnd0, data.bufferSize(), data.interval(), data.autoUnsubscribe(), false);
                }
                if (!data.autoUnsubscribe()) {
                    this.locInfos.putIfAbsent(routineId, new LocalRoutineInfo(prjPred, hnd0, data.bufferSize(), data.interval(), data.autoUnsubscribe()));
                }
            }
            catch (IgniteCheckedException e) {
                err2 = e;
                U.error(this.log, "Failed to register handler [nodeId=" + node.id() + ", routineId=" + routineId + ']', e);
            }
        }
        if (hnd0.isQuery() && (proc = this.ctx.cache()) != null && (cache = this.ctx.cache().internalCache(hnd0.cacheName())) != null && !cache.isLocal() && cache.context().userCache()) {
            req.addUpdateCounters(this.ctx.localNodeId(), CachePartitionPartialCountersMap.toCountersMap(cache.context().topology().localUpdateCounters(false, false)));
        }
        if (err2 != null) {
            req.addError(this.ctx.localNodeId(), err2);
        }
    }

    private void processRoutineStartResultMessage(UUID sndId, ContinuousRoutineStartResultMessage msg) {
        StartFuture fut = (StartFuture)this.startFuts.get(msg.routineId());
        if (fut != null) {
            fut.onResult(sndId, msg);
        }
    }

    private void processStartRequestV2(AffinityTopologyVersion topVer, final ClusterNode snd, final StartRoutineDiscoveryMessageV2 msg) {
        StartRequestDataV2 reqData = msg.startRequestData();
        ContinuousRoutineInfo routineInfo = new ContinuousRoutineInfo(snd.id(), msg.routineId(), reqData.handlerBytes(), reqData.nodeFilterBytes(), reqData.bufferSize(), reqData.interval(), reqData.autoUnsubscribe());
        this.routinesInfo.addRoutineInfo(routineInfo);
        final DiscoCache discoCache = this.ctx.discovery().discoCache(topVer);
        this.ctx.getSystemExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                boolean register2;
                if (snd.id().equals(GridContinuousProcessor.this.ctx.localNodeId())) {
                    StartFuture fut = (StartFuture)GridContinuousProcessor.this.startFuts.get(msg.routineId());
                    if (fut != null) {
                        fut.initRemoteNodes(discoCache);
                    }
                    return;
                }
                StartRequestDataV2 reqData = msg.startRequestData();
                Exception err2 = null;
                IgnitePredicate nodeFilter = null;
                byte[] cntrs = null;
                if (reqData.nodeFilterBytes() != null) {
                    try {
                        if (GridContinuousProcessor.this.ctx.config().isPeerClassLoadingEnabled() && reqData.className() != null) {
                            String clsName = reqData.className();
                            GridDeploymentInfo depInfo = reqData.deploymentInfo();
                            GridDeployment dep = GridContinuousProcessor.this.ctx.deploy().getGlobalDeployment(depInfo.deployMode(), clsName, clsName, depInfo.userVersion(), snd.id(), depInfo.classLoaderId(), depInfo.participants(), null);
                            if (dep == null) {
                                throw new IgniteDeploymentCheckedException("Failed to obtain deployment for class: " + clsName);
                            }
                            nodeFilter = (IgnitePredicate)U.unmarshal(GridContinuousProcessor.this.marsh, reqData.nodeFilterBytes(), U.resolveClassLoader(dep.classLoader(), GridContinuousProcessor.this.ctx.config()));
                        } else {
                            nodeFilter = (IgnitePredicate)U.unmarshal(GridContinuousProcessor.this.marsh, reqData.nodeFilterBytes(), U.resolveClassLoader(GridContinuousProcessor.this.ctx.config()));
                        }
                        if (nodeFilter != null) {
                            GridContinuousProcessor.this.ctx.resource().injectGeneric(nodeFilter);
                        }
                    }
                    catch (Exception e) {
                        err2 = e;
                        U.error(GridContinuousProcessor.this.log, "Failed to unmarshal continuous routine filter [routineId=" + msg.routineId + ", srcNodeId=" + snd.id() + ']', e);
                    }
                }
                boolean bl = register2 = err2 == null && (nodeFilter == null || nodeFilter.apply(GridContinuousProcessor.this.ctx.discovery().localNode()));
                if (register2) {
                    try {
                        GridCacheAdapter cache;
                        GridCacheProcessor proc;
                        GridContinuousHandler hnd = (GridContinuousHandler)U.unmarshal(GridContinuousProcessor.this.marsh, reqData.handlerBytes(), U.resolveClassLoader(GridContinuousProcessor.this.ctx.config()));
                        if (GridContinuousProcessor.this.ctx.config().isPeerClassLoadingEnabled()) {
                            hnd.p2pUnmarshal(snd.id(), GridContinuousProcessor.this.ctx);
                        }
                        if (msg.keepBinary()) {
                            assert (hnd instanceof CacheContinuousQueryHandler) : hnd;
                            ((CacheContinuousQueryHandler)hnd).keepBinary(true);
                        }
                        GridContinuousHandler hnd0 = hnd instanceof GridMessageListenHandler ? new GridMessageListenHandler((GridMessageListenHandler)hnd) : hnd;
                        GridContinuousProcessor.this.registerHandler(snd.id(), msg.routineId, hnd0, reqData.bufferSize(), reqData.interval(), reqData.autoUnsubscribe(), false);
                        if (hnd0.isQuery() && (proc = GridContinuousProcessor.this.ctx.cache()) != null && (cache = GridContinuousProcessor.this.ctx.cache().internalCache(hnd0.cacheName())) != null && !cache.isLocal() && cache.context().userCache()) {
                            CachePartitionPartialCountersMap cntrsMap = cache.context().topology().localUpdateCounters(false, false);
                            cntrs = U.marshal(GridContinuousProcessor.this.marsh, (Object)cntrsMap);
                        }
                    }
                    catch (Exception e) {
                        err2 = e;
                        U.error(GridContinuousProcessor.this.log, "Failed to register continuous routine handler [routineId=" + msg.routineId + ", srcNodeId=" + snd.id() + ']', e);
                    }
                }
                GridContinuousProcessor.this.sendMessageStartResult(snd, msg.routineId(), cntrs, err2);
            }
        });
    }

    private void sendMessageStartResult(ClusterNode node, UUID routineId, byte[] cntrsMapBytes, @Nullable Exception err2) {
        byte[] errBytes = null;
        if (err2 != null) {
            try {
                errBytes = U.marshal(this.marsh, (Object)err2);
            }
            catch (Exception e) {
                U.error(this.log, "Failed to marshal routine start error: " + e, e);
            }
        }
        ContinuousRoutineStartResultMessage msg = new ContinuousRoutineStartResultMessage(routineId, cntrsMapBytes, errBytes, err2 != null);
        try {
            this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_CONTINUOUS, msg, (byte)2, null);
        }
        catch (ClusterTopologyCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send routine start result, node failed: " + e);
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send routine start result: " + e, e);
        }
    }

    private void processMessageAck(GridContinuousMessage msg) {
        assert (msg.futureId() != null);
        SyncMessageAckFuture fut = (SyncMessageAckFuture)this.syncMsgFuts.remove(msg.futureId());
        if (fut != null) {
            fut.onDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNotification(UUID nodeId, GridContinuousMessage msg) {
        assert (nodeId != null);
        assert (msg != null);
        UUID routineId = msg.routineId();
        try {
            LocalRoutineInfo routine = (LocalRoutineInfo)this.locInfos.get(routineId);
            if (routine != null) {
                routine.hnd.notifyCallback(nodeId, routineId, (Collection)msg.data(), this.ctx);
            }
        }
        finally {
            if (msg.futureId() != null) {
                try {
                    this.sendWithRetries(nodeId, new GridContinuousMessage(GridContinuousMessageType.MSG_EVT_ACK, null, msg.futureId(), null, false), null, null);
                }
                catch (IgniteCheckedException e) {
                    this.log.error("Failed to send event acknowledgment to node: " + nodeId, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerHandler(final UUID nodeId, final UUID routineId, final GridContinuousHandler hnd, int bufSize, final long interval, boolean autoUnsubscribe, boolean loc) throws IgniteCheckedException {
        assert (nodeId != null);
        assert (routineId != null);
        assert (hnd != null);
        assert (bufSize > 0);
        assert (interval >= 0L);
        final RemoteRoutineInfo info2 = new RemoteRoutineInfo(nodeId, hnd, bufSize, interval, autoUnsubscribe);
        boolean doRegister = loc;
        if (!doRegister) {
            this.stopLock.lock();
            try {
                doRegister = !this.stopped.remove(routineId) && this.rmtInfos.putIfAbsent(routineId, info2) == null;
            }
            finally {
                this.stopLock.unlock();
            }
        }
        if (doRegister) {
            GridContinuousHandler.RegisterStatus status;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Register handler: [nodeId=" + nodeId + ", routineId=" + routineId + ", info=" + info2 + ']');
            }
            if (interval > 0L) {
                IgniteThread checker = new IgniteThread(new GridWorker(this.ctx.igniteInstanceName(), "continuous-buffer-checker", this.log){

                    @Override
                    protected void body() {
                        long interval0 = interval;
                        while (!this.isCancelled()) {
                            try {
                                U.sleep(interval0);
                            }
                            catch (IgniteInterruptedCheckedException ignored) {
                                break;
                            }
                            IgniteBiTuple<GridContinuousBatch, Long> t = info2.checkInterval();
                            final GridContinuousBatch batch = t.get1();
                            if (batch != null && batch.size() > 0) {
                                try {
                                    Collection<Object> toSnd = batch.collect();
                                    boolean msg = toSnd.iterator().next() instanceof Message;
                                    CI1<IgniteException> ackC = new CI1<IgniteException>(){

                                        @Override
                                        public void apply(IgniteException e) {
                                            if (e == null) {
                                                info2.hnd.onBatchAcknowledged(routineId, batch, GridContinuousProcessor.this.ctx);
                                            }
                                        }
                                    };
                                    GridContinuousProcessor.this.sendNotification(nodeId, routineId, null, toSnd, hnd.orderedTopic(), msg, ackC);
                                }
                                catch (ClusterTopologyCheckedException ignored) {
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("Failed to send notification to node (is node alive?): " + nodeId);
                                    }
                                }
                                catch (IgniteCheckedException e) {
                                    U.error(this.log, "Failed to send notification to node: " + nodeId, e);
                                }
                            }
                            interval0 = t.get2();
                        }
                    }
                });
                checker.setUncaughtExceptionHandler(new OomExceptionHandler(this.ctx));
                this.bufCheckThreads.put(routineId, checker);
                checker.start();
            }
            if ((status = hnd.register(nodeId, routineId, this.ctx)) == GridContinuousHandler.RegisterStatus.DELAYED) {
                info2.markDelayedRegister();
                return false;
            }
            return status == GridContinuousHandler.RegisterStatus.REGISTERED;
        }
        return false;
    }

    private void unregisterHandler(UUID routineId, GridContinuousHandler hnd, boolean loc) {
        assert (routineId != null);
        assert (hnd != null);
        if (loc && hnd.orderedTopic() != null) {
            this.ctx.io().removeMessageListener(hnd.orderedTopic());
        }
        hnd.unregister(routineId, this.ctx);
        IgniteThread checker = this.bufCheckThreads.remove(routineId);
        if (checker != null) {
            checker.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterRemote(UUID routineId) {
        LocalRoutineInfo loc;
        RemoteRoutineInfo remote2;
        this.stopLock.lock();
        try {
            remote2 = (RemoteRoutineInfo)this.rmtInfos.remove(routineId);
            loc = (LocalRoutineInfo)this.locInfos.remove(routineId);
            if (remote2 == null) {
                this.stopped.add(routineId);
            }
        }
        finally {
            this.stopLock.unlock();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("unregisterRemote [routineId=" + routineId + ", loc=" + loc + ", rmt=" + remote2 + ']');
        }
        if (remote2 != null) {
            this.unregisterHandler(routineId, remote2.hnd, false);
        } else if (loc != null) {
            this.unregisterHandler(routineId, loc.hnd, false);
        }
    }

    private void sendWithRetries(UUID nodeId, GridContinuousMessage msg, @Nullable Object orderedTopic, IgniteInClosure<IgniteException> ackC) throws IgniteCheckedException {
        assert (nodeId != null);
        assert (msg != null);
        ClusterNode node = this.ctx.discovery().node(nodeId);
        if (node == null) {
            throw new ClusterTopologyCheckedException("Node for provided ID doesn't exist (did it leave the grid?): " + nodeId);
        }
        this.sendWithRetries(node, msg, orderedTopic, ackC);
    }

    private void sendWithRetries(ClusterNode node, GridContinuousMessage msg, @Nullable Object orderedTopic, IgniteInClosure<IgniteException> ackC) throws IgniteCheckedException {
        assert (node != null);
        assert (msg != null);
        this.sendWithRetries(F.asList(node), msg, orderedTopic, ackC);
    }

    private void sendWithRetries(Collection<? extends ClusterNode> nodes2, GridContinuousMessage msg, @Nullable Object orderedTopic, IgniteInClosure<IgniteException> ackC) throws IgniteCheckedException {
        assert (!F.isEmpty(nodes2));
        assert (msg != null);
        if (!(msg.messages() || msg.data() == null || nodes2.size() <= 1 && this.ctx.localNodeId().equals(F.first(nodes2).id()))) {
            msg.dataBytes(U.marshal(this.marsh, msg.data()));
        }
        block3: for (ClusterNode clusterNode : nodes2) {
            int cnt = 0;
            while (cnt <= this.retryCnt) {
                try {
                    ++cnt;
                    if (orderedTopic != null) {
                        this.ctx.io().sendOrderedMessage(clusterNode, orderedTopic, msg, (byte)2, 0L, true, ackC);
                        continue block3;
                    }
                    this.ctx.io().sendToGridTopic(clusterNode, GridTopic.TOPIC_CONTINUOUS, msg, (byte)2, ackC);
                    continue block3;
                }
                catch (IgniteInterruptedCheckedException | ClusterTopologyCheckedException e) {
                    throw e;
                }
                catch (IgniteCheckedException e) {
                    if (!this.ctx.discovery().alive(clusterNode.id())) {
                        throw new ClusterTopologyCheckedException("Node left grid while sending message to: " + clusterNode.id(), e);
                    }
                    if (cnt == this.retryCnt) {
                        throw e;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Failed to send message to node (will retry): " + clusterNode.id());
                    }
                    U.sleep(this.retryDelay);
                }
            }
        }
    }

    private static class SyncMessageAckFuture
    extends GridFutureAdapter<Object> {
        private UUID nodeId;

        SyncMessageAckFuture(UUID nodeId) {
            this.nodeId = nodeId;
        }

        UUID nodeId() {
            return this.nodeId;
        }

        @Override
        public String toString() {
            return S.toString(SyncMessageAckFuture.class, this);
        }
    }

    private static class StopFuture
    extends GridFutureAdapter<Object> {
        private volatile GridTimeoutObject timeoutObj;
        private GridKernalContext ctx;

        StopFuture(GridKernalContext ctx) {
            this.ctx = ctx;
        }

        public void addTimeoutObject(GridTimeoutObject timeoutObj) {
            assert (timeoutObj != null);
            this.timeoutObj = timeoutObj;
            this.ctx.timeout().addTimeoutObject(timeoutObj);
        }

        @Override
        public boolean onDone(@Nullable Object res, @Nullable Throwable err2) {
            if (this.timeoutObj != null) {
                this.ctx.timeout().removeTimeoutObject(this.timeoutObj);
            }
            return super.onDone(res, err2);
        }

        @Override
        public String toString() {
            return S.toString(StopFuture.class, this);
        }
    }

    private static class RoutineRegisterResults {
        private final AffinityTopologyVersion topVer;
        private final Map<UUID, ? extends Exception> errs;
        private final Map<UUID, Map<Integer, T2<Long, Long>>> cntrsPerNode;

        RoutineRegisterResults(AffinityTopologyVersion topVer, Map<UUID, ? extends Exception> errs, Map<UUID, Map<Integer, T2<Long, Long>>> cntrsPerNode) {
            this.topVer = topVer;
            this.errs = errs;
            this.cntrsPerNode = cntrsPerNode;
        }
    }

    private class StartFuture
    extends GridFutureAdapter<UUID> {
        private UUID routineId;
        private volatile boolean loc;
        private volatile boolean rmt;
        private final DiscoveryMessageResultsCollector<ContinuousRoutineStartResultMessage, RoutineRegisterResults> resCollect;

        StartFuture(UUID routineId) {
            this.routineId = routineId;
            this.resCollect = new DiscoveryMessageResultsCollector<ContinuousRoutineStartResultMessage, RoutineRegisterResults>(GridContinuousProcessor.this.ctx){

                @Override
                protected RoutineRegisterResults createResult(Map<UUID, DiscoveryMessageResultsCollector.NodeMessage<ContinuousRoutineStartResultMessage>> rcvd) {
                    HashMap<UUID, Exception> errs = null;
                    HashMap<UUID, Map<Integer, T2<Long, Long>>> cntrsPerNode = null;
                    for (Map.Entry<UUID, DiscoveryMessageResultsCollector.NodeMessage<ContinuousRoutineStartResultMessage>> entry2 : rcvd.entrySet()) {
                        ContinuousRoutineStartResultMessage msg = entry2.getValue().message();
                        if (msg == null) continue;
                        if (msg.error()) {
                            byte[] errBytes = msg.errorBytes();
                            Exception err2 = null;
                            if (errBytes != null) {
                                try {
                                    err2 = (Exception)U.unmarshal(GridContinuousProcessor.this.marsh, errBytes, U.resolveClassLoader(this.ctx.config()));
                                }
                                catch (Exception e) {
                                    U.warn(GridContinuousProcessor.this.log, "Failed to unmarhal continuous routine start error: " + e);
                                }
                            }
                            if (err2 == null) {
                                err2 = new IgniteCheckedException("Failed to start continuous routine on node: " + entry2.getKey());
                            }
                            if (errs == null) {
                                errs = new HashMap<UUID, Exception>();
                            }
                            errs.put(entry2.getKey(), err2);
                            continue;
                        }
                        byte[] cntrsMapBytes = msg.countersMapBytes();
                        if (cntrsMapBytes == null) continue;
                        try {
                            CachePartitionPartialCountersMap cntrsMap = (CachePartitionPartialCountersMap)U.unmarshal(GridContinuousProcessor.this.marsh, cntrsMapBytes, U.resolveClassLoader(this.ctx.config()));
                            if (cntrsPerNode == null) {
                                cntrsPerNode = new HashMap<UUID, Map<Integer, T2<Long, Long>>>();
                            }
                            cntrsPerNode.put(entry2.getKey(), CachePartitionPartialCountersMap.toCountersMap(cntrsMap));
                        }
                        catch (Exception e) {
                            U.warn(GridContinuousProcessor.this.log, "Failed to unmarhal continuous query update counters: " + e);
                        }
                    }
                    return new RoutineRegisterResults(this.discoCache.version(), errs, cntrsPerNode);
                }

                @Override
                protected void onResultsCollected(RoutineRegisterResults res0) {
                    StartFuture.this.onAllRemoteRegistered(res0.topVer, res0.errs, res0.cntrsPerNode, null);
                }

                @Override
                protected boolean waitForNode(DiscoCache discoCache, ClusterNode node) {
                    return !this.ctx.localNodeId().equals(node.id());
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onAllRemoteRegistered(AffinityTopologyVersion topVer, @Nullable Map<UUID, ? extends Exception> errs, Map<UUID, Map<Integer, T2<Long, Long>>> cntrsPerNode, Map<Integer, T2<Long, Long>> cntrs) {
            try {
                if (errs == null || errs.isEmpty()) {
                    LocalRoutineInfo routine = (LocalRoutineInfo)GridContinuousProcessor.this.locInfos.get(this.routineId);
                    if (routine != null && routine.handler().isQuery()) {
                        GridCacheContext cctx;
                        GridCacheAdapter interCache = GridContinuousProcessor.this.ctx.cache().internalCache(routine.handler().cacheName());
                        GridCacheContext gridCacheContext = cctx = interCache != null ? interCache.context() : null;
                        if (cctx != null && cntrsPerNode != null && !cctx.isLocal() && cctx.affinityNode()) {
                            cntrsPerNode.put(GridContinuousProcessor.this.ctx.localNodeId(), CachePartitionPartialCountersMap.toCountersMap(cctx.topology().localUpdateCounters(false, false)));
                        }
                        routine.handler().updateCounters(topVer, cntrsPerNode, cntrs);
                    }
                    this.onRemoteRegistered();
                } else {
                    Exception firstEx = F.first(errs.values());
                    this.onDone(firstEx);
                    GridContinuousProcessor.this.stopRoutine(this.routineId);
                }
            }
            finally {
                GridContinuousProcessor.this.startFuts.remove(this.routineId, this);
            }
        }

        void initRemoteNodes(DiscoCache discoCache) {
            this.resCollect.init(discoCache);
        }

        void onResult(UUID nodeId, ContinuousRoutineStartResultMessage msg) {
            this.resCollect.onMessage(nodeId, msg);
        }

        void onNodeFail(UUID nodeId) {
            this.resCollect.onNodeFail(nodeId);
        }

        void onLocalRegistered() {
            this.loc = true;
            if (this.rmt && !this.isDone()) {
                this.onDone(this.routineId);
            }
        }

        void onRemoteRegistered() {
            this.rmt = true;
            if (this.loc && !this.isDone()) {
                this.onDone(this.routineId);
            }
        }

        @Override
        public String toString() {
            return S.toString(StartFuture.class, this);
        }
    }

    private static class DiscoveryDataItem
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private UUID routineId;
        private IgnitePredicate<ClusterNode> prjPred;
        private GridContinuousHandler hnd;
        private int bufSize;
        private long interval;
        private boolean autoUnsubscribe;

        public DiscoveryDataItem() {
        }

        DiscoveryDataItem(UUID routineId, @Nullable IgnitePredicate<ClusterNode> prjPred, GridContinuousHandler hnd, int bufSize, long interval, boolean autoUnsubscribe) {
            assert (routineId != null);
            assert (hnd != null);
            assert (bufSize > 0);
            assert (interval >= 0L);
            this.routineId = routineId;
            this.prjPred = prjPred;
            this.hnd = hnd;
            this.bufSize = bufSize;
            this.interval = interval;
            this.autoUnsubscribe = autoUnsubscribe;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeUuid(out, this.routineId);
            out.writeObject(this.prjPred);
            out.writeObject(this.hnd);
            out.writeInt(this.bufSize);
            out.writeLong(this.interval);
            out.writeBoolean(this.autoUnsubscribe);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.routineId = U.readUuid(in);
            this.prjPred = (IgnitePredicate)in.readObject();
            this.hnd = (GridContinuousHandler)in.readObject();
            this.bufSize = in.readInt();
            this.interval = in.readLong();
            this.autoUnsubscribe = in.readBoolean();
        }

        public String toString() {
            return S.toString(DiscoveryDataItem.class, this);
        }
    }

    private static class DiscoveryData
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private UUID nodeId;
        @GridToStringInclude
        private Collection<DiscoveryDataItem> items;
        private Map<UUID, Map<UUID, LocalRoutineInfo>> clientInfos;

        public DiscoveryData() {
        }

        DiscoveryData(UUID nodeId, Map<UUID, Map<UUID, LocalRoutineInfo>> clientInfos) {
            assert (nodeId != null);
            this.nodeId = nodeId;
            this.clientInfos = clientInfos;
            this.items = new ArrayList<DiscoveryDataItem>();
        }

        public void addItem(DiscoveryDataItem item) {
            this.items.add(item);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            U.writeUuid(out, this.nodeId);
            U.writeCollection(out, this.items);
            U.writeMap(out, this.clientInfos);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.nodeId = U.readUuid(in);
            this.items = U.readCollection(in);
            this.clientInfos = U.readMap(in);
        }

        public String toString() {
            return S.toString(DiscoveryData.class, this);
        }
    }

    private static class RemoteRoutineInfo {
        private UUID nodeId;
        private final GridContinuousHandler hnd;
        private final int bufSize;
        private final long interval;
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private GridContinuousBatch batch;
        private long lastSndTime = U.currentTimeMillis();
        private boolean autoUnsubscribe;
        private boolean delayedRegister;

        RemoteRoutineInfo(UUID nodeId, GridContinuousHandler hnd, int bufSize, long interval, boolean autoUnsubscribe) {
            assert (nodeId != null);
            assert (hnd != null);
            assert (bufSize > 0);
            assert (interval >= 0L);
            this.nodeId = nodeId;
            this.hnd = hnd;
            this.bufSize = bufSize;
            this.interval = interval;
            this.autoUnsubscribe = autoUnsubscribe;
            this.batch = hnd.createBatch();
        }

        public void markDelayedRegister() {
            assert (this.hnd.isQuery());
            this.delayedRegister = true;
        }

        public boolean clearDelayedRegister() {
            if (this.delayedRegister) {
                this.delayedRegister = false;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        GridContinuousBatch addAll(Collection<?> objs) {
            GridContinuousBatch toSnd;
            assert (objs != null);
            this.lock.writeLock().lock();
            try {
                for (Object obj : objs) {
                    this.batch.add(obj);
                }
                toSnd = this.batch;
                this.batch = this.hnd.createBatch();
                if (this.interval > 0L) {
                    this.lastSndTime = U.currentTimeMillis();
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return toSnd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        GridContinuousBatch add(Object obj) {
            assert (obj != null);
            GridContinuousBatch toSnd = null;
            if (this.batch.size() >= this.bufSize - 1) {
                this.lock.writeLock().lock();
                try {
                    this.batch.add(obj);
                    toSnd = this.batch;
                    this.batch = this.hnd.createBatch();
                    if (this.interval <= 0L) return toSnd;
                    this.lastSndTime = U.currentTimeMillis();
                    return toSnd;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            this.lock.readLock().lock();
            try {
                this.batch.add(obj);
                return toSnd;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IgniteBiTuple<GridContinuousBatch, Long> checkInterval() {
            long diff2;
            assert (this.interval > 0L);
            GridContinuousBatch toSnd = null;
            long now = U.currentTimeMillis();
            this.lock.writeLock().lock();
            try {
                diff2 = now - this.lastSndTime;
                if (diff2 >= this.interval && this.batch.size() > 0) {
                    toSnd = this.batch;
                    this.batch = this.hnd.createBatch();
                    this.lastSndTime = now;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return F.t(toSnd, diff2 < this.interval ? this.interval - diff2 : this.interval);
        }

        public String toString() {
            return S.toString(RemoteRoutineInfo.class, this);
        }
    }

    static class LocalRoutineInfo
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final IgnitePredicate<ClusterNode> prjPred;
        private final GridContinuousHandler hnd;
        private final int bufSize;
        private final long interval;
        private boolean autoUnsubscribe;

        LocalRoutineInfo(@Nullable IgnitePredicate<ClusterNode> prjPred, GridContinuousHandler hnd, int bufSize, long interval, boolean autoUnsubscribe) {
            assert (hnd != null);
            assert (bufSize > 0);
            assert (interval >= 0L);
            this.prjPred = prjPred;
            this.hnd = hnd;
            this.bufSize = bufSize;
            this.interval = interval;
            this.autoUnsubscribe = autoUnsubscribe;
        }

        GridContinuousHandler handler() {
            return this.hnd;
        }

        public String toString() {
            return S.toString(LocalRoutineInfo.class, this);
        }
    }

    private class DiscoveryListener
    implements GridLocalEventListener,
    HighPriorityListener {
        private DiscoveryListener() {
        }

        @Override
        public void onEvent(Event evt) {
            assert (evt instanceof DiscoveryEvent);
            assert (evt.type() == 11 || evt.type() == 12);
            UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
            if (GridContinuousProcessor.this.discoProtoVer == 2) {
                GridContinuousProcessor.this.routinesInfo.onNodeFail(nodeId);
                for (StartFuture startFuture : GridContinuousProcessor.this.startFuts.values()) {
                    startFuture.onNodeFail(nodeId);
                }
            }
            GridContinuousProcessor.this.clientInfos.remove(nodeId);
            for (Map.Entry entry2 : GridContinuousProcessor.this.rmtInfos.entrySet()) {
                UUID routineId = (UUID)entry2.getKey();
                RemoteRoutineInfo info2 = (RemoteRoutineInfo)entry2.getValue();
                if (!nodeId.equals(info2.nodeId)) continue;
                if (info2.autoUnsubscribe) {
                    GridContinuousProcessor.this.unregisterRemote(routineId);
                }
                if (!info2.hnd.isQuery()) continue;
                info2.hnd.onNodeLeft();
            }
            for (Map.Entry entry3 : GridContinuousProcessor.this.syncMsgFuts.entrySet()) {
                SyncMessageAckFuture fut0;
                SyncMessageAckFuture fut = (SyncMessageAckFuture)entry3.getValue();
                if (!fut.nodeId().equals(nodeId) || (fut0 = (SyncMessageAckFuture)GridContinuousProcessor.this.syncMsgFuts.remove(entry3.getKey())) == null) continue;
                ClusterTopologyCheckedException err2 = new ClusterTopologyCheckedException("Node left grid while sending message to: " + nodeId);
                fut0.onDone(err2);
            }
        }

        @Override
        public int order() {
            return 1;
        }
    }
}

