/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.continuous;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.processors.continuous.ContinuousRoutineInfo;
import org.apache.ignite.internal.processors.continuous.ContinuousRoutinesCommonDiscoveryData;
import org.apache.ignite.internal.processors.continuous.ContinuousRoutinesJoiningNodeDiscoveryData;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;

class ContinuousRoutinesInfo {
    private final Map<UUID, ContinuousRoutineInfo> startedRoutines = new HashMap<UUID, ContinuousRoutineInfo>();

    ContinuousRoutinesInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collectGridNodeData(DiscoveryDataBag dataBag) {
        Map<UUID, ContinuousRoutineInfo> map2 = this.startedRoutines;
        synchronized (map2) {
            if (!dataBag.commonDataCollectedFor(GridComponent.DiscoveryDataExchangeType.CONTINUOUS_PROC.ordinal())) {
                dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.CONTINUOUS_PROC.ordinal(), new ContinuousRoutinesCommonDiscoveryData(new ArrayList<ContinuousRoutineInfo>(this.startedRoutines.values())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        Map<UUID, ContinuousRoutineInfo> map2 = this.startedRoutines;
        synchronized (map2) {
            for (ContinuousRoutineInfo info2 : this.startedRoutines.values()) {
                if (!info2.disconnected) continue;
                info2.sourceNodeId(dataBag.joiningNodeId());
            }
            dataBag.addJoiningNodeData(GridComponent.DiscoveryDataExchangeType.CONTINUOUS_PROC.ordinal(), new ContinuousRoutinesJoiningNodeDiscoveryData(new ArrayList<ContinuousRoutineInfo>(this.startedRoutines.values())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRoutineInfo(ContinuousRoutineInfo info2) {
        Map<UUID, ContinuousRoutineInfo> map2 = this.startedRoutines;
        synchronized (map2) {
            this.startedRoutines.put(info2.routineId, info2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean routineExists(UUID routineId) {
        Map<UUID, ContinuousRoutineInfo> map2 = this.startedRoutines;
        synchronized (map2) {
            return this.startedRoutines.containsKey(routineId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRoutine(UUID routineId) {
        Map<UUID, ContinuousRoutineInfo> map2 = this.startedRoutines;
        synchronized (map2) {
            this.startedRoutines.remove(routineId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientDisconnected(Collection<UUID> locRoutines) {
        Map<UUID, ContinuousRoutineInfo> map2 = this.startedRoutines;
        synchronized (map2) {
            Iterator<Map.Entry<UUID, ContinuousRoutineInfo>> it = this.startedRoutines.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<UUID, ContinuousRoutineInfo> e = it.next();
                ContinuousRoutineInfo info2 = e.getValue();
                if (!locRoutines.contains(info2.routineId)) {
                    it.remove();
                    continue;
                }
                info2.onDisconnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNodeFail(UUID nodeId) {
        Map<UUID, ContinuousRoutineInfo> map2 = this.startedRoutines;
        synchronized (map2) {
            Iterator<Map.Entry<UUID, ContinuousRoutineInfo>> it = this.startedRoutines.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<UUID, ContinuousRoutineInfo> e = it.next();
                ContinuousRoutineInfo info2 = e.getValue();
                if (!info2.autoUnsubscribe || !info2.srcNodeId.equals(nodeId)) continue;
                it.remove();
            }
        }
    }

    public String toString() {
        return S.toString(ContinuousRoutinesInfo.class, this);
    }
}

