/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridChangeGlobalStateMessageResponse;
import org.apache.ignite.internal.processors.cache.StateChangeRequest;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.cluster.BaselineTopologyHistory;
import org.apache.ignite.internal.processors.cluster.BaselineTopologyHistoryItem;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateFinishMessage;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.cluster.IGridClusterStateProcessor;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.jetbrains.annotations.Nullable;

public class GridClusterStateProcessor
extends GridProcessorAdapter
implements IGridClusterStateProcessor,
MetastorageLifecycleListener {
    private static final String METASTORE_CURR_BLT_KEY = "metastoreBltKey";
    private boolean inMemoryMode;
    private volatile boolean compatibilityMode;
    private volatile DiscoveryDataClusterState globalState;
    private final BaselineTopologyHistory bltHist = new BaselineTopologyHistory();
    private final AtomicReference<GridChangeGlobalStateFuture> stateChangeFut = new AtomicReference();
    private final ConcurrentMap<UUID, GridFutureAdapter<Void>> transitionFuts = new ConcurrentHashMap<UUID, GridFutureAdapter<Void>>();
    private TransitionOnJoinWaitFuture joinFut;
    @GridToStringExclude
    private GridCacheProcessor cacheProc;
    @GridToStringExclude
    private GridCacheSharedContext<?, ?> sharedCtx;
    @GridToStringExclude
    private ReadWriteMetastorage metastorage;
    private final JdkMarshaller marsh = new JdkMarshaller();
    private static final IgniteProductVersion MIN_BLT_SUPPORTING_VER = IgniteProductVersion.fromString("2.4.0");
    private final GridLocalEventListener lsr = new GridLocalEventListener(){

        @Override
        public void onEvent(Event evt) {
            assert (evt != null);
            final DiscoveryEvent e = (DiscoveryEvent)evt;
            assert (e.type() == 11 || e.type() == 12) : this;
            final GridChangeGlobalStateFuture f2 = (GridChangeGlobalStateFuture)GridClusterStateProcessor.this.stateChangeFut.get();
            if (f2 != null) {
                f2.initFut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> fut) {
                        f2.onNodeLeft(e);
                    }
                });
            }
        }
    };

    public GridClusterStateProcessor(GridKernalContext ctx) {
        super(ctx);
        ctx.internalSubscriptionProcessor().registerMetastorageListener(this);
    }

    public boolean compatibilityMode() {
        return this.compatibilityMode;
    }

    @Override
    public boolean publicApiActiveState(boolean waitForTransition) {
        if (this.ctx.isDaemon()) {
            return this.sendComputeCheckGlobalState();
        }
        DiscoveryDataClusterState globalState = this.globalState;
        assert (globalState != null);
        if (globalState.transition() && globalState.active()) {
            Boolean transitionRes = globalState.transitionResult();
            if (transitionRes != null) {
                return transitionRes;
            }
            if (waitForTransition) {
                GridFutureAdapter fut = (GridFutureAdapter)this.transitionFuts.get(globalState.transitionRequestId());
                if (fut != null) {
                    try {
                        fut.get();
                    }
                    catch (IgniteCheckedException ex) {
                        throw new IgniteException(ex);
                    }
                }
                transitionRes = globalState.transitionResult();
                assert (transitionRes != null);
                return transitionRes;
            }
            return globalState.baselineChanged();
        }
        return globalState.active();
    }

    @Override
    public void onReadyForRead(ReadOnlyMetastorage metastorage) throws IgniteCheckedException {
        BaselineTopology blt = (BaselineTopology)metastorage.read(METASTORE_CURR_BLT_KEY);
        if (blt != null) {
            if (this.log.isInfoEnabled()) {
                U.log(this.log, "Restoring history for BaselineTopology[id=" + blt.id() + "]");
            }
            this.bltHist.restoreHistory(metastorage, blt.id());
        }
        this.onStateRestored(blt);
    }

    @Override
    public void onReadyForReadWrite(ReadWriteMetastorage metastorage) throws IgniteCheckedException {
        this.metastorage = metastorage;
        if (this.compatibilityMode) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BaselineTopology won't be stored as this node is running in compatibility mode");
            }
            return;
        }
        this.writeBaselineTopology(this.globalState.baselineTopology(), null);
        this.bltHist.flushHistoryItems(metastorage);
    }

    public void resetBranchingHistory(long newBranchingHash) throws IgniteCheckedException {
        if (!this.compatibilityMode()) {
            this.globalState.baselineTopology().resetBranchingHistory(newBranchingHash);
            this.writeBaselineTopology(this.globalState.baselineTopology(), null);
            U.log(this.log, String.format("Branching history of current BaselineTopology is reset to the value %d", newBranchingHash));
        }
    }

    private void writeBaselineTopology(BaselineTopology blt, BaselineTopologyHistoryItem prevBltHistItem) throws IgniteCheckedException {
        assert (this.metastorage != null);
        if (this.inMemoryMode) {
            return;
        }
        this.sharedCtx.database().checkpointReadLock();
        try {
            if (blt != null) {
                if (this.log.isInfoEnabled()) {
                    U.log(this.log, "Writing BaselineTopology[id=" + blt.id() + "]");
                    if (prevBltHistItem != null) {
                        U.log(this.log, "Writing BaselineTopologyHistoryItem[id=" + prevBltHistItem.id() + "]");
                    }
                }
                this.bltHist.writeHistoryItem(this.metastorage, prevBltHistItem);
                this.metastorage.write(METASTORE_CURR_BLT_KEY, blt);
            } else {
                if (this.log.isInfoEnabled()) {
                    U.log(this.log, "Removing BaselineTopology and history");
                }
                this.metastorage.remove(METASTORE_CURR_BLT_KEY);
                this.bltHist.removeHistory(this.metastorage);
            }
        }
        finally {
            this.sharedCtx.database().checkpointReadUnlock();
        }
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.inMemoryMode = !CU.isPersistenceEnabled(this.ctx.config());
        boolean activeOnStart = this.inMemoryMode && this.ctx.config().isActiveOnStart();
        this.globalState = DiscoveryDataClusterState.createState(activeOnStart, null);
        this.ctx.event().addLocalEventListener(this.lsr, 11, 12);
    }

    @Override
    public void onKernalStop(boolean cancel) {
        GridChangeGlobalStateFuture fut = this.stateChangeFut.get();
        if (fut != null) {
            fut.onDone(new IgniteCheckedException("Failed to wait for cluster state change, node is stopping."));
        }
        super.onKernalStop(cancel);
    }

    @Override
    @Nullable
    public IgniteInternalFuture<Boolean> onLocalJoin(DiscoCache discoCache) {
        DiscoveryDataClusterState state = this.globalState;
        if (state.active()) {
            this.checkLocalNodeInBaseline(state.baselineTopology());
        }
        if (state.transition()) {
            this.joinFut = new TransitionOnJoinWaitFuture(state, discoCache);
            return this.joinFut;
        }
        if (!this.ctx.clientNode() && !this.ctx.isDaemon() && this.ctx.config().isAutoActivationEnabled() && !state.active() && this.isBaselineSatisfied(state.baselineTopology(), discoCache.serverNodes())) {
            this.changeGlobalState0(true, state.baselineTopology(), false);
        }
        return null;
    }

    private void checkLocalNodeInBaseline(BaselineTopology blt) {
        if (blt == null || blt.consistentIds() == null || this.ctx.clientNode() || this.ctx.isDaemon()) {
            return;
        }
        if (!CU.isPersistenceEnabled(this.ctx.config())) {
            return;
        }
        if (!blt.consistentIds().contains(this.ctx.discovery().localNode().consistentId())) {
            U.quietAndInfo(this.log, "Local node is not included in Baseline Topology and will not be used for persistent data storage. Use control.(sh|bat) script or IgniteCluster interface to include the node to Baseline Topology.");
        }
    }

    private boolean isBaselineSatisfied(BaselineTopology blt, List<ClusterNode> serverNodes) {
        if (blt == null) {
            return false;
        }
        if (blt.consistentIds() == null) {
            return false;
        }
        return blt.consistentIds().contains(this.ctx.discovery().localNode().consistentId()) && blt.isSatisfied(serverNodes);
    }

    @Override
    @Nullable
    public ChangeGlobalStateFinishMessage onNodeLeft(ClusterNode node) {
        Set<UUID> nodes2;
        if (this.globalState.transition() && (nodes2 = this.globalState.transitionNodes()).remove(node.id()) && nodes2.isEmpty()) {
            U.warn(this.log, "Failed to change cluster state, all participating nodes failed. Switching to inactive state.");
            ChangeGlobalStateFinishMessage msg = new ChangeGlobalStateFinishMessage(this.globalState.transitionRequestId(), false, false);
            this.onStateFinishMessage(msg);
            return msg;
        }
        return null;
    }

    @Override
    public void onStateFinishMessage(ChangeGlobalStateFinishMessage msg) {
        DiscoveryDataClusterState state = this.globalState;
        if (msg.requestId().equals(state.transitionRequestId())) {
            GridFutureAdapter transitionFut;
            this.log.info("Received state change finish message: " + msg.clusterActive());
            this.globalState = this.globalState.finish(msg.success());
            this.afterStateChangeFinished(msg.id(), msg.success());
            this.ctx.cache().onStateChangeFinish(msg);
            TransitionOnJoinWaitFuture joinFut = this.joinFut;
            if (joinFut != null) {
                joinFut.onDone(false);
            }
            if ((transitionFut = (GridFutureAdapter)this.transitionFuts.remove(state.transitionRequestId())) != null) {
                state.setTransitionResult(msg.requestId(), msg.clusterActive());
                transitionFut.onDone();
            }
        } else {
            U.warn(this.log, "Received state finish message with unexpected ID: " + msg);
        }
    }

    protected void afterStateChangeFinished(IgniteUuid msgId, boolean success2) {
    }

    @Override
    public boolean onStateChangeMessage(AffinityTopologyVersion topVer, ChangeGlobalStateMessage msg, DiscoCache discoCache) {
        DiscoveryDataClusterState state = this.globalState;
        if (this.log.isInfoEnabled()) {
            U.log(this.log, "Received " + GridClusterStateProcessor.prettyStr(msg.activate()) + " request with BaselineTopology" + (msg.baselineTopology() == null ? ": null" : "[id=" + msg.baselineTopology().id() + "]"));
        }
        if (msg.baselineTopology() != null) {
            this.compatibilityMode = false;
        }
        if (state.transition()) {
            if (this.isApplicable(msg, state)) {
                GridChangeGlobalStateFuture fut = this.changeStateFuture(msg);
                if (fut != null) {
                    fut.onDone(this.concurrentStateChangeError(msg.activate()));
                }
            } else {
                final GridChangeGlobalStateFuture stateFut = this.changeStateFuture(msg);
                GridFutureAdapter transitionFut = (GridFutureAdapter)this.transitionFuts.get(state.transitionRequestId());
                if (stateFut != null && transitionFut != null) {
                    transitionFut.listen(new IgniteInClosure<IgniteInternalFuture<Void>>(){

                        @Override
                        public void apply(IgniteInternalFuture<Void> fut) {
                            try {
                                fut.get();
                                stateFut.onDone();
                            }
                            catch (Exception ex) {
                                stateFut.onDone(ex);
                            }
                        }
                    });
                }
            }
        } else {
            if (this.isApplicable(msg, state)) {
                ExchangeActions exchangeActions;
                try {
                    exchangeActions = this.ctx.cache().onStateChangeRequest(msg, topVer, state);
                }
                catch (IgniteCheckedException e) {
                    GridChangeGlobalStateFuture fut = this.changeStateFuture(msg);
                    if (fut != null) {
                        fut.onDone(e);
                    }
                    return false;
                }
                HashSet<UUID> nodeIds = U.newHashSet(discoCache.allNodes().size());
                for (ClusterNode node : discoCache.allNodes()) {
                    nodeIds.add(node.id());
                }
                GridChangeGlobalStateFuture fut = this.changeStateFuture(msg);
                if (fut != null) {
                    fut.setRemaining(nodeIds, topVer.nextMinorVersion());
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info("Started state transition: " + msg.activate());
                }
                BaselineTopologyHistoryItem bltHistItem = BaselineTopologyHistoryItem.fromBaseline(this.globalState.baselineTopology());
                this.transitionFuts.put(msg.requestId(), new GridFutureAdapter());
                DiscoveryDataClusterState prevState = this.globalState;
                this.globalState = DiscoveryDataClusterState.createTransitionState(prevState, msg.activate(), msg.activate() ? msg.baselineTopology() : prevState.baselineTopology(), msg.requestId(), topVer, nodeIds);
                if (msg.forceChangeBaselineTopology()) {
                    this.globalState.setTransitionResult(msg.requestId(), msg.activate());
                }
                AffinityTopologyVersion stateChangeTopVer = topVer.nextMinorVersion();
                StateChangeRequest req = new StateChangeRequest(msg, bltHistItem, msg.activate() != state.active(), stateChangeTopVer);
                exchangeActions.stateChangeRequest(req);
                msg.exchangeActions(exchangeActions);
                return true;
            }
            GridChangeGlobalStateFuture stateFut = this.changeStateFuture(msg);
            if (stateFut != null) {
                stateFut.onDone();
            }
        }
        return false;
    }

    protected boolean isApplicable(ChangeGlobalStateMessage msg, DiscoveryDataClusterState state) {
        return !GridClusterStateProcessor.isEquivalent(msg, state);
    }

    protected static boolean isEquivalent(ChangeGlobalStateMessage msg, DiscoveryDataClusterState state) {
        return msg.activate() == state.active() && BaselineTopology.equals(msg.baselineTopology(), state.baselineTopology());
    }

    @Override
    public DiscoveryDataClusterState clusterState() {
        return this.globalState;
    }

    @Override
    public DiscoveryDataClusterState pendingState(ChangeGlobalStateMessage stateMsg) {
        return DiscoveryDataClusterState.createState(stateMsg.activate() || stateMsg.forceChangeBaselineTopology(), stateMsg.baselineTopology());
    }

    @Nullable
    private GridChangeGlobalStateFuture changeStateFuture(ChangeGlobalStateMessage msg) {
        return this.changeStateFuture(msg.initiatorNodeId(), msg.requestId());
    }

    @Nullable
    private GridChangeGlobalStateFuture changeStateFuture(UUID initiatorNode, UUID reqId) {
        GridChangeGlobalStateFuture fut;
        assert (initiatorNode != null);
        assert (reqId != null);
        if (initiatorNode.equals(this.ctx.localNodeId()) && (fut = this.stateChangeFut.get()) != null && fut.requestId.equals(reqId)) {
            return fut;
        }
        return null;
    }

    protected IgniteCheckedException concurrentStateChangeError(boolean activate) {
        return new IgniteCheckedException("Failed to " + GridClusterStateProcessor.prettyStr(activate) + ", because another state change operation is currently in progress: " + GridClusterStateProcessor.prettyStr(!activate));
    }

    @Override
    public void cacheProcessorStarted() {
        this.cacheProc = this.ctx.cache();
        this.sharedCtx = this.cacheProc.context();
        this.sharedCtx.io().addCacheHandler(0, GridChangeGlobalStateMessageResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridChangeGlobalStateMessageResponse>(){

            @Override
            public void apply(UUID nodeId, GridChangeGlobalStateMessageResponse msg) {
                GridClusterStateProcessor.this.processChangeGlobalStateResponse(nodeId, msg);
            }
        });
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        super.stop(cancel);
        if (this.sharedCtx != null) {
            this.sharedCtx.io().removeHandler(false, 0, GridChangeGlobalStateMessageResponse.class);
        }
        this.ctx.event().removeLocalEventListener(this.lsr, 11, 12);
        IgniteCheckedException stopErr = new IgniteCheckedException("Node is stopping: " + this.ctx.igniteInstanceName());
        GridChangeGlobalStateFuture f2 = this.stateChangeFut.get();
        if (f2 != null) {
            f2.onDone(stopErr);
        }
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.STATE_PROC;
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        try {
            byte[] marshalledState = this.marsh.marshal(this.globalState);
            dataBag.addJoiningNodeData(this.discoveryDataType().ordinal(), (Serializable)marshalledState);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        DiscoveryDataBag.JoiningNodeDiscoveryData joiningNodeData = dataBag.newJoinerDiscoveryData(GridComponent.DiscoveryDataExchangeType.STATE_PROC.ordinal());
        if (joiningNodeData != null && !joiningNodeData.hasJoiningNodeData()) {
            this.compatibilityMode = true;
        }
        if (dataBag.commonDataCollectedFor(GridComponent.DiscoveryDataExchangeType.STATE_PROC.ordinal()) || joiningNodeData == null) {
            return;
        }
        if (!joiningNodeData.hasJoiningNodeData() || this.compatibilityMode) {
            dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.STATE_PROC.ordinal(), this.globalState);
            return;
        }
        DiscoveryDataClusterState joiningNodeState = null;
        try {
            if (joiningNodeData.joiningNodeData() != null) {
                joiningNodeState = (DiscoveryDataClusterState)this.marsh.unmarshal((byte[])joiningNodeData.joiningNodeData(), U.resolveClassLoader(this.ctx.config()));
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to unmarshal disco data from joining node: " + joiningNodeData.joiningNodeId());
            return;
        }
        BaselineTopologyHistory historyToSend = null;
        if (!this.bltHist.isEmpty()) {
            if (joiningNodeState != null && joiningNodeState.baselineTopology() != null) {
                int lastId = joiningNodeState.baselineTopology().id();
                historyToSend = this.bltHist.tailFrom(lastId);
            } else {
                historyToSend = this.bltHist;
            }
        }
        dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.STATE_PROC.ordinal(), new BaselineStateAndHistoryData(this.globalState, historyToSend));
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        if (data.commonData() instanceof DiscoveryDataClusterState) {
            if (this.globalState != null && this.globalState.baselineTopology() != null) {
                throw new IgniteException("Node with BaselineTopology cannot join mixed cluster running in compatibility mode");
            }
            this.globalState = (DiscoveryDataClusterState)data.commonData();
            this.compatibilityMode = true;
            return;
        }
        BaselineStateAndHistoryData stateDiscoData = (BaselineStateAndHistoryData)data.commonData();
        if (stateDiscoData != null) {
            DiscoveryDataClusterState state = stateDiscoData.globalState;
            if (state.transition()) {
                this.transitionFuts.put(state.transitionRequestId(), new GridFutureAdapter());
            }
            this.globalState = state;
            if (stateDiscoData.recentHistory != null) {
                for (BaselineTopologyHistoryItem item : stateDiscoData.recentHistory.history()) {
                    this.bltHist.bufferHistoryItemForStore(item);
                }
            }
        }
    }

    @Override
    public IgniteInternalFuture<?> changeGlobalState(boolean activate, Collection<? extends BaselineNode> baselineNodes, boolean forceChangeBaselineTopology) {
        if (this.inMemoryMode) {
            return this.changeGlobalState0(activate, null, false);
        }
        BaselineTopology newBlt = this.compatibilityMode && !forceChangeBaselineTopology ? null : this.calculateNewBaselineTopology(activate, baselineNodes, forceChangeBaselineTopology);
        return this.changeGlobalState0(activate, newBlt, forceChangeBaselineTopology);
    }

    private BaselineTopology calculateNewBaselineTopology(boolean activate, Collection<? extends BaselineNode> baselineNodes, boolean forceChangeBaselineTopology) {
        BaselineTopology newBlt;
        BaselineTopology currentBlt = this.globalState.baselineTopology();
        int newBltId = 0;
        if (currentBlt != null) {
            int n = newBltId = activate ? currentBlt.id() + 1 : currentBlt.id();
        }
        if (baselineNodes != null && !baselineNodes.isEmpty()) {
            ArrayList<? extends BaselineNode> baselineNodes0 = new ArrayList<BaselineNode>();
            for (BaselineNode baselineNode : baselineNodes) {
                if (baselineNode instanceof ClusterNode) {
                    ClusterNode clusterNode = (ClusterNode)baselineNode;
                    if (clusterNode.isClient() || clusterNode.isDaemon()) continue;
                    baselineNodes0.add(baselineNode);
                    continue;
                }
                baselineNodes0.add(baselineNode);
            }
            baselineNodes = baselineNodes0;
        }
        if (forceChangeBaselineTopology) {
            newBlt = BaselineTopology.build(baselineNodes, newBltId);
        } else if (activate) {
            if (baselineNodes == null) {
                baselineNodes = this.baselineNodes();
            }
            if (currentBlt == null) {
                newBlt = BaselineTopology.build(baselineNodes, newBltId);
            } else {
                newBlt = currentBlt;
                newBlt.updateHistory(baselineNodes);
            }
        } else {
            newBlt = null;
        }
        return newBlt;
    }

    private Collection<BaselineNode> baselineNodes() {
        List<ClusterNode> clNodes = this.ctx.discovery().serverNodes(AffinityTopologyVersion.NONE);
        ArrayList<BaselineNode> bltNodes = new ArrayList<BaselineNode>(clNodes.size());
        for (ClusterNode clNode : clNodes) {
            bltNodes.add(clNode);
        }
        return bltNodes;
    }

    private IgniteInternalFuture<?> changeGlobalState0(boolean activate, BaselineTopology blt, boolean forceChangeBaselineTopology) {
        if (this.ctx.isDaemon() || this.ctx.clientNode()) {
            GridFutureAdapter<Void> fut = new GridFutureAdapter<Void>();
            this.sendComputeChangeGlobalState(activate, blt, forceChangeBaselineTopology, fut);
            return fut;
        }
        if (this.cacheProc.transactions().tx() != null || this.sharedCtx.lockedTopologyVersion(null) != null) {
            return new GridFinishedFuture(new IgniteCheckedException("Failed to " + GridClusterStateProcessor.prettyStr(activate) + " cluster (must invoke the method outside of an active transaction)."));
        }
        DiscoveryDataClusterState curState = this.globalState;
        if (!curState.transition() && curState.active() == activate && BaselineTopology.equals(curState.baselineTopology(), blt)) {
            return new GridFinishedFuture();
        }
        GridChangeGlobalStateFuture startedFut = null;
        GridChangeGlobalStateFuture fut = this.stateChangeFut.get();
        while (fut == null || fut.isDone()) {
            fut = new GridChangeGlobalStateFuture(UUID.randomUUID(), activate, this.ctx);
            if (this.stateChangeFut.compareAndSet(null, fut)) {
                startedFut = fut;
                break;
            }
            fut = this.stateChangeFut.get();
        }
        if (startedFut == null) {
            if (fut.activate != activate) {
                return new GridFinishedFuture(new IgniteCheckedException("Failed to " + GridClusterStateProcessor.prettyStr(activate) + ", because another state change operation is currently in progress: " + GridClusterStateProcessor.prettyStr(fut.activate)));
            }
            return fut;
        }
        ArrayList<StoredCacheData> storedCfgs = null;
        if (activate && CU.isPersistenceEnabled(this.ctx.config())) {
            try {
                Map<String, StoredCacheData> cfgs = this.ctx.cache().context().pageStore().readCacheConfigurations();
                if (!F.isEmpty(cfgs)) {
                    storedCfgs = new ArrayList<StoredCacheData>(cfgs.values());
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to read stored cache configurations: " + e, e);
                startedFut.onDone(e);
                return startedFut;
            }
        }
        ChangeGlobalStateMessage msg = new ChangeGlobalStateMessage(startedFut.requestId, this.ctx.localNodeId(), storedCfgs, activate, blt, forceChangeBaselineTopology, System.currentTimeMillis());
        try {
            if (this.log.isInfoEnabled()) {
                U.log(this.log, "Sending " + GridClusterStateProcessor.prettyStr(activate) + " request with BaselineTopology " + blt);
            }
            this.ctx.discovery().sendCustomEvent(msg);
            if (this.ctx.isStopping()) {
                startedFut.onDone(new IgniteCheckedException("Failed to execute " + GridClusterStateProcessor.prettyStr(activate) + " request, node is stopping."));
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send global state change request: " + activate, e);
            startedFut.onDone(e);
        }
        return this.wrapStateChangeFuture(startedFut, msg);
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData discoData) {
        DiscoveryDataClusterState joiningNodeState;
        if (node.isClient() || node.isDaemon()) {
            return null;
        }
        if (discoData.joiningNodeData() == null) {
            if (this.globalState.baselineTopology() != null) {
                String msg = "Node not supporting BaselineTopology is not allowed to join the cluster with BaselineTopology";
                return new IgniteNodeValidationResult(node.id(), msg, msg);
            }
            return null;
        }
        try {
            joiningNodeState = (DiscoveryDataClusterState)this.marsh.unmarshal((byte[])discoData.joiningNodeData(), Thread.currentThread().getContextClassLoader());
        }
        catch (IgniteCheckedException e) {
            String msg = "Error on unmarshalling discovery data from node " + node.consistentId() + ": " + e.getMessage() + "; node is not allowed to join";
            return new IgniteNodeValidationResult(node.id(), msg, msg);
        }
        if (joiningNodeState == null || joiningNodeState.baselineTopology() == null) {
            return null;
        }
        if ((this.globalState == null || this.globalState.baselineTopology() == null) && joiningNodeState != null && joiningNodeState.baselineTopology() != null) {
            String msg = "Node with set up BaselineTopology is not allowed to join cluster without one: " + node.consistentId();
            return new IgniteNodeValidationResult(node.id(), msg, msg);
        }
        if (this.globalState.transition() && this.globalState.previousBaselineTopology() == null) {
            String msg = "Node with set up BaselineTopology is not allowed to join cluster in the process of first activation: " + node.consistentId();
            return new IgniteNodeValidationResult(node.id(), msg, msg);
        }
        BaselineTopology clusterBlt = this.globalState.transition() ? this.globalState.previousBaselineTopology() : this.globalState.baselineTopology();
        BaselineTopology joiningNodeBlt = joiningNodeState.baselineTopology();
        String recommendation = " Consider cleaning persistent storage of the node and adding it to the cluster again.";
        if (joiningNodeBlt.id() > clusterBlt.id()) {
            String msg = "BaselineTopology of joining node (" + node.consistentId() + ") is not compatible with BaselineTopology in the cluster. Joining node BlT id (" + joiningNodeBlt.id() + ") is greater than cluster BlT id (" + clusterBlt.id() + "). New BaselineTopology was set on joining node with set-baseline command." + recommendation;
            return new IgniteNodeValidationResult(node.id(), msg, msg);
        }
        if (joiningNodeBlt.id() == clusterBlt.id()) {
            if (!clusterBlt.isCompatibleWith(joiningNodeBlt)) {
                String msg = "BaselineTopology of joining node (" + node.consistentId() + ") is not compatible with BaselineTopology in the cluster. Branching history of cluster BlT (" + clusterBlt.branchingHistory() + ") doesn't contain branching point hash of joining node BlT (" + joiningNodeBlt.branchingPointHash() + ")." + recommendation;
                return new IgniteNodeValidationResult(node.id(), msg, msg);
            }
        } else if (joiningNodeBlt.id() < clusterBlt.id() && !this.bltHist.isCompatibleWith(joiningNodeBlt)) {
            String msg = "BaselineTopology of joining node (" + node.consistentId() + ") is not compatible with BaselineTopology in the cluster. BlT id of joining node (" + joiningNodeBlt.id() + ") less than BlT id of cluster (" + clusterBlt.id() + ") but cluster's BaselineHistory doesn't contain branching point hash of joining node BlT (" + joiningNodeBlt.branchingPointHash() + ")." + recommendation;
            return new IgniteNodeValidationResult(node.id(), msg, msg);
        }
        return null;
    }

    protected IgniteInternalFuture<?> wrapStateChangeFuture(IgniteInternalFuture fut, ChangeGlobalStateMessage msg) {
        return fut;
    }

    private void sendComputeChangeGlobalState(boolean activate, BaselineTopology blt, boolean forceBlt, final GridFutureAdapter<Void> resFut) {
        AffinityTopologyVersion topVer = this.ctx.discovery().topologyVersionEx();
        if (this.log.isInfoEnabled()) {
            this.log.info("Sending " + GridClusterStateProcessor.prettyStr(activate) + " request from node [id=" + this.ctx.localNodeId() + ", topVer=" + topVer + ", client=" + this.ctx.clientNode() + ", daemon=" + this.ctx.isDaemon() + "]");
        }
        IgniteCompute comp = ((ClusterGroupAdapter)this.ctx.cluster().get().forServers()).compute();
        IgniteFuture<Void> fut = comp.runAsync(new ClientChangeGlobalStateComputeRequest(activate, blt, forceBlt));
        fut.listen((IgniteInClosure<IgniteFuture<Void>>)new CI1<IgniteFuture>(){

            @Override
            public void apply(IgniteFuture fut) {
                try {
                    fut.get();
                    resFut.onDone();
                }
                catch (Exception e) {
                    resFut.onDone(e);
                }
            }
        });
    }

    private boolean sendComputeCheckGlobalState() {
        ClusterGroupAdapter clusterGroupAdapter;
        AffinityTopologyVersion topVer = this.ctx.discovery().topologyVersionEx();
        if (this.log.isInfoEnabled()) {
            this.log.info("Sending check cluster state request from node [id=" + this.ctx.localNodeId() + ", topVer=" + topVer + ", client=" + this.ctx.clientNode() + ", daemon" + this.ctx.isDaemon() + "]");
        }
        if (F.isEmpty((clusterGroupAdapter = (ClusterGroupAdapter)this.ctx.cluster().get().forServers()).nodes())) {
            return false;
        }
        IgniteCompute comp = clusterGroupAdapter.compute();
        return comp.call(new IgniteCallable<Boolean>(){
            @IgniteInstanceResource
            private Ignite ig;

            @Override
            public Boolean call() throws Exception {
                return this.ig.active();
            }
        });
    }

    @Override
    public void onStateChangeError(Map<UUID, Exception> errs, StateChangeRequest req) {
        GridChangeGlobalStateFuture fut;
        assert (!F.isEmpty(errs));
        if (req.activeChanged() && req.activate()) {
            try {
                this.cacheProc.onKernalStopCaches(true);
                this.cacheProc.stopCaches(true);
                this.sharedCtx.affinity().clearGroupHoldersAndRegistry();
                if (!this.ctx.clientNode()) {
                    this.sharedCtx.deactivate();
                }
            }
            catch (Exception e) {
                U.error(this.log, "Failed to revert activation request changes", e);
            }
        }
        if ((fut = this.changeStateFuture(req.initiatorNodeId(), req.requestId())) != null) {
            IgniteCheckedException e = new IgniteCheckedException("Failed to " + GridClusterStateProcessor.prettyStr(req.activate()) + " cluster", null, false);
            for (Map.Entry<UUID, Exception> entry2 : errs.entrySet()) {
                e.addSuppressed(entry2.getValue());
            }
            fut.onDone(e);
        }
    }

    private void onFinalActivate(final StateChangeRequest req) {
        this.ctx.dataStructures().onBeforeActivate();
        this.checkLocalNodeInBaseline(this.globalState.baselineTopology());
        this.ctx.closure().runLocalSafe(new Runnable(){

            @Override
            public void run() {
                boolean client = GridClusterStateProcessor.this.ctx.clientNode();
                Object e = null;
                try {
                    GridClusterStateProcessor.this.ctx.service().onUtilityCacheStarted();
                    GridClusterStateProcessor.this.ctx.service().onActivate(GridClusterStateProcessor.this.ctx);
                    GridClusterStateProcessor.this.ctx.dataStructures().onActivate(GridClusterStateProcessor.this.ctx);
                    GridClusterStateProcessor.this.ctx.igfs().onActivate(GridClusterStateProcessor.this.ctx);
                    GridClusterStateProcessor.this.ctx.task().onActivate(GridClusterStateProcessor.this.ctx);
                    GridClusterStateProcessor.this.ctx.encryption().onActivate(GridClusterStateProcessor.this.ctx);
                    if (GridClusterStateProcessor.this.log.isInfoEnabled()) {
                        GridClusterStateProcessor.this.log.info("Successfully performed final activation steps [nodeId=" + GridClusterStateProcessor.this.ctx.localNodeId() + ", client=" + client + ", topVer=" + req.topologyVersion() + "]");
                    }
                }
                catch (Exception ex) {
                    throw new IgniteException(ex);
                }
            }
        });
    }

    @Override
    public void onStateChangeExchangeDone(StateChangeRequest req) {
        try {
            if (req.activeChanged()) {
                if (req.activate()) {
                    this.onFinalActivate(req);
                }
                this.globalState.setTransitionResult(req.requestId(), req.activate());
            }
            this.sendChangeGlobalStateResponse(req.requestId(), req.initiatorNodeId(), null);
        }
        catch (Exception ex) {
            IgniteCheckedException e = new IgniteCheckedException("Failed to perform final activation steps", ex);
            U.error(this.log, "Failed to perform final activation steps [nodeId=" + this.ctx.localNodeId() + ", client=" + this.ctx.clientNode() + ", topVer=" + req.topologyVersion() + "]", ex);
            this.sendChangeGlobalStateResponse(req.requestId(), req.initiatorNodeId(), e);
        }
    }

    @Override
    public void onBaselineTopologyChanged(BaselineTopology blt, BaselineTopologyHistoryItem prevBltHistItem) throws IgniteCheckedException {
        if (this.compatibilityMode) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BaselineTopology won't be stored as this node is running in compatibility mode");
            }
            return;
        }
        this.writeBaselineTopology(blt, prevBltHistItem);
    }

    private void sendChangeGlobalStateResponse(UUID reqId, UUID initNodeId, Exception ex) {
        assert (reqId != null);
        assert (initNodeId != null);
        GridChangeGlobalStateMessageResponse res = new GridChangeGlobalStateMessageResponse(reqId, ex);
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending global state change response [nodeId=" + this.ctx.localNodeId() + ", topVer=" + this.ctx.discovery().topologyVersionEx() + ", res=" + res + "]");
            }
            if (this.ctx.localNodeId().equals(initNodeId)) {
                this.processChangeGlobalStateResponse(this.ctx.localNodeId(), res);
            } else {
                this.sharedCtx.io().send(initNodeId, (GridCacheMessage)res, (byte)2);
            }
        }
        catch (ClusterTopologyCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send change global state response, node left [node=" + initNodeId + ", res=" + res + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to send change global state response [node=" + initNodeId + ", res=" + res + ']', e);
        }
    }

    private void processChangeGlobalStateResponse(final UUID nodeId, final GridChangeGlobalStateMessageResponse msg) {
        assert (nodeId != null);
        assert (msg != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received activation response [requestId=" + msg.getRequestId() + ", nodeId=" + nodeId + "]");
        }
        UUID requestId = msg.getRequestId();
        final GridChangeGlobalStateFuture fut = this.stateChangeFut.get();
        if (fut != null && requestId.equals(fut.requestId)) {
            if (fut.initFut.isDone()) {
                fut.onResponse(nodeId, msg);
            } else {
                fut.initFut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> f2) {
                        GridClusterStateProcessor.this.ctx.getSystemExecutorService().execute(new Runnable(){

                            @Override
                            public void run() {
                                fut.onResponse(nodeId, msg);
                            }
                        });
                    }
                });
            }
        }
    }

    private void onStateRestored(BaselineTopology blt) {
        DiscoveryDataClusterState state = this.globalState;
        if (!state.active() && !state.transition() && state.baselineTopology() == null) {
            DiscoveryDataClusterState newState;
            this.globalState = newState = DiscoveryDataClusterState.createState(false, blt);
        }
    }

    @Override
    public void onExchangeFinishedOnCoordinator(IgniteInternalFuture exchangeFuture, boolean hasMovingPartitions) {
    }

    @Override
    public boolean evictionsAllowed() {
        return true;
    }

    private static String prettyStr(boolean activate) {
        return activate ? "activate" : "deactivate";
    }

    @Override
    public String toString() {
        return S.toString(GridClusterStateProcessor.class, this);
    }

    private static class BaselineStateAndHistoryData
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final DiscoveryDataClusterState globalState;
        private final BaselineTopologyHistory recentHistory;

        BaselineStateAndHistoryData(DiscoveryDataClusterState globalState, BaselineTopologyHistory recentHistory) {
            this.globalState = globalState;
            this.recentHistory = recentHistory;
        }
    }

    class TransitionOnJoinWaitFuture
    extends GridFutureAdapter<Boolean> {
        private DiscoveryDataClusterState transitionState;
        private final Set<UUID> transitionNodes;

        TransitionOnJoinWaitFuture(DiscoveryDataClusterState state, DiscoCache discoCache) {
            assert (state.transition()) : state;
            this.transitionNodes = U.newHashSet(state.transitionNodes().size());
            for (UUID nodeId : state.transitionNodes()) {
                if (discoCache.node(nodeId) == null) continue;
                this.transitionNodes.add(nodeId);
            }
        }

        @Override
        public boolean onDone(@Nullable Boolean res, @Nullable Throwable err2) {
            if (super.onDone(res, err2)) {
                GridClusterStateProcessor.this.joinFut = null;
                return true;
            }
            return false;
        }
    }

    private static class CheckGlobalStateComputeRequest
    implements IgniteCallable<Boolean> {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private Ignite ig;

        private CheckGlobalStateComputeRequest() {
        }

        @Override
        public Boolean call() throws Exception {
            return this.ig.active();
        }
    }

    @GridInternal
    private static class ClientChangeGlobalStateComputeRequest
    implements IgniteRunnable {
        private static final long serialVersionUID = 0L;
        private final boolean activate;
        private final BaselineTopology baselineTopology;
        private final boolean forceChangeBaselineTopology;
        @IgniteInstanceResource
        private IgniteEx ig;

        private ClientChangeGlobalStateComputeRequest(boolean activate, BaselineTopology blt, boolean forceBlt) {
            this.activate = activate;
            this.baselineTopology = blt;
            this.forceChangeBaselineTopology = forceBlt;
        }

        @Override
        public void run() {
            try {
                this.ig.context().state().changeGlobalState(this.activate, this.baselineTopology != null ? this.baselineTopology.currentBaseline() : null, this.forceChangeBaselineTopology).get();
            }
            catch (IgniteCheckedException ex) {
                throw new IgniteException(ex);
            }
        }
    }

    private class GridChangeGlobalStateFuture
    extends GridFutureAdapter<Void> {
        @GridToStringInclude
        private final UUID requestId;
        private final boolean activate;
        @GridToStringInclude
        private final Set<UUID> remaining = new HashSet<UUID>();
        @GridToStringInclude
        private final Map<UUID, GridChangeGlobalStateMessageResponse> responses = new HashMap<UUID, GridChangeGlobalStateMessageResponse>();
        @GridToStringExclude
        private final GridKernalContext ctx;
        @GridToStringExclude
        private final Object mux = new Object();
        @GridToStringInclude
        private final GridFutureAdapter<?> initFut = new GridFutureAdapter();
        @GridToStringExclude
        private final IgniteLogger log;

        GridChangeGlobalStateFuture(UUID requestId, boolean activate, GridKernalContext ctx) {
            this.requestId = requestId;
            this.activate = activate;
            this.ctx = ctx;
            this.log = ctx.log(this.getClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onNodeLeft(DiscoveryEvent event) {
            assert (event != null);
            if (this.isDone()) {
                return;
            }
            boolean allReceived = false;
            Object object = this.mux;
            synchronized (object) {
                if (this.remaining.remove(event.eventNode().id())) {
                    allReceived = this.remaining.isEmpty();
                }
            }
            if (allReceived) {
                this.onAllReceived();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setRemaining(Set<UUID> nodesIds, AffinityTopologyVersion topVer) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Setup remaining node [id=" + this.ctx.localNodeId() + ", client=" + this.ctx.clientNode() + ", topVer=" + topVer + ", nodes=" + nodesIds + "]");
            }
            Object object = this.mux;
            synchronized (object) {
                this.remaining.addAll(nodesIds);
            }
            this.initFut.onDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(UUID nodeId, GridChangeGlobalStateMessageResponse msg) {
            assert (msg != null);
            if (this.isDone()) {
                return;
            }
            boolean allReceived = false;
            Object object = this.mux;
            synchronized (object) {
                if (this.remaining.remove(nodeId)) {
                    allReceived = this.remaining.isEmpty();
                }
                this.responses.put(nodeId, msg);
            }
            if (allReceived) {
                this.onAllReceived();
            }
        }

        private void onAllReceived() {
            IgniteCheckedException e = new IgniteCheckedException();
            boolean fail2 = false;
            for (Map.Entry<UUID, GridChangeGlobalStateMessageResponse> entry2 : this.responses.entrySet()) {
                GridChangeGlobalStateMessageResponse r = entry2.getValue();
                if (r.getError() == null) continue;
                fail2 = true;
                e.addSuppressed(r.getError());
            }
            if (fail2) {
                this.onDone(e);
            } else {
                this.onDone();
            }
        }

        @Override
        public boolean onDone(@Nullable Void res, @Nullable Throwable err2) {
            if (super.onDone(res, err2)) {
                GridClusterStateProcessor.this.stateChangeFut.compareAndSet(this, null);
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return S.toString(GridChangeGlobalStateFuture.class, this);
        }
    }
}

