/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecord;
import org.apache.ignite.internal.processors.cache.verify.PartitionKey;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

@GridInternal
@Deprecated
public class VerifyBackupPartitionsTask
extends ComputeTaskAdapter<Set<String>, Map<PartitionKey, List<PartitionHashRecord>>> {
    private static final long serialVersionUID = 0L;
    @LoggerResource
    private IgniteLogger log;

    @Override
    @Nullable
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, Set<String> cacheNames) throws IgniteException {
        HashMap<VerifyBackupPartitionsJob, ClusterNode> jobs = new HashMap<VerifyBackupPartitionsJob, ClusterNode>();
        for (ClusterNode node : subgrid) {
            jobs.put(new VerifyBackupPartitionsJob(cacheNames), node);
        }
        return jobs;
    }

    @Override
    @Nullable
    public Map<PartitionKey, List<PartitionHashRecord>> reduce(List<ComputeJobResult> results) throws IgniteException {
        HashMap clusterHashes = new HashMap();
        for (ComputeJobResult res : results) {
            Map nodeHashes = (Map)res.getData();
            for (Map.Entry e : nodeHashes.entrySet()) {
                if (!clusterHashes.containsKey(e.getKey())) {
                    clusterHashes.put(e.getKey(), new ArrayList());
                }
                ((List)clusterHashes.get(e.getKey())).add(e.getValue());
            }
        }
        HashMap<PartitionKey, List<PartitionHashRecord>> hashConflicts = new HashMap<PartitionKey, List<PartitionHashRecord>>();
        HashMap updateCntrConflicts = new HashMap();
        block2: for (Map.Entry e : clusterHashes.entrySet()) {
            Integer partHash = null;
            Long updateCntr = null;
            for (PartitionHashRecord record2 : (List)e.getValue()) {
                if (partHash == null) {
                    partHash = record2.partitionHash();
                    updateCntr = record2.updateCounter();
                    continue;
                }
                if (record2.updateCounter() != updateCntr.longValue()) {
                    updateCntrConflicts.put(e.getKey(), e.getValue());
                    continue block2;
                }
                if (record2.partitionHash() == partHash.intValue()) continue;
                hashConflicts.put((PartitionKey)e.getKey(), (List<PartitionHashRecord>)e.getValue());
                continue block2;
            }
        }
        return updateCntrConflicts.isEmpty() ? hashConflicts : updateCntrConflicts;
    }

    @Override
    public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
        ComputeJobResultPolicy superRes = super.result(res, rcvd);
        if (superRes == ComputeJobResultPolicy.FAILOVER) {
            superRes = ComputeJobResultPolicy.WAIT;
            this.log.warning("VerifyBackupPartitionsJob failed on node [consistentId=" + res.getNode().consistentId() + "]", res.getException());
        }
        return superRes;
    }

    @Deprecated
    private static class VerifyBackupPartitionsJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        private IgniteEx ignite;
        @LoggerResource
        private IgniteLogger log;
        private Set<String> cacheNames;
        private final AtomicInteger completionCntr = new AtomicInteger(0);

        public VerifyBackupPartitionsJob(Set<String> names) {
            this.cacheNames = names;
        }

        @Override
        public Map<PartitionKey, PartitionHashRecord> execute() throws IgniteException {
            HashSet<Integer> grpIds = new HashSet<Integer>();
            HashSet<String> missingCaches = new HashSet<String>();
            if (this.cacheNames != null) {
                for (String string2 : this.cacheNames) {
                    DynamicCacheDescriptor dynamicCacheDescriptor = this.ignite.context().cache().cacheDescriptor(string2);
                    if (dynamicCacheDescriptor == null) {
                        missingCaches.add(string2);
                        continue;
                    }
                    grpIds.add(dynamicCacheDescriptor.groupId());
                }
                if (!missingCaches.isEmpty()) {
                    StringBuilder strBuilder = new StringBuilder("The following caches do not exist: ");
                    for (String string3 : missingCaches) {
                        strBuilder.append(string3).append(", ");
                    }
                    strBuilder.delete(strBuilder.length() - 2, strBuilder.length());
                    throw new IgniteException(strBuilder.toString());
                }
            } else {
                Collection<CacheGroupContext> groups = this.ignite.context().cache().cacheGroups();
                for (CacheGroupContext cacheGroupContext : groups) {
                    if (cacheGroupContext.systemCache() || cacheGroupContext.isLocal()) continue;
                    grpIds.add(cacheGroupContext.groupId());
                }
            }
            ArrayList<Future<Map<PartitionKey, PartitionHashRecord>>> partHashCalcFutures = new ArrayList<Future<Map<PartitionKey, PartitionHashRecord>>>();
            this.completionCntr.set(0);
            for (Integer n : grpIds) {
                CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(n);
                if (grpCtx == null) continue;
                List<GridDhtLocalPartition> parts = grpCtx.topology().localPartitions();
                for (GridDhtLocalPartition part : parts) {
                    partHashCalcFutures.add(this.calculatePartitionHashAsync(grpCtx, part));
                }
            }
            HashMap<PartitionKey, PartitionHashRecord> hashMap = new HashMap<PartitionKey, PartitionHashRecord>();
            long l = U.currentTimeMillis();
            int i = 0;
            while (i < partHashCalcFutures.size()) {
                Future fut = (Future)partHashCalcFutures.get(i);
                try {
                    Map partHash = (Map)fut.get(100L, TimeUnit.MILLISECONDS);
                    hashMap.putAll(partHash);
                    ++i;
                }
                catch (InterruptedException | ExecutionException e) {
                    for (int j = i + 1; j < partHashCalcFutures.size(); ++j) {
                        ((Future)partHashCalcFutures.get(j)).cancel(false);
                    }
                    if (e instanceof InterruptedException) {
                        throw new IgniteInterruptedException((InterruptedException)e);
                    }
                    if (e.getCause() instanceof IgniteException) {
                        throw (IgniteException)e.getCause();
                    }
                    throw new IgniteException(e.getCause());
                }
                catch (TimeoutException ignored) {
                    if (U.currentTimeMillis() - l <= 180000L) continue;
                    l = U.currentTimeMillis();
                    this.log.warning("idle_verify is still running, processed " + this.completionCntr.get() + " of " + partHashCalcFutures.size() + " local partitions");
                }
            }
            return hashMap;
        }

        private Future<Map<PartitionKey, PartitionHashRecord>> calculatePartitionHashAsync(final CacheGroupContext grpCtx, final GridDhtLocalPartition part) {
            return ForkJoinPool.commonPool().submit(new Callable<Map<PartitionKey, PartitionHashRecord>>(){

                @Override
                public Map<PartitionKey, PartitionHashRecord> call() throws Exception {
                    return this.calculatePartitionHash(grpCtx, part);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<PartitionKey, PartitionHashRecord> calculatePartitionHash(CacheGroupContext grpCtx, GridDhtLocalPartition part) {
            long partSize;
            long updateCntrBefore;
            if (!part.reserve()) {
                return Collections.emptyMap();
            }
            int partHash = 0;
            try {
                if (part.state() != GridDhtPartitionState.OWNING) {
                    Map<PartitionKey, PartitionHashRecord> map2 = Collections.emptyMap();
                    return map2;
                }
                updateCntrBefore = part.updateCounter();
                partSize = part.dataStore().fullSize();
                GridIterator<CacheDataRow> it = grpCtx.offheap().partitionIterator(part.id());
                while (it.hasNextX()) {
                    CacheDataRow row = it.nextX();
                    partHash += row.key().hashCode();
                    partHash += Arrays.hashCode(row.value().valueBytes(grpCtx.cacheObjectContext()));
                }
                long updateCntrAfter = part.updateCounter();
                if (updateCntrBefore != updateCntrAfter) {
                    throw new IgniteException("Cluster is not idle: update counter of partition [grpId=" + grpCtx.groupId() + ", partId=" + part.id() + "] changed during hash calculation [before=" + updateCntrBefore + ", after=" + updateCntrAfter + "]");
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Can't calculate partition hash [grpId=" + grpCtx.groupId() + ", partId=" + part.id() + "]", e);
                Map<PartitionKey, PartitionHashRecord> updateCntrAfter = Collections.emptyMap();
                return updateCntrAfter;
            }
            finally {
                part.release();
            }
            Object consId = this.ignite.context().discovery().localNode().consistentId();
            boolean isPrimary = part.primary(grpCtx.topology().readyTopologyVersion());
            PartitionKey partKey = new PartitionKey(grpCtx.groupId(), part.id(), grpCtx.cacheOrGroupName());
            PartitionHashRecord partRec = new PartitionHashRecord(partKey, isPrimary, consId, partHash, updateCntrBefore, partSize);
            this.completionCntr.incrementAndGet();
            return Collections.singletonMap(partKey, partRec);
        }
    }
}

