/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.mvcc.search;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.tree.RowLinkIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccTreeClosure;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class MvccFirstRowTreeClosure
implements MvccTreeClosure {
    private final GridCacheContext cctx;
    private CacheDataRow res;

    public MvccFirstRowTreeClosure(GridCacheContext cctx) {
        this.cctx = cctx;
    }

    @Nullable
    public CacheDataRow row() {
        return this.res;
    }

    @Override
    public boolean apply(BPlusTree<CacheSearchRow, CacheDataRow> tree2, BPlusIO<CacheSearchRow> io, long pageAddr, int idx) throws IgniteCheckedException {
        RowLinkIO rowIo = (RowLinkIO)((Object)io);
        MvccVersion newVersion = MvccUtils.getNewVersion(this.cctx, rowIo.getLink(pageAddr, idx));
        if (newVersion == null) {
            this.res = tree2.getRow(io, pageAddr, idx, (Object)CacheDataRowAdapter.RowData.NO_KEY);
        }
        return false;
    }

    public String toString() {
        return S.toString(MvccFirstRowTreeClosure.class, this);
    }
}

