/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.mvcc.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.tree.RowLinkIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.ResultType;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccLinkAwareSearchRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class MvccUpdateDataRowNative
extends MvccDataRow
implements BPlusTree.TreeRowClosure<CacheSearchRow, CacheDataRow> {
    private final MvccSnapshot mvccSnapshot;
    private ResultType res;
    private boolean canCleanup;
    private GridLongList activeTxs;
    private List<MvccLinkAwareSearchRow> cleanupRows;
    private CacheDataRow oldRow;

    public MvccUpdateDataRowNative(KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, MvccSnapshot mvccSnapshot, MvccVersion newVer, int part, GridCacheContext cctx) {
        super(key, val, ver, part, expireTime, cctx.cacheId(), mvccSnapshot, newVer);
        this.mvccSnapshot = mvccSnapshot;
    }

    @Override
    public boolean apply(BPlusTree<CacheSearchRow, CacheDataRow> tree2, BPlusIO<CacheSearchRow> io, long pageAddr, int idx) throws IgniteCheckedException {
        RowLinkIO rowIo = (RowLinkIO)((Object)io);
        assert (this.assertVersion(rowIo, pageAddr, idx));
        boolean checkActive = this.mvccSnapshot.activeTransactions().size() > 0;
        boolean txActive = false;
        long rowCrdVer = rowIo.getMvccCoordinatorVersion(pageAddr, idx);
        long crdVer = this.mvccCoordinatorVersion();
        boolean isFirstRmvd = false;
        if (this.res == null) {
            int cmp = Long.compare(crdVer, rowCrdVer);
            if (cmp == 0) {
                cmp = Long.compare(this.mvccSnapshot.counter(), rowIo.getMvccCounter(pageAddr, idx));
            }
            if (cmp == 0) {
                this.res = ResultType.VERSION_FOUND;
            } else {
                this.oldRow = tree2.getRow(io, pageAddr, idx, (Object)CacheDataRowAdapter.RowData.LINK_WITH_HEADER);
                isFirstRmvd = this.oldRow.newMvccCoordinatorVersion() != 0L;
                this.res = isFirstRmvd ? ResultType.PREV_NULL : ResultType.PREV_NOT_NULL;
            }
        }
        if (checkActive && crdVer == rowCrdVer) {
            long activeTx;
            long rowMvccCntr = rowIo.getMvccCounter(pageAddr, idx);
            long l = activeTx = isFirstRmvd ? this.oldRow.newMvccCounter() : rowMvccCntr;
            if (this.mvccSnapshot.activeTransactions().contains(activeTx)) {
                txActive = true;
                if (this.activeTxs == null) {
                    this.activeTxs = new GridLongList();
                }
                this.activeTxs.add(activeTx);
            }
        }
        if (!txActive) {
            assert (Long.compare(crdVer, rowCrdVer) >= 0);
            long rowCntr = rowIo.getMvccCounter(pageAddr, idx);
            int cmp = crdVer == rowCrdVer ? Long.compare(this.mvccSnapshot.cleanupVersion(), rowCntr) : 1;
            if (cmp >= 0) {
                if (this.canCleanup) {
                    assert (MvccUtils.mvccVersionIsValid(rowCrdVer, rowCntr));
                    assert (rowCrdVer != crdVer || !this.mvccSnapshot.activeTransactions().contains(rowCntr));
                    if (this.cleanupRows == null) {
                        this.cleanupRows = new ArrayList<MvccLinkAwareSearchRow>();
                    }
                    this.cleanupRows.add(new MvccLinkAwareSearchRow(this.cacheId, this.key, rowCrdVer, rowCntr, rowIo.getMvccOperationCounter(pageAddr, idx), rowIo.getLink(pageAddr, idx)));
                } else {
                    this.canCleanup = true;
                }
            }
        }
        return true;
    }

    @Override
    public int mvccOperationCounter() {
        return 1;
    }

    public CacheDataRow oldRow() {
        return this.oldRow;
    }

    public ResultType resultType() {
        return this.res == null ? ResultType.PREV_NULL : this.res;
    }

    @Nullable
    public GridLongList activeTransactions() {
        return this.activeTxs;
    }

    public List<MvccLinkAwareSearchRow> cleanupRows() {
        return this.cleanupRows;
    }

    private boolean assertVersion(RowLinkIO io, long pageAddr, int idx) {
        long rowCrdVer = io.getMvccCoordinatorVersion(pageAddr, idx);
        long rowCntr = io.getMvccCounter(pageAddr, idx);
        int cmp = Long.compare(this.mvccCoordinatorVersion(), rowCrdVer);
        if (cmp == 0) {
            cmp = Long.compare(this.mvccSnapshot.counter(), rowCntr);
        }
        assert (cmp >= 0) : "[updCrd=" + this.mvccCoordinatorVersion() + ", updCntr=" + this.mvccSnapshot.counter() + ", rowCrd=" + rowCrdVer + ", rowCntr=" + rowCntr + ']';
        return true;
    }

    @Override
    public String toString() {
        return S.toString(MvccUpdateDataRowNative.class, this, "super", super.toString());
    }
}

