/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheCompoundIdentityFuture;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.PartitionUpdateCountersMessage;
import org.apache.ignite.internal.processors.cache.mvcc.msg.PartitionCountersNeighborcastRequest;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class PartitionCountersNeighborcastFuture
extends GridCacheCompoundIdentityFuture<Void> {
    private final IgniteUuid futId = IgniteUuid.randomUuid();
    private boolean trackable = true;
    private final GridCacheSharedContext<?, ?> cctx;
    private final IgniteInternalTx tx;
    private final IgniteLogger log;

    public PartitionCountersNeighborcastFuture(IgniteInternalTx tx, GridCacheSharedContext<?, ?> cctx) {
        super(null);
        this.tx = tx;
        this.cctx = cctx;
        this.log = cctx.logger("org.apache.ignite.cache.msg.tx.recovery");
    }

    public void init() {
        if (this.log.isInfoEnabled()) {
            this.log.info("Starting delivery partition countres to remote nodes [txId=" + this.tx.nearXidVersion() + ", futId=" + this.futId);
        }
        HashSet<UUID> siblings = this.siblingBackups();
        this.cctx.mvcc().addFuture(this, this.futId);
        for (UUID peer : siblings) {
            List<PartitionUpdateCountersMessage> cntrs = this.cctx.tm().txHandler().filterUpdateCountersForBackupNode(this.tx, this.cctx.node(peer));
            if (F.isEmpty(cntrs)) continue;
            MiniFuture miniFut = new MiniFuture(peer);
            try {
                this.cctx.io().send(peer, (GridCacheMessage)new PartitionCountersNeighborcastRequest(cntrs, this.futId), (byte)2);
                this.add(miniFut);
            }
            catch (IgniteCheckedException e) {
                if (!(e instanceof ClusterTopologyCheckedException)) {
                    this.log.warning("Failed to send partition counters to remote node [node=" + peer + ']', e);
                } else {
                    this.logNodeLeft(peer);
                }
                miniFut.onDone();
            }
        }
        this.markInitialized();
    }

    private HashSet<UUID> siblingBackups() {
        Map<UUID, Collection<UUID>> txNodes = this.tx.transactionNodes();
        assert (txNodes != null);
        UUID locNodeId = this.cctx.localNodeId();
        HashSet<UUID> siblings = new HashSet<UUID>();
        txNodes.values().stream().filter(backups -> backups.contains(locNodeId)).forEach(siblings::addAll);
        siblings.remove(locNodeId);
        return siblings;
    }

    @Override
    public boolean onDone(@Nullable Void res, @Nullable Throwable err2) {
        boolean comp = super.onDone(res, err2);
        if (comp) {
            this.cctx.mvcc().removeFuture(this.futId);
        }
        return comp;
    }

    public void onResult(UUID nodeId) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Remote peer acked partition counters delivery [futId=" + this.futId + ", node=" + nodeId + ']');
        }
        this.completeMini(nodeId);
    }

    @Override
    public boolean onNodeLeft(UUID nodeId) {
        this.logNodeLeft(nodeId);
        this.completeMini(nodeId);
        return true;
    }

    private void completeMini(UUID nodeId) {
        for (IgniteInternalFuture fut : this.futures()) {
            assert (fut instanceof MiniFuture);
            MiniFuture mini = (MiniFuture)fut;
            if (!mini.nodeId.equals(nodeId)) continue;
            this.cctx.kernalContext().closure().runLocalSafe(mini::onDone);
            break;
        }
    }

    private void logNodeLeft(UUID nodeId) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Failed during partition counters delivery to remote node. Node left cluster (will ignore) [futId=" + this.futId + ", node=" + nodeId + ']');
        }
    }

    @Override
    public IgniteUuid futureId() {
        return this.futId;
    }

    @Override
    public boolean trackable() {
        return this.trackable;
    }

    @Override
    public void markNotTrackable() {
        this.trackable = false;
    }

    private static class MiniFuture
    extends GridFutureAdapter<Void> {
        private final UUID nodeId;

        private MiniFuture(UUID nodeId) {
            this.nodeId = nodeId;
        }
    }
}

