/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.cache.CacheStoppedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalStateAdapter;
import org.apache.ignite.internal.util.GridIntList;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class IgniteTxImplicitSingleStateImpl
extends IgniteTxLocalStateAdapter {
    private GridCacheContext cacheCtx;
    private List<IgniteTxEntry> entry;
    private boolean init;
    private boolean recovery;

    @Override
    public void addActiveCache(GridCacheContext ctx, boolean recovery, IgniteTxAdapter tx) throws IgniteCheckedException {
        assert (this.cacheCtx == null) : "Cache already set [cur=" + this.cacheCtx.name() + ", new=" + ctx.name() + ']';
        assert (tx.local());
        this.cacheCtx = ctx;
        this.recovery = recovery;
        tx.activeCachesDeploymentEnabled(this.cacheCtx.deploymentEnabled());
    }

    @Override
    @Nullable
    public GridIntList cacheIds() {
        return GridIntList.asList(this.cacheCtx.cacheId());
    }

    @Override
    @Nullable
    public GridCacheContext singleCacheContext(GridCacheSharedContext cctx) {
        return this.cacheCtx;
    }

    @Override
    @Nullable
    public Integer firstCacheId() {
        return this.cacheCtx != null ? Integer.valueOf(this.cacheCtx.cacheId()) : null;
    }

    @Override
    public void unwindEvicts(GridCacheSharedContext cctx) {
        if (this.entry == null || this.entry.isEmpty()) {
            return;
        }
        assert (this.entry.size() == 1);
        GridCacheContext ctx = cctx.cacheContext(this.entry.get(0).cacheId());
        if (ctx != null) {
            CU.unwindEvicts(ctx);
        }
    }

    @Override
    public void awaitLastFuture(GridCacheSharedContext ctx) {
        if (this.cacheCtx == null) {
            return;
        }
        this.cacheCtx.cache().awaitLastFut();
    }

    @Override
    public boolean implicitSingle() {
        return true;
    }

    @Override
    public IgniteCheckedException validateTopology(GridCacheSharedContext cctx, boolean read, GridDhtTopologyFuture topFut) {
        if (this.cacheCtx == null) {
            return null;
        }
        Throwable err2 = topFut.validateCache(this.cacheCtx, this.recovery, read, null, this.entry);
        if (err2 != null) {
            return new IgniteCheckedException("Failed to perform cache operation (cache topology is not valid): " + U.maskName(this.cacheCtx.name()), err2);
        }
        if (CU.affinityNodes(this.cacheCtx, topFut.topologyVersion()).isEmpty()) {
            return new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid): " + this.cacheCtx.name());
        }
        return null;
    }

    @Override
    public CacheWriteSynchronizationMode syncMode(GridCacheSharedContext cctx) {
        return this.cacheCtx != null ? this.cacheCtx.config().getWriteSynchronizationMode() : CacheWriteSynchronizationMode.FULL_ASYNC;
    }

    @Override
    public GridDhtTopologyFuture topologyReadLock(GridCacheSharedContext cctx, GridFutureAdapter<?> fut) {
        if (this.cacheCtx == null || this.cacheCtx.isLocal()) {
            return cctx.exchange().lastTopologyFuture();
        }
        this.cacheCtx.topology().readLock();
        if (this.cacheCtx.topology().stopping()) {
            fut.onDone(new CacheStoppedException(this.cacheCtx.name()));
            return null;
        }
        return this.cacheCtx.topology().topologyVersionFuture();
    }

    @Override
    public void topologyReadUnlock(GridCacheSharedContext cctx) {
        if (this.cacheCtx == null || this.cacheCtx.isLocal()) {
            return;
        }
        this.cacheCtx.topology().readUnlock();
    }

    @Override
    public boolean storeWriteThrough(GridCacheSharedContext cctx) {
        if (this.cacheCtx == null) {
            return false;
        }
        CacheStoreManager store = this.cacheCtx.store();
        return store.configured() && store.isWriteThrough();
    }

    @Override
    public boolean hasInterceptor(GridCacheSharedContext cctx) {
        GridCacheContext ctx0 = this.cacheCtx;
        return ctx0 != null && ctx0.config().getInterceptor() != null;
    }

    @Override
    public Collection<CacheStoreManager> stores(GridCacheSharedContext cctx) {
        if (this.cacheCtx == null) {
            return null;
        }
        CacheStoreManager store = this.cacheCtx.store();
        if (store.configured()) {
            return Collections.singleton(store);
        }
        return null;
    }

    @Override
    public void onTxEnd(GridCacheSharedContext cctx, IgniteInternalTx tx, boolean commit2) {
        if (this.cacheCtx != null) {
            this.onTxEnd(this.cacheCtx, tx, commit2);
        }
    }

    @Override
    public IgniteTxEntry entry(IgniteTxKey key) {
        if (this.entry != null && this.entry.get(0).txKey().equals(key)) {
            return this.entry.get(0);
        }
        return null;
    }

    @Override
    public boolean hasWriteKey(IgniteTxKey key) {
        return this.entry != null && this.entry.get(0).txKey().equals(key);
    }

    @Override
    public Set<IgniteTxKey> readSet() {
        return Collections.emptySet();
    }

    @Override
    public Set<IgniteTxKey> writeSet() {
        if (this.entry != null) {
            HashSet<IgniteTxKey> set = new HashSet<IgniteTxKey>(3, 0.75f);
            set.add(this.entry.get(0).txKey());
            return set;
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<IgniteTxEntry> writeEntries() {
        return this.entry != null ? this.entry : Collections.emptyList();
    }

    @Override
    public Collection<IgniteTxEntry> readEntries() {
        return Collections.emptyList();
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> writeMap() {
        return this.entry != null ? F.asMap(this.entry.get(0).txKey(), this.entry.get(0)) : Collections.emptyMap();
    }

    @Override
    public Map<IgniteTxKey, IgniteTxEntry> readMap() {
        return Collections.emptyMap();
    }

    @Override
    public boolean empty() {
        return this.entry == null;
    }

    @Override
    public Collection<IgniteTxEntry> allEntries() {
        return this.entry != null ? this.entry : Collections.emptyList();
    }

    @Override
    public boolean init(int txSize) {
        if (!this.init) {
            this.init = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean initialized() {
        return this.init;
    }

    @Override
    public void addEntry(IgniteTxEntry entry2) {
        assert (this.entry == null) : "Entry already set [cur=" + this.entry + ", new=" + entry2 + ']';
        this.entry = Collections.singletonList(entry2);
    }

    @Override
    public void seal() {
    }

    @Override
    public IgniteTxEntry singleWrite() {
        return this.entry != null ? this.entry.get(0) : null;
    }

    @Override
    public boolean mvccEnabled() {
        GridCacheContext ctx0 = this.cacheCtx;
        return ctx0 != null && ctx0.mvccEnabled();
    }

    public String toString() {
        return S.toString(IgniteTxImplicitSingleStateImpl.class, this);
    }
}

