/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryInfoCollection;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheAffinityManager;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheReturnCompletableWrapper;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheUpdateTxResult;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheTxRecoveryFuture;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheTxRecoveryRequest;
import org.apache.ignite.internal.processors.cache.distributed.GridCacheTxRecoveryResponse;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxRemoteAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxOnePhaseCommitAckRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTxRemote;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridInvokeValue;
import org.apache.ignite.internal.processors.cache.distributed.dht.PartitionUpdateCountersMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxFinishResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareFutureAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareRequest;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxPrepareResponse;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxRemote;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.msg.PartitionCountersNeighborcastRequest;
import org.apache.ignite.internal.processors.cache.mvcc.msg.PartitionCountersNeighborcastResponse;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteEx;
import org.apache.ignite.internal.processors.cache.transactions.PartitionCountersNeighborcastFuture;
import org.apache.ignite.internal.processors.cache.transactions.TxCounters;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.transactions.IgniteTxHeuristicCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxOptimisticCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxRollbackCheckedException;
import org.apache.ignite.internal.transactions.IgniteTxTimeoutCheckedException;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class IgniteTxHandler {
    private IgniteLogger log;
    private final IgniteLogger txPrepareMsgLog;
    private final IgniteLogger txFinishMsgLog;
    private final IgniteLogger txRecoveryMsgLog;
    private GridCacheSharedContext<?, ?> ctx;

    private void processNearTxPrepareRequest(UUID nearNodeId, GridNearTxPrepareRequest req) {
        ClusterNode nearNode;
        if (this.txPrepareMsgLog.isDebugEnabled()) {
            this.txPrepareMsgLog.debug("Received near prepare request [txId=" + req.version() + ", node=" + nearNodeId + ']');
        }
        if ((nearNode = this.ctx.node(nearNodeId)) == null) {
            if (this.txPrepareMsgLog.isDebugEnabled()) {
                this.txPrepareMsgLog.debug("Received near prepare from node that left grid (will ignore) [txId=" + req.version() + ", node=" + nearNodeId + ']');
            }
            return;
        }
        this.processNearTxPrepareRequest0(nearNode, req);
    }

    private void processNearTxPrepareRequest0(ClusterNode nearNode, GridNearTxPrepareRequest req) {
        IgniteInternalFuture<GridNearTxPrepareResponse> fut;
        if (req.firstClientRequest() && req.allowWaitTopologyFuture()) {
            do {
                if (!this.waitForExchangeFuture(nearNode, req)) continue;
                return;
            } while ((fut = this.prepareNearTx(nearNode, req)) == null);
        } else {
            fut = this.prepareNearTx(nearNode, req);
        }
        assert (req.txState() != null || fut == null || fut.error() != null || this.ctx.tm().tx(req.version()) == null && this.ctx.tm().nearTx(req.version()) == null);
    }

    public IgniteTxHandler(GridCacheSharedContext ctx) {
        this.ctx = ctx;
        this.log = ctx.logger(IgniteTxHandler.class);
        this.txRecoveryMsgLog = ctx.logger("org.apache.ignite.cache.msg.tx.recovery");
        this.txPrepareMsgLog = ctx.logger("org.apache.ignite.cache.msg.tx.prepare");
        this.txFinishMsgLog = ctx.logger("org.apache.ignite.cache.msg.tx.finish");
        ctx.io().addCacheHandler(0, GridNearTxPrepareRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processNearTxPrepareRequest(nodeId, (GridNearTxPrepareRequest)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridNearTxPrepareResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processNearTxPrepareResponse(nodeId, (GridNearTxPrepareResponse)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridNearTxFinishRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processNearTxFinishRequest(nodeId, (GridNearTxFinishRequest)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridNearTxFinishResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processNearTxFinishResponse(nodeId, (GridNearTxFinishResponse)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridDhtTxPrepareRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxPrepareRequest(nodeId, (GridDhtTxPrepareRequest)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridDhtTxPrepareResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxPrepareResponse(nodeId, (GridDhtTxPrepareResponse)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridDhtTxFinishRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxFinishRequest(nodeId, (GridDhtTxFinishRequest)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridDhtTxOnePhaseCommitAckRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxOnePhaseCommitAckRequest(nodeId, (GridDhtTxOnePhaseCommitAckRequest)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridDhtTxFinishResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheMessage>(){

            @Override
            public void apply(UUID nodeId, GridCacheMessage msg) {
                IgniteTxHandler.this.processDhtTxFinishResponse(nodeId, (GridDhtTxFinishResponse)msg);
            }
        });
        ctx.io().addCacheHandler(0, GridCacheTxRecoveryRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheTxRecoveryRequest>(){

            @Override
            public void apply(UUID nodeId, GridCacheTxRecoveryRequest req) {
                IgniteTxHandler.this.processCheckPreparedTxRequest(nodeId, req);
            }
        });
        ctx.io().addCacheHandler(0, GridCacheTxRecoveryResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, GridCacheTxRecoveryResponse>(){

            @Override
            public void apply(UUID nodeId, GridCacheTxRecoveryResponse res) {
                IgniteTxHandler.this.processCheckPreparedTxResponse(nodeId, res);
            }
        });
        ctx.io().addCacheHandler(0, PartitionCountersNeighborcastRequest.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, PartitionCountersNeighborcastRequest>(){

            @Override
            public void apply(UUID nodeId, PartitionCountersNeighborcastRequest req) {
                IgniteTxHandler.this.processPartitionCountersRequest(nodeId, req);
            }
        });
        ctx.io().addCacheHandler(0, PartitionCountersNeighborcastResponse.class, (IgniteBiInClosure<UUID, ? extends GridCacheMessage>)new CI2<UUID, PartitionCountersNeighborcastResponse>(){

            @Override
            public void apply(UUID nodeId, PartitionCountersNeighborcastResponse res) {
                IgniteTxHandler.this.processPartitionCountersResponse(nodeId, res);
            }
        });
    }

    public IgniteInternalFuture<GridNearTxPrepareResponse> prepareColocatedTx(final GridNearTxLocal locTx, final GridNearTxPrepareRequest req) {
        req.txState(locTx.txState());
        IgniteInternalFuture<GridNearTxPrepareResponse> fut = locTx.prepareAsyncLocal(req);
        return fut.chain(new C1<IgniteInternalFuture<GridNearTxPrepareResponse>, GridNearTxPrepareResponse>(){

            @Override
            public GridNearTxPrepareResponse apply(IgniteInternalFuture<GridNearTxPrepareResponse> f2) {
                try {
                    return f2.get();
                }
                catch (Exception e) {
                    locTx.setRollbackOnly();
                    if (!X.hasCause(e, IgniteTxOptimisticCheckedException.class) && !X.hasCause(e, IgniteFutureCancelledException.class)) {
                        U.error(IgniteTxHandler.this.log, "Failed to prepare DHT transaction: " + locTx, e);
                    }
                    return new GridNearTxPrepareResponse(req.partition(), req.version(), req.futureId(), req.miniId(), req.version(), req.version(), null, e, null, req.onePhaseCommit(), req.deployInfo() != null);
                }
            }
        });
    }

    private IgniteTxEntry unmarshal(@Nullable Collection<IgniteTxEntry> entries) throws IgniteCheckedException {
        if (entries == null) {
            return null;
        }
        IgniteTxEntry firstEntry = null;
        for (IgniteTxEntry e : entries) {
            e.unmarshal(this.ctx, false, this.ctx.deploy().globalLoader());
            if (firstEntry != null) continue;
            firstEntry = e;
        }
        return firstEntry;
    }

    public IgniteInternalFuture<GridNearTxPrepareResponse> prepareNearTxLocal(GridNearTxPrepareRequest req) {
        req.cloneEntries();
        return this.prepareNearTx(this.ctx.localNode(), req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private IgniteInternalFuture<GridNearTxPrepareResponse> prepareNearTx(ClusterNode nearNode, GridNearTxPrepareRequest req) {
        IgniteTxEntry firstEntry;
        try {
            IgniteTxEntry firstWrite = this.unmarshal(req.writes());
            IgniteTxEntry firstRead = this.unmarshal(req.reads());
            firstEntry = firstWrite != null ? firstWrite : firstRead;
        }
        catch (IgniteCheckedException e) {
            return new GridFinishedFuture<GridNearTxPrepareResponse>(e);
        }
        GridDhtTxLocal tx = null;
        GridCacheVersion mappedVer = this.ctx.tm().mappedVersion(req.version());
        if (mappedVer != null) {
            tx = (GridDhtTxLocal)this.ctx.tm().tx(mappedVer);
            if (tx == null) {
                U.warn(this.log, "Missing local transaction for mapped near version [nearVer=" + req.version() + ", mappedVer=" + mappedVer + ']');
            } else if (req.concurrency() == TransactionConcurrency.PESSIMISTIC) {
                tx.nearFutureId(req.futureId());
            }
        } else {
            GridDhtPartitionTopology top = null;
            if (req.firstClientRequest()) {
                GridDhtTopologyFuture topFut;
                assert (firstEntry != null) : req;
                assert (req.concurrency() == TransactionConcurrency.OPTIMISTIC) : req;
                assert (nearNode.isClient()) : nearNode;
                top = firstEntry.context().topology();
                top.readLock();
                if (req.allowWaitTopologyFuture() && !(topFut = top.topologyVersionFuture()).isDone()) {
                    top.readUnlock();
                    return null;
                }
            }
            try {
                if (top != null) {
                    boolean retry = false;
                    GridDhtTopologyFuture topFut = top.topologyVersionFuture();
                    if (!req.allowWaitTopologyFuture() && !topFut.isDone()) {
                        retry = true;
                        if (this.txPrepareMsgLog.isDebugEnabled()) {
                            this.txPrepareMsgLog.debug("Topology change is in progress, need remap transaction [txId=" + req.version() + ", node=" + nearNode.id() + ", reqTopVer=" + req.topologyVersion() + ", locTopVer=" + top.readyTopologyVersion() + ", req=" + req + ']');
                        }
                    }
                    if (!retry && this.needRemap(req.topologyVersion(), top.readyTopologyVersion(), req)) {
                        retry = true;
                        if (this.txPrepareMsgLog.isDebugEnabled()) {
                            this.txPrepareMsgLog.debug("Topology version mismatch for near prepare, need remap transaction [txId=" + req.version() + ", node=" + nearNode.id() + ", reqTopVer=" + req.topologyVersion() + ", locTopVer=" + top.readyTopologyVersion() + ", req=" + req + ']');
                        }
                    }
                    if (retry) {
                        GridNearTxPrepareResponse res = new GridNearTxPrepareResponse(req.partition(), req.version(), req.futureId(), req.miniId(), req.version(), req.version(), null, null, top.lastTopologyChangeVersion(), req.onePhaseCommit(), req.deployInfo() != null);
                        try {
                            this.ctx.io().send(nearNode, (GridCacheMessage)res, req.policy());
                            if (this.txPrepareMsgLog.isDebugEnabled()) {
                                this.txPrepareMsgLog.debug("Sent remap response for near prepare [txId=" + req.version() + ", node=" + nearNode.id() + ']');
                            }
                        }
                        catch (ClusterTopologyCheckedException ignored) {
                            if (this.txPrepareMsgLog.isDebugEnabled()) {
                                this.txPrepareMsgLog.debug("Failed to send remap response for near prepare, node failed [txId=" + req.version() + ", node=" + nearNode.id() + ']');
                            }
                        }
                        catch (IgniteCheckedException e) {
                            U.error(this.txPrepareMsgLog, "Failed to send remap response for near prepare [txId=" + req.version() + ", node=" + nearNode.id() + ", req=" + req + ']', e);
                        }
                        GridFinishedFuture<GridNearTxPrepareResponse> gridFinishedFuture = new GridFinishedFuture<GridNearTxPrepareResponse>(res);
                        return gridFinishedFuture;
                    }
                    assert (topFut.isDone());
                }
                tx = new GridDhtTxLocal(this.ctx, req.topologyVersion(), nearNode.id(), req.version(), req.futureId(), req.miniId(), req.threadId(), req.implicitSingle(), req.implicitSingle(), req.system(), req.explicitLock(), req.policy(), req.concurrency(), req.isolation(), req.timeout(), req.isInvalidate(), true, req.onePhaseCommit(), req.txSize(), req.transactionNodes(), req.subjectId(), req.taskNameHash());
                tx = this.ctx.tm().onCreated(null, tx);
                if (tx != null) {
                    tx.topologyVersion(req.topologyVersion());
                } else {
                    U.warn(this.log, "Failed to create local transaction (was transaction rolled back?) [xid=" + req.version() + ", req=" + req + ']');
                }
            }
            finally {
                if (tx != null) {
                    req.txState(tx.txState());
                }
                if (top != null) {
                    top.readUnlock();
                }
            }
        }
        if (tx != null) {
            req.txState(tx.txState());
            if (req.explicitLock()) {
                tx.explicitLock(true);
            }
            tx.transactionNodes(req.transactionNodes());
            if (req.near()) {
                tx.nearOnOriginatingNode(true);
            }
            if (req.onePhaseCommit()) {
                assert (req.last()) : req;
                tx.onePhaseCommit(true);
            }
            if (req.needReturnValue()) {
                tx.needReturnValue(true);
            }
            IgniteInternalFuture<GridNearTxPrepareResponse> fut = tx.prepareAsync(req);
            if (tx.isRollbackOnly() && !tx.commitOnPrepare() && tx.state() != TransactionState.ROLLED_BACK && tx.state() != TransactionState.ROLLING_BACK) {
                tx.rollbackDhtLocalAsync();
            }
            final GridDhtTxLocal tx0 = tx;
            fut.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> txFut) {
                    block2: {
                        try {
                            txFut.get();
                        }
                        catch (IgniteCheckedException e) {
                            tx0.setRollbackOnly();
                            if (X.hasCause(e, IgniteTxOptimisticCheckedException.class) || X.hasCause(e, IgniteFutureCancelledException.class) || IgniteTxHandler.this.ctx.kernalContext().isStopping()) break block2;
                            U.error(IgniteTxHandler.this.log, "Failed to prepare DHT transaction: " + tx0, e);
                        }
                    }
                }
            });
            return fut;
        }
        return new GridFinishedFuture<GridNearTxPrepareResponse>((GridNearTxPrepareResponse)null);
    }

    private boolean waitForExchangeFuture(ClusterNode node, GridNearTxPrepareRequest req) {
        assert (req.firstClientRequest()) : req;
        GridDhtPartitionsExchangeFuture topFut = this.ctx.exchange().lastTopologyFuture();
        if (!topFut.isDone()) {
            IgniteThread thread;
            Thread curThread = Thread.currentThread();
            if (curThread instanceof IgniteThread && (thread = (IgniteThread)curThread).cachePoolThread()) {
                this.ctx.time().waitAsync(topFut, req.timeout(), (e, timedOut) -> {
                    if (e != null || timedOut.booleanValue()) {
                        this.sendResponseOnTimeoutOrError((IgniteCheckedException)e, topFut, node, req);
                        return;
                    }
                    this.ctx.kernalContext().closure().runLocalWithThreadPolicy(thread, () -> {
                        try {
                            this.processNearTxPrepareRequest0(node, req);
                        }
                        finally {
                            this.ctx.io().onMessageProcessed(req);
                        }
                    });
                });
                return true;
            }
            try {
                if (req.timeout() > 0L) {
                    topFut.get(req.timeout());
                } else {
                    topFut.get();
                }
            }
            catch (IgniteFutureTimeoutCheckedException e2) {
                this.sendResponseOnTimeoutOrError(null, topFut, node, req);
                return true;
            }
            catch (IgniteCheckedException e3) {
                U.error(this.log, "Topology future failed: " + e3, e3);
            }
        }
        return false;
    }

    private void sendResponseOnTimeoutOrError(@Nullable IgniteCheckedException e, GridDhtTopologyFuture topFut, ClusterNode node, GridNearTxPrepareRequest req) {
        if (e == null) {
            e = new IgniteTxTimeoutCheckedException("Failed to wait topology version for near prepare [txId=" + req.version() + ", topVer=" + topFut.initialVersion() + ", node=" + node.id() + ", req=" + req + ']');
        }
        GridNearTxPrepareResponse res = new GridNearTxPrepareResponse(req.partition(), req.version(), req.futureId(), req.miniId(), req.version(), req.version(), null, e, null, req.onePhaseCommit(), req.deployInfo() != null);
        try {
            this.ctx.io().send(node.id(), (GridCacheMessage)res, req.policy());
        }
        catch (IgniteCheckedException e0) {
            U.error(this.txPrepareMsgLog, "Failed to send wait topology version response for near prepare [txId=" + req.version() + ", topVer=" + topFut.initialVersion() + ", node=" + node.id() + ", req=" + req + ']', e0);
        }
    }

    private boolean needRemap(AffinityTopologyVersion expVer, AffinityTopologyVersion curVer, GridNearTxPrepareRequest req) {
        if (expVer.equals(curVer)) {
            return false;
        }
        for (IgniteTxEntry e : F.concat(false, req.reads(), req.writes())) {
            Collection<ClusterNode> cacheNodes1;
            GridCacheContext<?, ?> ctx = e.context();
            Collection<ClusterNode> cacheNodes0 = ctx.discovery().cacheGroupAffinityNodes(ctx.groupId(), expVer);
            if (!cacheNodes0.equals(cacheNodes1 = ctx.discovery().cacheGroupAffinityNodes(ctx.groupId(), curVer)) || ctx.affinity().affinityTopologyVersion().compareTo(curVer) < 0) {
                return true;
            }
            try {
                List<List<ClusterNode>> aff2;
                List<List<ClusterNode>> aff1 = ctx.affinity().assignments(expVer);
                if (aff1.equals(aff2 = ctx.affinity().assignments(curVer))) continue;
                return true;
            }
            catch (IllegalStateException ignored) {
                return true;
            }
        }
        return false;
    }

    private void processNearTxPrepareResponse(UUID nodeId, GridNearTxPrepareResponse res) {
        GridNearTxPrepareFutureAdapter fut;
        if (this.txPrepareMsgLog.isDebugEnabled()) {
            this.txPrepareMsgLog.debug("Received near prepare response [txId=" + res.version() + ", node=" + nodeId + ']');
        }
        if ((fut = (GridNearTxPrepareFutureAdapter)this.ctx.mvcc().versionedFuture(res.version(), res.futureId())) == null) {
            U.warn(this.log, "Failed to find future for near prepare response [txId=" + res.version() + ", node=" + nodeId + ", res=" + res + ']');
            return;
        }
        IgniteInternalTx tx = fut.tx();
        assert (tx != null);
        res.txState(tx.txState());
        fut.onResult(nodeId, res);
    }

    private void processNearTxFinishResponse(UUID nodeId, GridNearTxFinishResponse res) {
        if (this.txFinishMsgLog.isDebugEnabled()) {
            this.txFinishMsgLog.debug("Received near finish response [txId=" + res.xid() + ", node=" + nodeId + ']');
        }
        this.ctx.tm().onFinishedRemote(nodeId, res.threadId());
        GridNearTxFinishFuture fut = (GridNearTxFinishFuture)this.ctx.mvcc().future(res.futureId());
        if (fut == null) {
            if (this.txFinishMsgLog.isDebugEnabled()) {
                this.txFinishMsgLog.debug("Failed to find future for near finish response [txId=" + res.xid() + ", node=" + nodeId + ", res=" + res + ']');
            }
            return;
        }
        fut.onResult(nodeId, res);
    }

    private void processDhtTxPrepareResponse(UUID nodeId, GridDhtTxPrepareResponse res) {
        GridDhtTxPrepareFuture fut = (GridDhtTxPrepareFuture)this.ctx.mvcc().versionedFuture(res.version(), res.futureId());
        if (fut == null) {
            if (this.txPrepareMsgLog.isDebugEnabled()) {
                this.txPrepareMsgLog.debug("Failed to find future for dht prepare response [txId=null, dhtTxId=" + res.version() + ", node=" + nodeId + ", res=" + res + ']');
            }
            return;
        }
        if (this.txPrepareMsgLog.isDebugEnabled()) {
            this.txPrepareMsgLog.debug("Received dht prepare response [txId=" + fut.tx().nearXidVersion() + ", node=" + nodeId + ']');
        }
        GridDhtTxLocalAdapter tx = fut.tx();
        assert (tx != null);
        res.txState(tx.txState());
        fut.onResult(nodeId, res);
    }

    private void processDhtTxFinishResponse(UUID nodeId, GridDhtTxFinishResponse res) {
        assert (nodeId != null);
        assert (res != null);
        if (res.checkCommitted()) {
            GridNearTxFinishFuture fut = (GridNearTxFinishFuture)this.ctx.mvcc().future(res.futureId());
            if (fut == null) {
                if (this.txFinishMsgLog.isDebugEnabled()) {
                    this.txFinishMsgLog.debug("Failed to find future for dht finish check committed response [txId=null, dhtTxId=" + res.xid() + ", node=" + nodeId + ", res=" + res + ']');
                }
                return;
            }
            if (this.txFinishMsgLog.isDebugEnabled()) {
                this.txFinishMsgLog.debug("Received dht finish check committed response [txId=" + fut.tx().nearXidVersion() + ", dhtTxId=" + res.xid() + ", node=" + nodeId + ']');
            }
            fut.onResult(nodeId, res);
        } else {
            GridDhtTxFinishFuture fut = (GridDhtTxFinishFuture)this.ctx.mvcc().future(res.futureId());
            if (fut == null) {
                if (this.txFinishMsgLog.isDebugEnabled()) {
                    this.txFinishMsgLog.debug("Failed to find future for dht finish response [txId=null, dhtTxId=" + res.xid() + ", node=" + nodeId + ", res=" + res);
                }
                return;
            }
            if (this.txFinishMsgLog.isDebugEnabled()) {
                this.txFinishMsgLog.debug("Received dht finish response [txId=" + fut.tx().nearXidVersion() + ", dhtTxId=" + res.xid() + ", node=" + nodeId + ']');
            }
            fut.onResult(nodeId, res);
        }
    }

    @Nullable
    private IgniteInternalFuture<IgniteInternalTx> processNearTxFinishRequest(UUID nodeId, GridNearTxFinishRequest req) {
        if (this.txFinishMsgLog.isDebugEnabled()) {
            this.txFinishMsgLog.debug("Received near finish request [txId=" + req.version() + ", node=" + nodeId + ']');
        }
        IgniteInternalFuture<IgniteInternalTx> fut = this.finish(nodeId, null, req);
        assert (req.txState() != null || fut == null || fut.error() != null || this.ctx.tm().tx(req.version()) == null && this.ctx.tm().nearTx(req.version()) == null) : "[req=" + req + ", fut=" + fut + "]";
        return fut;
    }

    @Nullable
    public IgniteInternalFuture<IgniteInternalTx> finish(UUID nodeId, @Nullable GridNearTxLocal locTx, GridNearTxFinishRequest req) {
        assert (nodeId != null);
        assert (req != null);
        if (locTx != null) {
            req.txState(locTx.txState());
        }
        if (!req.commit()) {
            this.ctx.tm().addRolledbackTx(null, req.version());
        }
        if (locTx != null && !locTx.nearLocallyMapped() && !locTx.colocatedLocallyMapped()) {
            return new GridFinishedFuture<IgniteInternalTx>(locTx);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing near tx finish request [nodeId=" + nodeId + ", req=" + req + "]");
        }
        IgniteInternalFuture<IgniteInternalTx> colocatedFinishFut = null;
        if (locTx != null && locTx.colocatedLocallyMapped()) {
            colocatedFinishFut = this.finishColocatedLocal(req.commit(), locTx);
        }
        IgniteInternalFuture<IgniteInternalTx> nearFinishFut = null;
        if (locTx == null || locTx.nearLocallyMapped()) {
            nearFinishFut = this.finishDhtLocal(nodeId, locTx, req);
        }
        if (colocatedFinishFut != null && nearFinishFut != null) {
            GridCompoundFuture res = new GridCompoundFuture();
            res.add(colocatedFinishFut);
            res.add(nearFinishFut);
            res.markInitialized();
            return res;
        }
        if (colocatedFinishFut != null) {
            return colocatedFinishFut;
        }
        return nearFinishFut;
    }

    private IgniteInternalFuture<IgniteInternalTx> finishDhtLocal(UUID nodeId, @Nullable GridNearTxLocal locTx, GridNearTxFinishRequest req) {
        GridCacheVersion dhtVer = this.ctx.tm().mappedVersion(req.version());
        GridDhtTxLocal tx = null;
        if (dhtVer == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received transaction finish request for unknown near version (was lock explicit?): " + req);
            }
        } else {
            tx = (GridDhtTxLocal)this.ctx.tm().tx(dhtVer);
        }
        if (tx != null) {
            tx.mvccSnapshot(req.mvccSnapshot());
            req.txState(tx.txState());
        }
        if (tx == null && locTx != null && !req.commit()) {
            U.warn(this.log, "DHT local tx not found for near local tx rollback [req=" + req + ", dhtVer=" + dhtVer + ", tx=" + locTx + ']');
            return null;
        }
        if (tx == null && !req.explicitLock()) {
            block26: {
                assert (locTx == null) : "DHT local tx should never be lost for near local tx: " + locTx;
                U.warn(this.txFinishMsgLog, "Received finish request for completed transaction (the message may be too late) [txId=" + req.version() + ", dhtTxId=" + dhtVer + ", node=" + nodeId + ", commit=" + req.commit() + ']');
                GridNearTxFinishResponse res = new GridNearTxFinishResponse(req.partition(), req.version(), req.threadId(), req.futureId(), req.miniId(), new IgniteTxRollbackCheckedException("Transaction has been already completed or not started yet."));
                try {
                    this.ctx.io().send(nodeId, (GridCacheMessage)res, req.policy());
                    if (this.txFinishMsgLog.isDebugEnabled()) {
                        this.txFinishMsgLog.debug("Sent near finish response for completed tx [txId=" + req.version() + ", dhtTxId=" + dhtVer + ", node=" + nodeId + ']');
                    }
                }
                catch (Throwable e) {
                    if (this.ctx.discovery().node(nodeId) == null) {
                        if (this.txFinishMsgLog.isDebugEnabled()) {
                            this.txFinishMsgLog.debug("Failed to send near finish response for completed tx, node failed [txId=" + req.version() + ", dhtTxId=" + dhtVer + ", node=" + nodeId + ']');
                        }
                    } else {
                        U.error(this.txFinishMsgLog, "Failed to send near finish response for completed tx, node failed [txId=" + req.version() + ", dhtTxId=" + dhtVer + ", node=" + nodeId + ", req=" + req + ", res=" + res + ']', e);
                    }
                    if (!(e instanceof Error)) break block26;
                    throw (Error)e;
                }
            }
            return null;
        }
        try {
            assert (tx != null) : "Transaction is null for near finish request [nodeId=" + nodeId + ", req=" + req + "]";
            assert (req.syncMode() != null) : req;
            tx.syncMode(req.syncMode());
            tx.nearFinishFutureId(req.futureId());
            tx.nearFinishMiniId(req.miniId());
            tx.storeEnabled(req.storeEnabled());
            if (req.commit()) {
                if (!tx.markFinalizing(IgniteInternalTx.FinalizationStatus.USER_FINISH)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Will not finish transaction (it is handled by another thread): " + tx);
                    }
                    return null;
                }
                IgniteInternalFuture<IgniteInternalTx> commitFut = tx.commitDhtLocalAsync();
                commitFut.listen(CU.errorLogger(this.log, new Class[0]));
                return commitFut;
            }
            IgniteInternalFuture<IgniteInternalTx> rollbackFut = tx.rollbackDhtLocalAsync();
            rollbackFut.listen(CU.errorLogger(this.log, new Class[0]));
            return rollbackFut;
        }
        catch (Throwable e) {
            block27: {
                try {
                    U.error(this.log, "Failed completing transaction [commit=" + req.commit() + ", tx=" + tx + ']', e);
                }
                catch (Throwable e0) {
                    ClusterNode node0 = this.ctx.discovery().node(nodeId);
                    U.error(this.log, "Failed completing transaction [commit=" + req.commit() + ", tx=" + CU.txString(tx) + ']', e);
                    U.error(this.log, "Failed to log message due to an error: ", e0);
                    if (node0 == null || node0.isClient() && !node0.isLocal()) break block27;
                    this.ctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                    throw e;
                }
            }
            if (tx != null) {
                tx.commitError(e);
                tx.systemInvalidate(true);
                try {
                    IgniteInternalFuture<IgniteInternalTx> res = tx.rollbackDhtLocalAsync();
                    res.listen(CU.errorLogger(this.log, new Class[0]));
                    return res;
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            return new GridFinishedFuture<IgniteInternalTx>(e);
        }
    }

    public IgniteInternalFuture<IgniteInternalTx> finishColocatedLocal(boolean commit2, GridNearTxLocal tx) {
        try {
            if (commit2) {
                if (!tx.markFinalizing(IgniteInternalTx.FinalizationStatus.USER_FINISH)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Will not finish transaction (it is handled by another thread): " + tx);
                    }
                    return null;
                }
                return tx.commitAsyncLocal();
            }
            return tx.rollbackAsyncLocal();
        }
        catch (Throwable e) {
            U.error(this.log, "Failed completing transaction [commit=" + commit2 + ", tx=" + tx + ']', e);
            if (e instanceof Error) {
                throw e;
            }
            if (tx != null) {
                try {
                    return tx.rollbackNearTxLocalAsync();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
            return new GridFinishedFuture<IgniteInternalTx>(e);
        }
    }

    private void processDhtTxPrepareRequest(final UUID nodeId, final GridDhtTxPrepareRequest req) {
        GridDhtTxPrepareResponse res;
        if (this.txPrepareMsgLog.isDebugEnabled()) {
            this.txPrepareMsgLog.debug("Received dht prepare request [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
        }
        assert (nodeId != null);
        assert (req != null);
        assert (req.transactionNodes() != null);
        GridDhtTxRemote dhtTx = null;
        GridDistributedTxRemoteAdapter nearTx = null;
        try {
            List<IgniteTxKey> writesCacheMissed;
            res = new GridDhtTxPrepareResponse(req.partition(), req.version(), req.futureId(), req.miniId(), req.deployInfo() != null);
            nearTx = !F.isEmpty(req.nearWrites()) ? this.startNearRemoteTx(this.ctx.deploy().globalLoader(), nodeId, req) : null;
            dhtTx = this.startRemoteTx(nodeId, req, res);
            if (dhtTx != null && req.updateCounters() != null) {
                dhtTx.txCounters(true).updateCounters(req.updateCounters());
            }
            if (nearTx != null) {
                res.nearEvicted(((GridNearTxRemote)nearTx).evicted());
            }
            if ((writesCacheMissed = req.nearWritesCacheMissed()) != null) {
                Collection<IgniteTxKey> evicted0 = res.nearEvicted();
                if (evicted0 != null) {
                    writesCacheMissed.addAll(evicted0);
                }
                res.nearEvicted(writesCacheMissed);
            }
            if (dhtTx != null) {
                req.txState(dhtTx.txState());
            } else if (nearTx != null) {
                req.txState(nearTx.txState());
            }
            if (dhtTx != null && !F.isEmpty(dhtTx.invalidPartitions())) {
                res.invalidPartitionsByCacheId(dhtTx.invalidPartitions());
            }
            if (req.onePhaseCommit()) {
                assert (req.last());
                if (dhtTx != null) {
                    dhtTx.onePhaseCommit(true);
                    dhtTx.needReturnValue(req.needReturnValue());
                    this.finish(dhtTx, req);
                }
                if (nearTx != null) {
                    nearTx.onePhaseCommit(true);
                    this.finish(nearTx, req);
                }
            }
        }
        catch (IgniteCheckedException e) {
            if (e instanceof IgniteTxRollbackCheckedException) {
                U.error(this.log, "Transaction was rolled back before prepare completed: " + req, e);
            } else if (e instanceof IgniteTxOptimisticCheckedException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Optimistic failure for remote transaction (will rollback): " + req);
                }
            } else if (e instanceof IgniteTxHeuristicCheckedException) {
                U.warn(this.log, "Failed to commit transaction (all transaction entries were invalidated): " + CU.txString(dhtTx));
            } else {
                U.error(this.log, "Failed to process prepare request: " + req, e);
            }
            if (nearTx != null) {
                try {
                    nearTx.rollbackRemoteTx();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
            res = new GridDhtTxPrepareResponse(req.partition(), req.version(), req.futureId(), req.miniId(), e, req.deployInfo() != null);
        }
        if (req.onePhaseCommit()) {
            IgniteInternalFuture<IgniteInternalTx> completeFut;
            IgniteInternalFuture<IgniteInternalTx> nearFin;
            IgniteInternalFuture<IgniteInternalTx> dhtFin;
            IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture = dhtTx == null ? null : (dhtFin = dhtTx.done() ? null : dhtTx.finishFuture());
            IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture2 = nearTx == null ? null : (nearFin = nearTx.done() ? null : nearTx.finishFuture());
            if (dhtFin != null && nearFin != null) {
                GridCompoundFuture<IgniteInternalTx, IgniteInternalTx> fut = new GridCompoundFuture<IgniteInternalTx, IgniteInternalTx>();
                fut.add(dhtFin);
                fut.add(nearFin);
                fut.markInitialized();
                completeFut = fut;
            } else {
                IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture3 = completeFut = dhtFin != null ? dhtFin : nearFin;
            }
            if (completeFut != null) {
                final GridDhtTxPrepareResponse res0 = res;
                final GridDhtTxRemote dhtTx0 = dhtTx;
                GridDistributedTxRemoteAdapter nearTx0 = nearTx;
                completeFut.listen((IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>)new CI1<IgniteInternalFuture<IgniteInternalTx>>((GridNearTxRemote)nearTx0){
                    final /* synthetic */ GridNearTxRemote val$nearTx0;
                    {
                        this.val$nearTx0 = gridNearTxRemote;
                    }

                    @Override
                    public void apply(IgniteInternalFuture<IgniteInternalTx> fut) {
                        IgniteTxHandler.this.sendReply(nodeId, req, res0, dhtTx0, this.val$nearTx0);
                    }
                });
            } else {
                this.sendReply(nodeId, req, res, dhtTx, (GridNearTxRemote)nearTx);
            }
        } else {
            this.sendReply(nodeId, req, res, dhtTx, (GridNearTxRemote)nearTx);
        }
        assert (req.txState() != null || res.error() != null || dhtTx == null && nearTx == null) : req + " tx=" + dhtTx + " nearTx=" + nearTx;
    }

    private void processDhtTxOnePhaseCommitAckRequest(UUID nodeId, GridDhtTxOnePhaseCommitAckRequest req) {
        assert (nodeId != null);
        assert (req != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing dht tx one phase commit ack request [nodeId=" + nodeId + ", req=" + req + ']');
        }
        for (GridCacheVersion ver : req.versions()) {
            this.ctx.tm().removeTxReturn(ver);
        }
    }

    private void processDhtTxFinishRequest(final UUID nodeId, final GridDhtTxFinishRequest req) {
        GridCacheVersion nearTxId;
        assert (nodeId != null);
        assert (req != null);
        if (req.checkCommitted()) {
            boolean committed;
            boolean bl = committed = req.waitRemoteTransactions() || !this.ctx.tm().addRolledbackTx(null, req.version());
            if (!committed || req.syncMode() != CacheWriteSynchronizationMode.FULL_SYNC) {
                this.sendReply(nodeId, req, committed, null);
            } else {
                IgniteInternalFuture<?> fut = this.ctx.tm().remoteTxFinishFuture(req.version());
                fut.listen(new CI1<IgniteInternalFuture<?>>(){

                    @Override
                    public void apply(IgniteInternalFuture<?> fut) {
                        IgniteTxHandler.this.sendReply(nodeId, req, true, null);
                    }
                });
            }
            return;
        }
        GridDhtTxRemote dhtTx = (GridDhtTxRemote)this.ctx.tm().tx(req.version());
        GridNearTxRemote nearTx = (GridNearTxRemote)this.ctx.tm().nearTx(req.version());
        GridCacheVersion gridCacheVersion = dhtTx != null ? dhtTx.nearXidVersion() : (nearTxId = nearTx != null ? nearTx.nearXidVersion() : null);
        if (this.txFinishMsgLog.isDebugEnabled()) {
            this.txFinishMsgLog.debug("Received dht finish request [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
        }
        if (nearTx != null && nearTx.local()) {
            nearTx = null;
        }
        this.finish(nodeId, dhtTx, req);
        if (nearTx != null) {
            this.finish(nodeId, nearTx, req);
        }
        if (req.replyRequired()) {
            IgniteInternalFuture<IgniteInternalTx> completeFut;
            IgniteInternalFuture<IgniteInternalTx> nearFin;
            IgniteInternalFuture<IgniteInternalTx> dhtFin;
            IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture = dhtTx == null ? null : (dhtFin = dhtTx.done() ? null : dhtTx.finishFuture());
            IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture2 = nearTx == null ? null : (nearFin = nearTx.done() ? null : nearTx.finishFuture());
            if (dhtFin != null && nearFin != null) {
                GridCompoundFuture<IgniteInternalTx, IgniteInternalTx> fut = new GridCompoundFuture<IgniteInternalTx, IgniteInternalTx>();
                fut.add(dhtFin);
                fut.add(nearFin);
                fut.markInitialized();
                completeFut = fut;
            } else {
                IgniteInternalFuture<IgniteInternalTx> igniteInternalFuture3 = completeFut = dhtFin != null ? dhtFin : nearFin;
            }
            if (completeFut != null) {
                completeFut.listen((IgniteInClosure<IgniteInternalFuture<IgniteInternalTx>>)new CI1<IgniteInternalFuture<IgniteInternalTx>>(){

                    @Override
                    public void apply(IgniteInternalFuture<IgniteInternalTx> fut) {
                        IgniteTxHandler.this.sendReply(nodeId, req, true, nearTxId);
                    }
                });
            } else {
                this.sendReply(nodeId, req, true, nearTxId);
            }
        } else {
            this.sendReply(nodeId, req, true, null);
        }
        assert (req.txState() != null || dhtTx == null && nearTx == null) : req + " tx=" + dhtTx + " nearTx=" + nearTx;
    }

    protected void finish(UUID nodeId, IgniteTxRemoteEx tx, GridDhtTxFinishRequest req) {
        block12: {
            if (tx == null) {
                if (req.commit()) {
                    this.ctx.tm().addCommittedTx(tx, req.version(), null);
                } else {
                    this.ctx.tm().addRolledbackTx(tx, req.version());
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received finish request for non-existing transaction (added to completed set) [senderNodeId=" + nodeId + ", res=" + req + ']');
                }
                return;
            }
            if (req.updateCounters() != null) {
                tx.txCounters(true).updateCounters(req.updateCounters());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received finish request for transaction [senderNodeId=" + nodeId + ", req=" + req + ", tx=" + tx + ']');
            }
            req.txState(tx.txState());
            try {
                if (req.commit() || req.isSystemInvalidate()) {
                    tx.commitVersion(req.commitVersion());
                    tx.invalidate(req.isInvalidate());
                    tx.systemInvalidate(req.isSystemInvalidate());
                    tx.mvccSnapshot(req.mvccSnapshot());
                    tx.doneRemote(req.baseVersion(), null, null, null);
                    tx.setPartitionUpdateCounters(req.partUpdateCounters() != null ? req.partUpdateCounters().array() : null);
                    tx.commitRemoteTx();
                } else {
                    tx.doneRemote(req.baseVersion(), null, null, null);
                    tx.mvccSnapshot(req.mvccSnapshot());
                    tx.rollbackRemoteTx();
                }
            }
            catch (Throwable e) {
                U.error(this.log, "Failed completing transaction [commit=" + req.commit() + ", tx=" + tx + ']', e);
                tx.invalidate(true);
                tx.systemInvalidate(true);
                try {
                    tx.commitRemoteTx();
                }
                catch (IgniteCheckedException ex) {
                    U.error(this.log, "Failed to invalidate transaction: " + tx, ex);
                }
                if (!(e instanceof Error)) break block12;
                throw (Error)e;
            }
        }
    }

    protected void finish(GridDistributedTxRemoteAdapter tx, GridDhtTxPrepareRequest req) throws IgniteTxHeuristicCheckedException {
        block6: {
            assert (tx != null) : "No transaction for one-phase commit prepare request: " + req;
            try {
                tx.commitVersion(req.writeVersion());
                tx.invalidate(req.isInvalidate());
                tx.mvccSnapshot(req.mvccSnapshot());
                tx.doneRemote(req.version(), null, null, null);
                tx.commitRemoteTx();
            }
            catch (IgniteTxHeuristicCheckedException e) {
                throw e;
            }
            catch (Throwable e) {
                U.error(this.log, "Failed committing transaction [tx=" + tx + ']', e);
                tx.invalidate(true);
                tx.systemInvalidate(true);
                try {
                    tx.rollbackRemoteTx();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                    U.error(this.log, "Failed to automatically rollback transaction: " + tx, e1);
                }
                if (!(e instanceof Error)) break block6;
                throw (Error)e;
            }
        }
    }

    private void sendReply(UUID nodeId, GridDhtTxPrepareRequest req, GridDhtTxPrepareResponse res, GridDhtTxRemote dhtTx, GridNearTxRemote nearTx) {
        block11: {
            try {
                this.ctx.io().send(nodeId, (GridCacheMessage)res, req.policy());
                if (this.txPrepareMsgLog.isDebugEnabled()) {
                    this.txPrepareMsgLog.debug("Sent dht prepare response [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
                }
            }
            catch (IgniteCheckedException e) {
                if (e instanceof ClusterTopologyCheckedException) {
                    if (this.txPrepareMsgLog.isDebugEnabled()) {
                        this.txPrepareMsgLog.debug("Failed to send dht prepare response, node left [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
                    }
                } else {
                    U.warn(this.log, "Failed to send tx response to remote node (will rollback transaction) [txId=" + req.nearXidVersion() + ", dhtTxId=" + req.version() + ", node=" + nodeId + ", err=" + e.getMessage() + ']');
                }
                if (nearTx != null) {
                    try {
                        nearTx.rollbackRemoteTx();
                    }
                    catch (Throwable e1) {
                        e.addSuppressed(e1);
                    }
                }
                if (dhtTx == null) break block11;
                try {
                    dhtTx.rollbackRemoteTx();
                }
                catch (Throwable e1) {
                    e.addSuppressed(e1);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendReply(UUID nodeId, GridDhtTxFinishRequest req, boolean committed, GridCacheVersion nearTxId) {
        if (req.replyRequired() || req.checkCommitted()) {
            GridDhtTxFinishResponse res = new GridDhtTxFinishResponse(req.partition(), req.version(), req.futureId(), req.miniId());
            if (req.checkCommitted()) {
                res.checkCommitted(true);
                if (committed) {
                    if (req.needReturnValue()) {
                        try {
                            GridCacheReturnCompletableWrapper wrapper = this.ctx.tm().getCommittedTxReturn(req.version());
                            if (wrapper != null) {
                                res.returnValue(wrapper.fut().get());
                            } else assert (!this.ctx.discovery().alive(nodeId)) : nodeId;
                        }
                        catch (IgniteCheckedException ignored) {
                            if (this.txFinishMsgLog.isDebugEnabled()) {
                                this.txFinishMsgLog.debug("Failed to gain entry processor return value. [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
                            }
                        }
                    }
                } else {
                    ClusterTopologyCheckedException cause = new ClusterTopologyCheckedException("Primary node left grid.");
                    res.checkCommittedError(new IgniteTxRollbackCheckedException("Failed to commit transaction (transaction has been rolled back on backup node): " + req.version(), cause));
                }
            }
            try {
                this.ctx.io().send(nodeId, (GridCacheMessage)res, req.policy());
                if (!this.txFinishMsgLog.isDebugEnabled()) return;
                this.txFinishMsgLog.debug("Sent dht tx finish response [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ", checkCommitted=" + req.checkCommitted() + ']');
                return;
            }
            catch (Throwable e) {
                if (this.ctx.discovery().node(nodeId) == null) {
                    if (this.txFinishMsgLog.isDebugEnabled()) {
                        this.txFinishMsgLog.debug("Node left while send dht tx finish response [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
                    }
                } else {
                    U.error(this.log, "Failed to send finish response to node [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", nodeId=" + nodeId + ", res=" + res + ']', e);
                }
                if (!(e instanceof Error)) return;
                throw (Error)e;
            }
        }
        if (!this.txFinishMsgLog.isDebugEnabled()) return;
        this.txFinishMsgLog.debug("Skip send dht tx finish response [txId=" + nearTxId + ", dhtTxId=" + req.version() + ", node=" + nodeId + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    GridDhtTxRemote startRemoteTx(UUID nodeId, GridDhtTxPrepareRequest req, GridDhtTxPrepareResponse res) throws IgniteCheckedException {
        if (req.queryUpdate() || !F.isEmpty(req.writes())) {
            tx = (GridDhtTxRemote)this.ctx.tm().tx(req.version());
            if (tx == null) {
                if (!IgniteTxHandler.$assertionsDisabled && req.queryUpdate()) {
                    throw new AssertionError();
                }
                single = req.last() != false && req.writes().size() == 1;
                tx = new GridDhtTxRemote(this.ctx, req.nearNodeId(), req.futureId(), nodeId, req.topologyVersion(), req.version(), null, req.system(), req.policy(), req.concurrency(), req.isolation(), req.isInvalidate(), req.timeout(), req.writes() != null ? Math.max(req.writes().size(), req.txSize()) : req.txSize(), req.nearXidVersion(), req.transactionNodes(), req.subjectId(), req.taskNameHash(), single, req.storeWriteThrough());
                tx.writeVersion(req.writeVersion());
                tx = this.ctx.tm().onCreated(null, tx);
                if (tx == null || !this.ctx.tm().onStarted(tx)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Attempt to start a completed transaction (will ignore): " + tx);
                    }
                    return null;
                }
                if (this.ctx.discovery().node(nodeId) == null) {
                    tx.state(TransactionState.ROLLING_BACK);
                    tx.state(TransactionState.ROLLED_BACK);
                    this.ctx.tm().uncommitTx(tx);
                    return null;
                }
            } else {
                tx.writeVersion(req.writeVersion());
                tx.transactionNodes(req.transactionNodes());
            }
            if (!tx.isSystemInvalidate()) {
                idx = 0;
                for (IgniteTxEntry entry : req.writes()) {
                    cacheCtx = entry.context();
                    part = cacheCtx.affinity().partition(entry.key());
                    locPart = cacheCtx.topology().localPartition(part, req.topologyVersion(), false);
                    if (locPart != null && locPart.reserve()) {
                        try {
                            tx.addWrite(entry, this.ctx.deploy().globalLoader());
                            if (GridCacheUtils.isNearEnabled(cacheCtx) && req.invalidateNearEntry(idx)) {
                                this.invalidateNearEntry(cacheCtx, entry.key(), req.version());
                            }
                            if (req.needPreloadKey(idx)) {
                                cached = entry.cached();
                                if (cached == null) {
                                    cached = cacheCtx.cache().entryEx(entry.key(), req.topologyVersion());
                                }
                                if ((info = cached.info()) != null && !info.isNew() && !info.isDeleted()) {
                                    res.addPreloadEntry(info);
                                }
                            }
                            if (!cacheCtx.readThroughConfigured() || entry.skipStore() || entry.op() != GridCacheOperation.TRANSFORM || !entry.oldValueOnPrimary() || entry.hasValue()) ** GOTO lbl66
                            while (true) {
                                try {
                                    cached = entry.cached();
                                    if (cached == null) {
                                        cached = cacheCtx.cache().entryEx(entry.key(), req.topologyVersion());
                                        entry.cached(cached);
                                    }
                                    if ((val = cached.innerGet(null, tx, false, false, false, tx.subjectId(), null, tx.resolveTaskName(), null, true, null)) == null) {
                                        val = cacheCtx.toCacheObject(cacheCtx.store().load(null, entry.key()));
                                    }
                                    if (val == null) break;
                                    entry.readValue(val);
                                }
                                catch (GridCacheEntryRemovedException ignored) {
                                    if (this.log.isDebugEnabled()) {
                                        this.log.debug("Got entry removed exception, will retry: " + entry.txKey());
                                    }
                                    entry.cached(cacheCtx.cache().entryEx(entry.key(), req.topologyVersion()));
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (GridDhtInvalidPartitionException e) {
                            tx.addInvalidPartition((GridCacheContext)cacheCtx, e.partition());
                            tx.clearEntry(entry.txKey());
                        }
                        finally {
                            locPart.release();
                        }
                    } else {
                        tx.addInvalidPartition((GridCacheContext)cacheCtx, part);
                    }
lbl66:
                    // 5 sources

                    ++idx;
                }
            }
            tx.prepareRemoteTx();
            if (req.last()) {
                if (!IgniteTxHandler.$assertionsDisabled && F.isEmpty(req.transactionNodes())) {
                    throw new AssertionError((Object)("Received last prepare request with empty transaction nodes: " + req));
                }
                tx.state(TransactionState.PREPARED);
            }
            res.invalidPartitionsByCacheId(tx.invalidPartitions());
            if (!req.queryUpdate() && tx.empty() && req.last()) {
                tx.skipCompletedVersions(req.skipCompletedVersion());
                tx.rollbackRemoteTx();
                return null;
            }
            return tx;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mvccEnlistBatch(GridDhtTxRemote tx, GridCacheContext ctx, EnlistOperation op, List<KeyCacheObject> keys, List<Message> vals, MvccSnapshot snapshot2, IgniteUuid futId, int batchNum) throws IgniteCheckedException {
        assert (keys != null && (vals == null || vals.size() == keys.size()));
        assert (tx != null);
        GridDhtCacheAdapter dht = ctx.dht();
        tx.addActiveCache(ctx, false);
        for (int i = 0; i < keys.size(); ++i) {
            KeyCacheObject key = keys.get(i);
            assert (key != null);
            int part = ctx.affinity().partition(key);
            GridDhtLocalPartition locPart = ctx.topology().localPartition(part, tx.topologyVersion(), false);
            if (locPart == null || !locPart.reserve()) {
                throw new ClusterTopologyException("Can not reserve partition. Please retry on stable topology.");
            }
            try {
                GridCacheUpdateTxResult updRes;
                CacheEntryInfoCollection entries;
                CacheObject val = null;
                EntryProcessor<Object, Object, Object> entryProc = null;
                Object[] invokeArgs = null;
                boolean needOldVal = ctx.shared().mvccCaching().continuousQueryListeners(ctx, tx, key) != null;
                Message val0 = vals != null ? vals.get(i) : null;
                CacheEntryInfoCollection cacheEntryInfoCollection = entries = val0 instanceof CacheEntryInfoCollection ? (CacheEntryInfoCollection)val0 : null;
                if (entries == null && !op.isDeleteOrLock() && !op.isInvoke()) {
                    CacheObject cacheObject = val = val0 instanceof CacheObject ? (CacheObject)val0 : null;
                }
                if (entries == null && op.isInvoke()) {
                    assert (val0 instanceof GridInvokeValue);
                    GridInvokeValue invokeVal = (GridInvokeValue)val0;
                    entryProc = invokeVal.entryProcessor();
                    invokeArgs = invokeVal.invokeArgs();
                }
                assert (entryProc != null || !op.isInvoke());
                GridDhtCacheEntry entry2 = dht.entryExx(key, tx.topologyVersion());
                block13: while (true) {
                    ctx.shared().database().checkpointReadLock();
                    try {
                        if (entries == null) {
                            switch (op) {
                                case DELETE: {
                                    updRes = entry2.mvccRemove(tx, ctx.localNodeId(), tx.topologyVersion(), snapshot2, false, needOldVal, null, false);
                                    break block13;
                                }
                                case INSERT: 
                                case TRANSFORM: 
                                case UPSERT: 
                                case UPDATE: {
                                    updRes = entry2.mvccSet(tx, ctx.localNodeId(), val, entryProc, invokeArgs, 0L, tx.topologyVersion(), snapshot2, op.cacheOperation(), false, false, needOldVal, null, false);
                                    break block13;
                                }
                                default: {
                                    throw new IgniteSQLException("Cannot acquire lock for operation [op= " + (Object)((Object)op) + "]Operation is unsupported at the moment ", 1002);
                                }
                            }
                        }
                        updRes = entry2.mvccUpdateRowsWithPreloadInfo(tx, ctx.localNodeId(), tx.topologyVersion(), entries.infos(), op.cacheOperation(), snapshot2, futId, batchNum);
                    }
                    catch (GridCacheEntryRemovedException ignore) {
                        entry2 = dht.entryExx(key);
                        continue;
                    }
                    finally {
                        ctx.shared().database().checkpointReadUnlock();
                        continue;
                    }
                    break;
                }
                if (!updRes.filtered()) {
                    ctx.shared().mvccCaching().addEnlisted(key, updRes.newValue(), 0L, 0L, tx.xidVersion(), updRes.oldValue(), tx.local(), tx.topologyVersion(), snapshot2, ctx.cacheId(), tx, futId, batchNum);
                }
                if ($assertionsDisabled || updRes.updateFuture() == null) continue;
                throw new AssertionError((Object)"Entry should not be locked on the backup");
            }
            finally {
                locPart.release();
            }
        }
    }

    private void invalidateNearEntry(GridCacheContext cacheCtx, KeyCacheObject key, GridCacheVersion ver) throws IgniteCheckedException {
        GridNearCacheAdapter near = cacheCtx.isNear() ? cacheCtx.near() : cacheCtx.dht().near();
        GridCacheEntryEx nearEntry = near.peekEx(key);
        if (nearEntry != null) {
            nearEntry.invalidate(ver);
        }
    }

    @Nullable
    private GridNearTxRemote startNearRemoteTx(ClassLoader ldr, UUID nodeId, GridDhtTxPrepareRequest req) throws IgniteCheckedException {
        if (!F.isEmpty(req.nearWrites())) {
            GridNearTxRemote tx = (GridNearTxRemote)this.ctx.tm().nearTx(req.version());
            if (tx == null) {
                tx = new GridNearTxRemote(this.ctx, req.topologyVersion(), ldr, nodeId, req.nearNodeId(), req.version(), null, req.system(), req.policy(), req.concurrency(), req.isolation(), req.isInvalidate(), req.timeout(), req.nearWrites(), req.txSize(), req.subjectId(), req.taskNameHash());
                tx.writeVersion(req.writeVersion());
                if (!(tx.empty() || (tx = this.ctx.tm().onCreated(null, tx)) != null && this.ctx.tm().onStarted(tx))) {
                    throw new IgniteTxRollbackCheckedException("Attempt to start a completed transaction: " + tx);
                }
            } else {
                tx.addEntries(ldr, req.nearWrites());
            }
            tx.ownedVersions(req.owned());
            tx.prepareRemoteTx();
            if (req.last()) {
                tx.state(TransactionState.PREPARED);
            }
            return tx;
        }
        return null;
    }

    private void processCheckPreparedTxRequest(final UUID nodeId, final GridCacheTxRecoveryRequest req) {
        IgniteInternalFuture<Boolean> fut;
        if (this.txRecoveryMsgLog.isDebugEnabled()) {
            this.txRecoveryMsgLog.debug("Received tx recovery request [txId=" + req.nearXidVersion() + ", node=" + nodeId + ']');
        }
        IgniteInternalFuture<Boolean> igniteInternalFuture = fut = req.nearTxCheck() ? this.ctx.tm().txCommitted(req.nearXidVersion()) : this.ctx.tm().txsPreparedOrCommitted(req.nearXidVersion(), req.transactions());
        if (fut == null || fut.isDone()) {
            boolean prepared;
            try {
                prepared = fut == null ? true : fut.get();
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Check prepared transaction future failed [req=" + req + ']', e);
                prepared = false;
            }
            this.sendCheckPreparedResponse(nodeId, req, prepared);
        } else {
            fut.listen((IgniteInClosure<IgniteInternalFuture<Boolean>>)new CI1<IgniteInternalFuture<Boolean>>(){

                @Override
                public void apply(IgniteInternalFuture<Boolean> fut) {
                    boolean prepared;
                    try {
                        prepared = fut.get();
                    }
                    catch (IgniteCheckedException e) {
                        U.error(IgniteTxHandler.this.log, "Check prepared transaction future failed [req=" + req + ']', e);
                        prepared = false;
                    }
                    IgniteTxHandler.this.sendCheckPreparedResponse(nodeId, req, prepared);
                }
            });
        }
    }

    private void sendCheckPreparedResponse(UUID nodeId, GridCacheTxRecoveryRequest req, boolean prepared) {
        GridCacheTxRecoveryResponse res = new GridCacheTxRecoveryResponse(req.version(), req.futureId(), req.miniId(), prepared, req.deployInfo() != null);
        try {
            this.ctx.io().send(nodeId, (GridCacheMessage)res, req.system() ? (byte)5 : 2);
            if (this.txRecoveryMsgLog.isDebugEnabled()) {
                this.txRecoveryMsgLog.debug("Sent tx recovery response [txId=" + req.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ']');
            }
        }
        catch (ClusterTopologyCheckedException ignored) {
            if (this.txRecoveryMsgLog.isDebugEnabled()) {
                this.txRecoveryMsgLog.debug("Failed to send tx recovery response, node failed [, txId=" + req.nearXidVersion() + ", node=" + nodeId + ", res=" + res + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.txRecoveryMsgLog, "Failed to send tx recovery response [txId=" + req.nearXidVersion() + ", node=" + nodeId + ", req=" + req + ", res=" + res + ']', e);
        }
    }

    protected void processCheckPreparedTxResponse(UUID nodeId, GridCacheTxRecoveryResponse res) {
        GridCacheTxRecoveryFuture fut;
        if (this.txRecoveryMsgLog.isInfoEnabled()) {
            this.txRecoveryMsgLog.info("Received tx recovery response [txId=" + res.version() + ", node=" + nodeId + ", res=" + res + ']');
        }
        if ((fut = (GridCacheTxRecoveryFuture)this.ctx.mvcc().future(res.futureId())) == null) {
            if (this.txRecoveryMsgLog.isInfoEnabled()) {
                this.txRecoveryMsgLog.info("Failed to find future for tx recovery response [txId=" + res.version() + ", node=" + nodeId + ", res=" + res + ']');
            }
            return;
        }
        res.txState(fut.tx().txState());
        fut.onResult(nodeId, res);
    }

    private void processPartitionCountersRequest(UUID nodeId, PartitionCountersNeighborcastRequest req) {
        this.applyPartitionsUpdatesCounters(req.updateCounters());
        try {
            this.ctx.io().send(nodeId, (GridCacheMessage)new PartitionCountersNeighborcastResponse(req.futId()), (byte)2);
        }
        catch (ClusterTopologyCheckedException ignored) {
            if (this.txRecoveryMsgLog.isDebugEnabled()) {
                this.txRecoveryMsgLog.debug("Failed to send partition counters response, node left [node=" + nodeId + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.txRecoveryMsgLog, "Failed to send partition counters response [node=" + nodeId + ']', e);
        }
    }

    private void processPartitionCountersResponse(UUID nodeId, PartitionCountersNeighborcastResponse res) {
        PartitionCountersNeighborcastFuture fut = (PartitionCountersNeighborcastFuture)this.ctx.mvcc().future(res.futId());
        if (fut == null) {
            this.log.warning("Failed to find future for partition counters response [futId=" + res.futId() + ", node=" + nodeId + ']');
            return;
        }
        fut.onResult(nodeId);
    }

    public void applyPartitionsUpdatesCounters(Iterable<PartitionUpdateCountersMessage> counters) {
        if (counters == null) {
            return;
        }
        int cacheId = 0;
        GridDhtPartitionTopology top = null;
        for (PartitionUpdateCountersMessage counter : counters) {
            if (counter.cacheId() != cacheId) {
                cacheId = counter.cacheId();
                GridCacheContext<?, ?> ctx0 = this.ctx.cacheContext(cacheId);
                assert (ctx0.mvccEnabled());
                top = ctx0.topology();
            }
            assert (top != null);
            for (int i = 0; i < counter.size(); ++i) {
                GridDhtLocalPartition part = top.localPartition(counter.partition(i));
                assert (part != null);
                part.updateCounter(counter.initialCounter(i), counter.updatesCount(i));
            }
        }
    }

    @Nullable
    public List<PartitionUpdateCountersMessage> filterUpdateCountersForBackupNode(IgniteInternalTx tx, ClusterNode node) {
        TxCounters txCntrs = tx.txCounters(false);
        if (txCntrs == null || F.isEmpty(txCntrs.updateCounters())) {
            return null;
        }
        Collection<PartitionUpdateCountersMessage> updCntrs = txCntrs.updateCounters();
        ArrayList<PartitionUpdateCountersMessage> res = new ArrayList<PartitionUpdateCountersMessage>(updCntrs.size());
        AffinityTopologyVersion top = tx.topologyVersionSnapshot();
        for (PartitionUpdateCountersMessage partCntrs : updCntrs) {
            GridCacheAffinityManager affinity = this.ctx.cacheContext(partCntrs.cacheId()).affinity();
            PartitionUpdateCountersMessage resCntrs = new PartitionUpdateCountersMessage(partCntrs.cacheId(), partCntrs.size());
            for (int i = 0; i < partCntrs.size(); ++i) {
                int part = partCntrs.partition(i);
                if (!affinity.backupByPartition(node, part, top)) continue;
                resCntrs.add(part, partCntrs.initialCounter(i), partCntrs.updatesCount(i));
            }
            if (resCntrs.size() <= 0) continue;
            res.add(resCntrs);
        }
        return res;
    }
}

