/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.jdbc;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlIndexMetadata;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlMetadata;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

public class GridCacheQueryJdbcMetadataTask
extends ComputeTaskAdapter<String, byte[]> {
    private static final long serialVersionUID = 0L;
    private static final Marshaller MARSHALLER = new JdkMarshaller();
    @IgniteInstanceResource
    private Ignite ignite;

    @Override
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable String cacheName) {
        HashMap<JdbcDriverMetadataJob, ClusterNode> map2 = new HashMap<JdbcDriverMetadataJob, ClusterNode>();
        IgniteKernal kernal = (IgniteKernal)this.ignite;
        GridDiscoveryManager discoMgr = kernal.context().discovery();
        for (ClusterNode n : subgrid) {
            if (!discoMgr.cacheAffinityNode(n, cacheName)) continue;
            map2.put(new JdbcDriverMetadataJob(cacheName), n);
            break;
        }
        return map2;
    }

    @Override
    public byte[] reduce(List<ComputeJobResult> results) {
        return (byte[])F.first(results).getData();
    }

    private static class JdbcDriverMetadataJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        private final String cacheName;
        @IgniteInstanceResource
        private Ignite ignite;
        @LoggerResource
        private IgniteLogger log;

        private JdbcDriverMetadataJob(@Nullable String cacheName) {
            this.cacheName = cacheName;
        }

        @Override
        public Object execute() {
            byte[] data;
            byte status;
            block10: {
                try {
                    IgniteInternalCache cache = ((IgniteEx)this.ignite).cachex(this.cacheName);
                    assert (cache != null);
                    Collection<GridCacheSqlMetadata> metas = cache.context().queries().sqlMetadata();
                    HashMap schemasMap = U.newHashMap(metas.size());
                    LinkedList<List<Object[]>> indexesInfo = new LinkedList<List<Object[]>>();
                    for (GridCacheSqlMetadata meta : metas) {
                        String name = meta.cacheName();
                        if (name == null) {
                            name = "PUBLIC";
                        }
                        Collection<String> types2 = meta.types();
                        HashMap<String, Map<String, String>> typesMap = U.newHashMap(types2.size());
                        for (String type : types2) {
                            typesMap.put(type.toUpperCase(), meta.fields(type));
                            for (GridCacheSqlIndexMetadata idx : meta.indexes(type)) {
                                int cnt = 0;
                                for (String field2 : idx.fields()) {
                                    indexesInfo.add(F.asList(new Object[]{name, type.toUpperCase(), !idx.unique(), idx.name().toUpperCase(), ++cnt, field2, idx.descending(field2)}));
                                }
                            }
                        }
                        schemasMap.put(name, typesMap);
                    }
                    status = 0;
                    data = U.marshal(MARSHALLER, F.asList(new Object[]{schemasMap, indexesInfo}));
                }
                catch (Throwable t) {
                    U.error(this.log, "Failed to get metadata for JDBC.", t);
                    SQLException err2 = new SQLException(t.getMessage());
                    status = 1;
                    try {
                        data = U.marshal(MARSHALLER, (Object)err2);
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException(e);
                    }
                    if (!(t instanceof Error)) break block10;
                    throw (Error)t;
                }
            }
            byte[] packet = new byte[data.length + 1];
            packet[0] = status;
            U.arrayCopy(data, 0, packet, 1, data.length);
            return packet;
        }
    }
}

