/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.continuous;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.cache.event.CacheEntryEvent;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryEntry;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryEvent;
import org.apache.ignite.internal.processors.cache.query.continuous.CacheContinuousQueryHandler;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.jetbrains.annotations.Nullable;

class CacheContinuousQueryPartitionRecovery {
    private static final CacheContinuousQueryEntry HOLE = new CacheContinuousQueryEntry();
    private static final int MAX_BUFF_SIZE;
    private IgniteLogger log;
    private long lastFiredEvt;
    private AffinityTopologyVersion curTop = AffinityTopologyVersion.NONE;
    private final TreeMap<Long, CacheContinuousQueryEntry> pendingEvts = new TreeMap();

    CacheContinuousQueryPartitionRecovery(IgniteLogger log2, AffinityTopologyVersion topVer, @Nullable Long initCntr) {
        this.log = log2;
        if (initCntr != null) {
            assert (topVer.topologyVersion() > 0L) : topVer;
            this.lastFiredEvt = initCntr;
            this.curTop = topVer;
        }
    }

    void resetTopologyCache() {
        this.curTop = AffinityTopologyVersion.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <K, V> Collection<CacheEntryEvent<? extends K, ? extends V>> collectEntries(CacheContinuousQueryEntry entry2, GridCacheContext cctx, IgniteCache cache) {
        ArrayList<CacheEntryEvent<K, V>> entries;
        assert (entry2 != null);
        if (entry2.topologyVersion() == null) {
            assert (entry2.updateCounter() == 0L) : entry2;
            return F.asList(new CacheContinuousQueryEvent(cache, cctx, entry2));
        }
        TreeMap<Long, CacheContinuousQueryEntry> treeMap = this.pendingEvts;
        synchronized (treeMap) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Handling event [lastFiredEvt=" + this.lastFiredEvt + ", curTop=" + this.curTop + ", entUpdCnt=" + entry2.updateCounter() + ", partId=" + entry2.partition() + ", pendingEvts=" + this.pendingEvts + ']');
            }
            if (this.curTop == AffinityTopologyVersion.NONE) {
                this.lastFiredEvt = entry2.updateCounter();
                this.curTop = entry2.topologyVersion();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("First event [lastFiredEvt=" + this.lastFiredEvt + ", curTop=" + this.curTop + ", entUpdCnt=" + entry2.updateCounter() + ", partId=" + entry2.partition() + ']');
                }
                return !entry2.isFiltered() ? F.asList(new CacheContinuousQueryEvent(cache, cctx, entry2)) : Collections.emptyList();
            }
            if (this.curTop.compareTo(entry2.topologyVersion()) < 0) {
                if (entry2.updateCounter() == 1L && !entry2.isBackup()) {
                    ArrayList<CacheEntryEvent<K, V>> entries2 = new ArrayList<CacheEntryEvent<K, V>>(this.pendingEvts.size());
                    for (CacheContinuousQueryEntry evt : this.pendingEvts.values()) {
                        if (evt == HOLE || evt.isFiltered()) continue;
                        entries2.add(new CacheContinuousQueryEvent(cache, cctx, evt));
                    }
                    this.pendingEvts.clear();
                    this.curTop = entry2.topologyVersion();
                    this.lastFiredEvt = entry2.updateCounter();
                    if (!entry2.isFiltered()) {
                        entries2.add(new CacheContinuousQueryEvent(cache, cctx, entry2));
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Partition was lost [lastFiredEvt=" + this.lastFiredEvt + ", curTop=" + this.curTop + ", entUpdCnt=" + entry2.updateCounter() + ", partId=" + entry2.partition() + ", pendingEvts=" + this.pendingEvts + ']');
                    }
                    return entries2;
                }
                this.curTop = entry2.topologyVersion();
            }
            if (entry2.updateCounter() <= this.lastFiredEvt) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Skip duplicate continuous query message: " + entry2);
                }
                return Collections.emptyList();
            }
            this.pendingEvts.put(entry2.updateCounter(), entry2);
            if (this.pendingEvts.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Nothing sent to listener [lastFiredEvt=" + this.lastFiredEvt + ", curTop=" + this.curTop + ", entUpdCnt=" + entry2.updateCounter() + ", partId=" + entry2.partition() + ']');
                }
                return Collections.emptyList();
            }
            Iterator<Map.Entry<Long, CacheContinuousQueryEntry>> iter2 = this.pendingEvts.entrySet().iterator();
            entries = new ArrayList<CacheEntryEvent<K, V>>();
            if (this.pendingEvts.size() >= MAX_BUFF_SIZE) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Pending events reached max of buffer size [lastFiredEvt=" + this.lastFiredEvt + ", curTop=" + this.curTop + ", entUpdCnt=" + entry2.updateCounter() + ", partId=" + entry2.partition() + ", pendingEvts=" + this.pendingEvts + ']');
                }
                LT.warn(this.log, "Pending events reached max of buffer size [cache=" + cctx.name() + ", bufSize=" + MAX_BUFF_SIZE + ", partId=" + entry2.partition() + ']');
                for (int i = 0; i < MAX_BUFF_SIZE - MAX_BUFF_SIZE / 10; ++i) {
                    Map.Entry<Long, CacheContinuousQueryEntry> e = iter2.next();
                    if (e.getValue() != HOLE && !e.getValue().isFiltered()) {
                        entries.add(new CacheContinuousQueryEvent(cache, cctx, e.getValue()));
                    }
                    this.lastFiredEvt = e.getKey();
                    iter2.remove();
                }
            } else {
                boolean skippedFiltered = false;
                while (iter2.hasNext()) {
                    boolean fire;
                    Map.Entry<Long, CacheContinuousQueryEntry> e = iter2.next();
                    CacheContinuousQueryEntry pending = e.getValue();
                    long filtered2 = pending.filteredCount();
                    boolean bl = fire = e.getKey() == this.lastFiredEvt + 1L;
                    if (!fire && filtered2 > 0L) {
                        boolean bl2 = fire = e.getKey() - filtered2 <= this.lastFiredEvt + 1L;
                    }
                    if (fire) {
                        this.lastFiredEvt = e.getKey();
                        if (e.getValue() != HOLE && !e.getValue().isFiltered()) {
                            entries.add(new CacheContinuousQueryEvent(cache, cctx, pending));
                        }
                        iter2.remove();
                        continue;
                    }
                    if (!pending.isFiltered()) break;
                    skippedFiltered = true;
                }
                if (skippedFiltered) {
                    this.pendingEvts.headMap(this.lastFiredEvt).clear();
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Will send to listener the following events [entries=" + entries + ", lastFiredEvt=" + this.lastFiredEvt + ", curTop=" + this.curTop + ", entUpdCnt=" + entry2.updateCounter() + ", partId=" + entry2.partition() + ", pendingEvts=" + this.pendingEvts + ']');
        }
        return entries;
    }

    static {
        HOLE.markFiltered();
        MAX_BUFF_SIZE = CacheContinuousQueryHandler.LSNR_MAX_BUF_SIZE;
    }
}

