/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.query.GridCacheQuerySqlMetadataV2;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlIndexMetadata;
import org.apache.ignite.internal.processors.datastructures.DataStructuresProcessor;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;

@GridInternal
class GridCacheQuerySqlMetadataJobV2
implements IgniteCallable<Collection<GridCacheQueryManager.CacheSqlMetadata>> {
    private static final long serialVersionUID = 0L;
    private static final int NO_FIELDS_COLUMNS_COUNT = 2;
    @IgniteInstanceResource
    private Ignite ignite;

    GridCacheQuerySqlMetadataJobV2() {
    }

    @Override
    public Collection<GridCacheQueryManager.CacheSqlMetadata> call() {
        final GridKernalContext ctx = ((IgniteKernal)this.ignite).context();
        Collection cacheNames = F.viewReadOnly(ctx.cache().caches(), new C1<IgniteInternalCache<?, ?>, String>(){

            @Override
            public String apply(IgniteInternalCache<?, ?> c) {
                return c.name();
            }
        }, new P1<IgniteInternalCache<?, ?>>(){

            @Override
            public boolean apply(IgniteInternalCache<?, ?> c) {
                return !CU.isSystemCache(c.name()) && !DataStructuresProcessor.isDataStructureCache(c.name());
            }
        });
        return F.transform(cacheNames, new C1<String, GridCacheQueryManager.CacheSqlMetadata>(){

            @Override
            public GridCacheQueryManager.CacheSqlMetadata apply(String cacheName) {
                Collection<GridQueryTypeDescriptor> types2 = ctx.query().types(cacheName);
                HashSet<String> names = U.newHashSet(types2.size());
                HashMap<String, String> keyClasses = U.newHashMap(types2.size());
                HashMap<String, String> valClasses = U.newHashMap(types2.size());
                HashMap<String, Map<String, String>> fields = U.newHashMap(types2.size());
                HashMap<String, Collection<GridCacheSqlIndexMetadata>> indexes = U.newHashMap(types2.size());
                HashMap<String, Set<String>> notNullFields = U.newHashMap(types2.size());
                for (GridQueryTypeDescriptor type : types2) {
                    if (type.name().startsWith("GridCache")) continue;
                    names.add(type.name());
                    keyClasses.put(type.name(), type.keyClass().getName());
                    valClasses.put(type.name(), type.valueClass().getName());
                    int size2 = type.fields().isEmpty() ? 2 : type.fields().size();
                    LinkedHashMap<String, String> fieldsMap = U.newLinkedHashMap(size2);
                    HashSet notNullFieldsSet = U.newHashSet(1);
                    if (type.fields().isEmpty()) {
                        fieldsMap.put("_KEY", type.keyClass().getName());
                        fieldsMap.put("_VAL", type.valueClass().getName());
                    }
                    for (Map.Entry<String, Class<?>> e : type.fields().entrySet()) {
                        String fieldName = e.getKey();
                        fieldsMap.put(fieldName.toUpperCase(), e.getValue().getName());
                        if (!type.property(fieldName).notNull()) continue;
                        notNullFieldsSet.add(fieldName.toUpperCase());
                    }
                    fields.put(type.name(), fieldsMap);
                    notNullFields.put(type.name(), notNullFieldsSet);
                    Map<String, GridQueryIndexDescriptor> idxs = type.indexes();
                    ArrayList<GridCacheQueryManager.CacheSqlIndexMetadata> indexesCol = new ArrayList<GridCacheQueryManager.CacheSqlIndexMetadata>(idxs.size());
                    for (Map.Entry<String, GridQueryIndexDescriptor> e : idxs.entrySet()) {
                        GridQueryIndexDescriptor desc = e.getValue();
                        if (desc.type() != QueryIndexType.SORTED) continue;
                        LinkedList<String> idxFields = new LinkedList<String>();
                        LinkedList<String> descendings = new LinkedList<String>();
                        for (String idxField : e.getValue().fields()) {
                            String idxFieldUpper = idxField.toUpperCase();
                            idxFields.add(idxFieldUpper);
                            if (!desc.descending(idxField)) continue;
                            descendings.add(idxFieldUpper);
                        }
                        indexesCol.add(new GridCacheQueryManager.CacheSqlIndexMetadata(e.getKey().toUpperCase(), idxFields, descendings, false));
                    }
                    indexes.put(type.name(), indexesCol);
                }
                return new GridCacheQuerySqlMetadataV2(cacheName, names, keyClasses, valClasses, fields, indexes, notNullFields);
            }
        });
    }
}

