/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.query.CacheQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheLocalFieldsQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheLocalQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryBean;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryInfo;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.jetbrains.annotations.Nullable;

public class GridCacheLocalQueryManager<K, V>
extends GridCacheQueryManager<K, V> {
    @Override
    protected boolean onPageReady(boolean loc, GridCacheQueryInfo qryInfo, Collection<?> data, boolean finished, Throwable e) {
        GridCacheLocalQueryFuture<?, ?, ?> fut = qryInfo.localQueryFuture();
        assert (fut != null);
        if (e != null) {
            fut.onPage(null, null, e, true);
        } else {
            fut.onPage(null, data, null, finished);
        }
        return true;
    }

    @Override
    protected boolean onFieldsPageReady(boolean loc, GridCacheQueryInfo qryInfo, @Nullable List<GridQueryFieldMetadata> metaData, @Nullable Collection<?> entities, @Nullable Collection<?> data, boolean finished, @Nullable Throwable e) {
        assert (qryInfo != null);
        GridCacheLocalFieldsQueryFuture fut = (GridCacheLocalFieldsQueryFuture)qryInfo.localQueryFuture();
        assert (fut != null);
        if (e != null) {
            fut.onPage(null, null, null, e, true);
        } else {
            fut.onPage(null, metaData, data, null, finished);
        }
        return true;
    }

    @Override
    public void start0() throws IgniteCheckedException {
        super.start0();
        assert (this.cctx.config().getCacheMode() == CacheMode.LOCAL);
    }

    @Override
    public CacheQueryFuture<?> queryDistributed(GridCacheQueryBean qry, Collection<ClusterNode> nodes2) {
        assert (this.cctx.config().getCacheMode() == CacheMode.LOCAL);
        throw new IgniteException("Distributed queries are not available for local cache (use 'CacheQuery.execute(grid.forLocal())' instead) [cacheName=" + this.cctx.name() + ']');
    }

    @Override
    public GridCloseableIterator scanQueryDistributed(GridCacheQueryAdapter qry, Collection<ClusterNode> nodes2) throws IgniteCheckedException {
        assert (this.cctx.isLocal()) : this.cctx.name();
        throw new IgniteException("Distributed scan query are not available for local cache (use 'CacheQuery.executeScanQuery(grid.forLocal())' instead) [cacheName=" + this.cctx.name() + ']');
    }

    @Override
    public void loadPage(long id, GridCacheQueryAdapter<?> qry, Collection<ClusterNode> nodes2, boolean all) {
    }

    @Override
    public CacheQueryFuture<?> queryFieldsLocal(GridCacheQueryBean qry) {
        assert (this.cctx.config().getCacheMode() == CacheMode.LOCAL);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executing query on local node: " + qry);
        }
        GridCacheLocalFieldsQueryFuture fut = new GridCacheLocalFieldsQueryFuture((GridCacheContext<?, ?>)this.cctx, qry);
        try {
            qry.query().validate();
            fut.execute();
        }
        catch (IgniteCheckedException e) {
            fut.onDone(e);
        }
        return fut;
    }

    @Override
    public CacheQueryFuture<?> queryFieldsDistributed(GridCacheQueryBean qry, Collection<ClusterNode> nodes2) {
        assert (this.cctx.config().getCacheMode() == CacheMode.LOCAL);
        throw new IgniteException("Distributed queries are not available for local cache (use 'CacheQuery.execute(grid.forLocal())' instead) [cacheName=" + this.cctx.name() + ']');
    }
}

