/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import org.apache.ignite.internal.util.typedef.internal.S;

public class CacheQueryPartitionInfo {
    private final int partId;
    private final String cacheName;
    private final String tableName;
    private final int dataType;
    private final int paramIdx;

    public CacheQueryPartitionInfo(int partId, String cacheName, String tableName, int dataType, int paramIdx) {
        assert (partId >= 0 ^ (cacheName != null && tableName != null));
        this.partId = partId;
        this.cacheName = cacheName;
        this.tableName = tableName;
        this.dataType = dataType;
        this.paramIdx = paramIdx;
    }

    public int partition() {
        return this.partId;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String tableName() {
        return this.tableName;
    }

    public int dataType() {
        return this.dataType;
    }

    public int paramIdx() {
        return this.paramIdx;
    }

    public int hashCode() {
        return this.partId ^ this.dataType ^ this.paramIdx ^ (this.cacheName == null ? 0 : this.cacheName.hashCode()) ^ (this.tableName == null ? 0 : this.tableName.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CacheQueryPartitionInfo)) {
            return false;
        }
        CacheQueryPartitionInfo other = (CacheQueryPartitionInfo)obj;
        if (this.partId >= 0) {
            return this.partId == other.partId;
        }
        if (other.cacheName == null || other.tableName == null) {
            return false;
        }
        return other.cacheName.equals(this.cacheName) && other.tableName.equals(this.tableName) && other.dataType == this.dataType && other.paramIdx == this.paramIdx;
    }

    public String toString() {
        return S.toString(CacheQueryPartitionInfo.class, this);
    }
}

