/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.serializer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.wal.record.MvccTxRecord;
import org.apache.ignite.internal.pagemem.wal.record.TxRecord;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersion;
import org.apache.ignite.internal.processors.cache.mvcc.MvccVersionImpl;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.CacheVersionIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferBackedDataInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.transactions.TransactionState;

public class TxRecordSerializer {
    static final int MVCC_VERSION_SIZE = 20;

    public MvccVersion readMvccVersion(ByteBufferBackedDataInput in) throws IOException {
        in.ensure(20);
        long coordVer = in.readLong();
        long cntr = in.readLong();
        int opCntr = in.readInt();
        return new MvccVersionImpl(coordVer, cntr, opCntr);
    }

    public void putMvccVersion(ByteBuffer buf, MvccVersion mvccVer) {
        buf.putLong(mvccVer.coordinatorVersion());
        buf.putLong(mvccVer.counter());
        buf.putInt(mvccVer.operationCounter());
    }

    public void write(TxRecord rec, ByteBuffer buf) {
        buf.put((byte)rec.state().ordinal());
        RecordV1Serializer.putVersion(buf, rec.nearXidVersion(), true);
        RecordV1Serializer.putVersion(buf, rec.writeVersion(), true);
        Map<Short, Collection<Short>> participatingNodes = rec.participatingNodes();
        if (participatingNodes != null && !participatingNodes.isEmpty()) {
            buf.putInt(participatingNodes.size());
            for (Map.Entry<Short, Collection<Short>> e : participatingNodes.entrySet()) {
                buf.putShort(e.getKey());
                Collection<Short> backupNodes = e.getValue();
                buf.putInt(backupNodes.size());
                for (short backupNode : backupNodes) {
                    buf.putShort(backupNode);
                }
            }
        } else {
            buf.putInt(0);
        }
        buf.putLong(rec.timestamp());
    }

    public TxRecord readTx(ByteBufferBackedDataInput in) throws IOException {
        byte txState = in.readByte();
        TransactionState state = TransactionState.fromOrdinal(txState);
        GridCacheVersion nearXidVer = RecordV1Serializer.readVersion(in, true);
        GridCacheVersion writeVer = RecordV1Serializer.readVersion(in, true);
        int participatingNodesSize = in.readInt();
        HashMap<Short, Collection<Short>> participatingNodes = U.newHashMap(participatingNodesSize);
        for (int i = 0; i < participatingNodesSize; ++i) {
            short primaryNode = in.readShort();
            int backupNodesSize = in.readInt();
            ArrayList<Short> backupNodes = new ArrayList<Short>(backupNodesSize);
            for (int j = 0; j < backupNodesSize; ++j) {
                short backupNode = in.readShort();
                backupNodes.add(backupNode);
            }
            participatingNodes.put(primaryNode, backupNodes);
        }
        long ts = in.readLong();
        return new TxRecord(state, nearXidVer, writeVer, participatingNodes, ts);
    }

    public int size(TxRecord rec) {
        int size2 = 0;
        ++size2;
        size2 += CacheVersionIO.size(rec.nearXidVersion(), true);
        size2 += CacheVersionIO.size(rec.writeVersion(), true);
        size2 += 4;
        Map<Short, Collection<Short>> participatingNodes = rec.participatingNodes();
        if (participatingNodes != null && !participatingNodes.isEmpty()) {
            for (Collection<Short> backupNodes : participatingNodes.values()) {
                size2 += 2;
                size2 += 4;
                size2 += 2 * backupNodes.size();
            }
        }
        return size2 += 8;
    }

    public MvccTxRecord readMvccTx(ByteBufferBackedDataInput in) throws IOException {
        byte txState = in.readByte();
        TransactionState state = TransactionState.fromOrdinal(txState);
        GridCacheVersion nearXidVer = RecordV1Serializer.readVersion(in, true);
        GridCacheVersion writeVer = RecordV1Serializer.readVersion(in, true);
        MvccVersion mvccVer = this.readMvccVersion(in);
        int participatingNodesSize = in.readInt();
        HashMap<Short, Collection<Short>> participatingNodes = U.newHashMap(participatingNodesSize);
        for (int i = 0; i < participatingNodesSize; ++i) {
            short primaryNode = in.readShort();
            int backupNodesSize = in.readInt();
            ArrayList<Short> backupNodes = new ArrayList<Short>(backupNodesSize);
            for (int j = 0; j < backupNodesSize; ++j) {
                short backupNode = in.readShort();
                backupNodes.add(backupNode);
            }
            participatingNodes.put(primaryNode, backupNodes);
        }
        long ts = in.readLong();
        return new MvccTxRecord(state, nearXidVer, writeVer, participatingNodes, mvccVer, ts);
    }

    public void write(MvccTxRecord rec, ByteBuffer buf) throws IgniteCheckedException {
        buf.put((byte)rec.state().ordinal());
        RecordV1Serializer.putVersion(buf, rec.nearXidVersion(), true);
        RecordV1Serializer.putVersion(buf, rec.writeVersion(), true);
        this.putMvccVersion(buf, rec.mvccVersion());
        Map<Short, Collection<Short>> participatingNodes = rec.participatingNodes();
        if (participatingNodes != null && !participatingNodes.isEmpty()) {
            buf.putInt(participatingNodes.size());
            for (Map.Entry<Short, Collection<Short>> e : participatingNodes.entrySet()) {
                buf.putShort(e.getKey());
                Collection<Short> backupNodes = e.getValue();
                buf.putInt(backupNodes.size());
                for (short backupNode : backupNodes) {
                    buf.putShort(backupNode);
                }
            }
        } else {
            buf.putInt(0);
        }
        buf.putLong(rec.timestamp());
    }

    public int size(MvccTxRecord rec) throws IgniteCheckedException {
        return this.size((TxRecord)rec) + 20;
    }
}

