/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.serializer;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.FilteredRecord;
import org.apache.ignite.internal.pagemem.wal.record.MarshalledRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferBackedDataInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentEofException;
import org.apache.ignite.internal.processors.cache.persistence.wal.WalSegmentTailReachedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordDataV2Serializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.io.RecordIO;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiPredicate;

public class RecordV2Serializer
implements RecordSerializer {
    private static final int FILE_WAL_POINTER_SIZE = 16;
    private final RecordDataV2Serializer dataSerializer;
    private final boolean writePointer;
    private final boolean marshalledMode;
    private final boolean skipPositionCheck;
    private final ThreadLocal<ByteBuffer> heapTlb = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            ByteBuffer buf = ByteBuffer.allocate(4096);
            buf.order(GridUnsafe.NATIVE_BYTE_ORDER);
            return buf;
        }
    };
    private final IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordFilter;
    private final RecordIO recordIO = new RecordIO(){

        @Override
        public int sizeWithHeaders(WALRecord record2) throws IgniteCheckedException {
            int recordSize = RecordV2Serializer.this.dataSerializer.size(record2);
            int recordSizeWithType = recordSize + 1;
            return record2.type() != WALRecord.RecordType.SWITCH_SEGMENT_RECORD ? recordSizeWithType + 16 + 4 : recordSizeWithType;
        }

        @Override
        public WALRecord readWithHeaders(ByteBufferBackedDataInput in, WALPointer expPtr) throws IOException, IgniteCheckedException {
            WALRecord.RecordType recType = RecordV1Serializer.readRecordType(in);
            if (recType == WALRecord.RecordType.SWITCH_SEGMENT_RECORD) {
                throw new SegmentEofException("Reached end of segment", null);
            }
            FileWALPointer ptr = RecordV2Serializer.readPositionAndCheckPoint(in, expPtr, RecordV2Serializer.this.skipPositionCheck, recType);
            if (recType == null) {
                FileWALPointer exp = (FileWALPointer)expPtr;
                throw new IOException("Unknown record type: " + (Object)((Object)recType) + ", expected pointer [idx=" + exp.index() + ", offset=" + exp.fileOffset() + "]");
            }
            if (RecordV2Serializer.this.recordFilter != null && !RecordV2Serializer.this.recordFilter.apply(recType, ptr)) {
                int toSkip = ptr.length() - 1 - 16 - 4;
                assert (toSkip >= 0) : "Too small saved record length: " + ptr;
                if (in.skipBytes(toSkip) < toSkip) {
                    throw new EOFException("Reached end of file while reading record: " + ptr);
                }
                return FilteredRecord.INSTANCE;
            }
            if (RecordV2Serializer.this.marshalledMode) {
                ByteBuffer buf = (ByteBuffer)RecordV2Serializer.this.heapTlb.get();
                if (buf.capacity() < ptr.length()) {
                    buf = ByteBuffer.allocate(ptr.length() * 3 / 2).order(ByteOrder.nativeOrder());
                    RecordV2Serializer.this.heapTlb.set(buf);
                } else {
                    buf.clear();
                }
                buf.put((byte)(recType.ordinal() + 1));
                buf.putLong(ptr.index());
                buf.putInt(ptr.fileOffset());
                buf.putInt(ptr.length());
                in.readFully(buf.array(), buf.position(), ptr.length() - buf.position());
                buf.position(ptr.length());
                in.buffer().position(in.buffer().position() - 4);
                buf.flip();
                assert (buf.remaining() == ptr.length());
                return new MarshalledRecord(recType, ptr, buf);
            }
            WALRecord rec = RecordV2Serializer.this.dataSerializer.readRecord(recType, in);
            rec.position(ptr);
            return rec;
        }

        @Override
        public void writeWithHeaders(WALRecord record2, ByteBuffer buf) throws IgniteCheckedException {
            RecordV1Serializer.putRecordType(buf, RecordV2Serializer.this.dataSerializer.recordType(record2));
            if (record2.type() == WALRecord.RecordType.SWITCH_SEGMENT_RECORD) {
                return;
            }
            RecordV2Serializer.putPositionOfRecord(buf, record2);
            RecordV2Serializer.this.dataSerializer.writeRecord(record2, buf);
        }
    };

    public RecordV2Serializer(RecordDataV2Serializer dataSerializer, boolean writePointer, boolean marshalledMode, boolean skipPositionCheck, IgniteBiPredicate<WALRecord.RecordType, WALPointer> recordFilter) {
        this.dataSerializer = dataSerializer;
        this.writePointer = writePointer;
        this.marshalledMode = marshalledMode;
        this.skipPositionCheck = skipPositionCheck;
        this.recordFilter = recordFilter;
    }

    @Override
    public int version() {
        return 2;
    }

    @Override
    public boolean writePointer() {
        return this.writePointer;
    }

    @Override
    public int size(WALRecord record2) throws IgniteCheckedException {
        return this.recordIO.sizeWithHeaders(record2);
    }

    @Override
    public void writeRecord(WALRecord record2, ByteBuffer buf) throws IgniteCheckedException {
        RecordV1Serializer.writeWithCrc(record2, buf, this.recordIO);
    }

    @Override
    public WALRecord readRecord(FileInput in, WALPointer expPtr) throws IOException, IgniteCheckedException {
        return RecordV1Serializer.readWithCrc(in, expPtr, this.recordIO);
    }

    private static FileWALPointer readPositionAndCheckPoint(DataInput in, WALPointer expPtr, boolean skipPositionCheck, WALRecord.RecordType type) throws IgniteCheckedException, IOException {
        long idx = in.readLong();
        int fileOff = in.readInt();
        int len = in.readInt();
        FileWALPointer p = (FileWALPointer)expPtr;
        if (!F.eq(idx, p.index()) || !skipPositionCheck && !F.eq(fileOff, p.fileOffset())) {
            throw new WalSegmentTailReachedException("WAL segment tail reached. [ Expected next state: {Index=" + p.index() + ",Offset=" + p.fileOffset() + "}, Actual state : {Index=" + idx + ",Offset=" + fileOff + "} ] recordType=" + (Object)((Object)type), null);
        }
        return new FileWALPointer(idx, fileOff, len);
    }

    private static void putPositionOfRecord(ByteBuffer buf, WALRecord rec) {
        FileWALPointer p = (FileWALPointer)rec.position();
        buf.putLong(p.index());
        buf.putInt(p.fileOffset());
        buf.putInt(rec.size());
    }
}

