/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.events.WalSegmentArchivedEvent;
import org.apache.ignite.events.WalSegmentCompactedEvent;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.MarshalledRecord;
import org.apache.ignite.internal.pagemem.wal.record.SwitchSegmentRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.WalStateManager;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.wal.AbstractWalRecordsIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentArchiveResult;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentEofException;
import org.apache.ignite.internal.processors.cache.persistence.wal.SingleSegmentLogicalRecordsIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.PureJavaCrc32;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SimpleSegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CIX1;
import org.apache.ignite.internal.util.typedef.CO;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FsyncModeFileWriteAheadLogManager
extends GridCacheSharedManagerAdapter
implements IgniteWriteAheadLogManager {
    public static final FileDescriptor[] EMPTY_DESCRIPTORS = new FileDescriptor[0];
    private static final byte[] FILL_BUF = new byte[0x100000];
    private static final Pattern WAL_NAME_PATTERN = Pattern.compile("\\d{16}\\.wal");
    private static final Pattern WAL_TEMP_NAME_PATTERN = Pattern.compile("\\d{16}\\.wal\\.tmp");
    public static final FileFilter WAL_SEGMENT_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && WAL_NAME_PATTERN.matcher(file.getName()).matches();
        }
    };
    private static final FileFilter WAL_SEGMENT_TEMP_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && WAL_TEMP_NAME_PATTERN.matcher(file.getName()).matches();
        }
    };
    private static final Pattern WAL_SEGMENT_FILE_COMPACTED_PATTERN = Pattern.compile("\\d{16}\\.wal\\.zip");
    public static final FileFilter WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && (WAL_NAME_PATTERN.matcher(file.getName()).matches() || WAL_SEGMENT_FILE_COMPACTED_PATTERN.matcher(file.getName()).matches());
        }
    };
    private static final Pattern WAL_SEGMENT_TEMP_FILE_COMPACTED_PATTERN = Pattern.compile("\\d{16}\\.wal\\.zip\\.tmp");
    private static final FileFilter WAL_SEGMENT_FILE_COMPACTED_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && WAL_SEGMENT_FILE_COMPACTED_PATTERN.matcher(file.getName()).matches();
        }
    };
    private static final FileFilter WAL_SEGMENT_TEMP_FILE_COMPACTED_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && WAL_SEGMENT_TEMP_FILE_COMPACTED_PATTERN.matcher(file.getName()).matches();
        }
    };
    private static final int LATEST_SERIALIZER_VERSION = 2;
    private static final double CHECKPOINT_TRIGGER_ARCHIVE_SIZE_PERCENTAGE = IgniteSystemProperties.getDouble("IGNITE_CHECKPOINT_TRIGGER_ARCHIVE_SIZE_PERCENTAGE", 0.25);
    private static final double THRESHOLD_WAL_ARCHIVE_SIZE_PERCENTAGE = IgniteSystemProperties.getDouble("IGNITE_THRESHOLD_WAL_ARCHIVE_SIZE_PERCENTAGE", 0.5);
    private final boolean alwaysWriteFullPages;
    private final long maxWalSegmentSize;
    private long maxSegCountWithoutCheckpoint;
    private final long allowedThresholdWalArchiveSize;
    private final WALMode mode;
    private final int tlbSize;
    private final long flushFreq;
    private final long fsyncDelay;
    private final DataStorageConfiguration dsCfg;
    private final GridEventStorageManager evt;
    private IgniteConfiguration igCfg;
    private DataStorageMetricsImpl metrics;
    private File walWorkDir;
    private File walArchiveDir;
    private RecordSerializer serializer;
    private final int serializerVersion = IgniteSystemProperties.getInteger("IGNITE_WAL_SERIALIZER_VERSION", 2);
    private volatile long lastTruncatedArchiveIdx = -1L;
    private volatile FileIOFactory ioFactory;
    private final SegmentFileInputFactory segmentFileInputFactory;
    private static final AtomicReferenceFieldUpdater<FsyncModeFileWriteAheadLogManager, FileWriteHandle> currentHndUpd = AtomicReferenceFieldUpdater.newUpdater(FsyncModeFileWriteAheadLogManager.class, FileWriteHandle.class, "currentHnd");
    private final ThreadLocal<ByteBuffer> tlb = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            ByteBuffer buf = ByteBuffer.allocateDirect(FsyncModeFileWriteAheadLogManager.this.tlbSize);
            buf.order(GridUnsafe.NATIVE_BYTE_ORDER);
            return buf;
        }
    };
    private volatile FileArchiver archiver;
    private volatile FileCompressor compressor;
    private volatile FileDecompressor decompressor;
    private final ThreadLocal<WALPointer> lastWALPtr = new ThreadLocal();
    private volatile FileWriteHandle currentHnd;
    private volatile WalStateManager.WALDisableContext walDisableContext;
    private final long walAutoArchiveAfterInactivity;
    private AtomicLong lastRecordLoggedMs = new AtomicLong();
    @Nullable
    private volatile GridTimeoutProcessor.CancelableTask backgroundFlushSchedule;
    @Nullable
    private volatile GridTimeoutObject nextAutoArchiveTimeoutObj;

    public FsyncModeFileWriteAheadLogManager(@NotNull GridKernalContext ctx) {
        this.igCfg = ctx.config();
        DataStorageConfiguration dsCfg = this.igCfg.getDataStorageConfiguration();
        assert (dsCfg != null);
        this.dsCfg = dsCfg;
        this.maxWalSegmentSize = dsCfg.getWalSegmentSize();
        this.mode = dsCfg.getWalMode();
        this.tlbSize = dsCfg.getWalThreadLocalBufferSize();
        this.flushFreq = dsCfg.getWalFlushFrequency();
        this.fsyncDelay = dsCfg.getWalFsyncDelayNanos();
        this.alwaysWriteFullPages = dsCfg.isAlwaysWriteFullPages();
        this.ioFactory = dsCfg.getFileIOFactory();
        this.segmentFileInputFactory = new SimpleSegmentFileInputFactory();
        this.walAutoArchiveAfterInactivity = dsCfg.getWalAutoArchiveAfterInactivity();
        this.evt = ctx.event();
        this.allowedThresholdWalArchiveSize = (long)((double)dsCfg.getMaxWalArchiveSize() * THRESHOLD_WAL_ARCHIVE_SIZE_PERCENTAGE);
        assert (this.mode == WALMode.FSYNC) : dsCfg;
    }

    public void setFileIOFactory(FileIOFactory ioFactory) {
        this.ioFactory = ioFactory;
    }

    @Override
    public void start0() throws IgniteCheckedException {
        if (!this.cctx.kernalContext().clientNode()) {
            this.maxSegCountWithoutCheckpoint = (long)((double)U.adjustedWalHistorySize(this.dsCfg, this.log) * CHECKPOINT_TRIGGER_ARCHIVE_SIZE_PERCENTAGE / (double)this.dsCfg.getWalSegmentSize());
            PdsFolderSettings resolveFolders = this.cctx.kernalContext().pdsFolderResolver().resolveFolders();
            this.checkWalConfiguration();
            final File walWorkDir0 = this.walWorkDir = this.initDirectory(this.dsCfg.getWalPath(), "db/wal", resolveFolders.folderName(), "write ahead log work directory");
            final File walArchiveDir0 = this.walArchiveDir = this.initDirectory(this.dsCfg.getWalArchivePath(), "db/wal/archive", resolveFolders.folderName(), "write ahead log archive directory");
            this.serializer = new RecordSerializerFactoryImpl(this.cctx).createSerializer(this.serializerVersion);
            GridCacheDatabaseSharedManager dbMgr = (GridCacheDatabaseSharedManager)this.cctx.database();
            this.metrics = dbMgr.persistentStoreMetricsImpl();
            this.checkOrPrepareFiles();
            this.metrics.setWalSizeProvider((IgniteOutClosure<Long>)new CO<Long>(){

                @Override
                public Long apply() {
                    long size2 = 0L;
                    for (File f2 : walWorkDir0.listFiles()) {
                        size2 += f2.length();
                    }
                    for (File f2 : walArchiveDir0.listFiles()) {
                        size2 += f2.length();
                    }
                    return size2;
                }
            });
            IgniteBiTuple<Long, Long> tup = this.scanMinMaxArchiveIndices();
            long l = this.lastTruncatedArchiveIdx = tup == null ? -1L : tup.get1() - 1L;
            FileArchiver fileArchiver = this.isArchiverEnabled() ? new FileArchiver(tup == null ? -1L : tup.get2(), this.log) : (this.archiver = null);
            if (this.archiver != null && this.dsCfg.isWalCompactionEnabled()) {
                this.compressor = new FileCompressor();
                if (this.decompressor == null) {
                    this.decompressor = new FileDecompressor(this.log);
                    new IgniteThread(this.decompressor).start();
                }
            }
            this.walDisableContext = this.cctx.walState().walDisableContext();
            if (this.mode != WALMode.NONE) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Started write-ahead log manager [mode=" + (Object)((Object)this.mode) + ']');
                }
            } else {
                U.quietAndWarn(this.log, "Started write-ahead log manager in NONE mode, persisted data may be lost in a case of unexpected node failure. Make sure to deactivate the cluster before shutdown.");
            }
        }
    }

    private void checkWalConfiguration() throws IgniteCheckedException {
        if (this.dsCfg.getWalPath() == null ^ this.dsCfg.getWalArchivePath() == null) {
            throw new IgniteCheckedException("Properties should be either both specified or both null [walStorePath = " + this.dsCfg.getWalPath() + ", walArchivePath = " + this.dsCfg.getWalArchivePath() + "]");
        }
    }

    @Override
    protected void stop0(boolean cancel) {
        GridTimeoutObject timeoutObj;
        GridTimeoutProcessor.CancelableTask schedule = this.backgroundFlushSchedule;
        if (schedule != null) {
            schedule.close();
        }
        if ((timeoutObj = this.nextAutoArchiveTimeoutObj) != null) {
            this.cctx.time().removeTimeoutObject(timeoutObj);
        }
        FileWriteHandle currHnd = this.currentHandle();
        try {
            if (this.mode == WALMode.BACKGROUND && currHnd != null) {
                currHnd.flush(null, true);
            }
            if (currHnd != null) {
                currHnd.close(false);
            }
            if (this.archiver != null) {
                this.archiver.shutdown();
            }
            if (this.compressor != null) {
                this.compressor.shutdown();
            }
            if (this.decompressor != null) {
                this.decompressor.shutdown();
            }
        }
        catch (Exception e) {
            U.error(this.log, "Failed to gracefully close WAL segment: " + this.currentHnd.fileIO, e);
        }
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Activated file write ahead log manager [nodeId=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.start0();
        if (!this.cctx.kernalContext().clientNode()) {
            if (this.isArchiverEnabled()) {
                assert (this.archiver != null);
                new IgniteThread(this.archiver).start();
            }
            if (this.compressor != null) {
                this.compressor.start();
            }
        }
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("DeActivate file write ahead log [nodeId=" + this.cctx.localNodeId() + " topVer=" + this.cctx.discovery().topologyVersionEx() + " ]");
        }
        this.stop0(true);
        this.currentHnd = null;
    }

    @Override
    public boolean isAlwaysWriteFullPages() {
        return this.alwaysWriteFullPages;
    }

    @Override
    public boolean isFullSync() {
        return this.mode == WALMode.FSYNC;
    }

    @Override
    public void resumeLogging(WALPointer lastPtr) throws IgniteCheckedException {
        assert (this.currentHnd == null);
        assert (lastPtr == null || lastPtr instanceof FileWALPointer);
        FileWALPointer filePtr = (FileWALPointer)lastPtr;
        this.currentHnd = this.restoreWriteHandle(filePtr);
        if (this.currentHnd.serializer.version() != this.serializer.version()) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Record serializer version change detected, will start logging with a new WAL record serializer to a new WAL segment [curFile=" + this.currentHnd + ", newVer=" + this.serializer.version() + ", oldVer=" + this.currentHnd.serializer.version() + ']');
            }
            this.rollOver(this.currentHnd);
        }
        if (this.mode == WALMode.BACKGROUND) {
            this.backgroundFlushSchedule = this.cctx.time().schedule(new Runnable(){

                @Override
                public void run() {
                    FsyncModeFileWriteAheadLogManager.this.doFlush();
                }
            }, this.flushFreq, this.flushFreq);
        }
        if (this.walAutoArchiveAfterInactivity > 0L) {
            this.scheduleNextInactivityPeriodElapsedCheck();
        }
    }

    private void scheduleNextInactivityPeriodElapsedCheck() {
        long lastRecMs = this.lastRecordLoggedMs.get();
        final long nextPossibleAutoArchive = (lastRecMs <= 0L ? U.currentTimeMillis() : lastRecMs) + this.walAutoArchiveAfterInactivity;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Schedule WAL rollover check at " + new Time(nextPossibleAutoArchive).toString());
        }
        this.nextAutoArchiveTimeoutObj = new GridTimeoutObject(){
            private final IgniteUuid id = IgniteUuid.randomUuid();

            @Override
            public IgniteUuid timeoutId() {
                return this.id;
            }

            @Override
            public long endTime() {
                return nextPossibleAutoArchive;
            }

            @Override
            public void onTimeout() {
                if (FsyncModeFileWriteAheadLogManager.this.log.isDebugEnabled()) {
                    FsyncModeFileWriteAheadLogManager.this.log.debug("Checking if WAL rollover required (" + new Time(U.currentTimeMillis()).toString() + ")");
                }
                FsyncModeFileWriteAheadLogManager.this.checkWalRolloverRequiredDuringInactivityPeriod();
                FsyncModeFileWriteAheadLogManager.this.scheduleNextInactivityPeriodElapsedCheck();
            }
        };
        this.cctx.time().addTimeoutObject(this.nextAutoArchiveTimeoutObj);
    }

    private boolean isArchiverEnabled() {
        if (this.walArchiveDir != null && this.walWorkDir != null) {
            return !this.walArchiveDir.equals(this.walWorkDir);
        }
        return !new File(this.dsCfg.getWalArchivePath()).equals(new File(this.dsCfg.getWalPath()));
    }

    public Collection<File> getAndReserveWalFiles(FileWALPointer low, FileWALPointer high) throws IgniteCheckedException {
        long awaitIdx = high.index() - 1L;
        while (this.archiver != null && this.archiver.lastArchivedAbsoluteIndex() < awaitIdx) {
            LockSupport.parkNanos(Thread.currentThread(), 1000000L);
        }
        if (!this.reserve(low)) {
            throw new IgniteCheckedException("WAL archive segment has been deleted [idx=" + low.index() + "]");
        }
        ArrayList<File> res = new ArrayList<File>();
        for (long i = low.index(); i < high.index(); ++i) {
            String segmentName = FileDescriptor.fileName(i);
            File file = new File(this.walArchiveDir, segmentName);
            File fileZip = new File(this.walArchiveDir, segmentName + ".zip");
            if (file.exists()) {
                res.add(file);
                continue;
            }
            if (fileZip.exists()) {
                res.add(fileZip);
                continue;
            }
            if (!this.log.isInfoEnabled()) break;
            this.log.info("Segment not found: " + file.getName() + "/" + fileZip.getName());
            this.log.info("Stopped iteration on idx: " + i);
            break;
        }
        return res;
    }

    @Override
    public int serializerVersion() {
        return this.serializerVersion;
    }

    private void checkWalRolloverRequiredDuringInactivityPeriod() {
        if (this.walAutoArchiveAfterInactivity <= 0L) {
            return;
        }
        long lastRecMs = this.lastRecordLoggedMs.get();
        if (lastRecMs == 0L) {
            return;
        }
        long elapsedMs = U.currentTimeMillis() - lastRecMs;
        if (elapsedMs <= this.walAutoArchiveAfterInactivity) {
            return;
        }
        if (!this.lastRecordLoggedMs.compareAndSet(lastRecMs, 0L)) {
            return;
        }
        FileWriteHandle handle = this.currentHandle();
        try {
            this.rollOver(handle);
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Unable to perform segment rollover: " + e.getMessage(), e);
            this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
        }
    }

    @Override
    public WALPointer log(WALRecord record2) throws IgniteCheckedException, StorageException {
        if (this.serializer == null || this.mode == WALMode.NONE) {
            return null;
        }
        FileWriteHandle currWrHandle = this.currentHandle();
        WalStateManager.WALDisableContext isDisable = this.walDisableContext;
        if (currWrHandle == null || isDisable != null && isDisable.check()) {
            return null;
        }
        record2.size(this.serializer.size(record2));
        do {
            WALPointer ptr;
            if (record2.rollOver()) {
                assert (this.cctx.database().checkpointLockIsHeldByThread());
                currWrHandle = this.rollOver(currWrHandle);
            }
            if ((ptr = currWrHandle.addRecord(record2)) != null) {
                this.metrics.onWalRecordLogged();
                this.lastWALPtr.set(ptr);
                if (this.walAutoArchiveAfterInactivity > 0L) {
                    this.lastRecordLoggedMs.set(U.currentTimeMillis());
                }
                return ptr;
            }
            currWrHandle = this.rollOver(currWrHandle);
            this.checkNode();
        } while (!this.isStopping());
        throw new IgniteCheckedException("Stopping.");
    }

    @Override
    public void flush(WALPointer ptr, boolean explicitFsync) throws IgniteCheckedException, StorageException {
        if (this.serializer == null || this.mode == WALMode.NONE) {
            return;
        }
        FileWriteHandle cur = this.currentHandle();
        if (cur == null) {
            return;
        }
        FileWALPointer filePtr = (FileWALPointer)(ptr == null ? this.lastWALPtr.get() : ptr);
        if (filePtr != null && !cur.needFsync(filePtr)) {
            return;
        }
        cur.fsync(filePtr, false);
    }

    @Override
    public WALIterator replay(WALPointer start) throws IgniteCheckedException, StorageException {
        assert (start == null || start instanceof FileWALPointer) : "Invalid start pointer: " + start;
        FileWriteHandle hnd = this.currentHandle();
        FileWALPointer end = null;
        if (hnd != null) {
            end = hnd.position();
        }
        return new RecordsIterator(this.cctx, this.walWorkDir, this.walArchiveDir, (FileWALPointer)start, end, this.dsCfg, new RecordSerializerFactoryImpl(this.cctx), this.ioFactory, this.archiver, this.decompressor, this.log, this.segmentFileInputFactory);
    }

    @Override
    public boolean reserve(WALPointer start) throws IgniteCheckedException {
        assert (start != null && start instanceof FileWALPointer) : "Invalid start pointer: " + start;
        if (this.mode == WALMode.NONE) {
            return false;
        }
        FileArchiver archiver0 = this.archiver;
        if (archiver0 == null) {
            throw new IgniteCheckedException("Could not reserve WAL segment: archiver == null");
        }
        archiver0.reserve(((FileWALPointer)start).index());
        if (!this.hasIndex(((FileWALPointer)start).index())) {
            archiver0.release(((FileWALPointer)start).index());
            return false;
        }
        return true;
    }

    @Override
    public void release(WALPointer start) throws IgniteCheckedException {
        assert (start != null && start instanceof FileWALPointer) : "Invalid start pointer: " + start;
        if (this.mode == WALMode.NONE) {
            return;
        }
        FileArchiver archiver0 = this.archiver;
        if (archiver0 == null) {
            throw new IgniteCheckedException("Could not release WAL segment: archiver == null");
        }
        archiver0.release(((FileWALPointer)start).index());
    }

    private boolean hasIndex(long absIdx) {
        boolean inArchive;
        String segmentName = FileDescriptor.fileName(absIdx);
        String zipSegmentName = FileDescriptor.fileName(absIdx) + ".zip";
        boolean bl = inArchive = new File(this.walArchiveDir, segmentName).exists() || new File(this.walArchiveDir, zipSegmentName).exists();
        if (inArchive) {
            return true;
        }
        if (absIdx <= this.lastArchivedIndex()) {
            return false;
        }
        FileWriteHandle cur = this.currentHnd;
        return cur != null && cur.getSegmentId() >= absIdx;
    }

    @Override
    public int truncate(WALPointer low, WALPointer high) {
        if (high == null) {
            return 0;
        }
        assert (high instanceof FileWALPointer) : high;
        FileWALPointer lowPtr = (FileWALPointer)low;
        FileWALPointer highPtr = (FileWALPointer)high;
        FileDescriptor[] descs = FsyncModeFileWriteAheadLogManager.scan(this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER));
        int deleted = 0;
        FileArchiver archiver0 = this.archiver;
        for (FileDescriptor desc : descs) {
            long lastArchived;
            if (lowPtr != null && desc.idx < lowPtr.index()) continue;
            if (archiver0 != null && archiver0.reserved(desc.idx)) {
                return deleted;
            }
            long l = lastArchived = archiver0 != null ? archiver0.lastArchivedAbsoluteIndex() : this.lastArchivedIndex();
            if (desc.idx >= highPtr.index() || desc.idx >= lastArchived) continue;
            if (!desc.file.delete()) {
                U.warn(this.log, "Failed to remove obsolete WAL segment (make sure the process has enough rights): " + desc.file.getAbsolutePath());
            } else {
                ++deleted;
            }
            if (this.lastTruncatedArchiveIdx >= desc.idx) continue;
            this.lastTruncatedArchiveIdx = desc.idx;
        }
        return deleted;
    }

    @Override
    public void notchLastCheckpointPtr(WALPointer ptr) {
        if (this.compressor != null) {
            this.compressor.keepUncompressedIdxFrom(((FileWALPointer)ptr).index());
        }
    }

    @Override
    public int walArchiveSegments() {
        if (this.archiver == null) {
            return 0;
        }
        long lastTruncated = this.lastTruncatedArchiveIdx;
        long lastArchived = this.archiver.lastArchivedAbsoluteIndex();
        if (lastArchived == -1L) {
            return 0;
        }
        int res = (int)(lastArchived - lastTruncated);
        return res >= 0 ? res : 0;
    }

    private FileDescriptor[] walArchiveFiles() {
        return FsyncModeFileWriteAheadLogManager.scan(this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER));
    }

    @Override
    public long maxArchivedSegmentToDelete() {
        if (this.dsCfg.getMaxWalArchiveSize() == Long.MAX_VALUE) {
            return -1L;
        }
        FileDescriptor[] archivedFiles = this.walArchiveFiles();
        Long totalArchiveSize = Stream.of(archivedFiles).map(desc -> desc.file().length()).reduce(0L, Long::sum);
        if (archivedFiles.length == 0 || totalArchiveSize < this.allowedThresholdWalArchiveSize) {
            return -1L;
        }
        long sizeOfOldestArchivedFiles = 0L;
        for (FileDescriptor desc2 : archivedFiles) {
            if (totalArchiveSize - (sizeOfOldestArchivedFiles += desc2.file().length()) >= this.allowedThresholdWalArchiveSize) continue;
            return desc2.getIdx();
        }
        return archivedFiles[archivedFiles.length - 1].getIdx();
    }

    @Override
    public long lastArchivedSegment() {
        return this.archiver != null ? this.archiver.lastArchivedAbsoluteIndex() : -1L;
    }

    @Override
    public long lastCompactedSegment() {
        return this.compressor != null ? this.compressor.lastCompressedIdx : -1L;
    }

    @Override
    public boolean reserved(WALPointer ptr) {
        FileWALPointer fPtr = (FileWALPointer)ptr;
        FileArchiver archiver0 = this.archiver;
        return archiver0 != null && archiver0.reserved(fPtr.index());
    }

    @Override
    public int reserved(WALPointer low, WALPointer high) {
        long lowIdx;
        if (high == null) {
            return 0;
        }
        assert (high instanceof FileWALPointer) : high;
        assert (low == null || low instanceof FileWALPointer) : low;
        FileWALPointer lowPtr = (FileWALPointer)low;
        FileWALPointer highPtr = (FileWALPointer)high;
        FileArchiver archiver0 = this.archiver;
        long highIdx = highPtr.index();
        for (lowIdx = lowPtr != null ? lowPtr.index() : 0L; !(lowIdx >= highIdx || archiver0 != null && archiver0.reserved(lowIdx)); ++lowIdx) {
        }
        return (int)(highIdx - lowIdx + 1L);
    }

    @Override
    public boolean disabled(int grpId) {
        return this.cctx.walState().isDisabled(grpId);
    }

    @Override
    public void cleanupWalDirectories() throws IgniteCheckedException {
        Throwable throwable2;
        DirectoryStream<Path> files2;
        try {
            files2 = Files.newDirectoryStream(this.walWorkDir.toPath());
            throwable2 = null;
            try {
                for (Path path2 : files2) {
                    Files.delete(path2);
                }
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (files2 != null) {
                    if (throwable2 != null) {
                        try {
                            files2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                    } else {
                        files2.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to cleanup wal work directory: " + this.walWorkDir, e);
        }
        try {
            files2 = Files.newDirectoryStream(this.walArchiveDir.toPath());
            throwable2 = null;
            try {
                for (Path path2 : files2) {
                    Files.delete(path2);
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                if (files2 != null) {
                    if (throwable2 != null) {
                        try {
                            files2.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        files2.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IgniteCheckedException("Failed to cleanup wal archive directory: " + this.walArchiveDir, e);
        }
    }

    private long lastArchivedIndex() {
        long lastIdx = -1L;
        for (File file : this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER)) {
            try {
                long idx = Long.parseLong(file.getName().substring(0, 16));
                lastIdx = Math.max(lastIdx, idx);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        return lastIdx;
    }

    private IgniteBiTuple<Long, Long> scanMinMaxArchiveIndices() {
        TreeSet<Long> archiveIndices = new TreeSet<Long>();
        for (File file : this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER)) {
            try {
                long idx = Long.parseLong(file.getName().substring(0, 16));
                archiveIndices.add(idx);
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                // empty catch block
            }
        }
        if (archiveIndices.isEmpty()) {
            return null;
        }
        Long min2 = (Long)archiveIndices.first();
        Long max2 = (Long)archiveIndices.last();
        if (max2 - min2 == (long)(archiveIndices.size() - 1)) {
            return F.t(min2, max2);
        }
        for (Long idx : archiveIndices.descendingSet()) {
            if (archiveIndices.contains(idx - 1L)) continue;
            return F.t(idx, max2);
        }
        throw new IllegalStateException("Should never happen if TreeSet is valid.");
    }

    private File initDirectory(String cfg, String defDir, String consId, String msg) throws IgniteCheckedException {
        File workDir0;
        File dir = cfg != null ? ((workDir0 = new File(cfg)).isAbsolute() ? new File(workDir0, consId) : new File(U.resolveWorkDirectory(this.igCfg.getWorkDirectory(), cfg, false), consId)) : new File(U.resolveWorkDirectory(this.igCfg.getWorkDirectory(), defDir, false), consId);
        U.ensureDirectory(dir, msg, this.log);
        return dir;
    }

    private FileWriteHandle currentHandle() {
        return this.currentHnd;
    }

    private FileWriteHandle rollOver(FileWriteHandle cur) throws IgniteCheckedException {
        FileWriteHandle hnd = this.currentHandle();
        if (hnd != cur) {
            return hnd;
        }
        if (hnd.close(true)) {
            FileWriteHandle next2;
            if (this.metrics.metricsEnabled()) {
                this.metrics.onWallRollOver();
            }
            if ((next2 = this.initNextWriteHandle(cur.getSegmentId())).getSegmentId() - this.lashCheckpointFileIdx() >= this.maxSegCountWithoutCheckpoint) {
                this.cctx.database().forceCheckpoint("too big size of WAL without checkpoint");
            }
            boolean swapped = currentHndUpd.compareAndSet(this, hnd, next2);
            assert (swapped) : "Concurrent updates on rollover are not allowed";
            if (this.walAutoArchiveAfterInactivity > 0L) {
                this.lastRecordLoggedMs.set(0L);
            }
            hnd.signalNextAvailable();
        } else {
            hnd.awaitNext();
        }
        return this.currentHandle();
    }

    private long lashCheckpointFileIdx() {
        WALPointer lastCheckpointMark = this.cctx.database().lastCheckpointMarkWalPointer();
        return lastCheckpointMark == null ? 0L : ((FileWALPointer)lastCheckpointMark).index();
    }

    private FileWriteHandle restoreWriteHandle(FileWALPointer lastReadPtr) throws StorageException {
        long absIdx = lastReadPtr == null ? 0L : lastReadPtr.index();
        long segNo = absIdx % (long)this.dsCfg.getWalSegments();
        File curFile = new File(this.walWorkDir, FileDescriptor.fileName(segNo));
        int offset = lastReadPtr == null ? 0 : lastReadPtr.fileOffset();
        int len = lastReadPtr == null ? 0 : lastReadPtr.length();
        try {
            SegmentIO fileIO = new SegmentIO(absIdx, this.ioFactory.create(curFile));
            try {
                int serVer = this.serializerVersion;
                if (lastReadPtr != null) {
                    try {
                        serVer = RecordV1Serializer.readSegmentHeader(fileIO, this.segmentFileInputFactory).getSerializerVersion();
                    }
                    catch (EOFException | SegmentEofException ignore) {
                        serVer = this.serializerVersion;
                    }
                }
                RecordSerializer ser = new RecordSerializerFactoryImpl(this.cctx).createSerializer(serVer);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Resuming logging to WAL segment [file=" + curFile.getAbsolutePath() + ", offset=" + offset + ", ver=" + serVer + ']');
                }
                FileWriteHandle hnd = new FileWriteHandle(fileIO, offset + len, this.maxWalSegmentSize, ser);
                if (lastReadPtr == null) {
                    hnd.writeSerializerVersion();
                }
                if (this.archiver != null) {
                    this.archiver.currentWalIndex(absIdx);
                }
                return hnd;
            }
            catch (IOException | IgniteCheckedException e) {
                try {
                    fileIO.close();
                }
                catch (IOException suppressed) {
                    e.addSuppressed(suppressed);
                }
                if (e instanceof StorageException) {
                    throw (StorageException)e;
                }
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to restore WAL write handle: " + curFile.getAbsolutePath(), e);
        }
    }

    private FileWriteHandle initNextWriteHandle(long curIdx) throws IgniteCheckedException {
        IgniteCheckedException error2 = null;
        try {
            File nextFile = this.pollNextFile(curIdx);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Switching to a new WAL segment: " + nextFile.getAbsolutePath());
            }
            SegmentIO fileIO = new SegmentIO(curIdx + 1L, this.ioFactory.create(nextFile));
            FileWriteHandle hnd = new FileWriteHandle(fileIO, 0L, this.maxWalSegmentSize, this.serializer);
            hnd.writeSerializerVersion();
            FileWriteHandle fileWriteHandle = hnd;
            return fileWriteHandle;
        }
        catch (IgniteCheckedException e) {
            error2 = e;
            throw error2;
        }
        catch (IOException e) {
            error2 = new StorageException("Unable to initialize WAL segment", e);
            throw error2;
        }
        finally {
            if (error2 != null) {
                this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, error2));
            }
        }
    }

    private void checkOrPrepareFiles() throws StorageException {
        File[] allFiles;
        File[] tmpFiles = this.walWorkDir.listFiles(WAL_SEGMENT_TEMP_FILE_FILTER);
        if (!F.isEmpty(tmpFiles)) {
            for (File tmp : tmpFiles) {
                boolean deleted = tmp.delete();
                if (deleted) continue;
                throw new StorageException("Failed to delete previously created temp file (make sure Ignite process has enough rights): " + tmp.getAbsolutePath());
            }
        }
        if ((allFiles = this.walWorkDir.listFiles(WAL_SEGMENT_FILE_FILTER)).length != 0 && allFiles.length > this.dsCfg.getWalSegments()) {
            throw new StorageException("Failed to initialize wal (work directory contains incorrect number of segments) [cur=" + allFiles.length + ", expected=" + this.dsCfg.getWalSegments() + ']');
        }
        if (allFiles.length == 0) {
            File first = new File(this.walWorkDir, FileDescriptor.fileName(0L));
            this.createFile(first);
        } else {
            this.checkFiles(0, false, null, null);
        }
    }

    private void formatFile(File file) throws StorageException {
        this.formatFile(file, this.dsCfg.getWalSegmentSize());
    }

    private void formatFile(File file, int bytesCntToFormat) throws StorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Formatting file [exists=" + file.exists() + ", file=" + file.getAbsolutePath() + ']');
        }
        try (FileIO fileIO = this.ioFactory.create(file, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            int left = bytesCntToFormat;
            if (this.mode == WALMode.FSYNC) {
                while ((left -= fileIO.writeFully(FILL_BUF, 0, Math.min(FILL_BUF.length, left))) > 0) {
                }
                fileIO.force();
            } else {
                fileIO.clear();
            }
        }
        catch (IOException e) {
            throw new StorageException("Failed to format WAL segment file: " + file.getAbsolutePath(), e);
        }
    }

    private void createFile(File file) throws StorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating new file [exists=" + file.exists() + ", file=" + file.getAbsolutePath() + ']');
        }
        File tmp = new File(file.getParent(), file.getName() + ".tmp");
        this.formatFile(tmp);
        try {
            Files.move(tmp.toPath(), file.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new StorageException("Failed to move temp file to a regular WAL segment file: " + file.getAbsolutePath(), e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created WAL segment [file=" + file.getAbsolutePath() + ", size=" + file.length() + ']');
        }
    }

    private File pollNextFile(long curIdx) throws StorageException, IgniteInterruptedCheckedException {
        FileArchiver archiver0 = this.archiver;
        if (archiver0 == null) {
            return new File(this.walWorkDir, FileDescriptor.fileName(curIdx + 1L));
        }
        long absNextIdx = archiver0.nextAbsoluteSegmentIndex(curIdx);
        long segmentIdx = absNextIdx % (long)this.dsCfg.getWalSegments();
        return new File(this.walWorkDir, FileDescriptor.fileName(segmentIdx));
    }

    public static FileDescriptor[] scan(File[] allFiles) {
        if (allFiles == null) {
            return EMPTY_DESCRIPTORS;
        }
        Object[] descs = new FileDescriptor[allFiles.length];
        for (int i = 0; i < allFiles.length; ++i) {
            File f2 = allFiles[i];
            descs[i] = new FileDescriptor(f2);
        }
        Arrays.sort(descs);
        return descs;
    }

    private void checkNode() throws StorageException {
        if (this.cctx.kernalContext().invalid()) {
            throw new StorageException("Failed to perform WAL operation (environment was invalidated by a previous error)");
        }
    }

    private void checkFiles(int startWith, boolean create, @Nullable IgnitePredicate<Integer> p, @Nullable IgniteInClosure<Integer> completionCallback) throws StorageException {
        for (int i = startWith; i < this.dsCfg.getWalSegments() && (p == null || p != null && p.apply(i)); ++i) {
            File checkFile = new File(this.walWorkDir, FileDescriptor.fileName(i));
            if (checkFile.exists()) {
                if (checkFile.isDirectory()) {
                    throw new StorageException("Failed to initialize WAL log segment (a directory with the same name already exists): " + checkFile.getAbsolutePath());
                }
                if (checkFile.length() != (long)this.dsCfg.getWalSegmentSize() && this.mode == WALMode.FSYNC) {
                    throw new StorageException("Failed to initialize WAL log segment (WAL segment size change is not supported):" + checkFile.getAbsolutePath());
                }
            } else if (create) {
                this.createFile(checkFile);
            }
            if (completionCallback == null) continue;
            completionCallback.apply(i);
        }
    }

    public static long writeSerializerVersion(FileIO io, long idx, int version, WALMode mode) throws IOException {
        ByteBuffer buffer = FsyncModeFileWriteAheadLogManager.prepareSerializerVersionBuffer(idx, version, false);
        io.writeFully(buffer);
        if (mode == WALMode.FSYNC) {
            io.force();
        }
        return io.position();
    }

    @NotNull
    private static ByteBuffer prepareSerializerVersionBuffer(long idx, int ver, boolean compacted) {
        ByteBuffer buf = ByteBuffer.allocate(29);
        buf.order(ByteOrder.nativeOrder());
        buf.put((byte)(WALRecord.RecordType.HEADER_RECORD.ordinal() + 1));
        RecordV1Serializer.putPosition(buf, new FileWALPointer(idx, 0, 0));
        buf.putLong(compacted ? 5622654036411574606L : -5705984118950656934L);
        buf.putInt(ver);
        if (!RecordV1Serializer.skipCrc) {
            int curPos = buf.position();
            buf.position(0);
            int crcVal = PureJavaCrc32.calcCrc32(buf, curPos);
            buf.putInt(crcVal);
        } else {
            buf.putInt(0);
        }
        buf.position(0);
        return buf;
    }

    private static int recordOffset(WALRecord rec) {
        FileWALPointer ptr = (FileWALPointer)rec.position();
        assert (ptr != null);
        return ptr.fileOffset();
    }

    private void doFlush() {
        FileWriteHandle hnd = this.currentHandle();
        try {
            hnd.flush((WALRecord)hnd.head.get(), false);
        }
        catch (Exception e) {
            U.warn(this.log, "Failed to flush WAL record queue", e);
        }
    }

    private static FileDescriptor[] loadFileDescriptors(@NotNull File walFilesDir) throws IgniteCheckedException {
        File[] files2 = walFilesDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER);
        if (files2 == null) {
            throw new IgniteCheckedException("WAL files directory does not not denote a directory, or if an I/O error occurs: [" + walFilesDir.getAbsolutePath() + "]");
        }
        return FsyncModeFileWriteAheadLogManager.scan(files2);
    }

    private class RecordsIterator
    extends AbstractWalRecordsIterator {
        private static final long serialVersionUID = 0L;
        private final File walWorkDir;
        private final File walArchiveDir;
        private final FileArchiver archiver;
        private final FileDecompressor decompressor;
        private final DataStorageConfiguration psCfg;
        @Nullable
        private FileWALPointer start;
        @Nullable
        private FileWALPointer end;

        private RecordsIterator(GridCacheSharedContext cctx, File walWorkDir, @Nullable File walArchiveDir, @Nullable FileWALPointer start, FileWALPointer end, @NotNull DataStorageConfiguration psCfg, RecordSerializerFactory serializerFactory, FileIOFactory ioFactory, FileArchiver archiver, FileDecompressor decompressor, IgniteLogger log2, SegmentFileInputFactory segmentFileInputFactory) throws IgniteCheckedException {
            super(log2, cctx, serializerFactory, ioFactory, psCfg.getWalRecordIteratorBufferSize(), segmentFileInputFactory);
            this.walWorkDir = walWorkDir;
            this.walArchiveDir = walArchiveDir;
            this.psCfg = psCfg;
            this.archiver = archiver;
            this.start = start;
            this.end = end;
            this.decompressor = decompressor;
            this.init();
            this.advance();
        }

        @Override
        protected ReadFileHandle initReadHandle(@NotNull AbstractWalRecordsIterator.AbstractFileDescriptor desc, @Nullable FileWALPointer start) throws IgniteCheckedException, FileNotFoundException {
            AbstractWalRecordsIterator.AbstractFileDescriptor currDesc = desc;
            if (!desc.file().exists()) {
                FileDescriptor zipFile = new FileDescriptor(new File(this.walArchiveDir, FileDescriptor.fileName(desc.idx()) + ".zip"));
                if (!zipFile.file.exists()) {
                    throw new FileNotFoundException("Both compressed and raw segment files are missing in archive [segmentIdx=" + desc.idx() + "]");
                }
                if (this.decompressor != null) {
                    this.decompressor.decompressFile(desc.idx()).get();
                } else {
                    currDesc = zipFile;
                }
            }
            return (ReadFileHandle)super.initReadHandle(currDesc, start);
        }

        @Override
        protected void onClose() throws IgniteCheckedException {
            super.onClose();
            this.curRec = null;
            AbstractWalRecordsIterator.AbstractReadFileHandle handle = this.closeCurrentWalSegment();
            if (handle != null && handle.workDir()) {
                this.releaseWorkSegment(this.curWalSegmIdx);
            }
            this.curWalSegmIdx = Integer.MAX_VALUE;
        }

        private void init() throws IgniteCheckedException {
            FileDescriptor[] descs = FsyncModeFileWriteAheadLogManager.loadFileDescriptors(this.walArchiveDir);
            if (this.start != null) {
                if (!F.isEmpty(descs)) {
                    if (descs[0].idx() > this.start.index()) {
                        throw new IgniteCheckedException("WAL history is too short [descs=" + Arrays.asList(descs) + ", start=" + this.start + ']');
                    }
                    for (FileDescriptor desc : descs) {
                        if (desc.idx() != this.start.index()) continue;
                        this.curWalSegmIdx = this.start.index();
                        break;
                    }
                    if (this.curWalSegmIdx == -1L) {
                        long lastArchived = descs[descs.length - 1].idx();
                        if (lastArchived > this.start.index()) {
                            throw new IgniteCheckedException("WAL history is corrupted (segment is missing): " + this.start);
                        }
                        this.curWalSegmIdx = this.start.index();
                    }
                } else {
                    this.curWalSegmIdx = this.start.index();
                }
            } else {
                this.curWalSegmIdx = !F.isEmpty(descs) ? descs[0].idx() : 0L;
            }
            --this.curWalSegmIdx;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Initialized WAL cursor [start=" + this.start + ", end=" + this.end + ", curWalSegmIdx=" + this.curWalSegmIdx + ']');
            }
        }

        @Override
        protected AbstractWalRecordsIterator.AbstractReadFileHandle advanceSegment(@Nullable AbstractWalRecordsIterator.AbstractReadFileHandle curWalSegment) throws IgniteCheckedException {
            ReadFileHandle nextHandle;
            FileDescriptor fd;
            if (curWalSegment != null) {
                curWalSegment.close();
                if (curWalSegment.workDir()) {
                    this.releaseWorkSegment(curWalSegment.idx());
                }
            }
            if (this.end != null && this.curWalSegmIdx + 1L > this.end.index()) {
                return null;
            }
            ++this.curWalSegmIdx;
            boolean readArchive = this.canReadArchiveOrReserveWork(this.curWalSegmIdx);
            if (readArchive) {
                fd = new FileDescriptor(new File(this.walArchiveDir, FileDescriptor.fileName(this.curWalSegmIdx)));
            } else {
                long workIdx = this.curWalSegmIdx % (long)this.psCfg.getWalSegments();
                fd = new FileDescriptor(new File(this.walWorkDir, FileDescriptor.fileName(workIdx)), this.curWalSegmIdx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Reading next file [absIdx=" + this.curWalSegmIdx + ", file=" + fd.file().getAbsolutePath() + ']');
            }
            try {
                nextHandle = this.initReadHandle(fd, this.start != null && this.curWalSegmIdx == this.start.index() ? this.start : null);
            }
            catch (FileNotFoundException e) {
                if (readArchive) {
                    throw new IgniteCheckedException("Missing WAL segment in the archive", e);
                }
                nextHandle = null;
            }
            if (nextHandle == null) {
                if (!readArchive) {
                    this.releaseWorkSegment(this.curWalSegmIdx);
                }
            } else {
                nextHandle.workDir = !readArchive;
            }
            this.curRec = null;
            return nextHandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IgniteCheckedException handleRecordException(@NotNull Exception e, @Nullable FileWALPointer ptr) {
            if (e instanceof IgniteCheckedException && X.hasCause(e, IgniteDataIntegrityViolationException.class) && this.end == null) {
                long nextWalSegmentIdx = this.curWalSegmIdx + 1L;
                if (this.archiver != null && !this.canReadArchiveOrReserveWork(nextWalSegmentIdx)) {
                    try {
                        long workIdx = nextWalSegmentIdx % (long)FsyncModeFileWriteAheadLogManager.this.dsCfg.getWalSegments();
                        FileDescriptor fd = new FileDescriptor(new File(this.walWorkDir, FileDescriptor.fileName(workIdx)), nextWalSegmentIdx);
                        try {
                            ReadFileHandle nextHandle = this.initReadHandle(fd, null);
                            if (nextHandle == null) {
                                IgniteCheckedException igniteCheckedException = null;
                                return igniteCheckedException;
                            }
                        }
                        catch (FileNotFoundException | IgniteCheckedException initReadHandleException) {
                            e.addSuppressed(initReadHandleException);
                        }
                    }
                    finally {
                        this.releaseWorkSegment(nextWalSegmentIdx);
                    }
                }
            }
            return super.handleRecordException(e, ptr);
        }

        private boolean canReadArchiveOrReserveWork(long absIdx) {
            return this.archiver != null && this.archiver.checkCanReadArchiveOrReserveWorkSegment(absIdx);
        }

        private void releaseWorkSegment(long absIdx) {
            if (this.archiver != null) {
                this.archiver.releaseWorkSegment(absIdx);
            }
        }

        @Override
        protected AbstractWalRecordsIterator.AbstractReadFileHandle createReadFileHandle(SegmentIO fileIO, RecordSerializer ser, FileInput in) {
            return new ReadFileHandle(fileIO, ser, in);
        }
    }

    private static final class FakeRecord
    extends WALRecord {
        private final boolean stop;

        FakeRecord(FileWALPointer pos, boolean stop) {
            this.position(pos);
            this.stop = stop;
        }

        @Override
        public WALRecord.RecordType type() {
            return null;
        }

        @Override
        public FileWALPointer position() {
            return (FileWALPointer)super.position();
        }

        @Override
        public String toString() {
            return S.toString(FakeRecord.class, this, "super", super.toString());
        }
    }

    private class FileWriteHandle
    extends FileHandle {
        private final RecordSerializer serializer;
        private final long maxSegmentSize;
        private final AtomicReference<WALRecord> head;
        private volatile long written;
        private volatile long lastFsyncPos;
        private final AtomicBoolean stop;
        private final Lock lock;
        private final Condition writeComplete;
        private final Condition fsync;
        private final Condition nextSegment;

        private FileWriteHandle(SegmentIO fileIO, long pos, long maxSegmentSize, RecordSerializer serializer) throws IOException {
            super(fileIO);
            this.head = new AtomicReference();
            this.stop = new AtomicBoolean(false);
            this.lock = new ReentrantLock();
            this.writeComplete = this.lock.newCondition();
            this.fsync = this.lock.newCondition();
            this.nextSegment = this.lock.newCondition();
            assert (serializer != null);
            fileIO.position(pos);
            this.maxSegmentSize = maxSegmentSize;
            this.serializer = serializer;
            this.head.set(new FakeRecord(new FileWALPointer(fileIO.getSegmentId(), (int)pos, 0), false));
            this.written = pos;
            this.lastFsyncPos = pos;
        }

        private void writeSerializerVersion() throws IOException {
            try {
                long updatedPosition;
                assert (this.fileIO.position() == 0L) : "Serializer version can be written only at the begin of file " + this.fileIO.position();
                this.written = updatedPosition = FsyncModeFileWriteAheadLogManager.writeSerializerVersion(this.fileIO, this.getSegmentId(), this.serializer.version(), FsyncModeFileWriteAheadLogManager.this.mode);
                this.lastFsyncPos = updatedPosition;
                this.head.set(new FakeRecord(new FileWALPointer(this.getSegmentId(), (int)updatedPosition, 0), false));
            }
            catch (IOException e) {
                throw new IOException("Unable to write serializer version for segment " + this.getSegmentId(), e);
            }
        }

        private boolean stopped() {
            return this.stopped(this.head.get());
        }

        private boolean stopped(WALRecord record2) {
            return record2 instanceof FakeRecord && ((FakeRecord)record2).stop;
        }

        @Nullable
        private WALPointer addRecord(WALRecord rec) throws StorageException {
            FileWALPointer ptr;
            assert (rec.size() > 0 || rec.getClass() == FakeRecord.class);
            boolean flushed = false;
            while (true) {
                WALRecord h;
                long nextPos;
                if ((nextPos = this.nextPosition(h = this.head.get())) + (long)rec.size() >= this.maxSegmentSize || this.stopped(h)) {
                    return null;
                }
                int newChainSize = h.chainSize() + rec.size();
                if (newChainSize > FsyncModeFileWriteAheadLogManager.this.tlbSize && !flushed) {
                    boolean res;
                    boolean bl = res = h.previous() == null || this.flush(h, false);
                    if (rec.size() <= FsyncModeFileWriteAheadLogManager.this.tlbSize) continue;
                    flushed = res;
                    continue;
                }
                rec.chainSize(newChainSize);
                rec.previous(h);
                ptr = new FileWALPointer(this.getSegmentId(), (int)nextPos, rec.size());
                rec.position(ptr);
                if (this.head.compareAndSet(h, rec)) break;
            }
            return ptr;
        }

        private long nextPosition(WALRecord rec) {
            return FsyncModeFileWriteAheadLogManager.recordOffset(rec) + rec.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushOrWait(FileWALPointer ptr, boolean stop) throws StorageException {
            long expWritten;
            if (ptr != null) {
                if (ptr.index() != this.getSegmentId()) {
                    return;
                }
                expWritten = ptr.fileOffset();
            } else {
                expWritten = FsyncModeFileWriteAheadLogManager.recordOffset(this.head.get());
            }
            if (this.flush(ptr, stop)) {
                return;
            }
            if (stop) {
                FakeRecord fr = (FakeRecord)this.head.get();
                assert (fr.stop) : "Invalid fake record on top of the queue: " + fr;
                expWritten = FsyncModeFileWriteAheadLogManager.recordOffset(fr);
            }
            for (int i = 0; i < 64; ++i) {
                if (this.written < expWritten) continue;
                return;
            }
            this.lock.lock();
            try {
                while (this.written < expWritten && !FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().invalid()) {
                    U.awaitQuiet(this.writeComplete);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        private boolean flush(FileWALPointer ptr, boolean stop) throws StorageException {
            WALRecord h;
            if (ptr == null) {
                WALRecord expHead;
                do {
                    FakeRecord frHead;
                    if ((expHead = this.head.get()).previous() != null || (frHead = (FakeRecord)expHead).stop != stop && !frHead.stop && !this.head.compareAndSet(expHead, new FakeRecord(frHead.position(), stop))) continue;
                    return false;
                } while (!this.flush(expHead, stop));
                return true;
            }
            assert (ptr.index() == this.getSegmentId());
            do {
                if (this.chainBeginPosition(h = this.head.get()) <= (long)ptr.fileOffset()) continue;
                return false;
            } while (!this.flush(h, stop));
            return true;
        }

        private long chainBeginPosition(WALRecord h) {
            return FsyncModeFileWriteAheadLogManager.recordOffset(h) + h.size() - h.chainSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean flush(WALRecord expHead, boolean stop) throws StorageException {
            if (expHead.previous() == null) {
                FakeRecord frHead = (FakeRecord)expHead;
                if (!stop || frHead.stop) {
                    return false;
                }
            }
            FsyncModeFileWriteAheadLogManager.this.checkNode();
            if (!this.head.compareAndSet(expHead, new FakeRecord(new FileWALPointer(this.getSegmentId(), (int)this.nextPosition(expHead), 0), stop))) {
                return false;
            }
            if (expHead.chainSize() == 0) {
                return false;
            }
            try {
                ByteBuffer buf;
                boolean tmpBuf = false;
                if (expHead.chainSize() > FsyncModeFileWriteAheadLogManager.this.tlbSize) {
                    buf = GridUnsafe.allocateBuffer(expHead.chainSize());
                    tmpBuf = true;
                } else {
                    buf = (ByteBuffer)FsyncModeFileWriteAheadLogManager.this.tlb.get();
                }
                try {
                    long pos = this.fillBuffer(buf, expHead);
                    this.writeBuffer(pos, buf);
                }
                finally {
                    if (tmpBuf) {
                        GridUnsafe.freeBuffer(buf);
                    }
                }
                return true;
            }
            catch (Throwable e) {
                StorageException se = e instanceof StorageException ? (StorageException)e : new StorageException("Unable to write", new IOException(e));
                FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, se));
                this.signalNextAvailable();
                throw se;
            }
        }

        private long fillBuffer(ByteBuffer buf, WALRecord head2) throws IgniteCheckedException {
            int limit = head2.chainSize();
            assert (limit <= buf.capacity());
            buf.rewind();
            buf.limit(limit);
            do {
                buf.position(head2.chainSize() - head2.size());
                buf.limit(head2.chainSize());
                try {
                    this.serializer.writeRecord(head2, buf);
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Failed to write record: " + head2, e);
                }
                assert (!buf.hasRemaining()) : "Reported record size is greater than actual: " + head2;
            } while ((head2 = head2.previous()).previous() != null);
            assert (head2 instanceof FakeRecord) : head2.getClass();
            buf.rewind();
            buf.limit(limit);
            return FsyncModeFileWriteAheadLogManager.recordOffset(head2);
        }

        private boolean needFsync(FileWALPointer ptr) {
            return this.getSegmentId() == ptr.index() && this.lastFsyncPos <= (long)ptr.fileOffset();
        }

        private FileWALPointer position() {
            this.lock.lock();
            try {
                FileWALPointer fileWALPointer = new FileWALPointer(this.getSegmentId(), (int)this.written, 0);
                return fileWALPointer;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fsync(FileWALPointer ptr, boolean stop) throws StorageException, IgniteInterruptedCheckedException {
            block16: {
                this.lock.lock();
                try {
                    long end;
                    if (ptr != null) {
                        if (!this.needFsync(ptr)) {
                            return;
                        }
                        if (FsyncModeFileWriteAheadLogManager.this.fsyncDelay > 0L && !this.stopped()) {
                            U.await(this.fsync, FsyncModeFileWriteAheadLogManager.this.fsyncDelay, TimeUnit.NANOSECONDS);
                            if (!this.needFsync(ptr)) {
                                return;
                            }
                        }
                    }
                    this.flushOrWait(ptr, stop);
                    if (this.stopped()) {
                        return;
                    }
                    if (this.lastFsyncPos == this.written) break block16;
                    assert (this.lastFsyncPos < this.written);
                    boolean metricsEnabled = FsyncModeFileWriteAheadLogManager.this.metrics.metricsEnabled();
                    long start = metricsEnabled ? System.nanoTime() : 0L;
                    try {
                        this.fileIO.force();
                    }
                    catch (IOException e) {
                        throw new StorageException(e);
                    }
                    this.lastFsyncPos = this.written;
                    if (FsyncModeFileWriteAheadLogManager.this.fsyncDelay > 0L) {
                        this.fsync.signalAll();
                    }
                    long l = end = metricsEnabled ? System.nanoTime() : 0L;
                    if (metricsEnabled) {
                        FsyncModeFileWriteAheadLogManager.this.metrics.onFsync(end - start);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean close(boolean rollOver) throws StorageException {
            if (this.stop.compareAndSet(false, true)) {
                this.lock.lock();
                try {
                    this.flushOrWait(null, true);
                    assert (this.stopped()) : "Segment is not closed after close flush: " + this.head.get();
                    try {
                        try {
                            RecordSerializer backwardSerializer = new RecordSerializerFactoryImpl(FsyncModeFileWriteAheadLogManager.this.cctx).createSerializer(FsyncModeFileWriteAheadLogManager.this.serializerVersion);
                            SwitchSegmentRecord segmentRecord = new SwitchSegmentRecord();
                            int switchSegmentRecSize = backwardSerializer.size(segmentRecord);
                            if (rollOver && this.written < this.maxSegmentSize - (long)switchSegmentRecSize) {
                                ByteBuffer buf = ByteBuffer.allocate(switchSegmentRecSize);
                                segmentRecord.position(new FileWALPointer(this.getSegmentId(), (int)this.written, switchSegmentRecSize));
                                backwardSerializer.writeRecord(segmentRecord, buf);
                                buf.rewind();
                                this.written += (long)this.fileIO.writeFully(buf, this.written);
                            }
                        }
                        catch (IgniteCheckedException e) {
                            throw new IOException(e);
                        }
                        finally {
                            assert (FsyncModeFileWriteAheadLogManager.this.mode == WALMode.FSYNC);
                            this.fileIO.force();
                            this.lastFsyncPos = this.written;
                            this.fileIO.close();
                        }
                    }
                    catch (IOException e) {
                        throw new StorageException("Failed to close WAL write handle [idx=" + this.getSegmentId() + "]", e);
                    }
                    if (FsyncModeFileWriteAheadLogManager.this.log.isDebugEnabled()) {
                        FsyncModeFileWriteAheadLogManager.this.log.debug("Closed WAL write handle [idx=" + this.getSegmentId() + "]");
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return false;
        }

        private void signalNextAvailable() {
            this.lock.lock();
            try {
                WALRecord rec = this.head.get();
                if (!FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().invalid()) {
                    assert (rec instanceof FakeRecord) : "Expected head FakeRecord, actual head " + (rec != null ? rec.getClass().getSimpleName() : "null");
                    assert (this.written == this.lastFsyncPos || FsyncModeFileWriteAheadLogManager.this.mode != WALMode.FSYNC) : "fsync [written=" + this.written + ", lastFsync=" + this.lastFsyncPos + ']';
                    this.fileIO = null;
                } else {
                    try {
                        this.fileIO.close();
                    }
                    catch (IOException e) {
                        U.error(FsyncModeFileWriteAheadLogManager.this.log, "Failed to close WAL file [idx=" + this.getSegmentId() + ", fileIO=" + this.fileIO + "]", e);
                    }
                }
                this.nextSegment.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        private void awaitNext() {
            this.lock.lock();
            try {
                while (this.fileIO != null && !FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().invalid()) {
                    U.awaitQuiet(this.nextSegment);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeBuffer(long pos, ByteBuffer buf) throws StorageException {
            boolean interrupted = false;
            this.lock.lock();
            try {
                assert (this.fileIO != null) : "Writing to a closed segment.";
                FsyncModeFileWriteAheadLogManager.this.checkNode();
                long lastLogged = U.currentTimeMillis();
                long logBackoff = 2000L;
                while (this.written != pos) {
                    assert (this.written < pos) : "written = " + this.written + ", pos = " + pos;
                    long now = U.currentTimeMillis();
                    if (now - lastLogged >= logBackoff) {
                        if (logBackoff < 3600000L) {
                            logBackoff *= 2L;
                        }
                        U.warn(FsyncModeFileWriteAheadLogManager.this.log, "Still waiting for a concurrent write to complete [written=" + this.written + ", pos=" + pos + ", lastFsyncPos=" + this.lastFsyncPos + ", stop=" + this.stop.get() + ", actualPos=" + this.safePosition() + ']');
                        lastLogged = now;
                    }
                    try {
                        this.writeComplete.await(2L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException ignore) {
                        interrupted = true;
                    }
                    FsyncModeFileWriteAheadLogManager.this.checkNode();
                }
                int size2 = buf.remaining();
                assert (size2 > 0) : size2;
                try {
                    assert (this.written == this.fileIO.position());
                    this.fileIO.writeFully(buf);
                    this.written += (long)size2;
                    FsyncModeFileWriteAheadLogManager.this.metrics.onWalBytesWritten(size2);
                    assert (this.written == this.fileIO.position());
                }
                catch (IOException e) {
                    StorageException se = new StorageException("Unable to write", e);
                    FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, se));
                    throw se;
                }
            }
            finally {
                this.writeComplete.signalAll();
                this.lock.unlock();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private String safePosition() {
            SegmentIO io = this.fileIO;
            if (io == null) {
                return "null";
            }
            try {
                return String.valueOf(io.position());
            }
            catch (IOException e) {
                return "{Failed to read channel position: " + e.getMessage() + "}";
            }
        }
    }

    public static class ReadFileHandle
    extends FileHandle
    implements AbstractWalRecordsIterator.AbstractReadFileHandle {
        RecordSerializer ser;
        FileInput in;
        private boolean workDir;

        ReadFileHandle(SegmentIO fileIO, RecordSerializer ser, FileInput in) {
            super(fileIO);
            this.ser = ser;
            this.in = in;
        }

        @Override
        public void close() throws IgniteCheckedException {
            try {
                this.fileIO.close();
            }
            catch (IOException e) {
                throw new IgniteCheckedException(e);
            }
        }

        @Override
        public long idx() {
            return this.getSegmentId();
        }

        @Override
        public FileInput in() {
            return this.in;
        }

        @Override
        public RecordSerializer ser() {
            return this.ser;
        }

        @Override
        public boolean workDir() {
            return this.workDir;
        }
    }

    private static abstract class FileHandle {
        protected SegmentIO fileIO;
        final long segmentIdx;

        private FileHandle(@NotNull SegmentIO fileIO) {
            this.fileIO = fileIO;
            this.segmentIdx = fileIO.getSegmentId();
        }

        public long getSegmentId() {
            return this.segmentIdx;
        }
    }

    private class FileDecompressor
    extends GridWorker {
        private Map<Long, GridFutureAdapter<Void>> decompressionFutures;
        private PriorityBlockingQueue<Long> segmentsQueue;
        private byte[] arr;

        FileDecompressor(IgniteLogger log2) {
            super(FsyncModeFileWriteAheadLogManager.this.cctx.igniteInstanceName(), "wal-file-decompressor%" + FsyncModeFileWriteAheadLogManager.this.cctx.igniteInstanceName(), log2, FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().workersRegistry());
            this.decompressionFutures = new HashMap<Long, GridFutureAdapter<Void>>();
            this.segmentsQueue = new PriorityBlockingQueue();
            this.arr = new byte[FsyncModeFileWriteAheadLogManager.this.tlbSize];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void body() {
            Throwable err2 = null;
            try {
                while (!this.isCancelled()) {
                    long segmentToDecompress = -1L;
                    try {
                        block51: {
                            this.blockingSectionBegin();
                            try {
                                segmentToDecompress = this.segmentsQueue.take();
                            }
                            finally {
                                this.blockingSectionEnd();
                            }
                            if (this.isCancelled()) {
                                return;
                            }
                            File zip2 = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(segmentToDecompress) + ".zip");
                            File unzipTmp = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(segmentToDecompress) + ".tmp");
                            File unzip2 = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(segmentToDecompress));
                            try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip2)));
                                 FileIO io = FsyncModeFileWriteAheadLogManager.this.ioFactory.create(unzipTmp);){
                                zis.getNextEntry();
                                while (io.writeFully(this.arr, 0, zis.read(this.arr)) > 0) {
                                    this.updateHeartbeat();
                                }
                            }
                            try {
                                Files.move(unzipTmp.toPath(), unzip2.toPath(), new CopyOption[0]);
                            }
                            catch (FileAlreadyExistsException e) {
                                U.error(this.log, "Can't rename temporary unzipped segment: raw segment is already present [tmp=" + unzipTmp + ", raw=" + unzip2 + ']', e);
                                if (unzipTmp.delete()) break block51;
                                U.error(this.log, "Can't delete temporary unzipped segment [tmp=" + unzipTmp + ']');
                            }
                        }
                        this.updateHeartbeat();
                        FileDecompressor fileDecompressor = this;
                        synchronized (fileDecompressor) {
                            this.decompressionFutures.remove(segmentToDecompress).onDone();
                        }
                    }
                    catch (IOException ex) {
                        if (this.isCancelled || segmentToDecompress == -1L) continue;
                        IgniteCheckedException e = new IgniteCheckedException("Error during WAL segment decompression [segmentIdx=" + segmentToDecompress + ']', ex);
                        FileDecompressor fileDecompressor = this;
                        synchronized (fileDecompressor) {
                            this.decompressionFutures.remove(segmentToDecompress).onDone(e);
                        }
                    }
                }
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (this.isCancelled) return;
                err2 = e;
                return;
            }
            catch (Throwable t) {
                err2 = t;
                return;
            }
            finally {
                if (err2 == null && !this.isCancelled) {
                    err2 = new IllegalStateException("Worker " + this.name() + " is terminated unexpectedly");
                }
                if (err2 instanceof OutOfMemoryError) {
                    FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err2));
                } else if (err2 != null) {
                    FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err2));
                }
            }
        }

        synchronized IgniteInternalFuture<Void> decompressFile(long idx) {
            if (this.decompressionFutures.containsKey(idx)) {
                return this.decompressionFutures.get(idx);
            }
            File f2 = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(idx));
            if (f2.exists()) {
                return new GridFinishedFuture<Void>();
            }
            this.segmentsQueue.put(idx);
            GridFutureAdapter<Void> res = new GridFutureAdapter<Void>();
            this.decompressionFutures.put(idx, res);
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() {
            FileDecompressor fileDecompressor = this;
            synchronized (fileDecompressor) {
                U.cancel(this);
                this.segmentsQueue.put(-1L);
            }
            U.join(this, this.log);
        }
    }

    private class FileCompressor
    extends Thread {
        private volatile boolean stopped;
        private volatile long lastCompressedIdx;
        private volatile long minUncompressedIdxToKeep;

        FileCompressor() {
            super("wal-file-compressor%" + FsyncModeFileWriteAheadLogManager.this.cctx.igniteInstanceName());
            this.lastCompressedIdx = -1L;
            this.minUncompressedIdxToKeep = -1L;
        }

        private void init() {
            File[] toDel;
            for (File f2 : toDel = FsyncModeFileWriteAheadLogManager.this.walArchiveDir.listFiles(WAL_SEGMENT_TEMP_FILE_COMPACTED_FILTER)) {
                if (this.stopped) {
                    return;
                }
                f2.delete();
            }
            FileDescriptor[] alreadyCompressed = FsyncModeFileWriteAheadLogManager.scan(FsyncModeFileWriteAheadLogManager.this.walArchiveDir.listFiles(WAL_SEGMENT_FILE_COMPACTED_FILTER));
            if (alreadyCompressed.length > 0) {
                this.lastCompressedIdx = alreadyCompressed[alreadyCompressed.length - 1].idx();
            }
        }

        synchronized void keepUncompressedIdxFrom(long idx) {
            this.minUncompressedIdxToKeep = idx;
            this.notify();
        }

        synchronized void onNextSegmentArchived() {
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long tryReserveNextSegmentOrWait() throws InterruptedException, IgniteCheckedException {
            long segmentToCompress = this.lastCompressedIdx + 1L;
            FileCompressor fileCompressor = this;
            synchronized (fileCompressor) {
                if (this.stopped) {
                    return -1L;
                }
                while (segmentToCompress > FsyncModeFileWriteAheadLogManager.this.archiver.lastArchivedAbsoluteIndex()) {
                    this.wait();
                    if (!this.stopped) continue;
                    return -1L;
                }
            }
            segmentToCompress = Math.max(segmentToCompress, FsyncModeFileWriteAheadLogManager.this.lastTruncatedArchiveIdx + 1L);
            boolean reserved = FsyncModeFileWriteAheadLogManager.this.reserve(new FileWALPointer(segmentToCompress, 0, 0));
            return reserved ? segmentToCompress : -1L;
        }

        private void deleteObsoleteRawSegments() {
            FileDescriptor[] descs = FsyncModeFileWriteAheadLogManager.scan(FsyncModeFileWriteAheadLogManager.this.walArchiveDir.listFiles(WAL_SEGMENT_COMPACTED_OR_RAW_FILE_FILTER));
            HashSet<Long> indices = new HashSet<Long>();
            HashSet<Long> duplicateIndices = new HashSet<Long>();
            for (FileDescriptor desc : descs) {
                if (indices.add(desc.idx)) continue;
                duplicateIndices.add(desc.idx);
            }
            FileArchiver archiver0 = FsyncModeFileWriteAheadLogManager.this.archiver;
            for (FileDescriptor desc : descs) {
                if (desc.isCompressed()) continue;
                if (archiver0 != null && archiver0.reserved(desc.idx)) {
                    return;
                }
                if (desc.idx >= this.minUncompressedIdxToKeep || !duplicateIndices.contains(desc.idx) || desc.file.delete()) continue;
                U.warn(FsyncModeFileWriteAheadLogManager.this.log, "Failed to remove obsolete WAL segment (make sure the process has enough rights): " + desc.file.getAbsolutePath() + ", exists: " + desc.file.exists());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.init();
            while (!Thread.currentThread().isInterrupted() && !this.stopped) {
                long currReservedSegment = -1L;
                try {
                    this.deleteObsoleteRawSegments();
                    currReservedSegment = this.tryReserveNextSegmentOrWait();
                    if (currReservedSegment == -1L) continue;
                    File tmpZip = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(currReservedSegment) + ".zip" + ".tmp");
                    File zip2 = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(currReservedSegment) + ".zip");
                    File raw2 = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, FileDescriptor.fileName(currReservedSegment));
                    if (!Files.exists(raw2.toPath(), new LinkOption[0])) {
                        throw new IgniteCheckedException("WAL archive segment is missing: " + raw2);
                    }
                    this.compressSegmentToFile(currReservedSegment, raw2, tmpZip);
                    Files.move(tmpZip.toPath(), zip2.toPath(), new CopyOption[0]);
                    if (FsyncModeFileWriteAheadLogManager.this.mode != WALMode.NONE) {
                        try (FileIO f0 = FsyncModeFileWriteAheadLogManager.this.ioFactory.create(zip2, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                            f0.force();
                        }
                        if (FsyncModeFileWriteAheadLogManager.this.evt.isRecordable(134)) {
                            FsyncModeFileWriteAheadLogManager.this.evt.record(new WalSegmentCompactedEvent(FsyncModeFileWriteAheadLogManager.this.cctx.discovery().localNode(), currReservedSegment, zip2.getAbsoluteFile()));
                        }
                    }
                    this.lastCompressedIdx = currReservedSegment;
                }
                catch (IOException | IgniteCheckedException e) {
                    U.error(FsyncModeFileWriteAheadLogManager.this.log, "Compression of WAL segment [idx=" + currReservedSegment + "] was skipped due to unexpected error", e);
                    ++this.lastCompressedIdx;
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    try {
                        if (currReservedSegment == -1L) continue;
                        FsyncModeFileWriteAheadLogManager.this.release(new FileWALPointer(currReservedSegment, 0, 0));
                    }
                    catch (IgniteCheckedException e) {
                        U.error(FsyncModeFileWriteAheadLogManager.this.log, "Can't release raw WAL segment [idx=" + currReservedSegment + "] after compression", e);
                    }
                }
            }
        }

        private void compressSegmentToFile(long nextSegment, File raw2, File zip2) throws IOException, IgniteCheckedException {
            int segmentSerializerVer;
            try (FileIO fileIO = FsyncModeFileWriteAheadLogManager.this.ioFactory.create(raw2);){
                segmentSerializerVer = RecordV1Serializer.readSegmentHeader(new SegmentIO(nextSegment, fileIO), FsyncModeFileWriteAheadLogManager.this.segmentFileInputFactory).getSerializerVersion();
            }
            var7_5 = null;
            try (final ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zip2)));){
                zos.setLevel(FsyncModeFileWriteAheadLogManager.this.dsCfg.getWalCompactionLevel());
                zos.putNextEntry(new ZipEntry(""));
                zos.write(FsyncModeFileWriteAheadLogManager.prepareSerializerVersionBuffer(nextSegment, segmentSerializerVer, true).array());
                CIX1<WALRecord> appendToZipC = new CIX1<WALRecord>(){

                    @Override
                    public void applyx(WALRecord record2) throws IgniteCheckedException {
                        MarshalledRecord marshRec = (MarshalledRecord)record2;
                        try {
                            zos.write(marshRec.buffer().array(), 0, marshRec.buffer().remaining());
                        }
                        catch (IOException e) {
                            throw new IgniteCheckedException(e);
                        }
                    }
                };
                try (SingleSegmentLogicalRecordsIterator iter2 = new SingleSegmentLogicalRecordsIterator(FsyncModeFileWriteAheadLogManager.this.log, FsyncModeFileWriteAheadLogManager.this.cctx, FsyncModeFileWriteAheadLogManager.this.ioFactory, FsyncModeFileWriteAheadLogManager.this.tlbSize, nextSegment, FsyncModeFileWriteAheadLogManager.this.walArchiveDir, appendToZipC);){
                    while (iter2.hasNextX()) {
                        iter2.nextX();
                    }
                }
            }
            catch (Throwable throwable2) {
                var7_5 = throwable2;
                throw throwable2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() throws IgniteInterruptedCheckedException {
            FileCompressor fileCompressor = this;
            synchronized (fileCompressor) {
                this.stopped = true;
                this.notifyAll();
            }
            U.join(this);
        }
    }

    private class FileArchiver
    extends GridWorker {
        private StorageException cleanException;
        private long curAbsWalIdx;
        private volatile long lastAbsArchivedIdx;
        private NavigableMap<Long, Integer> reserved;
        private Map<Long, Integer> locked;
        private int formatted;

        private FileArchiver(long lastAbsArchivedIdx, IgniteLogger log2) {
            super(FsyncModeFileWriteAheadLogManager.this.cctx.igniteInstanceName(), "wal-file-archiver%" + FsyncModeFileWriteAheadLogManager.this.cctx.igniteInstanceName(), log2, FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().workersRegistry());
            this.curAbsWalIdx = -1L;
            this.lastAbsArchivedIdx = -1L;
            this.reserved = new TreeMap<Long, Integer>();
            this.locked = new HashMap<Long, Integer>();
            this.lastAbsArchivedIdx = lastAbsArchivedIdx;
        }

        private long lastArchivedAbsoluteIndex() {
            return this.lastAbsArchivedIdx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() throws IgniteInterruptedCheckedException {
            FileArchiver fileArchiver = this;
            synchronized (fileArchiver) {
                this.isCancelled = true;
                this.notifyAll();
            }
            U.join(this.runner());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void currentWalIndex(long curAbsWalIdx) {
            FileArchiver fileArchiver = this;
            synchronized (fileArchiver) {
                this.curAbsWalIdx = curAbsWalIdx;
                this.notifyAll();
            }
        }

        private synchronized void reserve(long absIdx) {
            Integer cur = (Integer)this.reserved.get(absIdx);
            if (cur == null) {
                this.reserved.put(absIdx, 1);
            } else {
                this.reserved.put(absIdx, cur + 1);
            }
        }

        private synchronized boolean reserved(long absIdx) {
            return this.locked.containsKey(absIdx) || this.reserved.floorKey(absIdx) != null;
        }

        private synchronized void release(long absIdx) {
            Integer cur = (Integer)this.reserved.get(absIdx);
            assert (cur != null && cur >= 1) : cur;
            if (cur == 1) {
                this.reserved.remove(absIdx);
            } else {
                this.reserved.put(absIdx, cur - 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() {
            this.blockingSectionBegin();
            try {
                this.allocateRemainingFiles();
            }
            catch (StorageException e) {
                FileArchiver fileArchiver = this;
                synchronized (fileArchiver) {
                    this.cleanException = e;
                    this.notifyAll();
                }
                FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                return;
            }
            finally {
                this.blockingSectionEnd();
            }
            Throwable err2 = null;
            try {
                FileArchiver fileArchiver = this;
                synchronized (fileArchiver) {
                    while (this.curAbsWalIdx == -1L && !this.isCancelled()) {
                        this.blockingSectionBegin();
                        try {
                            this.wait();
                        }
                        finally {
                            this.blockingSectionEnd();
                        }
                    }
                }
                while (!Thread.currentThread().isInterrupted() && !this.isCancelled()) {
                    SegmentArchiveResult res;
                    long toArchive;
                    FileArchiver fileArchiver2 = this;
                    synchronized (fileArchiver2) {
                        assert (this.lastAbsArchivedIdx <= this.curAbsWalIdx) : "lastArchived=" + this.lastAbsArchivedIdx + ", current=" + this.curAbsWalIdx;
                        while (this.lastAbsArchivedIdx >= this.curAbsWalIdx - 1L && !this.isCancelled()) {
                            this.blockingSectionBegin();
                            try {
                                this.wait();
                            }
                            finally {
                                this.blockingSectionEnd();
                            }
                        }
                        toArchive = this.lastAbsArchivedIdx + 1L;
                    }
                    if (this.isCancelled()) {
                        break;
                    }
                    this.blockingSectionBegin();
                    try {
                        res = this.archiveSegment(toArchive);
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                    FileArchiver fileArchiver3 = this;
                    synchronized (fileArchiver3) {
                        while (this.locked.containsKey(toArchive) && !this.isCancelled()) {
                            this.blockingSectionBegin();
                            try {
                                this.wait();
                            }
                            finally {
                                this.blockingSectionEnd();
                            }
                        }
                        this.changeLastArchivedIndexAndWakeupCompressor(toArchive);
                        this.notifyAll();
                    }
                    if (FsyncModeFileWriteAheadLogManager.this.evt.isRecordable(128)) {
                        FsyncModeFileWriteAheadLogManager.this.evt.record(new WalSegmentArchivedEvent(FsyncModeFileWriteAheadLogManager.this.cctx.discovery().localNode(), res.getAbsIdx(), res.getDstArchiveFile()));
                    }
                    this.onIdle();
                }
            }
            catch (InterruptedException t) {
                Thread.currentThread().interrupt();
                if (!this.isCancelled()) {
                    err2 = t;
                }
            }
            catch (Throwable t) {
                err2 = t;
            }
            finally {
                if (err2 == null && !this.isCancelled()) {
                    err2 = new IllegalStateException("Worker " + this.name() + " is terminated unexpectedly");
                }
                if (err2 instanceof OutOfMemoryError) {
                    FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err2));
                } else if (err2 != null) {
                    FsyncModeFileWriteAheadLogManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err2));
                }
            }
        }

        private void changeLastArchivedIndexAndWakeupCompressor(long idx) {
            this.lastAbsArchivedIdx = idx;
            if (FsyncModeFileWriteAheadLogManager.this.compressor != null) {
                FsyncModeFileWriteAheadLogManager.this.compressor.onNextSegmentArchived();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long nextAbsoluteSegmentIndex(long curIdx) throws StorageException, IgniteInterruptedCheckedException {
            try {
                FileArchiver fileArchiver = this;
                synchronized (fileArchiver) {
                    if (this.cleanException != null) {
                        throw this.cleanException;
                    }
                    assert (curIdx == this.curAbsWalIdx);
                    ++this.curAbsWalIdx;
                    this.notifyAll();
                    int segments2 = FsyncModeFileWriteAheadLogManager.this.dsCfg.getWalSegments();
                    if (FsyncModeFileWriteAheadLogManager.this.isArchiverEnabled()) {
                        while (this.curAbsWalIdx - this.lastAbsArchivedIdx > (long)segments2 && this.cleanException == null) {
                            this.wait();
                        }
                    }
                    if (this.cleanException != null) {
                        throw this.cleanException;
                    }
                    while (this.curAbsWalIdx % (long)FsyncModeFileWriteAheadLogManager.this.dsCfg.getWalSegments() > (long)this.formatted && this.cleanException == null) {
                        this.wait();
                    }
                    if (this.cleanException != null) {
                        throw this.cleanException;
                    }
                    return this.curAbsWalIdx;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IgniteInterruptedCheckedException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkCanReadArchiveOrReserveWorkSegment(long absIdx) {
            FileArchiver fileArchiver = this;
            synchronized (fileArchiver) {
                if (this.lastAbsArchivedIdx >= absIdx) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Not needed to reserve WAL segment: absIdx=" + absIdx + "; lastAbsArchivedIdx=" + this.lastAbsArchivedIdx);
                    }
                    return true;
                }
                Integer cur = this.locked.get(absIdx);
                cur = cur == null ? 1 : cur + 1;
                this.locked.put(absIdx, cur);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Reserved work segment [absIdx=" + absIdx + ", pins=" + cur + ']');
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseWorkSegment(long absIdx) {
            FileArchiver fileArchiver = this;
            synchronized (fileArchiver) {
                Integer cur = this.locked.get(absIdx);
                assert (cur != null && cur > 0) : "WAL Segment with Index " + absIdx + " is not locked; lastAbsArchivedIdx = " + this.lastAbsArchivedIdx;
                if (cur == 1) {
                    this.locked.remove(absIdx);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Fully released work segment (ready to archive) [absIdx=" + absIdx + ']');
                    }
                } else {
                    this.locked.put(absIdx, cur - 1);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Partially released work segment [absIdx=" + absIdx + ", pins=" + (cur - 1) + ']');
                    }
                }
                this.notifyAll();
            }
        }

        private SegmentArchiveResult archiveSegment(long absIdx) throws IgniteCheckedException {
            File dstFile;
            File origFile;
            block16: {
                long segIdx = absIdx % (long)FsyncModeFileWriteAheadLogManager.this.dsCfg.getWalSegments();
                origFile = new File(FsyncModeFileWriteAheadLogManager.this.walWorkDir, FileDescriptor.fileName(segIdx));
                String name = FileDescriptor.fileName(absIdx);
                File dstTmpFile = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, name + ".tmp");
                dstFile = new File(FsyncModeFileWriteAheadLogManager.this.walArchiveDir, name);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Starting to copy WAL segment [absIdx=" + absIdx + ", segIdx=" + segIdx + ", origFile=" + origFile.getAbsolutePath() + ", dstFile=" + dstFile.getAbsolutePath() + ']');
                }
                try {
                    Files.deleteIfExists(dstTmpFile.toPath());
                    Files.copy(origFile.toPath(), dstTmpFile.toPath(), new CopyOption[0]);
                    Files.move(dstTmpFile.toPath(), dstFile.toPath(), new CopyOption[0]);
                    if (FsyncModeFileWriteAheadLogManager.this.mode != WALMode.FSYNC) break block16;
                    try (FileIO f0 = FsyncModeFileWriteAheadLogManager.this.ioFactory.create(dstFile, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                        f0.force();
                    }
                }
                catch (IOException e) {
                    throw new IgniteCheckedException("Failed to archive WAL segment [srcFile=" + origFile.getAbsolutePath() + ", dstFile=" + dstTmpFile.getAbsolutePath() + ']', e);
                }
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Copied file [src=" + origFile.getAbsolutePath() + ", dst=" + dstFile.getAbsolutePath() + ']');
            }
            return new SegmentArchiveResult(absIdx, origFile, dstFile);
        }

        private boolean checkStop() {
            return this.isCancelled();
        }

        private void allocateRemainingFiles() throws StorageException {
            final FileArchiver archiver = this;
            FsyncModeFileWriteAheadLogManager.this.checkFiles(1, true, new IgnitePredicate<Integer>(){

                @Override
                public boolean apply(Integer integer) {
                    return !FileArchiver.this.checkStop();
                }
            }, new CI1<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(Integer idx) {
                    FileArchiver fileArchiver = archiver;
                    synchronized (fileArchiver) {
                        FileArchiver.this.formatted = idx;
                        archiver.notifyAll();
                    }
                }
            });
        }
    }
}

