/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.internal.util.GridUnsafe;

public class ByteBufferExpander
implements AutoCloseable {
    private ByteBuffer buf;

    public ByteBufferExpander(int initSize, ByteOrder order) {
        ByteBuffer buffer = GridUnsafe.allocateBuffer(initSize);
        buffer.order(order);
        this.buf = buffer;
    }

    public ByteBuffer buffer() {
        return this.buf;
    }

    public ByteBuffer expand(int size2) {
        assert (this.buf.capacity() < size2);
        int pos = this.buf.position();
        int lim = this.buf.limit();
        ByteBuffer newBuf = GridUnsafe.reallocateBuffer(this.buf, size2);
        newBuf.order(this.buf.order());
        newBuf.position(pos);
        newBuf.limit(lim);
        this.buf = newBuf;
        return newBuf;
    }

    @Override
    public void close() {
        GridUnsafe.freeBuffer(this.buf);
    }
}

